/*
 * Decompiled with CFR 0.152.
 */
package Gibson;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Variant {
    public static final int TYPE_DNA = 0;
    public static final int TYPE_DNA_CONVERTED = 4;
    public static final int TYPE_AA = 1;
    public static final int TYPE_RNA = 2;
    public static final int TYPE_GDNA = 3;
    public static final int UNKNOWN = 99;
    static Pattern proteinSNV3 = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<pos>\\d+)(?<new>[A-Za-z]{3})");
    static Pattern proteinSNV1 = Pattern.compile("p\\.?(?<orig>[A-Za-z])(?<pos>\\d+)(?<new>[A-Za-z])");
    static Pattern proteinDel = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<start>\\d+)_?(?<orig2>[A-Za-z]{3})?(?<end>\\d+)?del");
    static Pattern proteinIns = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<start>\\d+)_?(?<orig2>[A-Za-z]{3})?(?<end>\\d+)?ins(?<ins>[A-Za-z]+)");
    static Pattern proteinDelins = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<start>\\d+)_?(?<orig2>[A-Za-z]{3})?(?<end>\\d+)?delins(?<new>[A-Za-z]+)");
    static Pattern proteinFS = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<pos>\\d+)fs");
    static Pattern proteinStop = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<pos>\\d+)(\\*|Ter)");
    static Pattern proteinSilent = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<pos>\\d+)=");
    static Pattern proteinLoss = Pattern.compile("p\\.?(?<orig>[A-Za-z]{3})(?<pos>\\d+)loss");
    static Pattern dnaSNV = Pattern.compile("c\\.(?<pos>\\d+)(?<orig>[ACGT])>(?<new>[ACGT])");
    static Pattern dnaMNV = Pattern.compile("c\\.(?<start>\\d+)_(?<end>\\d+)(?<orig>[ACGT]+)>(?<new>[ACGT]+)");
    static Pattern dnaDel = Pattern.compile("c\\.(?<start>\\d+)(?:_(?<end>\\d+))?del(?<delSeq>[ACGT]*)");
    static Pattern dnaIns = Pattern.compile("c\\.(?<start>\\d+)_(?<end>\\d+)ins(?<insSeq>[ACGT]+)");
    static Pattern dnaDup = Pattern.compile("c\\.(?<start>\\d+)_(?<end>\\d+)dup");
    static Pattern dnaSingleDup = Pattern.compile("c\\.(?<pos>\\d+)dup");
    static Pattern dnaDelins = Pattern.compile("c\\.(?<start>\\d+)_(?<end>\\d+)delins(?<newSeq>[ACGT]+)");
    static Pattern dnaInv = Pattern.compile("c\\.(?<start>\\d+)_(?<end>\\d+)inv");
    static Pattern dnaSingleDelins = Pattern.compile("c\\.(?<pos>\\d+)delins(?<newSeq>[ACGT]+)");
    static Pattern dnaSingleDel = Pattern.compile("c\\.(?<pos>\\d+)del(?<delSeq>[ACGT]*)");
    static Pattern dnaSingleIns = Pattern.compile("c\\.(?<pos>\\d+)ins(?<insSeq>[ACGT]+)");
    static Pattern rnaSNV = Pattern.compile("r\\.(?<pos>\\d+)(?<orig>[acgu])>(?<new>[acgu])");
    static Pattern rnaDel = Pattern.compile("r\\.(?<start>\\d+)(?:_(?<end>\\d+))?del(?<delSeq>[acgu]*)");
    static Pattern rnaIns = Pattern.compile("r\\.(?<start>\\d+)_(?<end>\\d+)ins(?<insSeq>[acgu]+)");
    static Pattern genomicSNV = Pattern.compile("g\\.(?<pos>\\d+)(?<orig>[ACGT])>(?<new>[ACGT])");
    static Pattern genomicDel = Pattern.compile("g\\.(?<start>\\d+)_(?<end>\\d+)del(?<delSeq>[ACGT]*)");
    static Pattern genomicIns = Pattern.compile("g\\.(?<start>\\d+)_(?<end>\\d+)ins(?<insSeq>[ACGT]+)");
    static Pattern vcfPattern = Pattern.compile("(?<chr>chr[\\w]+|\\d+|X|Y|MT)[\\t ]+(?<pos>\\d+)[\\t ]+(?<id>rs\\d+|COSM\\d+|\\.|[\\w-]+)[\\t ]+(?<ref>[ACGT]+)[\\t ]+(?<alt>[ACGT]+|\\.|<DEL>|<INS>|<DUP>|<INV>)");
    static Pattern dbsnpPattern = Pattern.compile("rs(?<rsid>\\d+)[\\t ]+(?<chr>[\\w]+)[\\t ]+(?<pos>\\d+)[\\t ]+(?<ref>[ACGT]+)[\\t ]+(?<alt>[ACGT]+)");
    static Pattern cosmicProtein = Pattern.compile("COSM\\d+[\\t ]+(?<mut>[A-Za-z]{1,3}\\d+[A-Za-z]{1,3})");
    static Pattern cosmicBase = Pattern.compile("COSM\\d+[\\t ]+c\\.(?<pos>\\d+)(?<orig>[ACGT])>(?<new>[ACGT])");
    static Pattern ensemblPattern = Pattern.compile("(ENSG|ENST)\\d+(\\.\\d+)?[\\t ]+(?<mut>[A-Za-z]{1,3}\\d+[A-Za-z]{1,3}|c\\.\\d+[ACGT]>[ACGT])");
    static Pattern simpleProtein = Pattern.compile("(?<orig>[A-Za-z]{1,3})(?<pos>\\d+)(?<new>[A-Za-z]{1,3})");
    private Integer startPosition;
    private Integer endPosition;
    private String originalResidue;
    private String newResidue;
    private String type;
    private String source;
    private String error = null;
    private String annotation = "";

    private static boolean isAmbiguousResidue(String residue) {
        return residue != null && residue.matches("[NX\\.]+");
    }

    private static int findOrigNearby(String seq, String orig, int idx, int window) {
        int left = Math.max(0, idx - window);
        int right = Math.min(seq.length() - orig.length(), idx + window);
        for (int i = left; i <= right; ++i) {
            if (!seq.substring(i, i + orig.length()).equals(orig)) continue;
            return i;
        }
        return -1;
    }

    private static int leftAlignIndel(String seq, String indel, int idx) {
        while (idx > 0 && seq.substring(idx - 1, idx - 1 + indel.length()).equals(indel)) {
            --idx;
        }
        return idx;
    }

    public int getAnnotationType() {
        switch (this.type) {
            case "dna_snv": 
            case "cosmic_base": 
            case "ensembl_dna": 
            case "dna_mnv": 
            case "dna_deletion": 
            case "dna_insertion": 
            case "dna_duplication": 
            case "dna_delins": 
            case "dna_inversion": {
                return 0;
            }
            case "genomic_insertion": 
            case "genomic_snv": 
            case "genomic_deletion": {
                return 3;
            }
            case "rna_insertion": 
            case "rna_deletion": 
            case "rna_snv": {
                return 2;
            }
            case "protein_deletion": 
            case "cosmic_protein": 
            case "ensembl_protein": 
            case "protein_delins": 
            case "protein_snv": 
            case "protein_insertion": 
            case "protein_frameshift": 
            case "protein_stopgain": 
            case "protein_stoploss": 
            case "protein_silent": {
                return 1;
            }
        }
        return 99;
    }

    public static String applyVariant(Variant variant, String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return sequence;
        }
        Integer start = variant.getStartPosition();
        Integer end = variant.getEndPosition() != null ? variant.getEndPosition() : start;
        String orig = variant.getOriginalResidue() != null ? variant.getOriginalResidue() : "";
        String newRes = variant.getNewResidue() != null ? variant.getNewResidue() : "";
        String type = variant.getType();
        int startIdx = start - 1;
        int endIdx = end - 1;
        int seqLen = sequence.length();
        switch (type) {
            case "protein_snv": 
            case "dna_snv": 
            case "rna_snv": 
            case "genomic_snv": 
            case "cosmic_protein": 
            case "cosmic_base": 
            case "ensembl_protein": 
            case "ensembl_dna": {
                String refAtPos = sequence.substring(startIdx, Math.min(startIdx + orig.length(), seqLen));
                if (orig.equals(refAtPos) || Variant.isAmbiguousResidue(orig)) {
                    return sequence.substring(0, startIdx) + newRes + sequence.substring(startIdx + orig.length());
                }
                int nearbyIdx = Variant.findOrigNearby(sequence, orig, startIdx, 3);
                if (nearbyIdx != -1) {
                    return sequence.substring(0, nearbyIdx) + newRes + sequence.substring(nearbyIdx + orig.length());
                }
                return null;
            }
            case "dna_mnv": {
                String refAtPos = sequence.substring(startIdx, Math.min(endIdx + 1, seqLen));
                if (orig.equals(refAtPos) || Variant.isAmbiguousResidue(orig)) {
                    return sequence.substring(0, startIdx) + newRes + sequence.substring(endIdx + 1);
                }
                int nearbyIdx = Variant.findOrigNearby(sequence, orig, startIdx, 3);
                if (nearbyIdx != -1) {
                    return sequence.substring(0, nearbyIdx) + newRes + sequence.substring(nearbyIdx + orig.length());
                }
                return null;
            }
            case "protein_deletion": 
            case "dna_deletion": 
            case "rna_deletion": 
            case "genomic_deletion": {
                String delSeq = orig.equals("del") ? sequence.substring(startIdx, endIdx + 1) : orig;
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, delSeq, startIdx);
                return sequence.substring(0, leftAlignedIdx) + sequence.substring(leftAlignedIdx + delSeq.length());
            }
            case "protein_insertion": 
            case "dna_insertion": 
            case "rna_insertion": 
            case "genomic_insertion": {
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, newRes, endIdx + 1);
                return sequence.substring(0, leftAlignedIdx) + newRes + sequence.substring(leftAlignedIdx);
            }
            case "dna_duplication": {
                String dupSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, dupSeq, endIdx + 1);
                return sequence.substring(0, leftAlignedIdx) + dupSeq + sequence.substring(leftAlignedIdx);
            }
            case "dna_delins": 
            case "protein_delins": {
                String delSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, delSeq, startIdx);
                return sequence.substring(0, leftAlignedIdx) + newRes + sequence.substring(leftAlignedIdx + delSeq.length());
            }
            case "dna_inversion": {
                String invSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, invSeq, startIdx);
                String inv = new StringBuilder(invSeq).reverse().toString();
                return sequence.substring(0, leftAlignedIdx) + inv + sequence.substring(leftAlignedIdx + invSeq.length());
            }
            case "protein_frameshift": {
                return sequence.substring(0, startIdx) + "[" + orig + "fs]" + sequence.substring(startIdx + orig.length());
            }
            case "protein_stopgain": {
                return sequence.substring(0, startIdx) + "*";
            }
            case "protein_stoploss": {
                return sequence.replace("*", "");
            }
            case "protein_silent": {
                return sequence;
            }
        }
        return null;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    static String[] getGibsonFragments(Variant variant, String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return null;
        }
        Integer start = variant.getStartPosition();
        Integer end = variant.getEndPosition() != null ? variant.getEndPosition() : start;
        String orig = variant.getOriginalResidue() != null ? variant.getOriginalResidue() : "";
        String newRes = variant.getNewResidue() != null ? variant.getNewResidue() : "";
        String type = variant.getType();
        int startIdx = start - 1;
        int endIdx = end - 1;
        int seqLen = sequence.length();
        switch (type) {
            case "protein_snv": 
            case "dna_snv": 
            case "rna_snv": 
            case "genomic_snv": 
            case "cosmic_protein": 
            case "cosmic_base": 
            case "ensembl_protein": 
            case "ensembl_dna": {
                String refAtPos = sequence.substring(startIdx, Math.min(startIdx + orig.length(), seqLen));
                if (orig.equals(refAtPos) || Variant.isAmbiguousResidue(orig)) {
                    return new String[]{sequence.substring(0, startIdx), newRes, sequence.substring(startIdx + orig.length())};
                }
                int nearbyIdx = Variant.findOrigNearby(sequence, orig, startIdx, 3);
                if (nearbyIdx != -1) {
                    return new String[]{sequence.substring(0, nearbyIdx), newRes, sequence.substring(nearbyIdx + orig.length())};
                }
                throw new IllegalArgumentException("Original residue " + orig + " not found at or near position " + start + " in sequence for SNV.");
            }
            case "dna_mnv": {
                String refAtPos = sequence.substring(startIdx, Math.min(endIdx + 1, seqLen));
                if (orig.equals(refAtPos) || Variant.isAmbiguousResidue(orig)) {
                    return new String[]{sequence.substring(0, startIdx), newRes, sequence.substring(endIdx + 1)};
                }
                int nearbyIdx = Variant.findOrigNearby(sequence, orig, startIdx, 3);
                if (nearbyIdx != -1) {
                    return new String[]{sequence.substring(0, nearbyIdx), newRes, sequence.substring(nearbyIdx + orig.length())};
                }
                throw new IllegalArgumentException("Original residues " + orig + " not found at or near positions " + start + "-" + end + " in sequence for MNV.");
            }
            case "protein_deletion": 
            case "dna_deletion": 
            case "rna_deletion": 
            case "genomic_deletion": {
                String delSeq = orig.equals("del") ? sequence.substring(startIdx, endIdx + 1) : orig;
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, delSeq, startIdx);
                return new String[]{sequence.substring(0, leftAlignedIdx), "", sequence.substring(leftAlignedIdx + delSeq.length())};
            }
            case "protein_insertion": 
            case "dna_insertion": 
            case "rna_insertion": 
            case "genomic_insertion": {
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, newRes, endIdx + 1);
                return new String[]{sequence.substring(0, leftAlignedIdx), newRes, sequence.substring(leftAlignedIdx)};
            }
            case "dna_duplication": {
                String dupSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, dupSeq, endIdx + 1);
                return new String[]{sequence.substring(0, leftAlignedIdx), dupSeq, sequence.substring(leftAlignedIdx)};
            }
            case "protein_delins": 
            case "dna_delins": {
                String delSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, delSeq, startIdx);
                return new String[]{sequence.substring(0, leftAlignedIdx), newRes, sequence.substring(leftAlignedIdx + delSeq.length())};
            }
            case "dna_inversion": {
                String invSeq = sequence.substring(startIdx, endIdx + 1);
                int leftAlignedIdx = Variant.leftAlignIndel(sequence, invSeq, startIdx);
                String inv = new StringBuilder(invSeq).reverse().toString();
                return new String[]{sequence.substring(0, leftAlignedIdx), inv, sequence.substring(leftAlignedIdx + invSeq.length())};
            }
            case "protein_frameshift": {
                return new String[]{sequence.substring(0, startIdx), "[" + orig + "fs]", sequence.substring(startIdx + orig.length())};
            }
            case "protein_stopgain": {
                return new String[]{sequence.substring(0, startIdx), "*"};
            }
            case "protein_stoploss": {
                return new String[]{sequence.replace("*", "")};
            }
            case "protein_silent": {
                return new String[]{sequence};
            }
        }
        throw new IllegalArgumentException("Unsupported or ambiguous variant type: " + type);
    }

    public static String[] applyVariants(String sequence, List<Variant> variants) {
        if (variants == null || variants.isEmpty()) {
            return new String[]{sequence, "", ""};
        }
        ArrayList<Variant> sorted = new ArrayList<Variant>(variants);
        sorted.sort(Comparator.comparingInt(Variant::getStartPosition));
        StringBuilder sb = new StringBuilder(sequence);
        int[] posShift = new int[sequence.length() + 1000];
        for (int i = 0; i < posShift.length; ++i) {
            posShift[i] = 0;
        }
        int firstStart = ((Variant)sorted.get(0)).getStartPosition();
        int lastEnd = ((Variant)sorted.get(sorted.size() - 1)).getEndPosition() != null ? ((Variant)sorted.get(sorted.size() - 1)).getEndPosition() : ((Variant)sorted.get(sorted.size() - 1)).getStartPosition();
        int netShift = 0;
        block41: for (Variant v : sorted) {
            String type;
            int vStart = v.getStartPosition() + netShift;
            int vEnd = v.getEndPosition() != null ? v.getEndPosition() + netShift : vStart;
            int startIdx = vStart - 1;
            int endIdx = vEnd - 1;
            String orig = v.getOriginalResidue() != null ? v.getOriginalResidue() : "";
            String newRes = v.getNewResidue() != null ? v.getNewResidue() : "";
            switch (type = v.getType()) {
                case "protein_snv": 
                case "dna_snv": 
                case "rna_snv": 
                case "genomic_snv": 
                case "cosmic_protein": 
                case "cosmic_base": 
                case "ensembl_protein": 
                case "ensembl_dna": {
                    sb.replace(startIdx, startIdx + orig.length(), newRes);
                    continue block41;
                }
                case "dna_mnv": {
                    sb.replace(startIdx, endIdx + 1, newRes);
                    continue block41;
                }
                case "protein_deletion": 
                case "dna_deletion": 
                case "rna_deletion": 
                case "genomic_deletion": {
                    sb.delete(startIdx, endIdx + 1);
                    netShift -= endIdx + 1 - startIdx;
                    continue block41;
                }
                case "protein_insertion": 
                case "dna_insertion": 
                case "rna_insertion": 
                case "genomic_insertion": {
                    sb.insert(endIdx + 1, newRes);
                    netShift += newRes.length();
                    continue block41;
                }
                case "dna_duplication": {
                    String dupSeq = sb.substring(startIdx, endIdx + 1);
                    sb.insert(endIdx + 1, dupSeq);
                    netShift += dupSeq.length();
                    continue block41;
                }
                case "dna_delins": 
                case "protein_delins": {
                    sb.replace(startIdx, endIdx + 1, newRes);
                    netShift += newRes.length() - (endIdx + 1 - startIdx);
                    continue block41;
                }
                case "dna_inversion": {
                    String invSeq = sb.substring(startIdx, endIdx + 1);
                    String inv = new StringBuilder(invSeq).reverse().toString();
                    sb.replace(startIdx, endIdx + 1, inv);
                    continue block41;
                }
                case "protein_frameshift": {
                    sb.replace(startIdx, startIdx + orig.length(), "[" + orig + "fs]");
                    netShift += ("[" + orig + "fs]").length() - orig.length();
                    continue block41;
                }
                case "protein_stopgain": {
                    sb.delete(startIdx, sb.length());
                    continue block41;
                }
                case "protein_stoploss": {
                    int starIdx = sb.indexOf("*");
                    if (starIdx == -1) continue block41;
                    sb.deleteCharAt(starIdx);
                    continue block41;
                }
                case "protein_silent": {
                    continue block41;
                }
            }
            throw new IllegalArgumentException("Unsupported variant type: " + type);
        }
        int leftIdx = firstStart - 1;
        int totalShift = netShift;
        int rightIdx = lastEnd + netShift;
        leftIdx = Math.max(0, leftIdx);
        rightIdx = Math.min(sb.length(), rightIdx);
        String left = sb.substring(0, leftIdx);
        String middle = sb.substring(leftIdx, rightIdx);
        String right = sb.substring(rightIdx);
        return new String[]{left, middle, right};
    }

    private Variant(Integer startPosition, Integer endPosition, String originalResidue, String newResidue, String type, String source) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.originalResidue = originalResidue;
        this.newResidue = newResidue;
        this.type = type;
        this.source = source;
    }

    private Variant(Integer startPosition, Integer endPosition, String originalResidue, String newResidue, String type, String source, String annotation) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.originalResidue = originalResidue;
        this.newResidue = newResidue;
        this.type = type;
        this.source = source;
        this.annotation = annotation;
    }

    public Integer getStartPosition() {
        return this.startPosition;
    }

    public Integer getEndPosition() {
        return this.endPosition;
    }

    public String getOriginalResidue() {
        return this.originalResidue;
    }

    public String getNewResidue() {
        return this.newResidue;
    }

    public String getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public String getError() {
        return this.error;
    }

    void setError(String err) {
        this.error = err;
    }

    public boolean isValid() {
        return this.error == null;
    }

    public String toString() {
        return "Variant{startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", originalResidue='" + this.originalResidue + '\'' + ", newResidue='" + this.newResidue + '\'' + ", type='" + this.type + '\'' + ", source='" + this.source + '\'' + '}';
    }

    public static Variant variantFrom(String annotation) {
        Integer end;
        Integer start;
        String mut;
        Matcher mp;
        Matcher m = vcfPattern.matcher(annotation = annotation.trim());
        if (m.matches()) {
            String type = "vcf";
            int pos = Integer.parseInt(m.group("pos"));
            String ref = m.group("ref");
            String alt = m.group("alt");
            String id = m.group("id");
            String chr = m.group("chr");
            return new Variant(pos, pos, ref, alt, type, "VCF:" + chr + ":" + id, annotation);
        }
        m = dbsnpPattern.matcher(annotation);
        if (m.matches()) {
            String type = "dbsnp";
            int pos = Integer.parseInt(m.group("pos"));
            String ref = m.group("ref");
            String alt = m.group("alt");
            String rsid = m.group("rsid");
            String chr = m.group("chr");
            return new Variant(pos, pos, ref, alt, type, "dbSNP:rs" + rsid + ":" + chr, annotation);
        }
        m = cosmicProtein.matcher(annotation);
        if (m.matches() && (mp = simpleProtein.matcher(mut = m.group("mut"))).matches()) {
            int pos = Integer.parseInt(mp.group("pos"));
            return new Variant(pos, pos, mp.group("orig"), mp.group("new"), "cosmic_protein", "COSMIC", annotation);
        }
        m = cosmicBase.matcher(annotation);
        if (m.matches()) {
            int pos = Integer.parseInt(m.group("pos"));
            return new Variant(pos, pos, m.group("orig"), m.group("new"), "cosmic_base", "COSMIC", annotation);
        }
        m = ensemblPattern.matcher(annotation);
        if (m.matches()) {
            mut = m.group("mut");
            mp = simpleProtein.matcher(mut);
            if (mp.matches()) {
                int pos = Integer.parseInt(mp.group("pos"));
                return new Variant(pos, pos, mp.group("orig"), mp.group("new"), "ensembl_protein", "Ensembl", annotation);
            }
            m = dnaSNV.matcher(mut);
            if (m.matches()) {
                int pos = Integer.parseInt(m.group("pos"));
                return new Variant(pos, pos, m.group("orig"), m.group("new"), "ensembl_dna", "Ensembl", annotation);
            }
        }
        if ((m = proteinSNV3.matcher(annotation)).matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "protein_snv", "HGVS", annotation);
        }
        m = proteinSNV1.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "protein_snv", "HGVS", annotation);
        }
        m = proteinDel.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = m.group("end") != null ? Integer.valueOf(m.group("end")) : start;
            return new Variant(start, end, "del", null, "protein_deletion", "HGVS", annotation);
        }
        m = proteinIns.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = m.group("end") != null ? Integer.valueOf(m.group("end")) : start;
            return new Variant(start, end, "ins", m.group("ins"), "protein_insertion", "HGVS", annotation);
        }
        m = proteinDelins.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = m.group("end") != null ? Integer.valueOf(m.group("end")) : start;
            return new Variant(start, end, "delins", m.group("new"), "protein_delins", "HGVS", annotation);
        }
        m = proteinFS.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), "fs", "protein_frameshift", "HGVS", annotation);
        }
        m = proteinStop.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), "*", "protein_stopgain", "HGVS", annotation);
        }
        m = proteinSilent.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), "=", "protein_silent", "HGVS", annotation);
        }
        m = proteinLoss.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), "loss", "protein_stoploss", "HGVS", annotation);
        }
        m = dnaSNV.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "dna_snv", "HGVS", annotation);
        }
        m = dnaMNV.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("start")), Integer.valueOf(m.group("end")), m.group("orig"), m.group("new"), "dna_mnv", "HGVS", annotation);
        }
        m = dnaDel.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = m.group("end") != null ? Integer.valueOf(m.group("end")) : start;
            return new Variant(start, end, "del", m.group("delSeq"), "dna_deletion", "HGVS", annotation);
        }
        m = dnaIns.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "ins", m.group("insSeq"), "dna_insertion", "HGVS", annotation);
        }
        m = dnaSingleDup.matcher(annotation);
        if (m.matches()) {
            int pos = Integer.parseInt(m.group("pos"));
            return new Variant(pos, pos, "dup", null, "dna_duplication", "HGVS", annotation);
        }
        m = dnaDup.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("start")), Integer.valueOf(m.group("end")), "dup", null, "dna_duplication", "HGVS", annotation);
        }
        m = dnaDelins.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "delins", m.group("newSeq"), "dna_delins", "HGVS", annotation);
        }
        m = dnaSingleDelins.matcher(annotation);
        if (m.matches()) {
            int pos = Integer.parseInt(m.group("pos"));
            String newSeq = m.group("newSeq");
            return new Variant(pos, pos, "delins", newSeq, "dna_delins", "HGVS", annotation);
        }
        m = dnaSingleDel.matcher(annotation);
        if (m.matches()) {
            int pos = Integer.parseInt(m.group("pos"));
            String delSeq = m.group("delSeq");
            return new Variant(pos, pos, "del", delSeq, "dna_deletion", "HGVS", annotation);
        }
        m = dnaSingleIns.matcher(annotation);
        if (m.matches()) {
            int pos = Integer.parseInt(m.group("pos"));
            String insSeq = m.group("insSeq");
            return new Variant(pos, pos, "ins", insSeq, "dna_insertion", "HGVS", annotation);
        }
        m = dnaInv.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "inv", null, "dna_inversion", "HGVS", annotation);
        }
        m = rnaSNV.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "rna_snv", "HGVS", annotation);
        }
        m = rnaDel.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = m.group("end") != null ? Integer.valueOf(m.group("end")) : start;
            return new Variant(start, end, "del", m.group("delSeq"), "rna_deletion", "HGVS", annotation);
        }
        m = rnaIns.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "ins", m.group("insSeq"), "rna_insertion", "HGVS", annotation);
        }
        m = genomicSNV.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "genomic_snv", "HGVS", annotation);
        }
        m = genomicDel.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "del", m.group("delSeq"), "genomic_deletion", "HGVS", annotation);
        }
        m = genomicIns.matcher(annotation);
        if (m.matches()) {
            start = Integer.valueOf(m.group("start"));
            end = Integer.valueOf(m.group("end"));
            return new Variant(start, end, "ins", m.group("insSeq"), "genomic_insertion", "HGVS", annotation);
        }
        m = simpleProtein.matcher(annotation);
        if (m.matches()) {
            return new Variant(Integer.valueOf(m.group("pos")), null, m.group("orig"), m.group("new"), "protein_snv", "simple", annotation);
        }
        Variant fail = new Variant(null, null, null, null, null, null);
        fail.setError("Annotation format not recognized: " + annotation);
        return fail;
    }

    public static void main(String[] args) {
        String sequence = "ATGGCCTAGGAACCTTG";
        ArrayList<Variant> variants = new ArrayList<Variant>();
        variants.add(new Variant(4, 6, "del", null, "dna_deletion", "HGVS"));
        variants.add(new Variant(2, 2, "ins", "TT", "dna_insertion", "HGVS"));
        variants.add(new Variant(8, null, "A", "C", "dna_snv", "HGVS"));
        String[] result = Variant.applyVariants(sequence, variants);
        System.out.println("Left:   " + result[0]);
        System.out.println("Middle: " + result[1]);
        System.out.println("Right:  " + result[2]);
        System.out.println("Original Sequence:  " + sequence);
        System.out.println("Expected Sequence:  ATTTGTCGGAACCTTG");
        System.out.println("Obtained Sequence:  " + result[0] + "[" + result[1] + "]" + result[2]);
    }
}

