/*
 * Decompiled with CFR 0.152.
 */
package Gibson;

class GibsonPrimer {
    public int start = 0;
    public int stop = 0;
    String sequence;
    String name;
    String comment;
    int tmPBS;
    public boolean isAntisense = false;
    int pbsLen = 0;
    private static final String COMMENT_END = ".  PBS in underlined lowercase.  Overlap in uppercase.";

    GibsonPrimer() {
    }

    public boolean isValid() {
        return this.start > 0 && this.stop > 0;
    }

    public String getHTMLFormatedResults() {
        return "<tr><th align=\"right\">" + this.name + "</th><th align=\"left\">" + GibsonPrimer.htmlSequence(this) + "</th><th align=\"center\">" + this.tmPBS + "</th><th align=\"center\">" + this.sequence.length() + "</th><th align=\"left\">" + this.comment + COMMENT_END + "</th></tr>";
    }

    public static String htmlSequence(GibsonPrimer p) {
        return p.sequence.substring(0, p.sequence.length() - p.pbsLen).toUpperCase() + "<u>" + p.sequence.substring(p.sequence.length() - p.pbsLen).toLowerCase() + "</u>";
    }

    public String pbs() {
        return this.sequence != null && this.sequence.length() >= this.pbsLen && this.pbsLen > 0 ? this.sequence.substring(this.sequence.length() - this.pbsLen) : "";
    }

    public String overlap() {
        return this.sequence != null && this.sequence.length() >= this.pbsLen && this.pbsLen > 0 ? this.sequence.substring(0, this.sequence.length() - this.pbsLen) : "";
    }

    void adjust(int bp, int maxSeqLen) {
        this.start += bp;
        this.stop += bp;
        if (this.start > maxSeqLen) {
            this.start -= maxSeqLen;
        }
        if (this.stop > maxSeqLen) {
            this.stop -= maxSeqLen;
        }
    }

    public String getFormattedResults() {
        return this.name + "\t\t" + this.comment + "\t" + this.sequence + "\tTm:" + String.valueOf(this.tmPBS);
    }

    public void copy(GibsonPrimer srcPrimer) {
        this.comment = srcPrimer.comment;
        this.tmPBS = srcPrimer.tmPBS;
        this.name = srcPrimer.name;
        this.sequence = srcPrimer.sequence;
    }
}

