/*
 * Decompiled with CFR 0.152.
 */
package Gibson;

import Gibson.GibsonPrimer;
import Gibson.GibsonPrimerMaker;
import SequenceEditorPanels.ROI;
import Tools.FrmOutput;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import plot.Feature;
import plot.PLOTJ;
import plot.ProjectDocument;

public class FrmGibson
extends JFrame {
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmGibson.this.lblStatus.setText(c.getToolTipText());
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmGibson.this.lblStatus.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    FrmOutput frmHelp;
    FrmOutput frmPrimers;
    String help = "<html><body><b>Gibson/SLIC Generator Help Document</b><br><b><u>Vector Backbone</u></b><br>Paste backbone name and sequence in their respective text boxes.<br>The vector backbone is optional and only required if you wish to generate primers where <br>the first and last inserts will have the full length of the overlaps to the vector backbone<br>contained in their sequences.  This is used for instances where the linear backbone is generated<br>by restriction digest. If the vector sequence is left blank, primers will be generated such that<br> the fragments can be assembled into a circular construct.<br><br><b><u>Insert Sequences</u></b><br>Paste inserts in order to be assembled in FASTA format in bottom text box<br><br>Example: ('...' indicates the rest of the sequence omitted for brevity)<br>>EGFP<br>ATGGTGAGCAAGGGCGAGGAGCTGTTCACCGGGGTGGTGCCCATCCTG<br>...<br>GTGACCGCCGCCGGGATCACTCTCGGCATGGACGAGCTGTACAAG<br><br>>Seq2_Name<br>[TGAGCCA] ATTCAACGGGAAACGTCTTGCTCTAGGCCGCGATTAAATT<br>GGGTATAAATGGGCTCGCGATAATGTCGGGCAATCAGGTGCGACAATCT<br><br>>Seq3_Name<br>[CGCC] GAGTTGTTTCTGAAACATGGCAAAGGTAGCGTTGCCAATGATG<br>AACTGGCTGACGGAATTTATGCCTCTTCCGACCATCAAGCATTTTATCC<br><br><b><u>Adding Non-Template Sequences</u></b><br>Backbone and inserts may have non-template sequences designed into the primers by surrounding the<br>sequences to be added to the 5' and 3' ends with brackets.<br><br><b>Example</b>: to add a Kozak signal 'CCACC' to the start of the EGFP ORF and a stop codon 'TAA' to the end<br> of the EGFP, the sequence could appear as below ('...' indicates the rest of the sequence omitted for brevity).<br>>Kozak_EGFP<br>[ccacc]ATGGTGAGCAAGGGCGAGGAGCTGTTCACCGGGGTGGT<br>...<br>GTGACCGCCGCCGGGATCACTCTCGGCATGGACGAGCTGTACAAG[taa]<br><br><b>Note</b> For the primer designing step, there is no difference between adding a<br>non-template sequence to the 3' end of the first sequence or adding it to the 5' end of the second sequence<br><br><b><u>Options</u></b><br>If the 'Inserts Only' option is selected, primers to linearize the vector will not be generated and the <br>forward primer of the first insert will have the complete overhang to the vector, to include any added sequences.<br>If the 'Inserts and Vector' option is selected, primers to linearize the vector will be generated.  By default, primers<br>are designed to balance the length with the overlaps modulated to balance the overlapping primers.<br>The Min Primer PBS Len. and Min PBS Tm boxes specify the minimum length and Tm of the primer binding sites.<br><br>The Overlap Length dropdown box specifies the length of the overlaps between primers and the Tm Calculation dropdown box<br>specifies the type of calculation used for determining the melting temperature of the PBS sequene.<br><br><b><u>Generating Sequences</u></b><br>To design and copy primers to the clipboard, click the 'Make Primers' button.  To make the primers<br>and expected sequence and open them in a new pLOT window, click 'Make Sequence'.  The resulting sequence<br>will have the inserts, vector, and primers annotated.<br><br><b><u>Example</u></b><br>To assemble a promoter fragment to a GFP lacking a kozak and stop codon fragments,<br>sequences could be entered as any of the following where <i>Plasmid_Sequence</i> and <i>GFP_Sequence</i> indicate the<br>plasmid backbone and GFP sequences respectively:<br><p>backbone: <i>Plasmid_Sequence</i>[ccacc]<br>insert: <i>GFP_Sequence</i>[taa]<br> - or -<br>backbone: <i>Plasmid_Sequence</i><br>insert: [ccacc]<i>GFP_Sequence</i>[taa]<br> - or -<br>backbone: [taa]<i>Plasmid_Sequence</i><br>insert: [ccacc]<i>GFP_Sequence</i><br> - or -<br>backbone: [taa]<i>Plasmid_Sequence</i>[ccacc]<br>insert: <i>GFP_Sequence</i></p><br>Any of these would result in a circular sequence of <i>Plasmid_Sequence</i>[ccacc]<i>GFP_Sequence</i>[taa]<br><br></body></html>";
    private JComboBox<String> cmbCalcType;
    private JComboBox<String> cmbMinPrimerLen;
    private JComboBox<String> cmbMinPrimerTm;
    private JComboBox<String> cmbOverlap;
    private JButton cmdClose;
    JButton cmdHelp;
    private JButton cmdMakePrimers;
    private ButtonGroup grpPrimers;
    private ButtonGroup grpSeq;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblStatus;
    private JRadioButton opInserts;
    private JRadioButton opInsertsAndVector;
    private JRadioButton opPrimers;
    private JRadioButton opPrimersSeq;
    private JTextArea txtInserts;
    private JTextField txtName;
    private JTextArea txtSeq;

    public FrmGibson() {
        this.initComponents();
        this.cmdMakePrimers.addMouseListener(this.menuMouseListener);
        this.cmdHelp.addMouseListener(this.menuMouseListener);
        this.cmdClose.addMouseListener(this.menuMouseListener);
        this.opInserts.addMouseListener(this.menuMouseListener);
        this.opInsertsAndVector.addMouseListener(this.menuMouseListener);
        this.cmbCalcType.addMouseListener(this.menuMouseListener);
        this.cmbMinPrimerLen.addMouseListener(this.menuMouseListener);
        this.cmbMinPrimerTm.addMouseListener(this.menuMouseListener);
        this.cmbOverlap.addMouseListener(this.menuMouseListener);
        this.opPrimers.addMouseListener(this.menuMouseListener);
        this.opPrimersSeq.addMouseListener(this.menuMouseListener);
        ((JLabel)((Object)this.cmbMinPrimerLen.getRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)this.cmbCalcType.getRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)this.cmbMinPrimerTm.getRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)this.cmbOverlap.getRenderer())).setHorizontalAlignment(0);
        try {
            this.cmdHelp.setIcon(new ImageIcon(FrmGibson.class.getResource("/icons/QUESTION.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (FrmGibson.this.frmHelp != null) {
                    FrmGibson.this.frmHelp.dispose();
                }
                if (FrmGibson.this.frmPrimers != null) {
                    FrmGibson.this.frmPrimers.dispose();
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    private void initComponents() {
        this.grpPrimers = new ButtonGroup();
        this.grpSeq = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtSeq = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.txtInserts = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.opInserts = new JRadioButton();
        this.opInsertsAndVector = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.cmbOverlap = new JComboBox();
        this.jLabel5 = new JLabel();
        this.cmbCalcType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.cmbMinPrimerLen = new JComboBox();
        this.jLabel7 = new JLabel();
        this.cmbMinPrimerTm = new JComboBox();
        this.lblStatus = new JLabel();
        this.jPanel4 = new JPanel();
        this.cmdClose = new JButton();
        this.cmdHelp = new JButton();
        this.cmdMakePrimers = new JButton();
        this.opPrimers = new JRadioButton();
        this.opPrimersSeq = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gibson Designer");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Vector Backbone (Optional)"));
        this.jLabel1.setText("Name");
        this.jLabel2.setText("Sequence");
        this.txtSeq.setColumns(20);
        this.txtSeq.setLineWrap(true);
        this.txtSeq.setRows(5);
        this.jScrollPane1.setViewportView(this.txtSeq);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtName)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Inserts"));
        this.jPanel2.setOpaque(false);
        this.txtInserts.setColumns(20);
        this.txtInserts.setLineWrap(true);
        this.txtInserts.setRows(5);
        this.jScrollPane2.setViewportView(this.txtInserts);
        this.jLabel3.setText("Enter inserts in FastA format in order to be assembled");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 89, Short.MAX_VALUE)).addComponent(this.jScrollPane2)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jPanel3.setOpaque(false);
        this.grpPrimers.add(this.opInserts);
        this.opInserts.setText("Inserts only");
        this.opInserts.setToolTipText("Generate insert fragment primers only");
        this.grpPrimers.add(this.opInsertsAndVector);
        this.opInsertsAndVector.setSelected(true);
        this.opInsertsAndVector.setText("Inserts & vector");
        this.opInsertsAndVector.setToolTipText("Generate insert fragment and vector linearization primers");
        this.jLabel4.setText("Overlap length");
        this.cmbOverlap.setModel(new DefaultComboBoxModel<String>(new String[]{"15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50"}));
        this.cmbOverlap.setSelectedIndex(5);
        this.cmbOverlap.setToolTipText("Homology overlap length");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Tm Calculation");
        this.cmbCalcType.setModel(new DefaultComboBoxModel<String>(new String[]{"Generic", "Nearest Neighbor", "Taq", "Q5", "Q5U", "Vent", "Phusion"}));
        this.cmbCalcType.setSelectedIndex(3);
        this.cmbCalcType.setToolTipText("Annealing temperature calculation method.");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Min. Primer PBS Len.");
        this.cmbMinPrimerLen.setModel(new DefaultComboBoxModel<String>(new String[]{"18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"}));
        this.cmbMinPrimerLen.setToolTipText("Minimum length for the annealing portion of generated primers.");
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Min. PBS Tm");
        this.cmbMinPrimerTm.setModel(new DefaultComboBoxModel<String>(new String[]{"45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72"}));
        this.cmbMinPrimerTm.setSelectedIndex(15);
        this.cmbMinPrimerTm.setToolTipText("Minimum PBS annealing temperature for generated primers.");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opInserts).addComponent(this.opInsertsAndVector)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbOverlap, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.cmbMinPrimerLen, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.cmbMinPrimerTm, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addGap(0, 11, Short.MAX_VALUE)).addComponent(this.cmbCalcType, 0, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(1, 1, 1).addComponent(this.cmbMinPrimerLen, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbMinPrimerTm, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbOverlap, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbCalcType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.opInserts).addGap(5, 5, 5).addComponent(this.opInsertsAndVector)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Generate"));
        this.jPanel4.setOpaque(false);
        this.cmdClose.setText("Close");
        this.cmdClose.setToolTipText("Close Gibson Designer");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGibson.this.cmdCloseActionPerformed(evt);
            }
        });
        this.cmdHelp.setToolTipText("Show help");
        this.cmdHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGibson.this.cmdHelpActionPerformed(evt);
            }
        });
        this.cmdMakePrimers.setText("Generate");
        this.cmdMakePrimers.setToolTipText("Generate primers and/or sequence");
        this.cmdMakePrimers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGibson.this.cmdMakePrimersActionPerformed(evt);
            }
        });
        this.grpSeq.add(this.opPrimers);
        this.opPrimers.setText("Primers only");
        this.opPrimers.setToolTipText("If selected, only primers are generated.");
        this.grpSeq.add(this.opPrimersSeq);
        this.opPrimersSeq.setSelected(true);
        this.opPrimersSeq.setText("Primers + Sequence");
        this.opPrimersSeq.setToolTipText("If selected, primers and expected sequence are generated.");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdMakePrimers, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdHelp, -2, 34, -2).addComponent(this.opPrimersSeq).addComponent(this.opPrimers)).addGap(0, 10, Short.MAX_VALUE)).addComponent(this.cmdClose, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.opPrimers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.opPrimersSeq).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdHelp, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdMakePrimers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdClose).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addGap(3, 3, 3).addComponent(this.lblStatus, -2, 25, -2)));
        this.pack();
    }

    private void cmdMakePrimersActionPerformed(ActionEvent evt) {
        this.makeSeqPrimers();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmdHelpActionPerformed(ActionEvent evt) {
        if (this.frmHelp == null) {
            this.frmHelp = new FrmOutput((Frame)this, false);
            this.frmHelp.setIconImage(this.getIconImage());
            this.frmHelp.setText(this.help);
        }
        this.frmHelp.setVisible(true);
    }

    private void makeSeqPrimers() {
        GibsonPrimerMaker maker = new GibsonPrimerMaker();
        maker.setMin_HA_Len(this.cmbOverlap.getSelectedIndex() + 15);
        maker.setTm_Calc_Type(this.cmbCalcType.getSelectedIndex());
        maker.setMin_PBS_Len(this.cmbMinPrimerLen.getSelectedIndex() + 18);
        maker.setMin_PBS_tm(this.cmbMinPrimerTm.getSelectedIndex() + 45);
        String vectorName = this.txtName.getText().trim();
        if (vectorName.length() == 0) {
            vectorName = "Vector";
        }
        if (!maker.setVector(vectorName, this.txtSeq.getText())) {
            JOptionPane.showMessageDialog(this, maker.getError(), "Vector backbone error", 0, null);
            return;
        }
        List<Map.Entry<String, String>> inserts = FrmGibson.parseFasta(this.txtInserts.getText());
        if (inserts.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Parsing inserts failed.  Inserts should be entered in Fasta format.  Ex:\n >Seq1_Name\n GATCCTCTACGCCGGACGCATCGTGGCCGGCATCACCGGCGCCACAGGTGCGGTTGCTGGCGCCTATATCGC\n CGACATCACCGATGGGGAAGATCGGGCTCGCCACTTCGGGCTCATGAGCGCTTGTTTCGGCGTGGGTATGGT\n GGCAGGCCCCGTGGCCGGGGGACTGTTGGGCGCCATCTCCTTGCATGCACCATTCCTTGCGGCGGCGGTGCT\n >Seq2_Name\n [TGAGCCA]ATTCAACGGGAAACGTCTTGCTCTAGGCCGCGATTAAATTCCAACATGGATGCTGATTTATAT\n GGGTATAAATGGGCTCGCGATAATGTCGGGCAATCAGGTGCGACAATCTATCGATTGTATGGGAAGCCCGAT\n >Seq3_Name\n [CGCC]GAGTTGTTTCTGAAACATGGCAAAGGTAGCGTTGCCAATGATGTTACAGATGAGATGGTCAGACTA\n AACTGGCTGACGGAATTTATGCCTCTTCCGACCATCAAGCATTTTATCCGTACTCCTGATGATG[ATGGTT]", "Error", 0, null);
            return;
        }
        for (Map.Entry<String, String> insert : inserts) {
            if (maker.addFragment(insert.getKey(), insert.getValue())) continue;
            JOptionPane.showMessageDialog(this, "Error with insert " + insert.getKey() + "\n" + maker.getError(), "Error entering insert", 0, null);
            return;
        }
        maker.setMakeVectorPrimers(this.opInsertsAndVector.isSelected());
        List<GibsonPrimer> primers = maker.getPrimers();
        if (primers == null || primers.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Primer generation failed.", "Error", 0, null);
            return;
        }
        if (this.frmPrimers == null) {
            this.frmPrimers = new FrmOutput((Frame)this, false);
            this.frmPrimers.setTitle("Gibson Assembly Generated Primers");
            this.frmPrimers.setIconImage(this.getIconImage());
        }
        String head = "<html>\n<head>\n<style>\nth {\n    white-space: nowrap;\n}</style>\n</head>\n<body>";
        StringBuilder pList = null;
        pList = new StringBuilder(head + "<table><tr><th><b><u>Primer Name</u></b></th><th><b><u>Primer Sequence (5' - 3')</u></b></th><th><b><u>Tm (C)</u></b></th><th><b><u>Length</u></b></th><th><b><u>Comments</u></b></th></tr>");
        for (GibsonPrimer p : primers) {
            pList.append(p.getHTMLFormatedResults());
        }
        pList.append("</table></body></html>");
        this.frmPrimers.setText(pList.toString());
        this.frmPrimers.setVisible(true);
        if (this.opPrimersSeq.isSelected()) {
            PLOTJ outFrm = PLOTJ.getActiveInstance();
            if (outFrm == null) {
                return;
            }
            if (outFrm.getProject().length() > 0) {
                outFrm = PLOTJ.newInstance();
                this.setVisible(true);
            }
            ProjectDocument doc = outFrm.getProject();
            doc.setName(vectorName + "_Gibson");
            pList = new StringBuilder("Primers:");
            for (GibsonPrimer p : primers) {
                pList.append("\n").append(p.getFormattedResults());
            }
            doc.setNotes("Expected sequence after Gibson Assembly.  Primers used:\n" + pList.toString());
            doc.setSequence(maker.getSequence());
            List<Feature> features = maker.getROI();
            for (Feature feat : features) {
                doc.addROI((ROI)feat);
            }
            doc.setCircular(true);
            doc.setChanged(true);
            doc.fireEvents(new int[]{116});
        }
    }

    static List<Map.Entry<String, String>> parseFasta(String fastaInput) {
        ArrayList<Map.Entry<String, String>> sequences = new ArrayList<Map.Entry<String, String>>();
        String[] lines = fastaInput.split("\\r?\\n");
        String currentName = null;
        StringBuilder currentSeq = new StringBuilder();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith(">")) {
                if (currentName != null) {
                    sequences.add(new AbstractMap.SimpleEntry<String, String>(currentName, currentSeq.toString()));
                }
                currentName = line.substring(1).trim();
                currentSeq = new StringBuilder();
                continue;
            }
            currentSeq.append(line);
        }
        if (currentName != null) {
            sequences.add(new AbstractMap.SimpleEntry<Object, String>(currentName, currentSeq.toString()));
        }
        return sequences;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmGibson.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmGibson.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmGibson.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmGibson.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmGibson().setVisible(true);
            }
        });
    }
}

