/*
 * Decompiled with CFR 0.152.
 */
package CopyTools;

import Clipboards.ClipBoard;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import plot.Feature;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.ProjectDocument;

public class SelectionToFasta
extends PLOTJPlugin {
    String iconPath = "/icons/Copy.png";

    public SelectionToFasta() {
        this.setName("Copy selected to clipboard as FASTA");
        this.setDescription("Converts selected items to FASTA format and copies to clipboard sorted alphabetically by name");
        this.setIcon(this.iconPath);
    }

    public void run() {
        ProjectDocument doc = PLOTJ.getActiveDocument();
        if (doc != null || doc.getFeatureCount() > 0) {
            Feature[] selectedF = doc.getSelectedItems(0);
            if (selectedF == null || selectedF.length == 0) {
                return;
            }
            int count = selectedF.length;
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < count; ++x) {
                if (x > 0) {
                    sb.append("\n\n");
                }
                sb.append(">").append(selectedF[x].getName()).append("\n").append(doc.getSequence(selectedF[x].getStart(), selectedF[x].getStop(), selectedF[x].isAntisense()));
            }
            String fasta = sb.toString();
            ClipBoard cb = new ClipBoard();
            StringSelection outData = new StringSelection(fasta);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(outData, (ClipboardOwner)cb);
        }
    }
}

