/*
 * Decompiled with CFR 0.152.
 */
package CopyTools;

import Clipboards.ClipBoard;
import Sequences.SequenceExportFormat;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.JOptionPane;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.ProjectDocument;

public class CopyTool
extends PLOTJPlugin {
    String iconPath = "/icons/Copy.png";

    public CopyTool() {
        this.setName("Copy a specified region to the clipboard");
        this.setDescription("Copies a specified region to the clipboard");
        this.setIcon(this.iconPath);
    }

    public void run() {
        ProjectDocument doc = PLOTJ.getActiveDocument();
        if (doc == null || doc.length() == 0) {
            return;
        }
        String range = (String)JOptionPane.showInputDialog(null, "Enter first and last base pair in the range to copy", "Copy to clipboard", 1, null, null, "1 - 100");
        String[] ranges = range.split("-");
        if (ranges.length != 2) {
            return;
        }
        try {
            int start = Integer.parseInt(ranges[0].trim());
            int stop = Integer.parseInt(ranges[1].trim());
            SequenceExportFormat.SequenceTransferable t = SequenceExportFormat.createTransferable((SequenceExportFormat)doc.getSEF(start, stop));
            if (t != null) {
                ClipBoard cb = new ClipBoard();
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)t, (ClipboardOwner)cb);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

