/*
 * Decompiled with CFR 0.152.
 */
package CopyTools;

import Sequences.SequenceExportFormat;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import plot.Feature;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.ProjectDocument;

public class SelectionToFusion
extends PLOTJPlugin {
    String iconPath = "/icons/Copy.png";

    public SelectionToFusion() {
        this.setName("Copy fused selection.");
        this.setDescription("Copies the selected features in order selected and fuses them then copies them to the clipboard.");
        this.setIcon(this.iconPath);
    }

    public void run() {
        ProjectDocument doc = PLOTJ.getActiveDocument();
        ProjectDocument newDoc = new ProjectDocument();
        if (doc == null) {
            return;
        }
        Feature[] features = doc.getSelectedItems(0);
        if (features.length > 0) {
            for (int x = 0; x < features.length; ++x) {
                Feature f = features[x];
                SequenceExportFormat sef = doc.getSEF(f.getStart(), f.getStop(), f.isAntisense());
                if (x > 0) {
                    newDoc.insert(newDoc.length() + 1, sef);
                    continue;
                }
                newDoc.setSequence(sef);
            }
            SequenceExportFormat sef = newDoc.getSEF(1, newDoc.length(), false);
            sef.name = "Fusion";
            SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable((SequenceExportFormat)sef);
            if (transferable != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)transferable, null);
            }
        }
    }
}

