/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import FileReaders.ExternalLibrary;
import FileReaders.TextFileWriter;
import plot.Ladder;

class UserLadders
extends ExternalLibrary {
    public BinaryChain<Ladder> items;

    @Override
    public void init() {
        this.setHistoryKey("userladderlibpath");
        this.items = new BinaryChain();
        this.setTitle("User Ladders Library");
        this.setDefaultSaveName("userladders.dat");
        this.setOpenExtension(".dat");
        this.setSaveExtension(".dat");
    }

    public UserLadders() {
    }

    public UserLadders(String filepath) {
        super(filepath);
    }

    @Override
    public boolean loadFileContents(String file) {
        this.items.clear();
        String[] lines = this.getFileData(file);
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (String line : lines) {
            Ladder ladder = Ladder.fromString(line);
            if (ladder == null) continue;
            this.items.add(ladder, ladder.name);
        }
        return true;
    }

    @Override
    public boolean saveContents(TextFileWriter writer) {
        for (Ladder item : this.items) {
            writer.writeLine(item.toSaveString(item));
        }
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
    }
}

