/*
 * Decompiled with CFR 0.152.
 */
package plot;

import ProteinTools.CodonTable;
import SequenceEditorPanels.Base;
import SequenceEditorPanels.DNASequenceDocument;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import Sequences.SequenceExportFormat;
import UndoRedo.ChangeEvent;
import UndoRedo.Undoable;
import UndoRedo.UndoableAction;
import plot.EnzymeFeature;
import plot.PrimerFeature;
import plot.ProjectDocument;

class Undoables {
    Undoables() {
    }

    public static Undoable createUndoable_setName(final ProjectDocument project, final String newName) {
        final String oldName = project.getName();
        if (newName != null && !newName.equals(oldName)) {
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    project.setName(oldName);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setName(newName);
                    return true;
                }
            };
            edit.undoName = "Undo rename";
            edit.redoName = "Redo rename";
            edit.runRedo();
            return edit;
        }
        return null;
    }

    public static Undoable createUndoable_setOrigin(final ProjectDocument project, final int position) {
        if (position < 2 || position > project.length()) {
            return null;
        }
        Undoable edit = new Undoable(){
            int newStart;
            int seqLen;
            {
                this.newStart = position;
                this.seqLen = project.length();
            }

            @Override
            public boolean undo() {
                int oldStart = this.seqLen - position + 2;
                if (project.getSequenceBases().rotateTo(oldStart - 1)) {
                    int count = project.getFeatureCount();
                    if (count > 0) {
                        for (int x = 0; x < count; ++x) {
                            project.getFeature(x).rotateOrigin(oldStart, this.seqLen);
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean redo() {
                if (project.getSequenceBases().rotateTo(this.newStart - 1)) {
                    int count = project.getFeatureCount();
                    if (count > 0) {
                        for (int x = 0; x < count; ++x) {
                            project.getFeature(x).rotateOrigin(this.newStart, this.seqLen);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        edit.undoName = "Undo rotate";
        edit.redoName = "Redo rotate";
        return edit;
    }

    public static Undoable createUndoable_setCodonTable(final ProjectDocument project, int index) {
        if (index == project.getCodonTable().getOrganismIndex()) {
            return null;
        }
        final String oldOrgName = project.getCodonTable().getOrganismName();
        final String newOrgName = CodonTable.getOrganismName(index);
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                project.setCodonTable(oldOrgName);
                return true;
            }

            @Override
            public boolean redo() {
                project.setCodonTable(newOrgName);
                return true;
            }
        };
        return edit;
    }

    public static Undoable createUndoable_setSource(final ProjectDocument project, final String source) {
        if (source == null || source.equals(project.getSource())) {
            return null;
        }
        final String oldSource = project.getSource();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                project.setSource(oldSource);
                return true;
            }

            @Override
            public boolean redo() {
                project.setSource(source);
                return true;
            }
        };
        edit.undoName = "Undo set source";
        edit.redoName = "Redo set source";
        return edit;
    }

    public static Undoable createUndoable_Sequence(final ProjectDocument project, final String seq) {
        final String oldSeq = project.getSequence();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                Undoables.main_setSeq(project, oldSeq);
                return true;
            }

            @Override
            public boolean redo() {
                Undoables.main_setSeq(project, seq);
                return true;
            }
        };
        edit.undoName = "Undo set sequence";
        edit.redoName = "Redo set sequence";
        return edit;
    }

    public static Undoable createUndoable_setAccession(final ProjectDocument project, final String accession) {
        if (accession == null || accession.equals(project.getAccession())) {
            return null;
        }
        final String oldSource = project.getAccession();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                project.setAccession(oldSource, false);
                return true;
            }

            @Override
            public boolean redo() {
                project.setAccession(accession, false);
                return true;
            }
        };
        edit.undoName = "Undo set accession";
        edit.redoName = "Redo set accession";
        return edit;
    }

    public static Undoable createUndoable_antisense(final ProjectDocument project) {
        if (project.length() == 0) {
            return null;
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                if (Undoables.main_AntisenseSeq(project)) {
                    Undoables.main_AntisenseFeatures(project);
                    return true;
                }
                return false;
            }

            @Override
            public boolean redo() {
                if (Undoables.main_AntisenseSeq(project)) {
                    Undoables.main_AntisenseFeatures(project);
                    return true;
                }
                return false;
            }
        };
        if (project instanceof ProjectDocument) {
            Undoable editFP = new Undoable(){

                @Override
                public boolean undo() {
                    return Undoables.main_AntisenseFP(project);
                }

                @Override
                public boolean redo() {
                    return Undoables.main_AntisenseFP(project);
                }
            };
            edit.addEdit(editFP);
        }
        edit.redoName = "Redo antisense";
        edit.undoName = "Undo antisense";
        return edit;
    }

    public static Undoable createUndoable_Features(final ProjectDocument project, final ExtensibleArray<ROI> newFeatures) {
        Undoable edit = new Undoable(){
            ExtensibleArray<ROI> backup;
            {
                this.backup = Undoables.cloneFeatures(project.getFeatures());
            }

            @Override
            public boolean undo() {
                project.getFeatures().copyFrom(this.backup);
                return true;
            }

            @Override
            public boolean redo() {
                project.getFeatures().copyFrom(newFeatures);
                return true;
            }
        };
        edit.redoName = "Redo features";
        edit.undoName = "Undo features";
        return edit;
    }

    private static ExtensibleArray<ROI> cloneFeatures(ExtensibleArray<ROI> src) {
        ExtensibleArray<ROI> clonedFeatures = new ExtensibleArray<ROI>(ROI.class);
        for (ROI roi : src) {
            clonedFeatures.add(roi.clone());
        }
        return clonedFeatures;
    }

    public static Undoable createUndoable_setSEF(final ProjectDocument project, final SequenceExportFormat data) {
        ExtensibleArray<ROI> newFeatures = new ExtensibleArray<ROI>(ROI.class);
        if (data.annotations != null && data.annotations.length > 0) {
            newFeatures.copyFrom(project.getFeatures());
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                return true;
            }

            @Override
            public boolean redo() {
                return true;
            }
        };
        Undoable editSeq = Undoables.createUndoable_Sequence(project, data.sequence);
        Undoable editFeatures = Undoables.createUndoable_Features(project, newFeatures);
        edit.addEdit(editSeq);
        edit.addEdit(editFeatures);
        if (data.circular != project.isCircular()) {
            Undoable editTopology = Undoables.createUndoable_Circular(project, data.circular);
            edit.addEdit(editTopology);
            edit.setAfterRedoAction(new UndoableAction(){

                @Override
                public boolean run() {
                    if (project.isListenerActive()) {
                        project.fireEvents(new ChangeEvent(6, data.circular), new ChangeEvent(107), new ChangeEvent(10));
                    }
                    return true;
                }
            });
            edit.setAfterRedoAction(new UndoableAction(){

                @Override
                public boolean run() {
                    if (project.isListenerActive()) {
                        project.fireEvents(new ChangeEvent(6, data.circular), new ChangeEvent(107), new ChangeEvent(10));
                    }
                    return true;
                }
            });
        } else {
            UndoableAction action = new UndoableAction(){

                @Override
                public boolean run() {
                    if (project.isListenerActive()) {
                        project.fireEvents(new ChangeEvent(10));
                    }
                    return true;
                }
            };
            edit.setAfterRedoAction(action);
            edit.setAfterUndoAction(action);
        }
        edit.redoName = "Redo sequence changes";
        edit.undoName = "Undo sequence changes";
        return edit;
    }

    public static Undoable createUndoable_Circular(final ProjectDocument project, final boolean isCircular) {
        if (isCircular == project.isCircular()) {
            return null;
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                project.setCircular(!isCircular);
                return true;
            }

            @Override
            public boolean redo() {
                project.setCircular(isCircular);
                return true;
            }
        };
        edit.undoName = isCircular ? "Undo circular" : "Undo linear";
        edit.redoName = !isCircular ? "Redo circular" : "Redo linear";
        return edit;
    }

    protected Undoable createUndoable_ClearFeatures(final ProjectDocument project) {
        Undoable editFeatures = new Undoable(){
            ExtensibleArray<ROI> backup;
            {
                this.backup = Undoables.cloneFeatures(project.getFeatures());
            }

            @Override
            public boolean undo() {
                project.getFeatures().copyFrom(this.backup);
                return true;
            }

            @Override
            public boolean redo() {
                project.getFeatures().clear();
                return true;
            }
        };
        return editFeatures;
    }

    public static boolean main_setSeq(ProjectDocument project, String seq) {
        int seqLen;
        if (seq == null) {
            seq = "";
        }
        if ((seqLen = seq.length()) > 0) {
            Base[] newSeqArray = new Base[seqLen + project.getSequenceBases().getBufferSize()];
            for (int x = 0; x < seqLen; ++x) {
                Base base;
                newSeqArray[x] = base = new Base(seq.charAt(x));
            }
            project.getSequenceBases().clear();
            project.getSequenceBases().add((Base[])newSeqArray);
            project.regenerateAA();
            return true;
        }
        return false;
    }

    public static boolean main_AntisenseSeq(ProjectDocument project) {
        int seqLen = project.length();
        if (seqLen == 0) {
            return false;
        }
        int mid = seqLen / 2;
        int lastIndex = seqLen - 1;
        Base[] sequence = project.getBaseArray();
        for (int i = 0; i <= mid; ++i) {
            Base c2;
            int i2 = lastIndex - i;
            Base c1 = sequence[i];
            sequence[i] = c2 = sequence[i2];
            c2.complement();
            if (1 == i2) break;
            sequence[i2] = c1;
            c1.complement();
        }
        return true;
    }

    public static boolean main_AntisenseFeatures(DNASequenceDocument project) {
        int seqLen = project.length();
        int count = project.getFeatureCount();
        if (count > 0) {
            for (int x = 0; x < count; ++x) {
                project.getROI(x).antisense(seqLen);
            }
            return true;
        }
        return false;
    }

    public static boolean main_AntisenseFP(ProjectDocument project) {
        int seqLen = project.length();
        if (seqLen == 0) {
            return false;
        }
        if (!project.foundPrimers.isEmpty()) {
            for (PrimerFeature p : project.foundPrimers) {
                p.antisense(seqLen);
            }
        }
        if (!project.foundEnzymes.isEmpty()) {
            for (EnzymeFeature e : project.foundEnzymes) {
                e.antisense(seqLen);
            }
        }
        return !project.foundPrimers.isEmpty() && !project.foundEnzymes.isEmpty();
    }

    public static boolean main_uppercase(ProjectDocument project, int first, int last) {
        int seqLen = project.length();
        if (first < 1 || last < 1 || first > last || first > seqLen || last > seqLen) {
            return false;
        }
        boolean retVal = false;
        Base[] sequence = project.getBaseArray();
        for (int index = first - 1; index < last; ++index) {
            if (sequence[index].getBase() <= '`' && sequence[index].getBase() >= '{') continue;
            sequence[index].uppercase();
            retVal = true;
        }
        return retVal;
    }

    public static boolean main_lowercase(ProjectDocument project, int first, int last) {
        int seqLen = project.length();
        if (first < 1 || last < 1 || first > last || first > seqLen || last > seqLen) {
            return false;
        }
        boolean retVal = false;
        Base[] sequence = project.getBaseArray();
        for (int index = first - 1; index < last; ++index) {
            if (sequence[index].getBase() <= '@' && sequence[index].getBase() >= '[') continue;
            sequence[index].lowercase();
            retVal = true;
        }
        return retVal;
    }

    public static boolean main_setSrc(ProjectDocument project, String source) {
        if (source != null && !project.getSource().equals(source)) {
            project.setSource(source, false);
            return true;
        }
        return false;
    }

    public static boolean main_setCodonTable(ProjectDocument project, int index) {
        project.getCodonTable().setOrganism(index);
        if (project.length() > 0) {
            project.regenerateAA();
        }
        return true;
    }

    public static boolean main_setCodonTable(ProjectDocument project, String orgName) {
        project.getCodonTable().setOrganism(orgName);
        if (project.length() > 0) {
            project.regenerateAA();
        }
        return true;
    }
}

