/*
 * Decompiled with CFR 0.152.
 */
package plot;

import SequenceEditorPanels.ROI;
import UndoRedo.ChangeEvent;
import UndoRedo.Undoable;
import java.awt.Window;
import java.util.ArrayList;
import plot.Feature;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;

abstract class TempFeatureDlg
extends MainExclusiveDlg {
    ArrayList<Feature> addedFeatures = new ArrayList();

    public TempFeatureDlg(PLOTJ parent) {
        super((Window)parent);
    }

    public TempFeatureDlg(PLOTJ parent, boolean modal) {
        super((Window)parent);
    }

    boolean removeAddedFeatures() {
        if (!this.addedFeatures.isEmpty()) {
            ProjectDocument project = this.getProject();
            for (Feature f : this.addedFeatures) {
                project.removeROI(f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void doCancel() {
        if (this.removeAddedFeatures()) {
            ((PLOTJ)this.getParent()).resetMap();
        }
        this.dispose();
    }

    @Override
    public void doOK() {
        if (!this.addedFeatures.isEmpty()) {
            final ProjectDocument project = this.getProject();
            this.removeAddedFeatures();
            final boolean changed = project.isChanged();
            for (Feature f : this.addedFeatures) {
                project.removeROI(f);
            }
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    for (Feature f : TempFeatureDlg.this.addedFeatures) {
                        project.removeROI(f);
                    }
                    project.fireEvents(new ChangeEvent(106));
                    project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (Feature f : TempFeatureDlg.this.addedFeatures) {
                        project.addROI((ROI)f);
                    }
                    project.fireEvents(new ChangeEvent(106));
                    project.setChanged(true);
                    return true;
                }
            };
            project.runEdit(edit);
        }
        this.dispose();
    }
}

