/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import java.util.Arrays;
import java.util.Comparator;
import plot.Enzyme;

class ProjectEnzyme {
    public static final Comparator sortComparator = new Comparator<ProjectEnzyme>(){

        @Override
        public int compare(ProjectEnzyme o1, ProjectEnzyme o2) {
            return o1.enzyme.name.compareToIgnoreCase(o2.enzyme.name);
        }
    };
    public static final Comparator schizoComp = new Comparator<ProjectEnzyme>(){

        @Override
        public int compare(ProjectEnzyme o1, ProjectEnzyme o2) {
            if (o1.enzyme.isoschizomer == o2.enzyme.isoschizomer) {
                return 0;
            }
            if (o1.enzyme.isoschizomer) {
                return 1;
            }
            return -1;
        }
    };
    Enzyme enzyme;
    transient Locus[] cuts = null;
    transient Locus[] bands = null;
    transient Locus position = new Locus();
    ProjectEnzyme proto;

    public int getCutCount() {
        return this.cuts != null ? this.cuts.length : 0;
    }

    public ProjectEnzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
    }

    public String toString() {
        return this.enzyme.name;
    }

    public ProjectEnzyme clone() {
        ProjectEnzyme out = new ProjectEnzyme(this.enzyme);
        if (this.cuts != null) {
            out.cuts = Arrays.copyOf(this.cuts, this.cuts.length);
        }
        if (this.bands != null) {
            out.bands = Arrays.copyOf(this.bands, this.bands.length);
        }
        out.position.cloneFrom(this.position);
        out.proto = this.proto;
        return out;
    }
}

