/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import plot.Feature;
import plot.FoundPrimer;
import plot.ProjectDocument;

class PrimerFeature
extends Feature {
    public FoundPrimer foundPrimer;

    public PrimerFeature() {
        this.setGBType("primer_bind");
        this.setTextColor(ProjectDocument.getPrimerColor());
    }

    @Override
    public PrimerFeature clone() {
        PrimerFeature clone = new PrimerFeature();
        clone.foundPrimer = this.foundPrimer;
        clone.set(this.start, this.stop, this.antisense);
        return clone;
    }

    public PrimerFeature(FoundPrimer primer, int start, int stop, boolean antisense) {
        this();
        this.foundPrimer = primer;
        this.start = start;
        this.stop = stop;
        this.antisense = antisense;
    }

    public PrimerFeature(FoundPrimer primer, Locus position) {
        this();
        this.foundPrimer = primer;
        this.set(position.getStart(), position.getStop(), position.isAntisense());
    }

    @Override
    public String getName() {
        return this.foundPrimer != null ? this.foundPrimer.refPrimer.name : "Unnamed";
    }

    @Override
    public String getLabelText() {
        if (this.antisense) {
            return this.getName() + " (" + this.stop + " - " + this.start + ") <<<<";
        }
        return this.getName() + " (" + this.start + " - " + this.stop + ") >>>>";
    }
}

