/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Frame_DD_File_Handler.ValidatingFormFileTransferHandler;
import GhostTextControls.GhostTextBox;
import JMOptionPanes.JMOptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import plot.DefaultLibraries;
import plot.Globals;

class PrefsPanel
extends JMOptionPane {
    boolean retVal = false;
    public boolean fLibChanged = false;
    public boolean uLibChanged = false;
    public boolean lLibChanged = false;
    public String newFLibPath = "";
    public String newULibPath = "";
    public String newLLibPath = "";
    public JCheckBox chkShow;
    private JButton cmUserLadders;
    private JButton cmdCancel;
    private JButton cmdOK;
    private JButton cmdResetLadders;
    private JButton cmdResetUser;
    private JButton cmdResetUserLib;
    private JButton cmdUser;
    private JButton cmdUserLibrary;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    public GhostTextBox txtFLib;
    public GhostTextBox txtLadders;
    public GhostTextBox txtPrimers;

    public PrefsPanel() {
        this.initComponents();
        this.txtFLib.setTransferHandler(new ValidatingFormFileTransferHandler(){

            @Override
            public void droppedFiles(List<File> filesList, int x, int y) {
                PrefsPanel.this.txtFLib.setText(filesList.get(0).getAbsolutePath());
            }

            @Override
            public boolean filesValid(List filesList) {
                return !filesList.isEmpty() && ((File)filesList.get(0)).getAbsolutePath().toLowerCase().endsWith("userlibrary.da2");
            }
        });
        this.txtPrimers.setTransferHandler(new ValidatingFormFileTransferHandler(){

            @Override
            public void droppedFiles(List<File> filesList, int x, int y) {
                PrefsPanel.this.txtPrimers.setText(filesList.get(0).getAbsolutePath());
            }

            @Override
            public boolean filesValid(List filesList) {
                return !filesList.isEmpty() && ((File)filesList.get(0)).getAbsolutePath().toLowerCase().endsWith("user.dat");
            }
        });
        this.txtLadders.setTransferHandler(new ValidatingFormFileTransferHandler(){

            @Override
            public void droppedFiles(List<File> filesList, int x, int y) {
                PrefsPanel.this.txtLadders.setText(filesList.get(0).getAbsolutePath());
            }

            @Override
            public boolean filesValid(List filesList) {
                return !filesList.isEmpty() && ((File)filesList.get(0)).getAbsolutePath().toLowerCase().endsWith("ladders.dat");
            }
        });
        this.chkShow.setSelected(Globals.history.getUserPref().getBoolean("showFilesPrompt", true));
        this.chkShow.setVisible(false);
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "enter");
        actionMap.put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PrefsPanel.this.cmdOKActionPerformed(null);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "esc");
        actionMap.put("esc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PrefsPanel.this.cmdCancelActionPerformed(null);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtPrimers = new GhostTextBox();
        this.cmdUser = new JButton();
        this.jLabel3 = new JLabel();
        this.txtLadders = new GhostTextBox();
        this.cmUserLadders = new JButton();
        this.cmdResetUserLib = new JButton();
        this.cmdResetUser = new JButton();
        this.jLabel1 = new JLabel();
        this.cmdResetLadders = new JButton();
        this.cmdUserLibrary = new JButton();
        this.chkShow = new JCheckBox();
        this.txtFLib = new GhostTextBox();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.cmdOK = new JButton();
        this.cmdCancel = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.txtPrimers.setEditable(false);
        this.txtPrimers.setBackground(new Color(255, 255, 255));
        this.txtPrimers.setBlankText("Drag and drop or use button to set the location of User .dat");
        this.txtPrimers.setToolTipText("Drag and drop or use button to set the location of User .dat");
        this.cmdUser.setText("...");
        this.cmdUser.setToolTipText("Click to select the location os your 'User.dat' file.");
        this.cmdUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdUserActionPerformed(evt);
            }
        });
        this.jLabel3.setText("User Ladder Library");
        this.txtLadders.setEditable(false);
        this.txtLadders.setBackground(new Color(255, 255, 255));
        this.txtLadders.setBlankText("Drag and drop or use button to set the location of Ladders.dat");
        this.txtLadders.setToolTipText("Drag and drop or use button to set the location of Ladders.dat");
        this.cmUserLadders.setText("...");
        this.cmUserLadders.setToolTipText("Click to select the location os your 'Ladders.da2' file.");
        this.cmUserLadders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmUserLaddersActionPerformed(evt);
            }
        });
        this.cmdResetUserLib.setIcon(new ImageIcon(this.getClass().getResource("/images16/Undo.png")));
        this.cmdResetUserLib.setToolTipText("Reset path to last set file location.");
        this.cmdResetUserLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdResetUserLibActionPerformed(evt);
            }
        });
        this.cmdResetUser.setIcon(new ImageIcon(this.getClass().getResource("/images16/Undo.png")));
        this.cmdResetUser.setToolTipText("Reset path to last set file location.");
        this.cmdResetUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdResetUserActionPerformed(evt);
            }
        });
        this.jLabel1.setText("User Features Library");
        this.cmdResetLadders.setIcon(new ImageIcon(this.getClass().getResource("/images16/Undo.png")));
        this.cmdResetLadders.setToolTipText("Reset path to last set file location.");
        this.cmdResetLadders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdResetLaddersActionPerformed(evt);
            }
        });
        this.cmdUserLibrary.setText("...");
        this.cmdUserLibrary.setToolTipText("Click to select the location os your 'UserLibrary.da2' file.");
        this.cmdUserLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdUserLibraryActionPerformed(evt);
            }
        });
        this.chkShow.setText("Show at startup if libraries are not found");
        this.txtFLib.setEditable(false);
        this.txtFLib.setBackground(new Color(255, 255, 255));
        this.txtFLib.setBlankText("Drag and drop or use button to set the location of UserLibrary.da2");
        this.txtFLib.setToolTipText("Drag and drop or use button to set the location of UserLibrary.da2");
        this.jLabel2.setText("User Primers Library");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.chkShow).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.txtPrimers, -1, 373, Short.MAX_VALUE).addComponent(this.txtLadders, -1, -1, Short.MAX_VALUE).addComponent(this.txtFLib, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.cmdUserLibrary).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdResetUserLib)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.cmdUser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdResetUser))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.cmUserLadders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdResetLadders))))).addGap(5, 5, 5)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cmdUserLibrary).addComponent(this.cmdResetUserLib).addComponent(this.txtFLib, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cmdUser).addComponent(this.cmdResetUser).addComponent(this.txtPrimers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.txtLadders, -2, -1, -2).addComponent(this.cmUserLadders).addComponent(this.cmdResetLadders)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkShow).addGap(0, 0, 0)));
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        this.jPanel2.setMinimumSize(new Dimension(150, 35));
        this.jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        this.cmdOK.setText("OK");
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdOKActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdOK);
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsPanel.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdCancel);
        this.add((Component)this.jPanel2, "Last");
    }

    private void cmdUserActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser f = new JFileChooser();
        if (DefaultLibraries.userLibrary.getLoadedFilePath().length() > 0) {
            f.setSelectedFile(new File(DefaultLibraries.userLibrary.getLoadedFilePath()));
        } else {
            f.setSelectedFile(new File("User.dat"));
        }
        if (f.showOpenDialog(this) == 0 && (file = f.getSelectedFile()) != null && file.exists() && file.isFile() && file.canRead()) {
            this.txtPrimers.setText(file.getAbsolutePath());
        }
    }

    private void cmUserLaddersActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser f = new JFileChooser();
        if (DefaultLibraries.userLadders.getLoadedFilePath().length() > 0) {
            f.setSelectedFile(new File(DefaultLibraries.userLadders.getLoadedFilePath()));
        } else {
            f.setSelectedFile(new File("Ladders.dat"));
        }
        if (f.showOpenDialog(this) == 0 && (file = f.getSelectedFile()) != null && file.exists() && file.isFile() && file.canRead()) {
            this.txtLadders.setText(file.getAbsolutePath());
        }
    }

    private void cmdResetUserLibActionPerformed(ActionEvent evt) {
        this.txtFLib.setText(DefaultLibraries.userFeatures.getLoadedFilePath());
    }

    private void cmdResetUserActionPerformed(ActionEvent evt) {
        this.txtPrimers.setText(DefaultLibraries.userLibrary.getLoadedFilePath());
    }

    private void cmdResetLaddersActionPerformed(ActionEvent evt) {
        this.txtLadders.setText(DefaultLibraries.userLadders.getLoadedFilePath());
    }

    private void cmdUserLibraryActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser f = new JFileChooser();
        if (DefaultLibraries.userFeatures.getLoadedFilePath().length() > 0) {
            f.setSelectedFile(new File(DefaultLibraries.userFeatures.getLoadedFilePath()));
        } else {
            f.setSelectedFile(new File("UserLibrary.da2"));
        }
        if (f.showOpenDialog(this) == 0 && (file = f.getSelectedFile()) != null && file.exists() && file.isFile() && file.canRead()) {
            this.txtFLib.setText(file.getAbsolutePath());
        }
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        String fLib = this.txtFLib.getText().trim();
        String pLib = this.txtPrimers.getText().trim();
        String lLib = this.txtLadders.getText().trim();
        if (!fLib.equalsIgnoreCase(DefaultLibraries.userFeatures.getLoadedFilePath())) {
            if (fLib.length() > 0 && !this.isFileValid(fLib, this.cmdUserLibrary)) {
                return;
            }
            this.newFLibPath = fLib;
            this.fLibChanged = true;
        }
        if (!pLib.equalsIgnoreCase(DefaultLibraries.userLibrary.getLoadedFilePath())) {
            if (pLib.length() > 0 && !this.isFileValid(pLib, this.cmdUser)) {
                return;
            }
            this.newULibPath = pLib;
            this.uLibChanged = true;
        }
        if (!lLib.equalsIgnoreCase(DefaultLibraries.userLadders.getLoadedFilePath())) {
            if (lLib.length() > 0 && !this.isFileValid(lLib, this.cmUserLadders)) {
                return;
            }
            this.newLLibPath = lLib;
            this.lLibChanged = true;
        }
        if (this.chkShow.isVisible()) {
            Globals.history.getUserPref().putBoolean("showFilesPrompt", this.chkShow.isSelected());
        }
        this.retVal = this.fLibChanged || this.uLibChanged || this.lLibChanged;
        this.hideParentDialog();
    }

    private boolean isFileValid(String filePath, Component returnFocusComponent) {
        File file = new File(filePath);
        if (!file.exists() || file.isDirectory()) {
            JMOptionPane.showConfirmDialog(this, "<html>The specified file<br>" + filePath + "<br> does not exist.</html>", "File path error", null, 3);
            returnFocusComponent.requestFocus();
            return false;
        }
        if (!file.canRead()) {
            JMOptionPane.showConfirmDialog(this, "<html>The specified file<br>" + filePath + "<br> does not have read access.</html>", "File path error", null, 3);
            returnFocusComponent.requestFocus();
            return false;
        }
        return true;
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.retVal = false;
        this.hideParentDialog();
    }

    @Override
    public Object getInputValue() {
        return this.retVal;
    }

    @Override
    public void setSelectionValues(Object[] values) {
    }

    @Override
    public void setInitialSelectionValue(Object value) {
    }

    @Override
    public void selectInitialValue() {
        this.txtFLib.setText(DefaultLibraries.userFeatures.getLoadedFilePath());
        this.txtPrimers.setText(DefaultLibraries.userLibrary.getLoadedFilePath());
        this.txtLadders.setText(DefaultLibraries.userLadders.getLoadedFilePath());
    }
}

