/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Encoders.Ascii85;
import MiscTools.StringTools;
import Sequences.DNA;
import java.io.Serializable;
import java.util.Comparator;
import plot.DefaultLibraries;
import plot.PrimerCategory;

public class PlotPrimer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRIMER_LEN = 5;
    public static final Comparator sortComparator = new Comparator<PlotPrimer>(){

        @Override
        public int compare(PlotPrimer o1, PlotPrimer o2) {
            return o1.name.compareToIgnoreCase(o2.name);
        }
    };
    public boolean isDefault = false;
    public String name = "";
    public String sequence = "";
    public String comment = "";
    public int minAnneal = 15;
    public String searchSeq;
    public String location = "";
    public transient PrimerCategory category;

    public void setName(String name) {
        if (name != null && name.length() > 0 && (name = name.trim()) != null && name.length() > 0) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMinAnneal() {
        return this.minAnneal;
    }

    public void setSequence(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return;
        }
        String fSeq = DNA.filterSequence(sequence);
        if (fSeq == null || fSeq.length() == 0) {
            return;
        }
        this.sequence = fSeq;
    }

    public void setLocation(String location) {
        if (location == null || location.length() == 0) {
            return;
        }
        this.location = location;
    }

    public void setComment(String comment) {
        if (comment == null || comment.length() == 0) {
            return;
        }
        this.comment = comment;
    }

    public void setMinAnneal(int minAnneal) {
        if (minAnneal > 0) {
            this.minAnneal = minAnneal;
        }
    }

    public void setMinAnneal(String annealLenString) {
        if (annealLenString != null && annealLenString.length() > 0) {
            try {
                int intMinAnneal = Integer.parseInt(annealLenString);
                this.setMinAnneal(intMinAnneal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public PlotPrimer clone() {
        PlotPrimer clone = new PlotPrimer();
        clone.name = this.name;
        clone.sequence = this.sequence;
        clone.searchSeq = this.searchSeq;
        clone.minAnneal = this.minAnneal;
        clone.location = this.location;
        clone.comment = this.comment;
        clone.category = this.category;
        return clone;
    }

    public void cloneTo(PlotPrimer primer) {
        primer.name = this.name;
        primer.sequence = this.sequence;
        primer.searchSeq = this.searchSeq;
        primer.minAnneal = this.minAnneal;
        primer.location = this.location;
        primer.comment = this.comment;
        primer.category = this.category;
    }

    public void cloneFrom(PlotPrimer primer) {
        this.name = primer.name;
        this.sequence = primer.sequence;
        this.searchSeq = primer.searchSeq;
        this.minAnneal = primer.minAnneal;
        this.location = primer.location;
        this.comment = primer.comment;
        this.category = primer.category;
    }

    public String getCategoryName() {
        return this.category != null ? this.category.name : "";
    }

    public String toExportString() {
        return "Primer\t" + this.name + "\t" + this.sequence + "\t" + (this.comment != null && this.comment.length() > 0 ? Ascii85.encode(this.comment) : "") + "\t" + this.minAnneal + "\t" + (this.category != null ? this.category.name : "") + "\t" + (this.location != null && this.location.length() > 0 ? Ascii85.encode(this.location) : "");
    }

    public String toString() {
        return this.name;
    }

    public static PlotPrimer fromString(String datafileline) {
        if (datafileline.startsWith(";")) {
            return null;
        }
        String[] entries = datafileline.split("\t");
        if (entries.length < 2 || !entries[0].equalsIgnoreCase("Primer")) {
            return null;
        }
        PlotPrimer outPrimer = new PlotPrimer();
        outPrimer.name = entries[1].trim();
        outPrimer.sequence = DNA.filterSequence(entries[2]);
        if (outPrimer.sequence.length() < 5) {
            return null;
        }
        if (entries.length > 3) {
            outPrimer.comment = Ascii85.decode(entries[3]);
        }
        if (entries.length > 4) {
            outPrimer.minAnneal = StringTools.filterStringToInt(entries[4]);
        }
        if (entries.length < 6 || entries[5].length() == 0 || entries[5].equalsIgnoreCase("[No Category]")) {
            outPrimer.category = DefaultLibraries.catNoCategory;
        } else if (DefaultLibraries.primerCategories.containsKey(entries[5])) {
            outPrimer.category = DefaultLibraries.primerCategories.get(entries[5]);
        } else {
            PrimerCategory cat;
            outPrimer.category = cat = new PrimerCategory(entries[5]);
            DefaultLibraries.primerCategories.add(cat, cat.name);
        }
        if (entries.length > 6) {
            outPrimer.location = Ascii85.decode(entries[6]);
        }
        return outPrimer;
    }
}

