/*
 * Decompiled with CFR 0.152.
 */
package plot;

import FileConverters.ImpFileWriter;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import Sequences.DNA;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import plot.DefaultConverter;
import plot.EnzymeFilter;
import plot.EnzymeMix;
import plot.Feature;
import plot.ProjectDocument;
import plot.ProjectEnzyme;

class PlotFileWriter
implements ImpFileWriter,
DefaultConverter {
    protected String error = null;

    PlotFileWriter() {
    }

    @Override
    public String getWriteFileExtension() {
        return "plt";
    }

    @Override
    public String getWriteFormatDescription() {
        return "pLOT Genbank Format";
    }

    @Override
    public String getWriteError() {
        return this.error != null ? this.error : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File write(File dest, ProjectDocument project) {
        if (!(!dest.exists() || dest.isFile() && dest.canWrite())) {
            return null;
        }
        BufferedWriter writer = null;
        try {
            FileWriter fw = new FileWriter(dest);
            writer = new BufferedWriter(fw);
            writer.write(project.toGBString());
            int refCount = project.getReferenceCount();
            if (refCount > 0) {
                for (int x = 0; x < refCount; ++x) {
                    writer.write("\n" + project.getReference(x).toGBString(x));
                }
            }
            if (!project.selectedEnzymes.isEmpty()) {
                for (ProjectEnzyme projectEnzyme : project.selectedEnzymes) {
                    writer.write("\nCOMMENT ENZYME = " + projectEnzyme.enzyme.getName());
                }
            }
            if (!project.enzymeMixes.isEmpty()) {
                for (EnzymeMix enzymeMix : project.enzymeMixes) {
                    writer.write("\n" + enzymeMix.toGBString());
                }
            }
            if (!project.enzymeFilters.isEmpty()) {
                for (EnzymeFilter enzymeFilter : project.enzymeFilters) {
                    writer.write("\n" + enzymeFilter.toGBString());
                }
            }
            writer.write("\nFEATURES             Location/Qualifiers");
            ExtensibleArray<ROI> features = project.getFeatures();
            if (!features.isEmpty()) {
                for (ROI roi : features) {
                    Feature f = (Feature)roi;
                    writer.write("\n" + f.toGBString());
                }
            }
            writer.write("\nORIGIN\n");
            writer.write(DNA.getFormattedSequence(project.getSequence(), 10));
            writer.write("//");
            writer.close();
            File file = dest;
            return file;
        }
        catch (IOException ex) {
            this.error = "Save error: " + ex.getLocalizedMessage();
            System.err.println(this.error);
            File file = null;
            return file;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                this.error = "Writter close error: " + iOException.getLocalizedMessage();
                System.err.println(this.error);
                return null;
            }
        }
    }

    @Override
    public int getSortOrder() {
        return 0;
    }
}

