/*
 * Decompiled with CFR 0.152.
 */
package plot;

import AboutWindow.AboutForm;
import Buttons.Constants;
import Buttons.LongPressButton;
import CustomLabels.ColorLabel;
import CustomPopupMenus.MenuScroller;
import DNATools.DegenerateFinder;
import DockingPanel.DockPanel;
import DockingPanel.DockingWindow;
import DocumentFilters.DocumentKeyFilter;
import FileConverters.ImpFileReader;
import FileConverters.ImpFileWriter;
import GenbankFileReader.GenBankFile;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import JMOptionPanes.JMOptionPane;
import MiscTools.StringTools;
import MouseMenuListeners.Listeners;
import Plugins.Plugin;
import Plugins.PluginCollection;
import Plugins.PluginLoader;
import Plugins.PluginPackage;
import Plugins.PluginsObject;
import ProteinTools.CodonTable;
import Renderers.MetallicRenderer;
import ScrollPanels.ScrollPanel;
import ScrollPanels.StatusLabel;
import ScrollableSearchablePopupMenu.ScrollSearchPopupMenu;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import SequenceEditorPanels.SeqDragListener;
import SequenceEditorPanels.SequenceDocumentChangeListener;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.DNA;
import Sequences.SequenceExportFormat;
import StatusBarDialogs.FrmStatusBar;
import StatusBarDialogs.ThreadRunner;
import ToolTip.BasicTextToolTip;
import Tools.SystemInfo;
import UIRenderers.RenderedMenuItemScrollUI;
import UIRenderers.RenderedMenuSeparatorUI;
import UndoRedo.ChangeEvent;
import UndoRedo.Undoable;
import UndoRedo.UndoableAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.jdesktop.swingx.VerticalLayout;
import plaf.BaseRootPaneUI;
import plaf.Defaults;
import plaf.Themes;
import plot.Circle;
import plot.CustomSliderUI;
import plot.DefaultLibraries;
import plot.EnzymeFeature;
import plot.EnzymeMix;
import plot.Feature;
import plot.FeatureRenderer;
import plot.FileReaders;
import plot.FileSeqDandDHandler;
import plot.FileWriters;
import plot.FilenameUtils;
import plot.FrmAAToDNA;
import plot.FrmAnnotations;
import plot.FrmAutoAnnotate;
import plot.FrmBpToCodon;
import plot.FrmCodonToBp;
import plot.FrmEditPrimers;
import plot.FrmEditSeq;
import plot.FrmElementFinder;
import plot.FrmEnzymes;
import plot.FrmFLibEditor;
import plot.FrmFind;
import plot.FrmGBDownload;
import plot.FrmGel;
import plot.FrmHelp;
import plot.FrmLadders;
import plot.FrmNewFeature;
import plot.FrmNewSeq;
import plot.FrmOutput;
import plot.FrmSearchRecents;
import plot.FrmUpdate;
import plot.Globals;
import plot.GraphicsListRenderer;
import plot.IconListRenderer;
import plot.JOptionPanes;
import plot.Label;
import plot.LibraryFeature;
import plot.ObjectSpacer;
import plot.PlotPrimer;
import plot.PrefsPanel;
import plot.PrimerCategory;
import plot.PrimerFeature;
import plot.ProjectDocument;
import plot.ProjectEnzyme;
import plot.SpacedRect;
import plot.SpacedRectV;
import plot.StaticArrayComboModel;
import plot.myClipboard;

public final class PLOTJ
extends JFrame
implements SequenceDocumentChangeListener {
    private static final int GRAPHIC_COLOR = 0;
    private static final int LABEL_COLOR = 1;
    private static final int GRAPHIC_AND_LABEL_COLOR = 2;
    private static int MAX_CAT_SHOWN = 16;
    private ProjectDocument project = new ProjectDocument();
    FrmStatusBar statusBarForm;
    FontMetrics fontMetric;
    AffineTransform cAT = null;
    AffineTransform rAT = null;
    FrmGel gelForm;
    Component activeComponent = null;
    int panelHeight = 0;
    int panelWidth = 0;
    int displayType = 1;
    FrmHelp frmHelp;
    FrmOutput outputWindow;
    private boolean useOverlay = false;
    ButtonModel toggleLinkModel;
    private MouseListener opaqueAdjuster = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (button.isEnabled()) {
                button.setOpaque(true);
                button.setContentAreaFilled(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            button.setOpaque(false);
            button.setContentAreaFilled(false);
        }
    };
    private boolean showSensePrimers = true;
    private boolean showAntisensePrimers = true;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                PLOTJ.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            PLOTJ.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private final JPopupMenu.Separator toggleAllCat = Globals.genToolTipSep("Toggle all categories", 0, this.menuMouseListener);
    private final JMenuItem selectAllCat = new JMenuItem("Select all categories");
    private final JMenuItem deselectAllCat = new JMenuItem("Deselect all categories");
    private final JPopupMenu.Separator toggleLib = Globals.genToolTipSep("Toggle by library", 0, this.menuMouseListener);
    private final JRadioButtonMenuItem showDefOnly = new JRadioButtonMenuItem("Show default primers only");
    private final JRadioButtonMenuItem showUserOnly = new JRadioButtonMenuItem("Show user primers only");
    private final JPopupMenu.Separator toggleDir = Globals.genToolTipSep("Toggle by direction", 0, this.menuMouseListener);
    private final JRadioButtonMenuItem showSenseAndAntisense = new JRadioButtonMenuItem("Show sense and antisense primers");
    private final JRadioButtonMenuItem showSense = new JRadioButtonMenuItem("Show sense primers only");
    private final JRadioButtonMenuItem showAntisense = new JRadioButtonMenuItem("Show antisense primers only");
    private final JRadioButtonMenuItem showDefAndUser = new JRadioButtonMenuItem("Show default and user primers");
    private final JPopupMenu.Separator toggleDatabaseCat = Globals.genToolTipSep("Toggle by category", 0, this.menuMouseListener);
    private final JPopupMenu.Separator footerDatabaseCat = Globals.genToolTipSep("Toggle all categories", 2, this.menuMouseListener);
    private final MouseListener linkLabelMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == PLOTJ.this.lblEditNotes) {
                FrmAnnotations f = new FrmAnnotations(PLOTJ.this);
                f.tabPanel.setSelectedIndex(1);
                f.setVisible(true);
            } else if (e.getSource() == PLOTJ.this.lblEditAnnotations) {
                FrmAnnotations f = new FrmAnnotations(PLOTJ.this);
                f.tabPanel.setSelectedIndex(0);
                f.setVisible(true);
            } else if (e.getSource() == PLOTJ.this.lblEditReferences) {
                // empty if block
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Color color;
            JLabel label = (JLabel)e.getSource();
            if (label.isEnabled() && (color = UIManager.getColor("Plot.link.active")) != null) {
                label.setForeground(color);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Color color;
            JLabel label = (JLabel)e.getSource();
            if (label.isEnabled() && (color = UIManager.getColor("Plot.link.inactive")) != null) {
                label.setForeground(color);
            }
        }
    };
    private BufferedImage canvasBuffer;
    private Graphics2D canvasGraphics;
    private Rectangle titleRect = new Rectangle();
    BasicTextToolTip toolTip;
    private int tDividerLoc = 0;
    private int fDividerLoc = 0;
    private static final int SEPWIDTH = 6;
    CustomSliderUI uiAlpha;
    CustomSliderUI uiDO;
    CustomSliderUI uiWd;
    CustomSliderUI uiOf;
    ScrollSearchPopupMenu primersPopupMenu;
    private RenderedMenuItemScrollUI menuScrollSepUpUI = new RenderedMenuItemScrollUI(1, false);
    private RenderedMenuItemScrollUI menuScrollSepDownUI = new RenderedMenuItemScrollUI(3, false);
    private String baseTitle = "";
    private ImpFileWriter lastWriter = FileWriters.getpLOTWriter();
    int startVal = 0;
    private JCheckBox chkCircular;
    private JCheckBox chkDrawGraphic;
    private JCheckBox chkShowLabel;
    private JCheckBoxMenuItem chkToggleOverlay;
    private JComboBox<String> cmbGBType;
    private JComboBox<FeatureRenderer> cmbGraphic;
    private JComboBox<Integer> cmbOrient;
    private JButton cmdChromat;
    private JToggleButton cmdCircular;
    private JMenuItem cmdDelFeature;
    private JMenuItem cmdDelSequence;
    private JButton cmdNew;
    private JButton cmdOpen;
    private JButton cmdRedo;
    private JButton cmdSave;
    private JToggleButton cmdShowLabels;
    private JToggleButton cmdShowPrimers;
    private JToggleButton cmdShowRE;
    private JToggleButton cmdToggleOverlay;
    private JButton cmdUndo;
    private LongPressButton cmdZoom100;
    private JButton cmdZoomIn;
    private JButton cmdZoomOut;
    DockPanel dockFeatures;
    DockPanel dockTools;
    SequenceEditorPanel editor;
    private ButtonGroup grpCodonTableFeature;
    private ButtonGroup grpCodonTableProject;
    private JSplitPane hSplitPane;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JMenuItem jMenuItem13;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane4;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator22;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator24;
    private JPopupMenu.Separator jSeparator25;
    private JPopupMenu.Separator jSeparator26;
    private JPopupMenu.Separator jSeparator27;
    private JPopupMenu.Separator jSeparator28;
    private JPopupMenu.Separator jSeparator29;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator30;
    private JPopupMenu.Separator jSeparator31;
    private JPopupMenu.Separator jSeparator32;
    private JPopupMenu.Separator jSeparator33;
    private JPopupMenu.Separator jSeparator34;
    private JPopupMenu.Separator jSeparator35;
    private JPopupMenu.Separator jSeparator36;
    private JPopupMenu.Separator jSeparator38;
    private JPopupMenu.Separator jSeparator39;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator40;
    private JPopupMenu.Separator jSeparator41;
    private JPopupMenu.Separator jSeparator42;
    private JPopupMenu.Separator jSeparator43;
    private JPopupMenu.Separator jSeparator44;
    private JPopupMenu.Separator jSeparator45;
    private JPopupMenu.Separator jSeparator46;
    private JPopupMenu.Separator jSeparator47;
    private JPopupMenu.Separator jSeparator48;
    private JPopupMenu.Separator jSeparator49;
    private JToolBar.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator50;
    private JPopupMenu.Separator jSeparator51;
    private JPopupMenu.Separator jSeparator52;
    private JToolBar.Separator jSeparator53;
    private JToolBar.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private ColorLabel lblColorGraphic;
    private ColorLabel lblColorLabel;
    private JLabel lblEditAnnotations;
    private JLabel lblEditNotes;
    private JLabel lblEditReferences;
    private JLabel lblEnd;
    private JLabel lblFName;
    private JLabel lblStart;
    private JMenuBar mainMenuBar;
    private JToolBar mainToolBar;
    private JMenuItem mnuAAtoDNA;
    private JMenu mnuAbout;
    private JMenuItem mnuAboutpLOT;
    private JMenuItem mnuAddAsMix;
    private JMenuItem mnuAddChromat;
    private JMenuItem mnuAddRE;
    private JMenuItem mnuAnnotate;
    private JMenuItem mnuAntisenseRegion;
    private JMenuItem mnuAntisenseSeq;
    private JMenuItem mnuCalcCodon;
    private JMenuItem mnuCalcCodon2;
    private JMenu mnuChangeGraphic;
    private JMenuItem mnuChangeTitle;
    private JMenuItem mnuCheckForUpdates;
    private JMenuItem mnuCircular;
    private JMenuItem mnuCloneWindow;
    private JMenuItem mnuConvertExons;
    private JMenuItem mnuCopy;
    private JMenuItem mnuCopyFpLOT;
    private JMenuItem mnuCopyRE;
    private JMenuItem mnuCut;
    private JMenuItem mnuCutters;
    private JMenuItem mnuDNAElements;
    private JMenu mnuDebug;
    private JMenuItem mnuDecFeatureOffset;
    private JMenuItem mnuDecFeatureOffsets;
    private JMenuItem mnuDecFeatureWidth;
    private JMenuItem mnuDecFeatureWidths;
    private JMenuItem mnuDockFeatures;
    private JMenuItem mnuDupFeature;
    private JMenu mnuEdit;
    private JMenuItem mnuEditAnnotations;
    private JMenuItem mnuEditFeaturesLib;
    private JMenuItem mnuEditLaddersLib;
    private JMenuItem mnuEditPrimersLib;
    private JMenuItem mnuEditSeq;
    private JMenuItem mnuExit;
    private JMenuItem mnuExportMap;
    private JMenu mnuFCopy;
    private JMenuItem mnuFCopyAAF1;
    private JMenuItem mnuFCopyAAF2;
    private JMenuItem mnuFCopyAAF3;
    private JMenuItem mnuFCopyAAdsF1;
    private JMenuItem mnuFCopyAAdsF123;
    private JMenuItem mnuFCopyAAdsF2;
    private JMenuItem mnuFCopyAAdsF3;
    private JMenuItem mnuFCopyAAssF1;
    private JMenuItem mnuFCopyAAssF123;
    private JMenuItem mnuFCopyAAssF2;
    private JMenuItem mnuFCopyAAssF3;
    private JMenuItem mnuFCopyFormattedDS;
    private JMenuItem mnuFCopyFormattedSS;
    private JMenuItem mnuFCopydsDNA;
    private JMenuItem mnuFCopyssDNA;
    private JMenuItem mnuFCopyssDNA_AS;
    private JPopupMenu mnuFPopup;
    private JMenu mnuFeatures;
    private JMenu mnuFile;
    private JMenuItem mnuFind;
    private JMenuItem mnuFontTest;
    private JMenuItem mnuGel;
    private JMenuItem mnuGetGB;
    private JMenuItem mnuGraphicColor;
    private JMenuItem mnuHideFeatures;
    private JMenuItem mnuIncFeatureOffset;
    private JMenuItem mnuIncFeatureOffsets;
    private JMenuItem mnuIncFeatureWidth;
    private JMenuItem mnuIncFeatureWidths;
    private JMenuItem mnuLabelColor;
    private JMenu mnuLabelOptions;
    private JMenuItem mnuLabelsCircle;
    private JMenuItem mnuLabelsLinear;
    private JMenu mnuLibraries;
    private JMenuItem mnuLoadPlugins;
    private JMenuItem mnuLowerCase;
    private JMenuItem mnuLowerCaseRE;
    private JMenuItem mnuMisc;
    private JMenuItem mnuMobileBlocks;
    private JMenuItem mnuMoveBottom;
    private JMenuItem mnuMoveDown;
    private JMenuItem mnuMoveTop;
    private JMenuItem mnuMoveUp;
    private JMenuItem mnuNew;
    private JMenuItem mnuNewFeature;
    private JMenuItem mnuNewWindow;
    private JMenuItem mnuNonCutters;
    private JMenuItem mnuOpen;
    private JPopupMenu mnuPPopup;
    private JMenuItem mnuPaste;
    private JMenu mnuPlugins;
    private JPopupMenu mnuPopupDockFeatures;
    private JMenuItem mnuPrimerToFeature;
    private JMenuItem mnuRE;
    private JPopupMenu mnuREPopup;
    private JMenu mnuRecent;
    private JMenuItem mnuRedo;
    private JMenuItem mnuRemFeature;
    private JMenuItem mnuRemoveAll;
    private JMenuItem mnuRemovePrimer;
    private JMenuItem mnuRemoveRE;
    private JMenuItem mnuRenameFeature;
    private JMenuItem mnuRevComp;
    private JMenuItem mnuRotate;
    private JMenuItem mnuRotate1;
    private JMenuItem mnuRotate2;
    private JMenu mnuRotateSeq;
    private JMenuItem mnuSave;
    private JMenu mnuSaveAllToLib;
    private JMenuItem mnuSaveAllToLibAA;
    private JMenuItem mnuSaveAllToLibDNA;
    private JMenuItem mnuSaveAs;
    private JMenu mnuSaveToLib;
    private JMenuItem mnuSaveToLibAA;
    private JMenuItem mnuSaveToLibDNA;
    private JPopupMenu.Separator mnuSepExportMap;
    private JMenuItem mnuSetDatabaseLocations;
    private JMenu mnuSetFeatureCodonTable;
    private JMenuItem mnuSetFeaturesLib;
    private JMenuItem mnuSetLaddersLib;
    private JMenuItem mnuSetPrimersLib;
    private JMenu mnuSetProjectCodonTable;
    private JMenuItem mnuShowAllLabels;
    private JMenuItem mnuShowHelp;
    private JMenuItem mnuShowLabel;
    private JMenuItem mnuShowSplitWindow;
    private JMenuItem mnuShowToolWindow;
    private JMenuItem mnuToArrow;
    private JMenuItem mnuToBox;
    private JMenuItem mnuToBrackets;
    private JMenuItem mnuToHeadlessArrow;
    private JMenuItem mnuToLine;
    private JMenuItem mnuToLineArrow;
    private JMenuItem mnuToNoGraphic;
    private JMenuItem mnuToTickMark;
    private JCheckBoxMenuItem mnuToggleAntisense;
    private JCheckBoxMenuItem mnuToggleFrame1;
    private JCheckBoxMenuItem mnuToggleFrame2;
    private JCheckBoxMenuItem mnuToggleFrame3;
    private JCheckBoxMenuItem mnuToggleFrame4;
    private JCheckBoxMenuItem mnuToggleFrame5;
    private JCheckBoxMenuItem mnuToggleFrame6;
    private JCheckBoxMenuItem mnuToggleNumbers;
    private JMenu mnuTools;
    private JMenuItem mnuUndo;
    private JMenuItem mnuUndockFeatures;
    private JMenuItem mnuUpperCase;
    private JMenuItem mnuUpperCaseRE;
    private JMenu mnuView;
    private JMenuItem mnuViewFeaturesList;
    private JMenu mnuWindows;
    private JRadioButtonMenuItem mnuZoom050;
    private JRadioButtonMenuItem mnuZoom075;
    private JRadioButtonMenuItem mnuZoom090;
    private JRadioButtonMenuItem mnuZoom100;
    private JRadioButtonMenuItem mnuZoom110;
    private JRadioButtonMenuItem mnuZoom125;
    private JRadioButtonMenuItem mnuZoom150;
    private JRadioButtonMenuItem mnuZoom200;
    private JRadioButtonMenuItem mnuZoom300;
    private JRadioButtonMenuItem mnuZoom400;
    private JPopupMenu mnuZoomPopup;
    private JPanel panelFMainOptions;
    private JPanel panelFeatureTools;
    private JPanel panelPlasmidTools;
    ScrollPanel picMap;
    private JScrollPane scrollPaneTools;
    private JPopupMenu.Separator sep3;
    private JPopupMenu.Separator sepCaseChange;
    private JPopupMenu.Separator sepCaseChangeRE;
    private JPopupMenu.Separator sepCopy1;
    private JPopupMenu.Separator sepCopy2;
    private JPopupMenu.Separator sepCopy3;
    private JPopupMenu.Separator sepCopy4;
    private JPopupMenu.Separator sepCopy5;
    private JPopupMenu.Separator sepCopy6;
    private JPopupMenu.Separator sepCopy7;
    private JPopupMenu.Separator sepCopy8;
    private JPopupMenu.Separator sepDisplayOptions;
    private JPopupMenu.Separator sepDrawingOrder;
    private JPopupMenu.Separator sepGel;
    private JPopupMenu.Separator sepLoadTools;
    private JPopupMenu.Separator sepPFooter;
    private JPopupMenu.Separator sepPHeader;
    private JToolBar.Separator sepPluginTools;
    private JPopupMenu.Separator sepPlugins;
    private JPopupMenu.Separator sepPlugins1;
    private JPopupMenu.Separator sepPref2;
    private JPopupMenu.Separator sepREFooter;
    private JPopupMenu.Separator sepREHeader;
    private JPopupMenu.Separator sepShowWindows;
    private JPopupMenu.Separator sepShowWindows1;
    private JPopupMenu.Separator sepSplitWindow;
    private JPopupMenu.Separator sepUpdates;
    private JSlider sldAlpha;
    private JSlider sldDrawingOrder;
    private JSlider sldRadius;
    private JSlider sldWidth;
    private JSpinner spinAlpha;
    private JSpinner spinRadius;
    private JSpinner spinWidth;
    private StatusLabel statusLabel;
    private JXTaskPaneContainer taskPaneContainer;
    private JToggleButton toggleLink;
    private JXTaskPane toolsFeatures;
    private JXTaskPane toolsPlasmid;
    private GhostTextBox txtCaption;
    private GhostTextBox txtEnd;
    private GhostTextBox txtFName;
    private GhostTextArea txtNotes;
    private GhostTextBox txtOrg;
    private GhostTextBox txtPlasmidName;
    private GhostTextBox txtSource;
    private GhostTextBox txtStart;
    private JSplitPane vSplitPane;
    private ButtonGroup zoomButtonGroup;
    static AffineTransform atLinear;
    static final double ROTATION_ANGLE = -1.5707963267948966;
    FrmGel.Band gelBand = null;
    Font leftFont;
    Font leftPrimerFont;
    int leftFontHt;
    Font leftREFont;
    FontMetrics leftFM;
    FontMetrics rightFMP;
    FontMetrics rightFME;
    FontMetrics leftFMP;
    FontMetrics leftFME;
    Font rightFont;
    Font rightPrimerFont;
    Font rightREFont;
    int rightFontHt;
    FontMetrics rightFM;
    Comparator c2 = (o1, o2) -> {
        int s2;
        Feature f1 = (Feature)o1;
        Feature f2 = (Feature)o2;
        int s1 = f1.isAntisense() ? f1.getStop() : f1.getStart();
        int n = s2 = f2.isAntisense() ? f2.getStop() : f2.getStart();
        if (s1 < s2) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        return 0;
    };
    Comparator c1 = (o1, o2) -> {
        int s2;
        Feature f1 = (Feature)o1;
        Feature f2 = (Feature)o2;
        int s1 = f1.isAntisense() ? f1.getStop() : f1.getStart();
        int n = s2 = f2.isAntisense() ? f2.getStop() : f2.getStart();
        if (s1 > s2) {
            return -1;
        }
        if (s1 < s2) {
            return 1;
        }
        return 0;
    };
    Comparator catSort = (o1, o2) -> o1.name.compareTo(o2.name);
    final ExtensibleArray<Feature> left = new ExtensibleArray<Feature>(Feature.class);
    final ExtensibleArray<Feature> right = new ExtensibleArray<Feature>(Feature.class);
    private static final double DegreesPerRadian = 0.0174533;
    private static final double RadianPerDegrees = 57.2958;
    private final OutlinedFilledGlyphDrawer LabelGlyph = new OutlinedFilledGlyphDrawer(Color.BLACK, Color.WHITE);

    public static final PLOTJ getActiveInstance() {
        return Globals.instance;
    }

    public static final ProjectDocument getActiveDocument() {
        return Globals.instance != null ? Globals.instance.getProject() : null;
    }

    public static void updatePlugins() {
        Globals.updatePlugins();
    }

    public static PLOTJ newInstance() {
        return Globals.newWindow();
    }

    public static FrmOutput newOutputWindow() {
        return new FrmOutput();
    }

    public static String getBuild() {
        return Globals.getBuildDate();
    }

    public ProjectDocument getProject() {
        return this.project;
    }

    Component getActiveComponent() {
        return this.activeComponent;
    }

    void setActiveComponent(Component c) {
        this.activeComponent = c;
    }

    private void setSpinnerListeners() {
        MouseListener alphaListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PLOTJ.this.startAlpha();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PLOTJ.this.commitAlpha();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        Component[] components = this.spinAlpha.getComponents();
        for (int x = 0; x < components.length; ++x) {
            if (!(components[x] instanceof JButton)) continue;
            components[x].addMouseListener(alphaListener);
        }
        MouseListener offsetListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PLOTJ.this.startOffset();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PLOTJ.this.commitOffset();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        components = this.spinRadius.getComponents();
        for (int x = 0; x < components.length; ++x) {
            if (!(components[x] instanceof JButton)) continue;
            components[x].addMouseListener(offsetListener);
        }
        MouseListener widthListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PLOTJ.this.startWidth();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PLOTJ.this.commitWidth();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        components = this.spinWidth.getComponents();
        for (int x = 0; x < components.length; ++x) {
            if (!(components[x] instanceof JButton)) continue;
            components[x].addMouseListener(widthListener);
        }
    }

    private void assignListeners(JComponent c) {
        if (c.getToolTipText() != null && c.getToolTipText().length() > 0) {
            c.addMouseListener(this.menuMouseListener);
        }
        for (int x = 0; x < c.getComponentCount(); ++x) {
            Component child = c.getComponent(x);
            if (!(child instanceof JComponent)) continue;
            this.assignListeners((JComponent)child);
        }
    }

    private void initMain() {
        int x;
        this.useOverlay = Globals.useOverlay;
        this.initComponents();
        this.cmdToggleOverlay.setSelected(this.useOverlay);
        Themes.setThemeMenus(this.mainMenuBar, "pLOT Plasmid Plotter", "plot_theme", this, true, -1);
        BaseRootPaneUI.addAlwaysOnTop(this, this.menuMouseListener);
        this.dockFeatures.getDockButton().setRenderer(Globals.genDockRenderer(false));
        this.dockTools.getDockButton().setRenderer(Globals.genDockRenderer(true));
        this.toggleLinkModel = this.toggleLink.getModel();
        Object fIcon = UIManager.get("plot.featureview.icon");
        if (fIcon instanceof ImageIcon) {
            this.dockFeatures.setIcon((ImageIcon)fIcon);
        }
        this.sepREHeader.setUI(new RenderedMenuSeparatorUI(1));
        this.sepREFooter.setUI(new RenderedMenuSeparatorUI(3));
        this.sepPHeader.setUI(new RenderedMenuSeparatorUI(1));
        this.sepPFooter.setUI(new RenderedMenuSeparatorUI(3));
        this.mnuPrimerToFeature.addMouseListener(this.menuMouseListener);
        this.mnuRemovePrimer.addMouseListener(this.menuMouseListener);
        this.sepREHeader.addMouseListener(this.menuMouseListener);
        this.sepREFooter.addMouseListener(this.menuMouseListener);
        this.sepPHeader.addMouseListener(this.menuMouseListener);
        this.sepPFooter.addMouseListener(this.menuMouseListener);
        this.mnuUpperCaseRE.addMouseListener(this.menuMouseListener);
        this.mnuLowerCaseRE.addMouseListener(this.menuMouseListener);
        this.mnuAddRE.addMouseListener(this.menuMouseListener);
        this.mnuAddAsMix.addMouseListener(this.menuMouseListener);
        this.mnuCopyRE.addMouseListener(this.menuMouseListener);
        this.mnuRemoveRE.addMouseListener(this.menuMouseListener);
        this.sepCaseChangeRE.addMouseListener(this.menuMouseListener);
        this.toggleAllCat.addMouseListener(this.menuMouseListener);
        this.selectAllCat.addMouseListener(this.menuMouseListener);
        this.deselectAllCat.addMouseListener(this.menuMouseListener);
        this.toggleLib.addMouseListener(this.menuMouseListener);
        this.showDefAndUser.addMouseListener(this.menuMouseListener);
        this.showDefOnly.addMouseListener(this.menuMouseListener);
        this.showUserOnly.addMouseListener(this.menuMouseListener);
        this.toggleDir.addMouseListener(this.menuMouseListener);
        this.showSenseAndAntisense.addMouseListener(this.menuMouseListener);
        this.showSense.addMouseListener(this.menuMouseListener);
        this.showAntisense.addMouseListener(this.menuMouseListener);
        this.toggleDatabaseCat.addMouseListener(this.menuMouseListener);
        this.lblEditAnnotations.addMouseListener(this.linkLabelMouseListener);
        this.lblEditNotes.addMouseListener(this.linkLabelMouseListener);
        this.lblEditReferences.addMouseListener(this.linkLabelMouseListener);
        this.setSpinnerListeners();
        Defaults.getPopupMenuBorder().registerMenu(this.mnuFile, " pLOT - " + Globals.buildDate + (Globals.debugMode ? " (Debug Mode)" : ""));
        Defaults.getPopupMenuBorder().registerMenu(this.mnuFPopup, " Feature Options");
        Defaults.setMenuBarHeaderFooterUIs(this.mainMenuBar, new RenderedMenuSeparatorUI(1), new RenderedMenuSeparatorUI(3));
        Defaults.setMenuHeaderFooterUIs(this.mnuFPopup, new RenderedMenuSeparatorUI(1), new RenderedMenuSeparatorUI(3));
        this.setRecentMenuScroller(this.mnuRecent, 10, 120, 3, 0);
        this.primersPopupMenu = new ScrollSearchPopupMenu();
        this.primersPopupMenu.addTopFixedItem(this.toggleAllCat);
        this.primersPopupMenu.addTopFixedItem(this.selectAllCat);
        this.primersPopupMenu.addTopFixedItem(this.deselectAllCat);
        this.primersPopupMenu.addTopFixedItem(this.toggleLib);
        this.primersPopupMenu.addTopFixedItem(this.showDefAndUser);
        this.primersPopupMenu.addTopFixedItem(this.showDefOnly);
        this.primersPopupMenu.addTopFixedItem(this.showUserOnly);
        this.primersPopupMenu.addTopFixedItem(this.toggleDir);
        this.primersPopupMenu.addTopFixedItem(this.showSenseAndAntisense);
        this.primersPopupMenu.addTopFixedItem(this.showSense);
        this.primersPopupMenu.addTopFixedItem(this.showAntisense);
        this.primersPopupMenu.addTopFixedItem(this.toggleDatabaseCat);
        this.primersPopupMenu.addBottomFixedItem(this.footerDatabaseCat);
        Color color = UIManager.getColor("TaskPane.background");
        if (color != null) {
            this.toolsPlasmid.getContentPane().setBackground(color);
            this.toolsFeatures.getContentPane().setBackground(color);
        }
        if ((color = UIManager.getColor("Plot.link.inactive")) != null) {
            this.lblEditAnnotations.setForeground(color);
            this.lblEditNotes.setForeground(color);
        }
        StaticArrayComboModel<FeatureRenderer> modelGraphicTypes = new StaticArrayComboModel<FeatureRenderer>(FeatureRenderer.drawFeatures);
        GraphicsListRenderer rendererGraphicTypes = new GraphicsListRenderer();
        this.cmbGraphic.setModel(modelGraphicTypes);
        this.cmbGraphic.setRenderer(rendererGraphicTypes);
        this.cmbGraphic.setSelectedIndex(0);
        StaticArrayComboModel<Integer> modelOrient = new StaticArrayComboModel<Integer>(Globals.orientItemValues);
        IconListRenderer rendererOrient = new IconListRenderer();
        rendererOrient.setValues(null, Globals.orientIcons);
        this.cmbOrient.setModel(modelOrient);
        this.cmbOrient.setRenderer(rendererOrient);
        this.cmbOrient.setSelectedIndex(0);
        SeqDragListener dragListener = new SeqDragListener(this.picMap.displayPanel){

            @Override
            public SequenceExportFormat[] getSEF() {
                Feature[] selectedItems = PLOTJ.this.project.getSelectedItems(0);
                if (selectedItems == null) {
                    return null;
                }
                SequenceExportFormat[] selectedSEF = new SequenceExportFormat[selectedItems.length];
                for (int x = 0; x < selectedItems.length; ++x) {
                    SequenceExportFormat sef = PLOTJ.this.project.getSEF(selectedItems[x]);
                    sef.name = selectedItems[x].getName();
                    selectedSEF[x] = sef;
                }
                return selectedSEF;
            }
        };
        this.statusBarForm = new FrmStatusBar((Frame)this, true);
        MetallicRenderer thumbRenderer2 = new MetallicRenderer();
        thumbRenderer2.getColors().setColors(1, Color.green);
        thumbRenderer2.setBorderColor(Color.white);
        this.statusBarForm.progressBar.setThumbRenderer(thumbRenderer2);
        MetallicRenderer trackRenderer2 = new MetallicRenderer();
        thumbRenderer2.getColors().setColors(1, Color.lightGray);
        trackRenderer2.setBorderColor(Color.white);
        this.statusBarForm.progressBar.setRenderer(trackRenderer2);
        this.statusBarForm.setValues(0, 100);
        this.mnuDebug.setVisible(Globals.debugMode);
        this.mainToolBar.setFloatable(false);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                PLOTJ.this.close();
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
            }

            @Override
            public void windowLostFocus(WindowEvent arg0) {
                ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
            }
        });
        KeyListener enterEscapeListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                if (key != 10 && key != 27) {
                    return;
                }
                if (e.getSource() == PLOTJ.this.txtPlasmidName) {
                    if (PLOTJ.this.txtPlasmidName.isChanged()) {
                        if (key == 10) {
                            PLOTJ.this.applyPName();
                        } else if (key == 27) {
                            PLOTJ.this.txtPlasmidName.setText(PLOTJ.this.project.getName());
                        }
                        PLOTJ.this.txtPlasmidName.setChanged(false);
                        PLOTJ.this.txtPlasmidName.selectAll();
                    }
                } else if (e.getSource() == PLOTJ.this.txtSource) {
                    if (PLOTJ.this.txtSource.isChanged()) {
                        if (key == 10) {
                            PLOTJ.this.applySource();
                        } else if (key == 27) {
                            PLOTJ.this.txtSource.setText(PLOTJ.this.project.getSource());
                            PLOTJ.this.txtSource.setChanged(false);
                        }
                        PLOTJ.this.txtSource.setChanged(false);
                        PLOTJ.this.txtSource.selectAll();
                    }
                } else if (e.getSource() == PLOTJ.this.txtOrg) {
                    if (PLOTJ.this.txtOrg.isChanged()) {
                        if (key == 10) {
                            PLOTJ.this.applyOrganism();
                        } else if (key == 27) {
                            PLOTJ.this.txtOrg.setText(PLOTJ.this.project.getOrganism());
                            PLOTJ.this.txtOrg.setChanged(false);
                        }
                        PLOTJ.this.txtOrg.setChanged(false);
                        PLOTJ.this.txtOrg.selectAll();
                    }
                } else if (((PLOTJ)PLOTJ.this).project.selectedItem != null) {
                    if (e.getSource() == PLOTJ.this.txtStart) {
                        if (PLOTJ.this.txtStart.isChanged()) {
                            if (key == 10) {
                                PLOTJ.this.applyStart();
                            } else if (key == 27) {
                                PLOTJ.this.txtStart.setText(String.valueOf(((PLOTJ)PLOTJ.this).project.selectedItem.getStart()));
                            }
                            PLOTJ.this.txtStart.setChanged(false);
                            PLOTJ.this.txtStart.selectAll();
                        }
                    } else if (e.getSource() == PLOTJ.this.txtEnd) {
                        if (PLOTJ.this.txtEnd.isChanged()) {
                            if (key == 10) {
                                PLOTJ.this.applyStop();
                            } else if (key == 27) {
                                PLOTJ.this.txtEnd.setText(String.valueOf(((PLOTJ)PLOTJ.this).project.selectedItem.getStop()));
                            }
                            PLOTJ.this.txtEnd.setChanged(false);
                            PLOTJ.this.txtEnd.selectAll();
                        }
                    } else if (e.getSource() == PLOTJ.this.txtFName) {
                        if (PLOTJ.this.txtFName.isChanged()) {
                            if (key == 10) {
                                PLOTJ.this.applyFName();
                            } else if (key == 27) {
                                PLOTJ.this.txtFName.setText(((PLOTJ)PLOTJ.this).project.selectedItem.getName());
                            }
                            PLOTJ.this.txtFName.setChanged(false);
                            PLOTJ.this.txtFName.selectAll();
                        }
                    } else if (e.getSource() == PLOTJ.this.txtCaption && PLOTJ.this.txtCaption.isChanged()) {
                        if (key == 10) {
                            PLOTJ.this.applyCaption();
                        } else if (key == 27) {
                            PLOTJ.this.txtCaption.setText(((PLOTJ)PLOTJ.this).project.selectedItem.getLabelText());
                        }
                        PLOTJ.this.txtCaption.setChanged(false);
                        PLOTJ.this.txtCaption.selectAll();
                    }
                }
            }
        };
        this.txtStart.addKeyListener(enterEscapeListener);
        this.txtEnd.addKeyListener(enterEscapeListener);
        this.txtFName.addKeyListener(enterEscapeListener);
        this.txtCaption.addKeyListener(enterEscapeListener);
        this.txtPlasmidName.addKeyListener(enterEscapeListener);
        this.txtSource.addKeyListener(enterEscapeListener);
        this.txtOrg.addKeyListener(enterEscapeListener);
        FocusListener lostFocus = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PLOTJ.this.project.getSelectedItem() != null) {
                    if (e.getSource() == PLOTJ.this.txtStart) {
                        if (PLOTJ.this.txtStart.isChanged()) {
                            PLOTJ.this.txtStart.setChanged(false);
                            PLOTJ.this.applyStart();
                        }
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.txtEnd) {
                        if (PLOTJ.this.txtEnd.isChanged()) {
                            PLOTJ.this.txtEnd.setChanged(false);
                            PLOTJ.this.applyStop();
                        }
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.txtFName) {
                        if (PLOTJ.this.txtFName.isChanged()) {
                            PLOTJ.this.txtFName.setChanged(false);
                            PLOTJ.this.applyFName();
                        }
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.txtNotes) {
                        if (PLOTJ.this.txtNotes.isChanged()) {
                            PLOTJ.this.txtNotes.setChanged(false);
                            PLOTJ.this.applyNotes();
                        }
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.txtCaption) {
                        if (PLOTJ.this.txtCaption.isChanged()) {
                            PLOTJ.this.txtCaption.setChanged(false);
                            PLOTJ.this.applyCaption();
                        }
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.sldAlpha || e.getSource() == PLOTJ.this.spinAlpha) {
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.sldWidth || e.getSource() == PLOTJ.this.spinWidth) {
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.sldRadius || e.getSource() == PLOTJ.this.spinRadius) {
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.cmbOrient) {
                        return;
                    }
                    if (e.getSource() == PLOTJ.this.cmbGBType) {
                        return;
                    }
                }
                if (e.getSource() == PLOTJ.this.txtPlasmidName) {
                    if (PLOTJ.this.txtPlasmidName.isChanged()) {
                        PLOTJ.this.applyPName();
                        PLOTJ.this.txtPlasmidName.setChanged(false);
                    }
                } else if (e.getSource() == PLOTJ.this.txtSource) {
                    if (PLOTJ.this.txtSource.isChanged()) {
                        PLOTJ.this.applySource();
                        PLOTJ.this.txtSource.setChanged(false);
                    }
                } else if (e.getSource() == PLOTJ.this.txtOrg && PLOTJ.this.txtOrg.isChanged()) {
                    PLOTJ.this.applyOrganism();
                    PLOTJ.this.txtOrg.setChanged(false);
                }
            }
        };
        DockingWindow.setDefaultDecorated(false);
        FileSeqDandDHandler dd = new FileSeqDandDHandler(this){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return PLOTJ.this.isEnabled() && super.canImport(support);
            }

            @Override
            public void droppedFiles(List<File> filesList, int x, int y) {
                PLOTJ.this.filesDropped(filesList);
            }

            @Override
            public void droppedSequence(SequenceExportFormat[] sequence, int x, int y) {
            }

            @Override
            public void droppedSequence(GenBankFile file, int x, int y) {
                PLOTJ.this.loadFile(file);
            }
        };
        FileSeqDandDHandler dd2 = new FileSeqDandDHandler(this.picMap.displayPanel){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return PLOTJ.this.isEnabled() && super.canImport(support);
            }

            @Override
            public void droppedFiles(List<File> filesList, int x, int y) {
                PLOTJ.this.filesDropped(filesList);
            }

            @Override
            public void droppedSequence(SequenceExportFormat[] sequence, int x, int y) {
                if (sequence.length == 1) {
                    PLOTJ.this.pasteInsert(sequence[0]);
                }
            }

            @Override
            public void droppedSequence(GenBankFile file, int x, int y) {
                PLOTJ.this.loadFile(file);
            }
        };
        this.setTransferHandler(dd);
        dd.acceptSeqs = false;
        this.editor.setDragEnabled(false);
        this.picMap.setTransferHandler(dd2);
        this.selectAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PrimerCategory cat : ((PLOTJ)PLOTJ.this).project.foundCategories) {
                    cat.shown = true;
                    PLOTJ.this.resetMap();
                }
            }
        });
        this.deselectAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PrimerCategory cat : ((PLOTJ)PLOTJ.this).project.foundCategories) {
                    cat.shown = false;
                    PLOTJ.this.resetMap();
                }
            }
        });
        this.showSense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PLOTJ.this.showSensePrimers = true;
                PLOTJ.this.showAntisensePrimers = false;
                PLOTJ.this.resetMap();
            }
        });
        this.showAntisense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PLOTJ.this.showSensePrimers = false;
                PLOTJ.this.showAntisensePrimers = true;
                PLOTJ.this.resetMap();
            }
        });
        this.showSenseAndAntisense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PLOTJ.this.showSensePrimers = true;
                PLOTJ.this.showAntisensePrimers = true;
                PLOTJ.this.resetMap();
            }
        });
        ButtonGroup g = new ButtonGroup();
        g.add(this.showAntisense);
        g.add(this.showSense);
        g.add(this.showSenseAndAntisense);
        this.showSenseAndAntisense.setSelected(true);
        this.showDefOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PLOTJ)PLOTJ.this).project.showDefaultPrimers = true;
                ((PLOTJ)PLOTJ.this).project.showUserPrimers = false;
                PLOTJ.this.resetMap();
            }
        });
        this.showUserOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PLOTJ)PLOTJ.this).project.showDefaultPrimers = false;
                ((PLOTJ)PLOTJ.this).project.showUserPrimers = true;
                PLOTJ.this.resetMap();
            }
        });
        this.showDefAndUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PLOTJ)PLOTJ.this).project.showDefaultPrimers = true;
                ((PLOTJ)PLOTJ.this).project.showUserPrimers = true;
                PLOTJ.this.resetMap();
            }
        });
        ButtonGroup g2 = new ButtonGroup();
        g2.add(this.showDefAndUser);
        g2.add(this.showDefOnly);
        g2.add(this.showUserOnly);
        this.showDefAndUser.setSelected(true);
        this.dockTools.getDockButton().addMouseListener(this.menuMouseListener);
        this.dockTools.getAlwaysOnTopButton().addMouseListener(this.menuMouseListener);
        this.dockTools.getMinimizeButton().addMouseListener(this.menuMouseListener);
        this.dockTools.getMaximizeButton().addMouseListener(this.menuMouseListener);
        this.dockTools.getCloseButton().addMouseListener(this.menuMouseListener);
        this.dockTools.getGradientBar().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    PLOTJ.this.dockTools.setDocked(!PLOTJ.this.dockTools.isDocked());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    JPopupMenu m = new JPopupMenu();
                    JSeparator sep = new JSeparator();
                    sep.setToolTipText("Split-Window Options");
                    m.add(sep);
                    if (PLOTJ.this.dockTools.isDocked()) {
                        JMenuItem menuItem = new JMenuItem("Undock Tools Window", new ImageIcon(this.getClass().getResource("/images24/Dock.png")));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PLOTJ.this.dockTools.setDocked(false);
                            }
                        });
                        m.add(menuItem);
                        m.add(new JMenuItem("Hide Window", new ImageIcon(this.getClass().getResource("/images24/Window.png"))));
                    } else {
                        JMenuItem menuItem = new JMenuItem("Dock Tools Window", new ImageIcon(this.getClass().getResource("/images24/Dock.png")));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PLOTJ.this.dockTools.setDocked(true);
                            }
                        });
                        m.add(menuItem);
                        menuItem = new JMenuItem("Hide Window", new ImageIcon(this.getClass().getResource("/images24/Window.png")));
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                            }
                        });
                        m.add(menuItem);
                    }
                    m.show(PLOTJ.this.dockTools.getGradientBar(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.dockFeatures.getDockButton().addMouseListener(this.menuMouseListener);
        this.dockFeatures.getAlwaysOnTopButton().addMouseListener(this.menuMouseListener);
        this.dockFeatures.getMinimizeButton().addMouseListener(this.menuMouseListener);
        this.dockFeatures.getMaximizeButton().addMouseListener(this.menuMouseListener);
        this.dockFeatures.getCloseButton().addMouseListener(this.menuMouseListener);
        this.dockFeatures.getGradientBar().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && evt.getButton() == 1) {
                    PLOTJ.this.dockFeatures.setDocked(!PLOTJ.this.dockFeatures.isDocked());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    if (PLOTJ.this.dockFeatures.isDocked()) {
                        PLOTJ.this.mnuUndockFeatures.setVisible(true);
                        PLOTJ.this.mnuDockFeatures.setVisible(false);
                    } else {
                        PLOTJ.this.mnuUndockFeatures.setVisible(false);
                        PLOTJ.this.mnuDockFeatures.setVisible(true);
                    }
                    PLOTJ.this.mnuPopupDockFeatures.show(PLOTJ.this.dockFeatures.getGradientBar(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.hSplitPane.addFocusListener(lostFocus);
        this.vSplitPane.addFocusListener(lostFocus);
        this.txtStart.addFocusListener(lostFocus);
        this.txtEnd.addFocusListener(lostFocus);
        this.txtFName.addFocusListener(lostFocus);
        this.txtNotes.addFocusListener(lostFocus);
        this.txtCaption.addFocusListener(lostFocus);
        this.txtPlasmidName.addFocusListener(lostFocus);
        this.txtSource.addFocusListener(lostFocus);
        this.txtOrg.addFocusListener(lostFocus);
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000000);
        this.picMap.setFont(Globals.LABELFONT);
        this.txtStart.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtEnd.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        Document doc = ((JTextComponent)this.cmbGBType.getEditor().getEditorComponent()).getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(DocumentKeyFilter.GenbankNameFilter);
        }
        if ((doc = ((JSpinner.NumberEditor)this.spinAlpha.getEditor()).getTextField().getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(DocumentKeyFilter.NumberFilter);
        }
        if ((doc = ((JSpinner.NumberEditor)this.spinWidth.getEditor()).getTextField().getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(DocumentKeyFilter.NumberFilter);
        }
        if ((doc = ((JSpinner.NumberEditor)this.spinRadius.getEditor()).getTextField().getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(DocumentKeyFilter.NumberFilter);
        }
        for (x = 0; x < CodonTable.getOrganismCount(); ++x) {
            String orgName = CodonTable.getOrganismName(x);
            JRadioButtonMenuItem newItem = new JRadioButtonMenuItem(orgName);
            newItem.addActionListener(new CodonActionListener(orgName, false));
            newItem.setToolTipText("Set the project's default codon table to " + orgName);
            this.grpCodonTableProject.add(newItem);
            this.mnuSetProjectCodonTable.add(newItem);
            JRadioButtonMenuItem newItem2 = new JRadioButtonMenuItem(CodonTable.getOrganismName(x));
            newItem2.addActionListener(new CodonActionListener(orgName, true));
            newItem2.setToolTipText("Set this feature's codon table to " + orgName);
            this.grpCodonTableFeature.add(newItem2);
            this.mnuSetFeatureCodonTable.add(newItem2);
            if (this.project.getCodonTable().getOrganismIndex() != x) continue;
            newItem.setSelected(true);
            newItem2.setSelected(true);
        }
        Listeners.setMenuBarListeners(this.mainMenuBar, this.menuMouseListener);
        Listeners.setToolbarListeners(this.mainToolBar, this.menuMouseListener);
        Listeners.setToolbarListeners(this.mainToolBar, this.opaqueAdjuster);
        Listeners.setMenuItemListeners(this.mnuFPopup, this.menuMouseListener);
        for (x = 0; x < this.getComponentCount(); ++x) {
            Component c = this.getComponent(x);
            if (!(c instanceof JComponent) || c instanceof JMenu || c instanceof JMenuBar) continue;
            this.assignListeners((JComponent)c);
        }
        this.setFeatureToolsEnabled(false);
        this.setPlasmidToolsEnabled(true);
        this.picMap.getHScrollBar().setUnitIncrement(10);
        this.picMap.getVScrollBar().setInvertDirection(true);
        this.picMap.getVScrollBar().setUnitIncrement(10);
        this.hSplitPane.setDividerSize(6);
        this.vSplitPane.setDividerSize(6);
        ((JSpinner.DefaultEditor)this.spinWidth.getEditor()).getTextField().setText(String.valueOf(this.sldWidth.getValue()));
        ((JSpinner.DefaultEditor)this.spinAlpha.getEditor()).getTextField().setText(String.valueOf(this.sldAlpha.getValue()));
        this.sldRadius.getModel().setRangeProperties(100, this.sldRadius.getModel().getExtent(), 50, 150, this.sldWidth.getModel().getValueIsAdjusting());
        ((JSpinner.DefaultEditor)this.spinRadius.getEditor()).getTextField().setText(String.valueOf(this.sldRadius.getValue()));
        this.setTitle("");
        this.project.showLabels = Globals.history.getUserPref().getBoolean("showLabels", true);
        this.project.showPrimers = Globals.history.getUserPref().getBoolean("showPrimers", true);
        this.project.showEnzymes = Globals.history.getUserPref().getBoolean("showEnzymes", true);
        this.cmdShowLabels.setSelected(this.project.showLabels);
        this.cmdShowPrimers.setSelected(this.project.showPrimers);
        this.cmdShowRE.setSelected(this.project.showEnzymes);
        this.toolsPlasmid.add(this.panelPlasmidTools);
        this.toolsFeatures.add(this.panelFeatureTools);
        this.uiAlpha = new CustomSliderUI(this.sldAlpha);
        this.sldAlpha.setUI(this.uiAlpha);
        this.uiDO = new CustomSliderUI(this.sldDrawingOrder);
        this.sldDrawingOrder.setUI(this.uiDO);
        this.uiOf = new CustomSliderUI(this.sldRadius);
        this.sldRadius.setUI(this.uiOf);
        this.uiWd = new CustomSliderUI(this.sldWidth);
        this.sldWidth.setUI(this.uiWd);
        this.uiAlpha.setUseAutoTextColor(true);
        color = UIManager.getColor("RenderedUI.Slider.thumbBorderColor");
        if (color != null) {
            this.uiDO.setThumbBorderColor(color);
            this.uiOf.setThumbBorderColor(color);
            this.uiWd.setThumbBorderColor(color);
        } else {
            this.uiDO.setThumbBorderColor(Color.BLACK);
            this.uiOf.setThumbBorderColor(Color.BLACK);
            this.uiWd.setThumbBorderColor(Color.BLACK);
        }
        color = UIManager.getColor("RenderedUI.Slider.thumbFillcolor");
        if (color != null) {
            this.uiDO.setThumbFillColor(color);
            this.uiOf.setThumbFillColor(color);
            this.uiWd.setThumbFillColor(color);
        } else {
            this.uiDO.setThumbFillColor(Color.lightGray);
            this.uiOf.setThumbFillColor(Color.lightGray);
            this.uiWd.setThumbFillColor(Color.lightGray);
        }
        color = UIManager.getColor("RenderedUI.Slider.forecolor");
        if (color != null) {
            this.uiDO.setTextColor(color);
            this.uiOf.setTextColor(color);
            this.uiWd.setTextColor(color);
        } else {
            this.uiDO.setTextColor(Color.BLACK);
            this.uiOf.setTextColor(Color.BLACK);
            this.uiWd.setTextColor(Color.BLACK);
        }
        this.uiDO.setTrackGradientColor(Color.LIGHT_GRAY);
        this.uiOf.setTrackGradientColor(Color.LIGHT_GRAY);
        this.uiWd.setTrackGradientColor(Color.LIGHT_GRAY);
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(null);
        Globals.populateGenbankTypes(this.cmbGBType);
        this.cmdZoom100.add(this.mnuZoom050);
        this.cmdZoom100.add(this.mnuZoom075);
        this.cmdZoom100.add(this.mnuZoom090);
        this.cmdZoom100.add(this.mnuZoom100);
        this.cmdZoom100.add(this.mnuZoom110);
        this.cmdZoom100.add(this.mnuZoom125);
        this.cmdZoom100.add(this.mnuZoom150);
        this.cmdZoom100.add(this.mnuZoom200);
        this.cmdZoom100.add(this.mnuZoom300);
        this.cmdZoom100.add(this.mnuZoom400);
        this.mnuZoom050.addMouseListener(this.menuMouseListener);
        this.mnuZoom075.addMouseListener(this.menuMouseListener);
        this.mnuZoom090.addMouseListener(this.menuMouseListener);
        this.mnuZoom100.addMouseListener(this.menuMouseListener);
        this.mnuZoom110.addMouseListener(this.menuMouseListener);
        this.mnuZoom125.addMouseListener(this.menuMouseListener);
        this.mnuZoom150.addMouseListener(this.menuMouseListener);
        this.mnuZoom200.addMouseListener(this.menuMouseListener);
        this.mnuZoom300.addMouseListener(this.menuMouseListener);
        this.mnuZoom400.addMouseListener(this.menuMouseListener);
        this.project.addListener(this);
        this.project.reset();
    }

    private void filesDropped(List<File> filesList) {
        if (filesList == null || filesList.isEmpty()) {
            return;
        }
        ArrayList<PluginPackage> found = null;
        for (File file : filesList) {
            GenBankFile f;
            String extention = FileReaders.getExtension(file);
            if (extention.equals(".jar") || extention.equals("jar")) {
                PluginPackage pack = Globals.loader.loadPackageFromFile(file);
                if (pack == null) continue;
                if (found == null) {
                    found = new ArrayList<PluginPackage>();
                }
                found.add(pack);
                continue;
            }
            ImpFileReader reader = FileReaders.getCompatibleReader(extention);
            if (reader == null || (f = reader.loadFile(file)) == null) continue;
            if (this.project.length() == 0) {
                this.loadFile(f);
                continue;
            }
            PLOTJ newMain = Globals.newWindow();
            newMain.loadFile(f);
        }
        if (found != null && !found.isEmpty()) {
            this.loadPackagesFromArray(found);
        }
    }

    private void setMenuScroller(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        MenuScroller scroller = MenuScroller.setScrollerFor(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
        scroller.getMenuScrollUpItem().setUI(this.menuScrollSepUpUI);
        scroller.getMenuScrollDownItem().setUI(this.menuScrollSepDownUI);
        scroller.getMenuScrollUpItem().setText("Scroll");
        scroller.getMenuScrollDownItem().setText("Scroll");
        scroller.setScrollTrigger(1);
    }

    private void setMenuScroller(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        MenuScroller scroller = MenuScroller.setScrollerFor(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
        scroller.getMenuScrollUpItem().setUI(this.menuScrollSepUpUI);
        scroller.getMenuScrollDownItem().setUI(this.menuScrollSepDownUI);
        scroller.getMenuScrollUpItem().setText("Scroll");
        scroller.getMenuScrollDownItem().setText("Scroll");
        scroller.setScrollTrigger(1);
    }

    private void setRecentMenuScroller(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        MenuScroller scroller = MenuScroller.setScrollerFor(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
        RenderedMenuItemScrollUI uiUp = new RenderedMenuItemScrollUI(1, true);
        RenderedMenuItemScrollUI uiDn = new RenderedMenuItemScrollUI(3, false);
        scroller.getMenuScrollUpItem().setUI(uiUp);
        scroller.getMenuScrollDownItem().setUI(uiDn);
        scroller.getMenuScrollUpItem().setText("Recent Files");
        scroller.getMenuScrollDownItem().setText("Recent Files");
        scroller.setScrollTrigger(1);
        scroller.getMenuScrollUpItem().setIcon(null);
    }

    private void close() {
        if (this.OKtoClose()) {
            if (this.gelForm != null) {
                this.gelForm.dispose();
                this.gelForm = null;
            }
            if (this.frmHelp != null) {
                this.frmHelp.dispose();
                this.frmHelp = null;
            }
            if (this.outputWindow != null) {
                this.outputWindow.dispose();
                this.outputWindow = null;
            }
            Globals.removeWindow(this);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.gelForm != null) {
            this.gelForm.setEnabled(b);
        }
        if (this.outputWindow != null) {
            this.outputWindow.setEnabled(b);
        }
    }

    public void panelMouseMoved(MouseEvent e) {
        if (this.right.isEmpty() && this.left.isEmpty() && !this.isEnabled()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.project.zoomFactor != 1.0f && this.cAT != null) {
            Point dst = new Point(x, y);
            try {
                this.cAT.inverseTransform(new Point(x, y), dst);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            x = dst.x;
            y = dst.y;
        }
        if (this.project.mouseoverItem != null && this.featureContains(this.project.mouseoverItem, x, y)) {
            this.toolTip.setLocation(x, y);
            return;
        }
        if (this.project.isCircular()) {
            if (x > this.panelWidth / 2) {
                if (!this.right.isEmpty() && this.checkForMouseOver(this.right, x, y)) {
                    return;
                }
                if (!this.left.isEmpty() && this.checkForMouseOver(this.left, x, y)) {
                    return;
                }
            } else {
                if (!this.left.isEmpty() && this.checkForMouseOver(this.left, x, y)) {
                    return;
                }
                if (!this.right.isEmpty() && this.checkForMouseOver(this.right, x, y)) {
                    return;
                }
            }
            if (this.checkForMouseOver(x, y)) {
                return;
            }
        } else if (!this.left.isEmpty() && y < this.panelHeight / 2 ? this.checkForMouseOver(this.left, x, y) : y > this.panelHeight / 4 && this.project.getFeatures() != null && this.checkForMouseOver(x, y)) {
            return;
        }
        if (this.project.mouseoverItem != null) {
            this.project.mouseoverItem = null;
            this.toolTip.setText(null);
            this.picMap.displayPanel.repaint();
        }
    }

    private boolean checkForMouseOver(ExtensibleArray<Feature> list, int x, int y) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int fIndex = list.size() - 1; fIndex >= 0; --fIndex) {
            Feature feature = list.get(fIndex);
            if (!this.featureContains(feature, x, y)) continue;
            this.project.mouseoverItem = feature;
            this.picMap.displayPanel.repaint();
            if (feature instanceof PrimerFeature) {
                this.toolTip.setText(this.getPrimerToolTip((PrimerFeature)this.project.mouseoverItem));
                this.toolTip.getLabel().setIcon(Globals.iconPrimer);
                this.toolTip.setBackground(Globals.toolTipGreen);
            } else if (feature instanceof EnzymeFeature) {
                this.toolTip.setText(this.getEnzymeToolTip((EnzymeFeature)this.project.mouseoverItem));
                this.toolTip.getLabel().setIcon(Globals.iconRE);
                this.toolTip.setBackground(Globals.toolTipRed);
            } else {
                this.toolTip.setText(this.getFeatureToolTip(this.project.mouseoverItem));
                if (feature.getGBType().equalsIgnoreCase("primer_bind")) {
                    this.toolTip.getLabel().setIcon(Globals.iconPrimer);
                    this.toolTip.setBackground(Globals.toolTipGreen);
                } else if (feature.getGBType().equalsIgnoreCase("cds")) {
                    this.toolTip.getLabel().setIcon(Globals.iconFeature);
                    this.toolTip.setBackground(Globals.toolTipBlue);
                } else if (feature.getGBType().equalsIgnoreCase("intron") || feature.getGBType().equalsIgnoreCase("exon")) {
                    this.toolTip.getLabel().setIcon(Globals.iconIntronExon);
                    this.toolTip.setBackground(Globals.toolTipYellow);
                } else {
                    this.toolTip.getLabel().setIcon(Globals.iconMisc);
                    this.toolTip.setBackground(Globals.toolTipYellow);
                }
            }
            this.toolTip.show(x, y);
            return true;
        }
        return false;
    }

    private boolean checkForMouseOver(int x, int y) {
        for (int fIndex = this.project.getFeatures().size() - 1; fIndex >= 0; --fIndex) {
            Feature feature = (Feature)this.project.getFeatures().get(fIndex);
            if (feature == null || !this.featureContains(feature, x, y)) continue;
            this.project.mouseoverItem = feature;
            this.picMap.displayPanel.repaint();
            if (feature instanceof PrimerFeature) {
                this.toolTip.setText(this.getPrimerToolTip((PrimerFeature)this.project.mouseoverItem));
                this.toolTip.getLabel().setIcon(Globals.iconPrimer);
                this.toolTip.setBackground(Globals.toolTipGreen);
            } else if (feature instanceof EnzymeFeature) {
                this.toolTip.setText(this.getEnzymeToolTip((EnzymeFeature)this.project.mouseoverItem));
                this.toolTip.getLabel().setIcon(Globals.iconRE);
                this.toolTip.setBackground(Globals.toolTipRed);
            } else {
                this.toolTip.setText(this.getFeatureToolTip(this.project.mouseoverItem));
                if (feature.getGBType().equalsIgnoreCase("primer_bind")) {
                    this.toolTip.getLabel().setIcon(Globals.iconPrimer);
                    this.toolTip.setBackground(Globals.toolTipGreen);
                } else if (feature.getGBType().equalsIgnoreCase("cds")) {
                    this.toolTip.getLabel().setIcon(Globals.iconFeature);
                    this.toolTip.setBackground(Globals.toolTipBlue);
                } else if (feature.getGBType().equalsIgnoreCase("intron") || feature.getGBType().equalsIgnoreCase("exon")) {
                    this.toolTip.getLabel().setIcon(Globals.iconIntronExon);
                    this.toolTip.setBackground(Globals.toolTipYellow);
                } else {
                    this.toolTip.getLabel().setIcon(Globals.iconMisc);
                    this.toolTip.setBackground(Globals.toolTipYellow);
                }
            }
            this.toolTip.show(x, y);
            return true;
        }
        return false;
    }

    private String getFeatureToolTip(Feature feature) {
        if (feature.note != null && feature.note.length() > 0) {
            feature.toolTipNote = feature.note.replaceAll("\n", "<br>");
            if (feature.toolTipNote.indexOf("<br>") > 0) {
                feature.toolTipNote = "<br>" + feature.toolTipNote;
            }
        }
        return "<html><b>" + feature.getName() + (feature.isAntisense() ? " complement(" + feature.getStop() + ".." + feature.getStart() : " (" + feature.getStart() + ".." + feature.getStop()) + ") - " + feature.getLength(this.project.length()) + "bp<br>GenBank Type:</b> " + feature.getGBType() + (feature.toolTipNote == null ? "" : "<br><b>Comment: </b>" + feature.toolTipNote) + "</html>";
    }

    private String getPrimerToolTip(PrimerFeature pFeature) {
        if (pFeature.foundPrimer.refPrimer.comment != null && pFeature.foundPrimer.refPrimer.comment.length() > 0) {
            pFeature.toolTipNote = pFeature.foundPrimer.refPrimer.comment.replaceAll("\n", "<br>");
            if (pFeature.toolTipNote.indexOf("<br>") > 0) {
                pFeature.toolTipNote = "<br>" + pFeature.toolTipNote;
            }
        }
        return "<html><b>" + pFeature.foundPrimer.refPrimer.name + (pFeature.isAntisense() ? " complement(" + pFeature.getStop() + ".." + pFeature.getStart() : " (" + pFeature.getStart() + ".." + pFeature.getStop()) + ")</b><br><b>Library: </b>" + (pFeature.foundPrimer.refPrimer.isDefault ? "Default Library" : "User Library") + "<br><b>Category: </b> " + pFeature.foundPrimer.refPrimer.category.name + "<br><b>Storage Location: </b>" + pFeature.foundPrimer.refPrimer.location + "<br><b>Sequence: </b>" + pFeature.foundPrimer.refPrimer.sequence + "<br><b>Comment: </b>" + (pFeature.toolTipNote == null ? "" : pFeature.toolTipNote) + "</html>";
    }

    private String getEnzymeToolTip(EnzymeFeature e) {
        return "<html><b>" + e.enzyme.enzyme.name + " (cuts: " + e.enzyme.getCutCount() + ") " + e.enzyme.enzyme.sequence + (e.enzyme.enzyme.tempComment.length() == 0 ? "</b></html>" : "<br>Comments:</b><br>" + e.enzyme.enzyme.tempComment);
    }

    void panelMouseDragged(MouseEvent e) {
    }

    void panelMouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            int x = e.getX();
            int y = e.getY();
            if (this.titleRect != null && this.titleRect.contains(x, y)) {
                FrmAnnotations f = new FrmAnnotations(this);
                f.tabPanel.setSelectedIndex(1);
                f.setVisible(true);
            } else if (this.project.mouseoverItem != null) {
                if (this.project.mouseoverItem instanceof PrimerFeature) {
                    if (FrmEditPrimers.showEditor(this, ((PrimerFeature)this.project.mouseoverItem).foundPrimer.refPrimer)) {
                        this.findPrimers(this.project);
                    }
                } else if (this.project.mouseoverItem instanceof EnzymeFeature) {
                    this.mnuEditSeqActionPerformed(null);
                } else {
                    this.editFeature();
                }
            }
        }
    }

    private void updateSelectedItems() {
        if (this.project.selectedItem != null && !(this.project.selectedItem instanceof PrimerFeature) && !(this.project.selectedItem instanceof EnzymeFeature)) {
            this.applyNotes();
        }
    }

    void panelMousePressed(MouseEvent e) {
        this.picMap.requestFocus();
    }

    void panelMouseReleased(MouseEvent e) {
        boolean addSubItem;
        boolean bl = addSubItem = e.isControlDown() || SystemInfo.isMacOS && e.isMetaDown();
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.project.mouseoverItem != null && !this.project.selectedItems.contains(this.project.mouseoverItem)) {
                if (addSubItem) {
                    this.project.addSelectedItem(this.project.mouseoverItem);
                } else {
                    this.project.setSelectedItem(this.project.mouseoverItem);
                }
            }
        } else if (addSubItem) {
            this.project.addSelectedItem(this.project.mouseoverItem);
        } else {
            this.project.setSelectedItem(this.project.mouseoverItem);
        }
        this.updateSelectedItems();
        this.picMap.displayPanel.repaint();
        if (!this.project.selectedItems.isEmpty() && SwingUtilities.isRightMouseButton(e)) {
            int fType = this.project.getSelectedItemsType();
            switch (fType) {
                case 1: {
                    this.updatePPopupMenu();
                    this.mnuPPopup.show(this.picMap.displayPanel, e.getX(), e.getY());
                    break;
                }
                case 2: {
                    EnzymeFeature selectedItem = (EnzymeFeature)this.project.getSelectedItem();
                    boolean haveAdd = false;
                    boolean haveRem = false;
                    for (Feature f : this.project.selectedItems) {
                        if (this.project.selectedEnzymes.containsKey(((EnzymeFeature)f).enzyme.enzyme.name)) {
                            haveRem = true;
                        } else {
                            haveAdd = true;
                        }
                        if (!haveAdd || !haveRem) continue;
                        break;
                    }
                    int selSize = this.project.selectedItems.size();
                    if (haveRem) {
                        this.mnuRemoveRE.setText("Remove " + (selSize > 1 ? "enzymes" : selectedItem.enzyme.enzyme.name) + " from selected");
                        this.mnuRemoveRE.setVisible(true);
                        this.mnuAddRE.setVisible(false);
                    }
                    if (haveAdd) {
                        this.mnuAddRE.setText("Add " + (selSize > 1 ? "enzymes" : selectedItem.enzyme.enzyme.name) + " from selected");
                        this.mnuAddRE.setVisible(true);
                        this.mnuRemoveRE.setVisible(false);
                    }
                    this.mnuAddAsMix.setVisible(selSize > 1);
                    this.mnuCopyRE.setText("Copy " + selectedItem.enzyme.enzyme.name + "'s sequence.");
                    this.mnuREPopup.show(this.picMap.displayPanel, e.getX(), e.getY());
                    break;
                }
                case 0: {
                    this.updateFPopupMenu();
                    this.mnuFPopup.show(this.picMap.displayPanel, e.getX(), e.getY());
                }
            }
        }
    }

    private void updatePPopupMenu() {
        boolean showSingle;
        boolean haveDefaultPrimer = false;
        boolean haveUserPrimer = false;
        for (Feature f : this.project.selectedItems) {
            if (((PrimerFeature)f).foundPrimer.refPrimer.isDefault) {
                haveDefaultPrimer = true;
                continue;
            }
            haveUserPrimer = true;
        }
        this.mnuRemovePrimer.setVisible(haveUserPrimer);
        boolean bl = showSingle = this.project.selectedItems.size() == 1;
        if (showSingle) {
            this.mnuPrimerToFeature.setText("Convert primer to a feature");
            this.mnuPrimerToFeature.setToolTipText("Converts the primer to a feature in the project.");
            this.mnuRemovePrimer.setText("Remove primer from library");
            this.mnuRemovePrimer.setToolTipText("Remove the primer from user primer library.");
        } else {
            this.mnuPrimerToFeature.setText("Convert selected primers to features");
            this.mnuPrimerToFeature.setToolTipText("Converts selected primers to feature in the project.");
            this.mnuRemovePrimer.setText("Remove selected primers from library");
            this.mnuRemovePrimer.setToolTipText("Remove selected user primers from user primer library.");
        }
    }

    private void updateFPopupMenu() {
        boolean showSingle = this.project.selectedItems.size() == 1;
        this.mnuChangeTitle.setVisible(showSingle);
        this.mnuShowAllLabels.setVisible(showSingle);
        this.mnuRenameFeature.setVisible(showSingle);
        this.sep3.setVisible(showSingle);
        this.jSeparator38.setVisible(showSingle);
        this.mnuRevComp.setVisible(showSingle);
        this.mnuRotateSeq.setVisible(showSingle);
        this.mnuSaveAllToLib.setVisible(showSingle);
        this.jSeparator41.setVisible(showSingle);
        this.mnuFCopy.setVisible(showSingle);
        this.sepDrawingOrder.setVisible(showSingle);
        this.mnuFPopup.setVisible(showSingle);
        this.mnuMoveUp.setVisible(showSingle);
        this.mnuMoveDown.setVisible(showSingle);
        this.mnuMoveTop.setVisible(showSingle);
        this.mnuMoveBottom.setVisible(showSingle);
        this.sepCaseChange.setVisible(showSingle);
        this.mnuUpperCase.setVisible(showSingle);
        this.mnuLowerCase.setVisible(showSingle);
        if (showSingle) {
            this.mnuShowLabel.setText("Show label");
            this.mnuSetFeatureCodonTable.setToolTipText("Sets the codon table used to translate this feature.");
            this.mnuSetFeatureCodonTable.setText("Set feature codon table");
            this.mnuChangeGraphic.setText("Change feature graphic");
            this.mnuChangeGraphic.setToolTipText("Select a new graphic style for this feature.");
            this.mnuLabelColor.setText("Change label color");
            this.mnuLabelColor.setToolTipText("Change the color used for this feature's label.");
            this.mnuGraphicColor.setText("Change graphic color");
            this.mnuGraphicColor.setToolTipText("Change the fill color used for this feature's graphic.");
            this.mnuSaveToLib.setText("Save this feature to library");
            this.mnuRemFeature.setText("Remove feature");
            this.mnuRemFeature.setToolTipText("Remove this feature annotation.");
            this.mnuSaveToLibDNA.setToolTipText("Save this feature as a DNA sequence to the user feature library for future autoannotating.");
        } else {
            this.mnuShowLabel.setText("Show labels");
            this.mnuSetFeatureCodonTable.setText("Set feature codon tables");
            this.mnuSetFeatureCodonTable.setToolTipText("Sets the codon table used to translate selected features.");
            this.mnuChangeGraphic.setText("Change feature graphics");
            this.mnuChangeGraphic.setToolTipText("Select a new graphic style for the selected features.");
            this.mnuLabelColor.setText("Change label colors");
            this.mnuLabelColor.setToolTipText("Change the color for the selected feature labels.");
            this.mnuGraphicColor.setText("Change graphic colors");
            this.mnuGraphicColor.setToolTipText("Change the fill color used for the selected feature graphics.");
            this.mnuSaveToLib.setText("Save selected features to library");
            this.mnuRemFeature.setText("Remove selected features");
            this.mnuRemFeature.setToolTipText("Remove selected feature annotations.");
            this.mnuSaveToLibDNA.setToolTipText("Save selected features as a DNA sequence to the user feature library for future autoannotating.");
        }
    }

    void panelMouseEntered(MouseEvent e) {
    }

    void panelMouseExited(MouseEvent e) {
        if (this.project.mouseoverItem != null) {
            this.project.mouseoverItem = null;
            this.picMap.displayPanel.repaint();
        }
    }

    void panelMouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown() || e.isMetaDown() || e.getButton() != 0) {
            this.adjustZoom(e.getWheelRotation() < 0 ? 0.1f : -0.1f);
        } else if (e.isShiftDown()) {
            this.picMap.getHScrollBar().setValue(this.picMap.getHScrollBar().getValue() + (long)(e.getWheelRotation() < 0 ? this.picMap.getHScrollBar().getUnitIncrement() : -this.picMap.getHScrollBar().getUnitIncrement()));
        } else {
            this.picMap.getVScrollBar().setValue(this.picMap.getVScrollBar().getValue() + (long)(e.getWheelRotation() < 0 ? -this.picMap.getVScrollBar().getUnitIncrement() : this.picMap.getVScrollBar().getUnitIncrement()));
        }
    }

    BasicTextToolTip genToolTip() {
        if (this.toolTip == null && this.picMap != null) {
            this.toolTip = new BasicTextToolTip((Component)this.picMap.displayPanel, "");
            Color color = UIManager.getColor("Tooltip.foreground");
            if (color != null) {
                this.toolTip.setForeground(color);
            }
            this.addFocusListener(this.toolTip);
            this.toolTip.getLabel().setHorizontalAlignment(2);
            this.toolTip.getLabel().setVerticalAlignment(3);
            this.toolTip.setHideOnRelease(false);
            this.toolTip.setHideOnMove(false);
            this.toolTip.setFadeIn(true);
            this.toolTip.setOpacity(0.9f);
            this.toolTip.setFadeStep(0.05f);
        }
        return this.toolTip;
    }

    @Override
    public void setTitle(String projectName) {
        Font font = this.project.isChanged() ? Globals.titleFontBold : Globals.titleFont;
        this.baseTitle = this.project.getFile() == null ? (projectName == null || projectName.length() == 0 ? "New Sequence" : (this.project.isChanged() ? "*" + projectName : projectName)) : (this.project.isChanged() ? "*" + this.project.getFile().getAbsolutePath() : this.project.getFile().getAbsolutePath());
        BaseRootPaneUI.setTitleFont(this, font);
        super.setTitle("pLOT - " + this.baseTitle);
        if (this.gelForm != null) {
            BaseRootPaneUI.setTitleFont(this.gelForm, font);
            this.gelForm.setTitle("Gel - " + this.baseTitle);
        }
        if (this.outputWindow != null) {
            BaseRootPaneUI.setTitleFont(this.outputWindow, font);
            this.outputWindow.setTitle("Output - " + this.baseTitle);
        }
    }

    PLOTJ() {
        this.initMain();
        Globals.addWindow(this);
    }

    private void initComponents() {
        this.mnuFPopup = new JPopupMenu();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.mnuLabelOptions = new JMenu();
        this.mnuShowLabel = new JMenuItem();
        this.mnuChangeTitle = new JMenuItem();
        this.mnuShowAllLabels = new JMenuItem();
        this.jSeparator38 = new JPopupMenu.Separator();
        this.mnuRenameFeature = new JMenuItem();
        this.sep3 = new JPopupMenu.Separator();
        this.mnuRevComp = new JMenuItem();
        this.mnuRotateSeq = new JMenu();
        this.sepCopy8 = new JPopupMenu.Separator();
        this.mnuRotate1 = new JMenuItem();
        this.mnuRotate2 = new JMenuItem();
        this.sepCopy7 = new JPopupMenu.Separator();
        this.jSeparator40 = new JPopupMenu.Separator();
        this.mnuSaveToLib = new JMenu();
        this.jSeparator48 = new JPopupMenu.Separator();
        this.mnuSaveToLibDNA = new JMenuItem();
        this.mnuSaveToLibAA = new JMenuItem();
        this.jSeparator47 = new JPopupMenu.Separator();
        this.mnuSaveAllToLib = new JMenu();
        this.jSeparator49 = new JPopupMenu.Separator();
        this.mnuSaveAllToLibDNA = new JMenuItem();
        this.mnuSaveAllToLibAA = new JMenuItem();
        this.jSeparator50 = new JPopupMenu.Separator();
        this.jSeparator41 = new JPopupMenu.Separator();
        this.mnuFCopy = new JMenu();
        this.sepCopy1 = new JPopupMenu.Separator();
        this.mnuCopyFpLOT = new JMenuItem();
        this.mnuFCopyssDNA_AS = new JMenuItem();
        this.sepCopy2 = new JPopupMenu.Separator();
        this.mnuFCopyssDNA = new JMenuItem();
        this.mnuFCopydsDNA = new JMenuItem();
        this.mnuFCopyFormattedSS = new JMenuItem();
        this.mnuFCopyFormattedDS = new JMenuItem();
        this.sepCopy3 = new JPopupMenu.Separator();
        this.mnuFCopyAAF1 = new JMenuItem();
        this.mnuFCopyAAF2 = new JMenuItem();
        this.mnuFCopyAAF3 = new JMenuItem();
        this.sepCopy4 = new JPopupMenu.Separator();
        this.mnuFCopyAAssF1 = new JMenuItem();
        this.mnuFCopyAAssF2 = new JMenuItem();
        this.mnuFCopyAAssF3 = new JMenuItem();
        this.mnuFCopyAAssF123 = new JMenuItem();
        this.sepCopy5 = new JPopupMenu.Separator();
        this.mnuFCopyAAdsF1 = new JMenuItem();
        this.mnuFCopyAAdsF2 = new JMenuItem();
        this.mnuFCopyAAdsF3 = new JMenuItem();
        this.mnuFCopyAAdsF123 = new JMenuItem();
        this.sepCopy6 = new JPopupMenu.Separator();
        this.sepDrawingOrder = new JPopupMenu.Separator();
        this.mnuMoveUp = new JMenuItem();
        this.mnuMoveDown = new JMenuItem();
        this.mnuMoveTop = new JMenuItem();
        this.mnuMoveBottom = new JMenuItem();
        this.sepDisplayOptions = new JPopupMenu.Separator();
        this.mnuLabelColor = new JMenuItem();
        this.mnuGraphicColor = new JMenuItem();
        this.mnuChangeGraphic = new JMenu();
        this.mnuToLine = new JMenuItem();
        this.mnuToBox = new JMenuItem();
        this.mnuToArrow = new JMenuItem();
        this.mnuToHeadlessArrow = new JMenuItem();
        this.mnuToLineArrow = new JMenuItem();
        this.mnuToTickMark = new JMenuItem();
        this.mnuToBrackets = new JMenuItem();
        this.mnuToNoGraphic = new JMenuItem();
        this.mnuSetFeatureCodonTable = new JMenu();
        this.sepCaseChange = new JPopupMenu.Separator();
        this.mnuUpperCase = new JMenuItem();
        this.mnuLowerCase = new JMenuItem();
        this.jSeparator43 = new JPopupMenu.Separator();
        this.mnuRemFeature = new JMenuItem();
        this.jSeparator46 = new JPopupMenu.Separator();
        this.zoomButtonGroup = new ButtonGroup();
        this.grpCodonTableProject = new ButtonGroup();
        this.grpCodonTableFeature = new ButtonGroup();
        this.mnuPPopup = new JPopupMenu();
        this.sepPHeader = new JPopupMenu.Separator();
        this.mnuPrimerToFeature = new JMenuItem();
        this.mnuRemovePrimer = new JMenuItem();
        this.sepPFooter = new JPopupMenu.Separator();
        this.mnuREPopup = new JPopupMenu();
        this.sepREHeader = new JPopupMenu.Separator();
        this.mnuAddRE = new JMenuItem();
        this.mnuAddAsMix = new JMenuItem();
        this.mnuRemoveRE = new JMenuItem();
        this.mnuCopyRE = new JMenuItem();
        this.sepCaseChangeRE = new JPopupMenu.Separator();
        this.mnuUpperCaseRE = new JMenuItem();
        this.mnuLowerCaseRE = new JMenuItem();
        this.sepREFooter = new JPopupMenu.Separator();
        this.jMenuItem13 = new JMenuItem();
        this.mnuZoomPopup = new JPopupMenu();
        this.mnuZoom050 = new JRadioButtonMenuItem();
        this.mnuZoom075 = new JRadioButtonMenuItem();
        this.mnuZoom090 = new JRadioButtonMenuItem();
        this.mnuZoom100 = new JRadioButtonMenuItem();
        this.mnuZoom110 = new JRadioButtonMenuItem();
        this.mnuZoom125 = new JRadioButtonMenuItem();
        this.mnuZoom150 = new JRadioButtonMenuItem();
        this.mnuZoom200 = new JRadioButtonMenuItem();
        this.mnuZoom300 = new JRadioButtonMenuItem();
        this.mnuZoom400 = new JRadioButtonMenuItem();
        this.mnuPopupDockFeatures = new JPopupMenu();
        this.sepSplitWindow = new JPopupMenu.Separator();
        this.mnuUndockFeatures = new JMenuItem();
        this.mnuDockFeatures = new JMenuItem();
        this.mnuHideFeatures = new JMenuItem();
        this.mnuDebug = new JMenu();
        this.sepPref2 = new JPopupMenu.Separator();
        this.mnuSetFeaturesLib = new JMenuItem();
        this.mnuSetPrimersLib = new JMenuItem();
        this.mnuSetLaddersLib = new JMenuItem();
        this.mnuCloneWindow = new JMenuItem();
        this.mnuSepExportMap = new JPopupMenu.Separator();
        this.mnuExportMap = new JMenuItem();
        this.jSeparator45 = new JPopupMenu.Separator();
        this.mnuMisc = new JMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.mnuLabelsCircle = new JMenuItem();
        this.mnuLabelsLinear = new JMenuItem();
        this.mnuAddChromat = new JMenuItem();
        this.mnuFontTest = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.mnuCheckForUpdates = new JMenuItem();
        this.sepUpdates = new JPopupMenu.Separator();
        this.mainToolBar = new JToolBar();
        this.cmdNew = new JButton();
        this.cmdOpen = new JButton();
        this.cmdSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.cmdCircular = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.cmdShowLabels = new JToggleButton();
        this.cmdShowRE = new JToggleButton();
        this.cmdShowPrimers = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.cmdChromat = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.cmdToggleOverlay = new JToggleButton();
        this.jSeparator53 = new JToolBar.Separator();
        this.cmdZoomIn = new JButton();
        this.cmdZoomOut = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.cmdZoom100 = new LongPressButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.cmdUndo = new JButton();
        this.cmdRedo = new JButton();
        this.sepPluginTools = new JToolBar.Separator();
        this.hSplitPane = new JSplitPane();
        this.vSplitPane = new JSplitPane();
        this.picMap = new ScrollPanel(){

            @Override
            public void customDisplayPaint(Graphics g, int Width, int Height) {
                PLOTJ.this.drawMap(g, Width, Height);
            }

            @Override
            public void hScrollValueChanged(long newValue) {
                PLOTJ.this.hScrollChanged((int)newValue);
            }

            @Override
            public void vScrollValueChanged(long newValue) {
                PLOTJ.this.vScrollChanged((int)newValue);
            }

            @Override
            public void displayPanelResized(int width, int height) {
                if (((PLOTJ)PLOTJ.this).project.zoomFactor > 1.0f) {
                    PLOTJ.this.setScrollbarValues();
                }
                PLOTJ.this.resetMap();
            }

            @Override
            public void displayPanelFocusGained() {
                PLOTJ.this.setActiveComponent(this);
            }

            @Override
            public void displayPanelClicked(MouseEvent e) {
                PLOTJ.this.panelMouseClicked(e);
            }

            @Override
            public void displayPanelMouseMoved(MouseEvent e) {
                PLOTJ.this.panelMouseMoved(e);
            }

            @Override
            public void displayPanelMouseDragged(MouseEvent e) {
                PLOTJ.this.panelMouseDragged(e);
            }

            @Override
            public void displayPanelMouseClicked(MouseEvent e) {
                PLOTJ.this.panelMouseClicked(e);
            }

            @Override
            public void displayPanelMousePressed(MouseEvent e) {
                PLOTJ.this.panelMousePressed(e);
            }

            @Override
            public void displayPanelMouseReleased(MouseEvent e) {
                PLOTJ.this.panelMouseReleased(e);
            }

            @Override
            public void displayPanelMouseEntered(MouseEvent e) {
                PLOTJ.this.panelMouseEntered(e);
            }

            @Override
            public void displayPanelMouseExited(MouseEvent e) {
                PLOTJ.this.panelMouseExited(e);
            }

            @Override
            public void displayPanelMouseWheelMoved(MouseWheelEvent e) {
                PLOTJ.this.panelMouseWheelMoved(e);
            }
        };
        this.dockFeatures = new DockPanel(){

            @Override
            public boolean beforeUndock() {
                PLOTJ.this.fDividerLoc = PLOTJ.this.vSplitPane.getDividerLocation();
                return true;
            }

            @Override
            public void afterDocked() {
                PLOTJ.this.vSplitPane.setDividerSize(5);
                PLOTJ.this.vSplitPane.setDividerLocation(PLOTJ.this.fDividerLoc);
            }

            @Override
            public void afterUndocked() {
                PLOTJ.this.vSplitPane.setDividerSize(0);
            }
        };
        this.editor = new SequenceEditorPanel(){

            @Override
            public void displayPanelFocusGained() {
                PLOTJ.this.setActiveComponent(this);
            }

            @Override
            public JPopupMenu getSelectionMenu(int selStart, int selStop) {
                return PLOTJ.this.getEditorPopupMenu();
            }
        };
        this.dockTools = new DockPanel(){

            @Override
            public boolean beforeUndock() {
                PLOTJ.this.tDividerLoc = PLOTJ.this.hSplitPane.getDividerLocation();
                return true;
            }

            @Override
            public void afterDocked() {
                PLOTJ.this.hSplitPane.setDividerSize(5);
                PLOTJ.this.hSplitPane.setDividerLocation(PLOTJ.this.tDividerLoc);
            }

            @Override
            public void afterUndocked() {
                PLOTJ.this.hSplitPane.setDividerSize(0);
            }
        };
        this.scrollPaneTools = new JScrollPane();
        this.taskPaneContainer = new JXTaskPaneContainer();
        this.toolsPlasmid = new JXTaskPane();
        this.toolsFeatures = new JXTaskPane();
        this.panelPlasmidTools = new JPanel();
        this.jLabel1 = new JLabel();
        this.chkCircular = new JCheckBox();
        this.txtPlasmidName = new GhostTextBox();
        this.jLabel2 = new JLabel();
        this.txtSource = new GhostTextBox();
        this.jLabel3 = new JLabel();
        this.txtOrg = new GhostTextBox();
        this.lblEditNotes = new JLabel();
        this.lblEditAnnotations = new JLabel();
        this.lblEditReferences = new JLabel();
        this.panelFeatureTools = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblColorGraphic = new ColorLabel();
        this.toggleLink = new JToggleButton();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.sldAlpha = new JSlider();
        this.spinAlpha = new JSpinner();
        this.jLabel11 = new JLabel();
        this.sldRadius = new JSlider();
        this.spinRadius = new JSpinner();
        this.jLabel12 = new JLabel();
        this.sldWidth = new JSlider();
        this.spinWidth = new JSpinner();
        this.jLabel13 = new JLabel();
        this.sldDrawingOrder = new JSlider();
        this.chkDrawGraphic = new JCheckBox();
        this.cmbGraphic = new JComboBox();
        this.jPanel2 = new JPanel();
        this.txtCaption = new GhostTextBox();
        this.chkShowLabel = new JCheckBox();
        this.lblColorLabel = new ColorLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.txtNotes = new GhostTextArea();
        this.panelFMainOptions = new JPanel();
        this.lblFName = new JLabel();
        this.txtFName = new GhostTextBox();
        this.lblStart = new JLabel();
        this.txtStart = new GhostTextBox();
        this.txtEnd = new GhostTextBox();
        this.lblEnd = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cmbGBType = new JComboBox();
        this.cmbOrient = new JComboBox();
        this.statusLabel = new StatusLabel();
        this.mainMenuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.mnuNew = new JMenuItem();
        this.mnuOpen = new JMenuItem();
        this.mnuNewWindow = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.mnuGetGB = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.mnuSave = new JMenuItem();
        this.mnuSaveAs = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.mnuRecent = new JMenu();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.mnuExit = new JMenuItem();
        this.jSeparator44 = new JPopupMenu.Separator();
        this.mnuEdit = new JMenu();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.mnuUndo = new JMenuItem();
        this.mnuRedo = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.mnuCut = new JMenuItem();
        this.mnuCopy = new JMenuItem();
        this.mnuPaste = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.mnuEditAnnotations = new JMenuItem();
        this.mnuEditSeq = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.mnuNewFeature = new JMenuItem();
        this.mnuDupFeature = new JMenuItem();
        this.cmdDelFeature = new JMenuItem();
        this.cmdDelSequence = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.mnuRotate = new JMenuItem();
        this.mnuAntisenseSeq = new JMenuItem();
        this.mnuAntisenseRegion = new JMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.mnuFind = new JMenuItem();
        this.jSeparator51 = new JPopupMenu.Separator();
        this.mnuView = new JMenu();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.mnuCircular = new JMenuItem();
        this.jSeparator22 = new JPopupMenu.Separator();
        this.mnuViewFeaturesList = new JMenuItem();
        this.jSeparator34 = new JPopupMenu.Separator();
        this.chkToggleOverlay = new JCheckBoxMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.mnuToggleFrame1 = new JCheckBoxMenuItem();
        this.mnuToggleFrame2 = new JCheckBoxMenuItem();
        this.mnuToggleFrame3 = new JCheckBoxMenuItem();
        this.mnuToggleFrame4 = new JCheckBoxMenuItem();
        this.mnuToggleFrame5 = new JCheckBoxMenuItem();
        this.mnuToggleFrame6 = new JCheckBoxMenuItem();
        this.mnuToggleAntisense = new JCheckBoxMenuItem();
        this.mnuToggleNumbers = new JCheckBoxMenuItem();
        this.mnuTools = new JMenu();
        this.jSeparator25 = new JPopupMenu.Separator();
        this.mnuConvertExons = new JMenuItem();
        this.jSeparator26 = new JPopupMenu.Separator();
        this.mnuDNAElements = new JMenuItem();
        this.jSeparator27 = new JPopupMenu.Separator();
        this.mnuCalcCodon = new JMenuItem();
        this.mnuCalcCodon2 = new JMenuItem();
        this.jSeparator28 = new JPopupMenu.Separator();
        this.mnuRE = new JMenuItem();
        this.mnuCutters = new JMenuItem();
        this.mnuNonCutters = new JMenuItem();
        this.jSeparator29 = new JPopupMenu.Separator();
        this.mnuSetProjectCodonTable = new JMenu();
        this.mnuAAtoDNA = new JMenuItem();
        this.mnuAnnotate = new JMenuItem();
        this.jSeparator31 = new JPopupMenu.Separator();
        this.mnuRemoveAll = new JMenuItem();
        this.jSeparator35 = new JPopupMenu.Separator();
        this.mnuPlugins = new JMenu();
        this.sepLoadTools = new JPopupMenu.Separator();
        this.mnuLoadPlugins = new JMenuItem();
        this.sepPlugins = new JPopupMenu.Separator();
        this.sepPlugins1 = new JPopupMenu.Separator();
        this.mnuFeatures = new JMenu();
        this.jSeparator32 = new JPopupMenu.Separator();
        this.mnuIncFeatureWidth = new JMenuItem();
        this.mnuDecFeatureWidth = new JMenuItem();
        this.mnuIncFeatureOffset = new JMenuItem();
        this.mnuDecFeatureOffset = new JMenuItem();
        this.jSeparator33 = new JPopupMenu.Separator();
        this.mnuIncFeatureWidths = new JMenuItem();
        this.mnuDecFeatureWidths = new JMenuItem();
        this.mnuIncFeatureOffsets = new JMenuItem();
        this.mnuDecFeatureOffsets = new JMenuItem();
        this.jSeparator39 = new JPopupMenu.Separator();
        this.mnuLibraries = new JMenu();
        this.jSeparator24 = new JPopupMenu.Separator();
        this.mnuEditFeaturesLib = new JMenuItem();
        this.mnuEditPrimersLib = new JMenuItem();
        this.mnuEditLaddersLib = new JMenuItem();
        this.jSeparator30 = new JPopupMenu.Separator();
        this.mnuSetDatabaseLocations = new JMenuItem();
        this.jSeparator52 = new JPopupMenu.Separator();
        this.mnuWindows = new JMenu();
        this.sepShowWindows = new JPopupMenu.Separator();
        this.mnuShowToolWindow = new JMenuItem();
        this.mnuShowSplitWindow = new JMenuItem();
        this.sepGel = new JPopupMenu.Separator();
        this.mnuGel = new JMenuItem();
        this.mnuMobileBlocks = new JMenuItem();
        this.sepShowWindows1 = new JPopupMenu.Separator();
        this.mnuAbout = new JMenu();
        this.jSeparator36 = new JPopupMenu.Separator();
        this.mnuShowHelp = new JMenuItem();
        this.mnuAboutpLOT = new JMenuItem();
        this.jSeparator42 = new JPopupMenu.Separator();
        this.jSeparator20.setToolTipText("Label Display Options");
        this.mnuFPopup.add(this.jSeparator20);
        this.mnuLabelOptions.setText("Label Options");
        this.mnuLabelOptions.setToolTipText("Change this feature's label display options.");
        this.mnuShowLabel.setText("Show Label");
        this.mnuLabelOptions.add(this.mnuShowLabel);
        this.mnuChangeTitle.setText("Change Feature Title");
        this.mnuLabelOptions.add(this.mnuChangeTitle);
        this.mnuShowAllLabels.setText("Show All Labels");
        this.mnuLabelOptions.add(this.mnuShowAllLabels);
        this.mnuFPopup.add(this.mnuLabelOptions);
        this.jSeparator38.setToolTipText("Rename");
        this.mnuFPopup.add(this.jSeparator38);
        this.mnuRenameFeature.setAccelerator(KeyStroke.getKeyStroke(78, 0));
        this.mnuRenameFeature.setText("Rename Feature");
        this.mnuRenameFeature.setToolTipText("Rename this feature.");
        this.mnuRenameFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRenameFeatureActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuRenameFeature);
        this.sep3.setToolTipText("Orientation/Rotation");
        this.mnuFPopup.add(this.sep3);
        this.mnuRevComp.setIcon(new ImageIcon(this.getClass().getResource("/images24/Reverse.png")));
        this.mnuRevComp.setText("Reverse/Complement Feature");
        this.mnuRevComp.setToolTipText("Reverse/Complement this feature's sequence and all annotations contained therein.");
        this.mnuRevComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRevCompActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuRevComp);
        this.mnuRotateSeq.setIcon(new ImageIcon(this.getClass().getResource("/images24/Rotate.png")));
        this.mnuRotateSeq.setText("Rotate Sequence");
        this.sepCopy8.setToolTipText("Rotate Sequence");
        this.mnuRotateSeq.add(this.sepCopy8);
        this.mnuRotate1.setBackground(new Color(255, 255, 255));
        this.mnuRotate1.setBorder(null);
        this.mnuRotate1.setIcon(new ImageIcon(this.getClass().getResource("/images24/Rotate.png")));
        this.mnuRotate1.setText("to Feature Start");
        this.mnuRotate1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRotate1ActionPerformed(evt);
            }
        });
        this.mnuRotateSeq.add(this.mnuRotate1);
        this.mnuRotate2.setBackground(new Color(255, 255, 255));
        this.mnuRotate2.setBorder(null);
        this.mnuRotate2.setIcon(new ImageIcon(this.getClass().getResource("/images24/Rotate.png")));
        this.mnuRotate2.setText("to Feature Stop");
        this.mnuRotate2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRotate2ActionPerformed(evt);
            }
        });
        this.mnuRotateSeq.add(this.mnuRotate2);
        this.sepCopy7.setToolTipText("");
        this.mnuRotateSeq.add(this.sepCopy7);
        this.mnuFPopup.add(this.mnuRotateSeq);
        this.jSeparator40.setToolTipText("Archive");
        this.mnuFPopup.add(this.jSeparator40);
        this.mnuSaveToLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveToLib.setText("Save this feature to library");
        this.mnuSaveToLib.setToolTipText("Save this feature to the user feature library for future autoannotating.");
        this.jSeparator48.setToolTipText("Archive Selection");
        this.mnuSaveToLib.add(this.jSeparator48);
        this.mnuSaveToLibDNA.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveToLibDNA.setText("Save to library as DNA");
        this.mnuSaveToLibDNA.setToolTipText("Save this feature as a DNA sequence to the user feature library for future autoannotating.");
        this.mnuSaveToLibDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveToLibDNAActionPerformed(evt);
            }
        });
        this.mnuSaveToLib.add(this.mnuSaveToLibDNA);
        this.mnuSaveToLibAA.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveToLibAA.setText("Save to library as Amino Acids");
        this.mnuSaveToLibAA.setToolTipText("Save this feature as an amino acid sequence to the user feature library for future autoannotating.");
        this.mnuSaveToLibAA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveToLibAAActionPerformed(evt);
            }
        });
        this.mnuSaveToLib.add(this.mnuSaveToLibAA);
        this.jSeparator47.setToolTipText("");
        this.mnuSaveToLib.add(this.jSeparator47);
        this.mnuFPopup.add(this.mnuSaveToLib);
        this.mnuSaveAllToLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveAllToLib.setText("Save all features to library.");
        this.mnuSaveAllToLib.setToolTipText("Save all annotated feature in this project to the user feature library for future autoannotating");
        this.jSeparator49.setToolTipText("Archive All");
        this.mnuSaveAllToLib.add(this.jSeparator49);
        this.mnuSaveAllToLibDNA.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveAllToLibDNA.setText("Save to library as DNA");
        this.mnuSaveAllToLibDNA.setToolTipText("Save all features in this project as DNA sequences to the user feature library for future autoannotating.");
        this.mnuSaveAllToLibDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveAllToLibDNAActionPerformed(evt);
            }
        });
        this.mnuSaveAllToLib.add(this.mnuSaveAllToLibDNA);
        this.mnuSaveAllToLibAA.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.mnuSaveAllToLibAA.setText("Save to library as Amino Acids");
        this.mnuSaveAllToLibAA.setToolTipText("Save all features in this project as amino acid sequences to the user feature library for future autoannotating.");
        this.mnuSaveAllToLibAA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveAllToLibAAActionPerformed(evt);
            }
        });
        this.mnuSaveAllToLib.add(this.mnuSaveAllToLibAA);
        this.jSeparator50.setToolTipText("");
        this.mnuSaveAllToLib.add(this.jSeparator50);
        this.mnuFPopup.add(this.mnuSaveAllToLib);
        this.jSeparator41.setToolTipText("Copy Options");
        this.mnuFPopup.add(this.jSeparator41);
        this.mnuFCopy.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuFCopy.setText("Copy Feature Sequence to Clipboard");
        this.mnuFCopy.setToolTipText("Copy this feature's sequence to clipboard.");
        this.sepCopy1.setToolTipText("pLOT Feature Format");
        this.mnuFCopy.add(this.sepCopy1);
        this.mnuCopyFpLOT.setText("Copy as sense");
        this.mnuCopyFpLOT.setToolTipText("Copies the selected feature's sequence and annotations.");
        this.mnuCopyFpLOT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCopyFpLOTActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuCopyFpLOT);
        this.mnuFCopyssDNA_AS.setText("Copy as antisense");
        this.mnuFCopyssDNA_AS.setToolTipText("Copies the selected feature's sequence and annotations as antisense.");
        this.mnuFCopyssDNA_AS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyssDNA_ASActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyssDNA_AS);
        this.sepCopy2.setToolTipText("DNA Only Options");
        this.mnuFCopy.add(this.sepCopy2);
        this.mnuFCopyssDNA.setText("DNA: Single Stranded (Sense)");
        this.mnuFCopyssDNA.setToolTipText("Copy this feature's sequence to the clipboard as a single sense strand.");
        this.mnuFCopyssDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyssDNAActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyssDNA);
        this.mnuFCopydsDNA.setText("DNA: Double Stranded");
        this.mnuFCopydsDNA.setToolTipText("Copy this feature's sequence to the clipboard as a double stranded.");
        this.mnuFCopydsDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopydsDNAActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopydsDNA);
        this.mnuFCopyFormattedSS.setText("DNA: Formatted, Single Stranded");
        this.mnuFCopyFormattedSS.setToolTipText("Copy this feature's sequence to the clipboard as a formatted single strand.");
        this.mnuFCopyFormattedSS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyFormattedSSActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyFormattedSS);
        this.mnuFCopyFormattedDS.setText("DNA: Formatted, Double Stranded");
        this.mnuFCopyFormattedDS.setToolTipText("Copy this feature's sequence to the clipboard as a formatted double strand.");
        this.mnuFCopyFormattedDS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyFormattedDSActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyFormattedDS);
        this.sepCopy3.setToolTipText("Amino Acid Only Options");
        this.mnuFCopy.add(this.sepCopy3);
        this.mnuFCopyAAF1.setText("Protein: Translation Frame 1");
        this.mnuFCopyAAF1.setToolTipText("Copy this feature's frame 1 translation to the clipboard.");
        this.mnuFCopyAAF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAF1ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAF1);
        this.mnuFCopyAAF2.setText("Protein: Translation Frame 2");
        this.mnuFCopyAAF2.setToolTipText("Copy this feature's frame 2 translation to the clipboard.");
        this.mnuFCopyAAF2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAF2ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAF2);
        this.mnuFCopyAAF3.setText("Protein: Translation Frame 3");
        this.mnuFCopyAAF3.setToolTipText("Copy this feature's frame 3 translation to the clipboard.");
        this.mnuFCopyAAF3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAF3ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAF3);
        this.sepCopy4.setToolTipText("ssDNA + Amino Acid Options");
        this.mnuFCopy.add(this.sepCopy4);
        this.mnuFCopyAAssF1.setText("Protein: ssDNA + Translation Frame 1");
        this.mnuFCopyAAssF1.setToolTipText("Copy this feature's single stranded sequence and its frame 1 translation to the clipboard.");
        this.mnuFCopyAAssF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAssF1ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAssF1);
        this.mnuFCopyAAssF2.setText("Protein: ssDNA + Translation Frame 2");
        this.mnuFCopyAAssF2.setToolTipText("Copy this feature's single stranded sequence and its frame 2 translation to the clipboard.");
        this.mnuFCopyAAssF2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAssF2ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAssF2);
        this.mnuFCopyAAssF3.setText("Protein: ssDNA + Translation Frame 3");
        this.mnuFCopyAAssF3.setToolTipText("Copy this feature's single stranded sequence and its frame 3 translation to the clipboard.");
        this.mnuFCopyAAssF3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAssF3ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAssF3);
        this.mnuFCopyAAssF123.setText("Protein: ssDNA + Translation Frame 1+2+3");
        this.mnuFCopyAAssF123.setToolTipText("Copy this feature's single stranded sequence and its 3 reading frame translations to the clipboard.");
        this.mnuFCopyAAssF123.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAssF123ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAssF123);
        this.sepCopy5.setToolTipText("dsDNA + Amino Acid Options");
        this.mnuFCopy.add(this.sepCopy5);
        this.mnuFCopyAAdsF1.setText("Protein: dsDNA + Translation Frame 1");
        this.mnuFCopyAAdsF1.setToolTipText("Copy this feature's double stranded sequence and its frame 1 translation to the clipboard.");
        this.mnuFCopyAAdsF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAdsF1ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAdsF1);
        this.mnuFCopyAAdsF2.setText("Protein: dsDNA + Translation Frame 2");
        this.mnuFCopyAAdsF2.setToolTipText("Copy this feature's double stranded sequence and its frame 2 translation to the clipboard.");
        this.mnuFCopyAAdsF2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAdsF2ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAdsF2);
        this.mnuFCopyAAdsF3.setText("Protein: dsDNA + Translation Frame 3");
        this.mnuFCopyAAdsF3.setToolTipText("Copy this feature's double stranded sequence and its frame 3 translation to the clipboard.");
        this.mnuFCopyAAdsF3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAdsF3ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAdsF3);
        this.mnuFCopyAAdsF123.setText("Protein: dsDNA + Translation Frame 1+2+3");
        this.mnuFCopyAAdsF123.setToolTipText("Copy this feature's double stranded sequence and its 3 reading frame translations to the clipboard.");
        this.mnuFCopyAAdsF123.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFCopyAAdsF123ActionPerformed(evt);
            }
        });
        this.mnuFCopy.add(this.mnuFCopyAAdsF123);
        this.sepCopy6.setToolTipText("pLOT Feature Format");
        this.mnuFCopy.add(this.sepCopy6);
        this.mnuFPopup.add(this.mnuFCopy);
        this.sepDrawingOrder.setToolTipText("Feature Drawing Order");
        this.mnuFPopup.add(this.sepDrawingOrder);
        this.mnuMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/images24/toFront.png")));
        this.mnuMoveUp.setText("Move Up One");
        this.mnuMoveUp.setToolTipText("Move this feature up one in the drawing order.");
        this.mnuMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMoveUpActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuMoveUp);
        this.mnuMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/images24/toBack.png")));
        this.mnuMoveDown.setText("Move Down One");
        this.mnuMoveDown.setToolTipText("Move this feature down one in the drawing order.");
        this.mnuMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMoveDownActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuMoveDown);
        this.mnuMoveTop.setIcon(new ImageIcon(this.getClass().getResource("/images24/toTop.png")));
        this.mnuMoveTop.setText("Move to Top");
        this.mnuMoveTop.setToolTipText("Move this feature to the top of the drawing order.");
        this.mnuMoveTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMoveTopActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuMoveTop);
        this.mnuMoveBottom.setIcon(new ImageIcon(this.getClass().getResource("/images24/toBottom.png")));
        this.mnuMoveBottom.setText("Move to Bottom");
        this.mnuMoveBottom.setToolTipText("Move this feature to the bottom of the drawing order.");
        this.mnuMoveBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMoveBottomActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuMoveBottom);
        this.sepDisplayOptions.setToolTipText("Display Options");
        this.mnuFPopup.add(this.sepDisplayOptions);
        this.mnuLabelColor.setIcon(new ImageIcon(this.getClass().getResource("/images24/paint.png")));
        this.mnuLabelColor.setText("Change Label Color");
        this.mnuLabelColor.setToolTipText("Change the color used for this feature's label.");
        this.mnuLabelColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLabelColorActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuLabelColor);
        this.mnuGraphicColor.setIcon(new ImageIcon(this.getClass().getResource("/images24/paint.png")));
        this.mnuGraphicColor.setText("Change Graphic Color");
        this.mnuGraphicColor.setToolTipText("Change the fill color used for this feature's graphic.");
        this.mnuGraphicColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuGraphicColorActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuGraphicColor);
        this.mnuChangeGraphic.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.mnuChangeGraphic.setText("Change Feature Graphic");
        this.mnuChangeGraphic.setToolTipText("Select a new graphic style for this feature.");
        this.mnuToLine.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToLine.png")));
        this.mnuToLine.setText("to line");
        this.mnuToLine.setToolTipText("Change the graphic style for this feature to a line.");
        this.mnuToLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToLineActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToLine);
        this.mnuToBox.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToBox.png")));
        this.mnuToBox.setText("to box");
        this.mnuToBox.setToolTipText("Change the graphic style for this feature to a box.");
        this.mnuToBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToBoxActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToBox);
        this.mnuToArrow.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow.png")));
        this.mnuToArrow.setText("to box arrow");
        this.mnuToArrow.setToolTipText("Change the graphic style for this feature to a box arrow.");
        this.mnuToArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToArrowActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToArrow);
        this.mnuToHeadlessArrow.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToHeadlessArrow.png")));
        this.mnuToHeadlessArrow.setText("to headless arrow");
        this.mnuToHeadlessArrow.setToolTipText("Change the graphic style for this feature to a headless arrow.");
        this.mnuToHeadlessArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToHeadlessArrowActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToHeadlessArrow);
        this.mnuToLineArrow.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToLineArrow.png")));
        this.mnuToLineArrow.setText("to line arrow");
        this.mnuToLineArrow.setToolTipText("Change the graphic style for this feature to a line arrow.");
        this.mnuToLineArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToLineArrowActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToLineArrow);
        this.mnuToTickMark.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToTickMark.png")));
        this.mnuToTickMark.setText("to tick mark");
        this.mnuToTickMark.setToolTipText("Change the graphic style for this feature to a tick mark.");
        this.mnuToTickMark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToTickMarkActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToTickMark);
        this.mnuToBrackets.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToBracketed.png")));
        this.mnuToBrackets.setText("to brackets");
        this.mnuToBrackets.setToolTipText("Change the graphic style for this feature to a brackets.");
        this.mnuToBrackets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToBracketsActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToBrackets);
        this.mnuToNoGraphic.setIcon(new ImageIcon(this.getClass().getResource("/images24/RedX.png")));
        this.mnuToNoGraphic.setText("to no graphic");
        this.mnuToNoGraphic.setToolTipText("Change the graphic style for this feature to no graphic.  The feature won't be displayed on the map but won't be deleted from the project.");
        this.mnuToNoGraphic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToNoGraphicActionPerformed(evt);
            }
        });
        this.mnuChangeGraphic.add(this.mnuToNoGraphic);
        this.mnuFPopup.add(this.mnuChangeGraphic);
        this.mnuSetFeatureCodonTable.setBackground(new Color(255, 255, 255));
        this.mnuSetFeatureCodonTable.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToDNA.png")));
        this.mnuSetFeatureCodonTable.setText("Set Feature Codon Table");
        this.mnuSetFeatureCodonTable.setToolTipText("Sets the codon table used to translate this feature.");
        this.mnuSetFeatureCodonTable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.mnuSetFeatureCodonTableStateChanged(evt);
            }
        });
        this.mnuFPopup.add(this.mnuSetFeatureCodonTable);
        this.sepCaseChange.setToolTipText("Sequence Case Change Options");
        this.mnuFPopup.add(this.sepCaseChange);
        this.mnuUpperCase.setAccelerator(KeyStroke.getKeyStroke(85, 0));
        this.mnuUpperCase.setText("Uppercase Sequence");
        this.mnuUpperCase.setToolTipText("Convert this feature's sequence to uppercase.");
        this.mnuUpperCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuUpperCaseActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuUpperCase);
        this.mnuLowerCase.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        this.mnuLowerCase.setText("Lowercase Sequence");
        this.mnuLowerCase.setToolTipText("Convert this feature's sequence to lowercase.");
        this.mnuLowerCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLowerCaseActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuLowerCase);
        this.jSeparator43.setToolTipText("Remove");
        this.mnuFPopup.add(this.jSeparator43);
        this.mnuRemFeature.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        this.mnuRemFeature.setIcon(new ImageIcon(this.getClass().getResource("/images24/X.png")));
        this.mnuRemFeature.setText("Remove Feature");
        this.mnuRemFeature.setToolTipText("Remove this feature annotation.");
        this.mnuRemFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRemFeatureActionPerformed(evt);
            }
        });
        this.mnuFPopup.add(this.mnuRemFeature);
        this.jSeparator46.setToolTipText("Label Display Options");
        this.mnuFPopup.add(this.jSeparator46);
        this.sepPHeader.setToolTipText("Primer Options");
        this.mnuPPopup.add(this.sepPHeader);
        this.mnuPrimerToFeature.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.mnuPrimerToFeature.setBackground(new Color(255, 255, 255));
        this.mnuPrimerToFeature.setIcon(new ImageIcon(this.getClass().getResource("/images24/Primers.png")));
        this.mnuPrimerToFeature.setText("Convert to a feature");
        this.mnuPrimerToFeature.setToolTipText("Converts the primer to a feature in the project.");
        this.mnuPrimerToFeature.setBorder(null);
        this.mnuPrimerToFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuPrimerToFeatureActionPerformed(evt);
            }
        });
        this.mnuPPopup.add(this.mnuPrimerToFeature);
        this.mnuRemovePrimer.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.mnuRemovePrimer.setBackground(new Color(255, 255, 255));
        this.mnuRemovePrimer.setIcon(new ImageIcon(this.getClass().getResource("/images24/Primers.png")));
        this.mnuRemovePrimer.setText("Remove primer from library");
        this.mnuRemovePrimer.setToolTipText("Remove the primer from user primer library.");
        this.mnuRemovePrimer.setBorder(null);
        this.mnuRemovePrimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRemovePrimerActionPerformed(evt);
            }
        });
        this.mnuPPopup.add(this.mnuRemovePrimer);
        this.sepPFooter.setToolTipText("Primer Options");
        this.mnuPPopup.add(this.sepPFooter);
        this.sepREHeader.setToolTipText("Enzyme Options");
        this.mnuREPopup.add(this.sepREHeader);
        this.mnuAddRE.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        this.mnuAddRE.setIcon(new ImageIcon(this.getClass().getResource("/images24/PLUS_1.png")));
        this.mnuAddRE.setMnemonic('A');
        this.mnuAddRE.setText("Uppercase Sequence");
        this.mnuAddRE.setToolTipText("Convert this feature's sequence to uppercase.");
        this.mnuAddRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAddREActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuAddRE);
        this.mnuAddAsMix.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        this.mnuAddAsMix.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus_Blue.png")));
        this.mnuAddAsMix.setText("Add as Enzyme Mix");
        this.mnuAddAsMix.setToolTipText("Adds the selected enzymes as a mix.");
        this.mnuAddAsMix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAddAsMixActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuAddAsMix);
        this.mnuRemoveRE.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.mnuRemoveRE.setMnemonic('R');
        this.mnuRemoveRE.setText("Uppercase Sequence");
        this.mnuRemoveRE.setToolTipText("Convert this feature's sequence to uppercase.");
        this.mnuRemoveRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRemoveREActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuRemoveRE);
        this.mnuCopyRE.setAccelerator(KeyStroke.getKeyStroke(67, 0));
        this.mnuCopyRE.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuCopyRE.setText("Copy sequence and annotations");
        this.mnuCopyRE.setToolTipText("Copy sequence and annotations to the clipboard.");
        this.mnuCopyRE.setActionCommand("Copy sequence");
        this.mnuCopyRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCopyREActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuCopyRE);
        this.sepCaseChangeRE.setToolTipText("Sequence Case Change Options");
        this.mnuREPopup.add(this.sepCaseChangeRE);
        this.mnuUpperCaseRE.setAccelerator(KeyStroke.getKeyStroke(85, 0));
        this.mnuUpperCaseRE.setText("Uppercase Sequence");
        this.mnuUpperCaseRE.setToolTipText("Convert this feature's sequence to uppercase.");
        this.mnuUpperCaseRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuUpperCaseREActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuUpperCaseRE);
        this.mnuLowerCaseRE.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        this.mnuLowerCaseRE.setText("Lowercase Sequence");
        this.mnuLowerCaseRE.setToolTipText("Convert this feature's sequence to lowercase.");
        this.mnuLowerCaseRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLowerCaseREActionPerformed(evt);
            }
        });
        this.mnuREPopup.add(this.mnuLowerCaseRE);
        this.sepREFooter.setToolTipText("Enzyme Options");
        this.mnuREPopup.add(this.sepREFooter);
        this.jMenuItem13.setText("jMenuItem13");
        this.zoomButtonGroup.add(this.mnuZoom050);
        this.mnuZoom050.setText("50%");
        this.mnuZoom050.setToolTipText("Set magnification to 50%");
        this.mnuZoom050.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom050ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom050);
        this.zoomButtonGroup.add(this.mnuZoom075);
        this.mnuZoom075.setText("75%");
        this.mnuZoom075.setToolTipText("Set magnification to 75%");
        this.mnuZoom075.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom075ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom075);
        this.zoomButtonGroup.add(this.mnuZoom090);
        this.mnuZoom090.setText("90%");
        this.mnuZoom090.setToolTipText("Set magnification to 90%");
        this.mnuZoom090.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom090ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom090);
        this.zoomButtonGroup.add(this.mnuZoom100);
        this.mnuZoom100.setSelected(true);
        this.mnuZoom100.setText("100%");
        this.mnuZoom100.setToolTipText("Set magnification to 100%");
        this.mnuZoom100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom100ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom100);
        this.zoomButtonGroup.add(this.mnuZoom110);
        this.mnuZoom110.setText("110%");
        this.mnuZoom110.setToolTipText("Set magnification to 110%");
        this.mnuZoom110.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom110ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom110);
        this.zoomButtonGroup.add(this.mnuZoom125);
        this.mnuZoom125.setText("125%");
        this.mnuZoom125.setToolTipText("Set magnification to 125%");
        this.mnuZoom125.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom125ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom125);
        this.zoomButtonGroup.add(this.mnuZoom150);
        this.mnuZoom150.setText("150%");
        this.mnuZoom150.setToolTipText("Set magnification to 150%");
        this.mnuZoom150.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom150ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom150);
        this.zoomButtonGroup.add(this.mnuZoom200);
        this.mnuZoom200.setText("200%");
        this.mnuZoom200.setToolTipText("Set magnification to 200%");
        this.mnuZoom200.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom200ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom200);
        this.zoomButtonGroup.add(this.mnuZoom300);
        this.mnuZoom300.setText("300%");
        this.mnuZoom300.setToolTipText("Set magnification to 300%");
        this.mnuZoom300.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom300ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom300);
        this.zoomButtonGroup.add(this.mnuZoom400);
        this.mnuZoom400.setText("400%");
        this.mnuZoom400.setToolTipText("Set magnification to 400%");
        this.mnuZoom400.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuZoom400ActionPerformed(evt);
            }
        });
        this.mnuZoomPopup.add(this.mnuZoom400);
        this.sepSplitWindow.setToolTipText("Split-Window Options");
        this.mnuPopupDockFeatures.add(this.sepSplitWindow);
        this.mnuUndockFeatures.setIcon(new ImageIcon(this.getClass().getResource("/images24/Dock.png")));
        this.mnuUndockFeatures.setText("Undock Feature Window");
        this.mnuUndockFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuUndockFeaturesActionPerformed(evt);
            }
        });
        this.mnuPopupDockFeatures.add(this.mnuUndockFeatures);
        this.mnuDockFeatures.setIcon(new ImageIcon(this.getClass().getResource("/images24/Dock.png")));
        this.mnuDockFeatures.setText("Dock Feature Window");
        this.mnuDockFeatures.setToolTipText("Return the Feature Viewer window to the main window.");
        this.mnuDockFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDockFeaturesActionPerformed(evt);
            }
        });
        this.mnuPopupDockFeatures.add(this.mnuDockFeatures);
        this.mnuHideFeatures.setIcon(new ImageIcon(this.getClass().getResource("/images24/Window.png")));
        this.mnuHideFeatures.setText("Hide Window");
        this.mnuHideFeatures.setToolTipText("Hide the Feature Viewer window.");
        this.mnuPopupDockFeatures.add(this.mnuHideFeatures);
        this.mnuDebug.setText("Debug/To Do Menu");
        this.mnuDebug.add(this.sepPref2);
        this.mnuSetFeaturesLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.mnuSetFeaturesLib.setText("Set Features Library File");
        this.mnuSetFeaturesLib.setToolTipText("Set the location of the user features library.");
        this.mnuSetFeaturesLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSetFeaturesLibActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuSetFeaturesLib);
        this.mnuSetPrimersLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Primers.png")));
        this.mnuSetPrimersLib.setText("Set Primers Library File");
        this.mnuSetPrimersLib.setToolTipText("Set the location of the user primers library.");
        this.mnuDebug.add(this.mnuSetPrimersLib);
        this.mnuSetLaddersLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Gel.png")));
        this.mnuSetLaddersLib.setText("Set Ladders Library File");
        this.mnuSetLaddersLib.setToolTipText("Set the location of the user gel ladder library.");
        this.mnuDebug.add(this.mnuSetLaddersLib);
        this.mnuCloneWindow.setAccelerator(KeyStroke.getKeyStroke(61, 192));
        this.mnuCloneWindow.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.mnuCloneWindow.setText("Clone to a new Window");
        this.mnuCloneWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCloneWindowActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuCloneWindow);
        this.mnuSepExportMap.setToolTipText("Export Map");
        this.mnuDebug.add(this.mnuSepExportMap);
        this.mnuExportMap.setIcon(new ImageIcon(this.getClass().getResource("/images24/Export.png")));
        this.mnuExportMap.setText("Export Map as Image");
        this.mnuExportMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuExportMapActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuExportMap);
        this.jSeparator45.setToolTipText("Misc.");
        this.mnuDebug.add(this.jSeparator45);
        this.mnuMisc.setText("Reset library paths");
        this.mnuMisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMiscActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuMisc);
        this.jSeparator21.setToolTipText("Labels Options");
        this.mnuDebug.add(this.jSeparator21);
        this.mnuLabelsCircle.setIcon(new ImageIcon(this.getClass().getResource("/images24/LabelsCirc.png")));
        this.mnuLabelsCircle.setText("Circular labels on circular maps");
        this.mnuLabelsCircle.setToolTipText("Toggle map view between linear and circular mode.");
        this.mnuLabelsCircle.setEnabled(false);
        this.mnuLabelsCircle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLabelsCircleActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuLabelsCircle);
        this.mnuLabelsLinear.setIcon(new ImageIcon(this.getClass().getResource("/images24/LabelsLin.png")));
        this.mnuLabelsLinear.setText("Linear labels on circular maps");
        this.mnuLabelsLinear.setToolTipText("Toggle map view between linear and circular mode.");
        this.mnuLabelsLinear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLabelsLinearActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuLabelsLinear);
        this.mnuAddChromat.setIcon(new ImageIcon(this.getClass().getResource("/images24/Chromat_Icon.png")));
        this.mnuAddChromat.setText("Add Chromatograms");
        this.mnuAddChromat.setToolTipText("Add an .ab1 file to this project.");
        this.mnuAddChromat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAddChromatActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuAddChromat);
        this.mnuFontTest.setIcon(new ImageIcon(this.getClass().getResource("/images24/Font.png")));
        this.mnuFontTest.setText("Font Test");
        this.mnuFontTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFontTestActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuFontTest);
        this.jSeparator17.setToolTipText("Import Chromatograms");
        this.mnuDebug.add(this.jSeparator17);
        this.mnuCheckForUpdates.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.mnuCheckForUpdates.setText("Check for Available Updates");
        this.mnuCheckForUpdates.setToolTipText("Check online for available updates.");
        this.mnuCheckForUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCheckForUpdatesActionPerformed(evt);
            }
        });
        this.mnuDebug.add(this.mnuCheckForUpdates);
        this.sepUpdates.setToolTipText("About Current Version");
        this.mnuDebug.add(this.sepUpdates);
        this.setDefaultCloseOperation(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PLOTJ.this.formMouseExited(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                PLOTJ.this.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                PLOTJ.this.formWindowActivated(evt);
            }
        });
        this.mainToolBar.setBorder(null);
        this.mainToolBar.setRollover(true);
        this.cmdNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.cmdNew.setToolTipText("Start a new project.");
        this.cmdNew.setContentAreaFilled(false);
        this.cmdNew.setFocusable(false);
        this.cmdNew.setHorizontalTextPosition(0);
        this.cmdNew.setVerticalTextPosition(3);
        this.cmdNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdNewActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdNew);
        this.cmdOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open_dd.png")));
        this.cmdOpen.setToolTipText("Open an existing project");
        this.cmdOpen.setContentAreaFilled(false);
        this.cmdOpen.setFocusable(false);
        this.cmdOpen.setHorizontalTextPosition(0);
        this.cmdOpen.setVerticalTextPosition(3);
        this.cmdOpen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.cmdOpenMouseClicked(evt);
            }
        });
        this.cmdOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdOpenActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdOpen);
        this.cmdSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.cmdSave.setToolTipText("Save the current project.");
        this.cmdSave.setContentAreaFilled(false);
        this.cmdSave.setFocusable(false);
        this.cmdSave.setHorizontalTextPosition(0);
        this.cmdSave.setVerticalTextPosition(3);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdSaveActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdSave);
        this.mainToolBar.add(this.jSeparator1);
        this.cmdCircular.setIcon(new ImageIcon(this.getClass().getResource("/images24/Circle.png")));
        this.cmdCircular.setToolTipText("Toggle map view between linear and circular mode.");
        this.cmdCircular.setFocusable(false);
        this.cmdCircular.setHorizontalTextPosition(0);
        this.cmdCircular.setPressedIcon(new ImageIcon(this.getClass().getResource("/images24/Linear.png")));
        this.cmdCircular.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/Linear.png")));
        this.cmdCircular.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/Linear.png")));
        this.cmdCircular.setVerticalTextPosition(3);
        this.cmdCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdCircularActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdCircular);
        this.mainToolBar.add(this.jSeparator2);
        this.cmdShowLabels.setIcon(new ImageIcon(this.getClass().getResource("/images24/Label.png")));
        this.cmdShowLabels.setSelected(true);
        this.cmdShowLabels.setToolTipText("Toggle show/hide feature labels.");
        this.cmdShowLabels.setFocusable(false);
        this.cmdShowLabels.setHorizontalTextPosition(0);
        this.cmdShowLabels.setRolloverIcon(new ImageIcon(this.getClass().getResource("/images24/Label.png")));
        this.cmdShowLabels.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/Label.png")));
        this.cmdShowLabels.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/Label.png")));
        this.cmdShowLabels.setVerticalTextPosition(3);
        this.cmdShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdShowLabelsActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdShowLabels);
        this.cmdShowRE.setIcon(new ImageIcon(this.getClass().getResource("/images24/RE.png")));
        this.cmdShowRE.setToolTipText("Toggle show/hide restriction enzyme labels.");
        this.cmdShowRE.setFocusable(false);
        this.cmdShowRE.setHorizontalTextPosition(0);
        this.cmdShowRE.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/RE.png")));
        this.cmdShowRE.setVerticalTextPosition(3);
        this.cmdShowRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdShowREActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdShowRE);
        this.cmdShowPrimers.setIcon(new ImageIcon(this.getClass().getResource("/images24/primers_dd.png")));
        this.cmdShowPrimers.setHorizontalTextPosition(0);
        this.cmdShowPrimers.setVerticalTextPosition(3);
        this.cmdShowPrimers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.cmdShowPrimersMouseClicked(evt);
            }
        });
        this.cmdShowPrimers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdShowPrimersActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdShowPrimers);
        this.mainToolBar.add(this.jSeparator3);
        this.cmdChromat.setIcon(new ImageIcon(this.getClass().getResource("/images24/Chromat_Icon.png")));
        this.cmdChromat.setToolTipText("Show chromatogram trace if available.");
        this.cmdChromat.setContentAreaFilled(false);
        this.cmdChromat.setEnabled(false);
        this.cmdChromat.setFocusable(false);
        this.cmdChromat.setHorizontalTextPosition(0);
        this.cmdChromat.setVerticalTextPosition(3);
        this.mainToolBar.add(this.cmdChromat);
        this.mainToolBar.add(this.jSeparator4);
        this.cmdToggleOverlay.setIcon(new ImageIcon(this.getClass().getResource("/images24/overlay.png")));
        this.cmdToggleOverlay.setToolTipText("Toggle bright / dimmed map and gel.");
        this.cmdToggleOverlay.setFocusable(false);
        this.cmdToggleOverlay.setHorizontalTextPosition(0);
        this.cmdToggleOverlay.setVerticalTextPosition(3);
        this.cmdToggleOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdToggleOverlayActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdToggleOverlay);
        this.mainToolBar.add(this.jSeparator53);
        this.cmdZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/images24/Zoom_In.png")));
        this.cmdZoomIn.setToolTipText("Increase the map magnification.");
        this.cmdZoomIn.setContentAreaFilled(false);
        this.cmdZoomIn.setFocusable(false);
        this.cmdZoomIn.setHorizontalTextPosition(0);
        this.cmdZoomIn.setVerticalTextPosition(3);
        this.cmdZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdZoomInActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdZoomIn);
        this.cmdZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/images24/Zoom_Out.png")));
        this.cmdZoomOut.setToolTipText("Decrease the map magnification.");
        this.cmdZoomOut.setContentAreaFilled(false);
        this.cmdZoomOut.setFocusable(false);
        this.cmdZoomOut.setHorizontalTextPosition(0);
        this.cmdZoomOut.setVerticalTextPosition(3);
        this.cmdZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdZoomOutActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdZoomOut);
        this.mainToolBar.add(this.jSeparator5);
        this.cmdZoom100.setArrowColor(new Color(255, 255, 255));
        this.cmdZoom100.setArrowHeight(4);
        this.cmdZoom100.setArrowInset(4);
        this.cmdZoom100.setArrowLineColor(new Color(0, 0, 0));
        this.cmdZoom100.setArrowWidth(4);
        this.cmdZoom100.setDelay(10);
        this.cmdZoom100.setIcon(new ImageIcon(this.getClass().getResource("/images24/Zoom_100.png")));
        this.cmdZoom100.setMenuPopUpLocation(Constants.PopupLocation.BELOW_LEFT);
        this.cmdZoom100.setMouseButtonMenuTrigger(3);
        this.cmdZoom100.setShowArrow(true);
        this.cmdZoom100.setToolTipText("Set the map magnification to default.  Long press for menu of standard magnifications.");
        this.cmdZoom100.setContentAreaFilled(false);
        this.cmdZoom100.setFocusable(false);
        this.cmdZoom100.setHorizontalTextPosition(0);
        this.cmdZoom100.setVerticalTextPosition(3);
        this.cmdZoom100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdZoom100ActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdZoom100);
        this.mainToolBar.add(this.jSeparator6);
        this.cmdUndo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Undo.png")));
        this.cmdUndo.setToolTipText("Undo last change.");
        this.cmdUndo.setContentAreaFilled(false);
        this.cmdUndo.setEnabled(false);
        this.cmdUndo.setFocusable(false);
        this.cmdUndo.setHorizontalTextPosition(0);
        this.cmdUndo.setVerticalTextPosition(3);
        this.cmdUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdUndoActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdUndo);
        this.cmdRedo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Redo.png")));
        this.cmdRedo.setToolTipText("Redo last undone change.");
        this.cmdRedo.setContentAreaFilled(false);
        this.cmdRedo.setEnabled(false);
        this.cmdRedo.setFocusable(false);
        this.cmdRedo.setHorizontalTextPosition(0);
        this.cmdRedo.setVerticalTextPosition(3);
        this.cmdRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdRedoActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdRedo);
        this.mainToolBar.add(this.sepPluginTools);
        this.hSplitPane.setDividerLocation(270);
        this.vSplitPane.setDividerLocation(450);
        this.vSplitPane.setOrientation(0);
        this.vSplitPane.setResizeWeight(1.0);
        this.picMap.setHandleFocusGained(true);
        this.picMap.setHandleMouseMotion(true);
        this.picMap.setScrollBars(-1);
        this.picMap.setScrollbarThumbColorOut(new Color(102, 102, 255));
        this.picMap.setScrollbarThumbColorPressed(new Color(102, 102, 255));
        this.picMap.setScrollbarThumbColorRollOver(new Color(102, 102, 255));
        this.picMap.setScrollbarTrackBorderColor(new Color(0, 0, 0));
        this.picMap.setScrollbarTrackColor(new Color(204, 204, 255));
        this.picMap.setScrollbarTrackColorPressed(new Color(204, 204, 255));
        this.picMap.setScrollbarTrackColorRollover(new Color(204, 204, 255));
        this.picMap.setFont(new Font("Monospaced", 0, 14));
        this.vSplitPane.setLeftComponent(this.picMap);
        this.dockFeatures.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToolWindow.png")));
        this.dockFeatures.setTitle("Feature Viewer (Ctrl + X)");
        this.dockFeatures.setToolTipText("Current selection sequence viewer.  Press Ctrl+X, double click the title bar or use the buttons to dock/undock from the main window.");
        this.editor.setAutoColumnCount(true);
        this.editor.setEditable(false);
        this.editor.setHandleFocusGained(true);
        this.editor.setHandleFocusLost(true);
        this.editor.setHideCursorOnFocusOut(true);
        this.editor.setHorizontalIconAlignment(SequenceEditorPanel.HorizontalAlignment.TILED);
        this.editor.setIcon(new ImageIcon(this.getClass().getResource("/TextBoxBackgrounds/DNATiled.png")));
        this.editor.setScrollBars(1);
        this.editor.setScrollbarThumbColorOut(new Color(153, 153, 255));
        this.editor.setScrollbarThumbColorPressed(new Color(143, 143, 245));
        this.editor.setScrollbarThumbColorRollOver(new Color(143, 143, 245));
        this.editor.setScrollbarTrackBorderColor(new Color(0, 0, 0));
        this.editor.setScrollbarTrackColor(new Color(204, 204, 255));
        this.editor.setScrollbarTrackColorPressed(new Color(165, 169, 200));
        this.editor.setScrollbarTrackColorRollover(new Color(165, 169, 200));
        this.editor.setShowAntisense(true);
        this.editor.setShowNumbers(true);
        GroupLayout dockFeaturesLayout = new GroupLayout(this.dockFeatures.getContentPane());
        this.dockFeatures.getContentPane().setLayout(dockFeaturesLayout);
        dockFeaturesLayout.setHorizontalGroup(dockFeaturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockFeaturesLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.editor, -1, 625, Short.MAX_VALUE).addGap(0, 0, 0)));
        dockFeaturesLayout.setVerticalGroup(dockFeaturesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockFeaturesLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.editor, -1, 89, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.vSplitPane.setRightComponent(this.dockFeatures);
        this.hSplitPane.setRightComponent(this.vSplitPane);
        this.dockTools.setIcon(new ImageIcon(this.getClass().getResource("/images24/Tools.png")));
        this.dockTools.setTitle("Tools (Ctrl + T)");
        this.dockTools.setToolTipText("Properties tools.  Press Ctrl+T, double click the title bar or use the buttons to dock/undock from the main window.");
        this.scrollPaneTools.setBorder(null);
        this.scrollPaneTools.setViewportBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.taskPaneContainer.setMaximumSize(null);
        this.taskPaneContainer.setScrollableHeightHint(ScrollableSizeHint.VERTICAL_STRETCH);
        this.taskPaneContainer.setScrollableWidthHint(ScrollableSizeHint.FIT);
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setGap(14);
        this.taskPaneContainer.setLayout(verticalLayout1);
        this.toolsPlasmid.setToolTipText("Main project options.");
        this.toolsPlasmid.setFocusable(false);
        this.toolsPlasmid.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.toolsPlasmid.setSpecial(true);
        this.toolsPlasmid.setTitle("Plasmid Options");
        this.taskPaneContainer.add(this.toolsPlasmid);
        this.toolsFeatures.setToolTipText("Selected feature project properties.");
        this.toolsFeatures.setFocusable(false);
        this.toolsFeatures.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.toolsFeatures.setScrollOnExpand(true);
        this.toolsFeatures.setSpecial(true);
        this.toolsFeatures.setTitle("Feature Options");
        this.taskPaneContainer.add(this.toolsFeatures);
        this.panelPlasmidTools.setOpaque(false);
        this.jLabel1.setText("Sequence Name");
        this.chkCircular.setBackground(new Color(214, 223, 247));
        this.chkCircular.setSelected(true);
        this.chkCircular.setText("Circular");
        this.chkCircular.setToolTipText("Toggle map view between linear and circular mode.");
        this.chkCircular.setContentAreaFilled(false);
        this.chkCircular.setFocusPainted(false);
        this.chkCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.chkCircularActionPerformed(evt);
            }
        });
        this.txtPlasmidName.setBlankText("Sequence Name");
        this.txtPlasmidName.setSelectionOnFocus(true);
        this.txtPlasmidName.setToolTipText("Name of the sequence.");
        this.txtPlasmidName.setBackcolor(Color.white);
        this.txtPlasmidName.setDeselectOnFocus(true);
        this.txtPlasmidName.setMargin(new Insets(5, 5, 1, 1));
        this.jLabel2.setText("Source");
        this.txtSource.setBlankText("Source");
        this.txtSource.setSelectionOnFocus(true);
        this.txtSource.setToolTipText("Genbank file SOURCE data.");
        this.txtSource.setBackcolor(Color.white);
        this.txtSource.setDeselectOnFocus(true);
        this.txtSource.setMargin(new Insets(5, 5, 1, 1));
        this.jLabel3.setText("Organism");
        this.txtOrg.setBlankText("Organism");
        this.txtOrg.setSelectionOnFocus(true);
        this.txtOrg.setToolTipText("Genbank file ORGANISM data.");
        this.txtOrg.setBackcolor(Color.white);
        this.txtOrg.setDeselectOnFocus(true);
        this.txtOrg.setMargin(new Insets(5, 5, 1, 1));
        this.lblEditNotes.setFont(this.lblEditNotes.getFont());
        this.lblEditNotes.setForeground(new Color(51, 51, 255));
        this.lblEditNotes.setText("Edit Project Notes");
        this.lblEditNotes.setToolTipText("Click to open project notes editor.");
        this.lblEditNotes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.lblEditNotesMouseClicked(evt);
            }
        });
        this.lblEditAnnotations.setFont(this.lblEditAnnotations.getFont());
        this.lblEditAnnotations.setForeground(new Color(51, 51, 255));
        this.lblEditAnnotations.setText("Edit Annotations");
        this.lblEditAnnotations.setToolTipText("Click to open project annotations/features editor.");
        this.lblEditAnnotations.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.lblEditAnnotationsMouseClicked(evt);
            }
        });
        this.lblEditReferences.setFont(this.lblEditReferences.getFont());
        this.lblEditReferences.setForeground(new Color(51, 51, 255));
        this.lblEditReferences.setText("Edit References");
        this.lblEditReferences.setToolTipText("Click to open project references editor.");
        this.lblEditReferences.setEnabled(false);
        this.lblEditReferences.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.lblEditReferencesMouseClicked(evt);
            }
        });
        GroupLayout panelPlasmidToolsLayout = new GroupLayout(this.panelPlasmidTools);
        this.panelPlasmidTools.setLayout(panelPlasmidToolsLayout);
        panelPlasmidToolsLayout.setHorizontalGroup(panelPlasmidToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPlasmidToolsLayout.createSequentialGroup().addContainerGap().addGroup(panelPlasmidToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPlasmidToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtPlasmidName, -1, 182, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 72, -2).addComponent(this.jLabel3).addGroup(panelPlasmidToolsLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.chkCircular, -1, -1, Short.MAX_VALUE)).addComponent(this.txtSource, -1, -1, Short.MAX_VALUE).addComponent(this.txtOrg, -1, -1, Short.MAX_VALUE)).addComponent(this.lblEditNotes).addComponent(this.lblEditAnnotations).addComponent(this.lblEditReferences)).addContainerGap(48, Short.MAX_VALUE)));
        panelPlasmidToolsLayout.setVerticalGroup(panelPlasmidToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPlasmidToolsLayout.createSequentialGroup().addContainerGap().addGroup(panelPlasmidToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.chkCircular)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPlasmidName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSource, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtOrg, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblEditNotes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEditAnnotations).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEditReferences).addContainerGap()));
        this.taskPaneContainer.add(this.panelPlasmidTools);
        this.panelFeatureTools.setOpaque(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graphic Options"));
        this.jPanel1.setOpaque(false);
        this.lblColorGraphic.setText("Color");
        this.lblColorGraphic.setToolTipText("Click to select the current feature's graphic color.");
        this.lblColorGraphic.setColor(Color.cyan);
        this.lblColorGraphic.setHorizontalTextPosition(2);
        this.lblColorGraphic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.lblColorGraphicMouseClicked(evt);
            }
        });
        this.toggleLink.setIcon(new ImageIcon(this.getClass().getResource("/images16/Unlink.png")));
        this.toggleLink.setToolTipText("Toggle linking the feature's graphic and label colors.");
        this.toggleLink.setBorder(BorderFactory.createLineBorder(Globals.buttonBorderColor));
        this.toggleLink.setFocusPainted(false);
        this.toggleLink.setOpaque(true);
        this.toggleLink.setPressedIcon(new ImageIcon(this.getClass().getResource("/images16/Link.png")));
        this.toggleLink.setRolloverIcon(new ImageIcon(this.getClass().getResource("/images16/Unlink.png")));
        this.toggleLink.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/images16/Link.png")));
        this.toggleLink.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images16/Link.png")));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Style");
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Alpha");
        this.sldAlpha.setBackground(new Color(214, 223, 247));
        this.sldAlpha.setMaximum(255);
        this.sldAlpha.setToolTipText("The transparency of the current feature's graphic color.");
        this.sldAlpha.setValue(255);
        this.sldAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.sldAlphaStateChanged(evt);
            }
        });
        this.sldAlpha.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PLOTJ.this.sldAlphaMouseDragged(evt);
            }
        });
        this.sldAlpha.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                PLOTJ.this.sldAlphaMouseWheelMoved(evt);
            }
        });
        this.sldAlpha.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PLOTJ.this.sldAlphaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PLOTJ.this.sldAlphaMouseReleased(evt);
            }
        });
        this.spinAlpha.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinAlpha.setToolTipText("The transparency of the current feature's graphic color.");
        this.spinAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.spinAlphaStateChanged(evt);
            }
        });
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Offset");
        this.sldRadius.setBackground(new Color(214, 223, 247));
        this.sldRadius.setMaximum(150);
        this.sldRadius.setMinimum(50);
        this.sldRadius.setToolTipText("The realtive distance of the current feature's graphic from the DNA line.");
        this.sldRadius.setValue(100);
        this.sldRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.sldRadiusStateChanged(evt);
            }
        });
        this.sldRadius.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PLOTJ.this.sldRadiusMouseDragged(evt);
            }
        });
        this.sldRadius.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                PLOTJ.this.sldRadiusMouseWheelMoved(evt);
            }
        });
        this.sldRadius.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PLOTJ.this.sldRadiusMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PLOTJ.this.sldRadiusMouseReleased(evt);
            }
        });
        this.spinRadius.setModel(new SpinnerNumberModel(100, 50, 150, 1));
        this.spinRadius.setToolTipText("The realtive distance of the current feature's graphic from the DNA line.");
        this.spinRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.spinRadiusStateChanged(evt);
            }
        });
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("Width");
        this.sldWidth.setBackground(new Color(214, 223, 247));
        this.sldWidth.setMaximum(255);
        this.sldWidth.setMinimum(1);
        this.sldWidth.setToolTipText("The width of the current feature's graphic.");
        this.sldWidth.setValue(255);
        this.sldWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.sldWidthStateChanged(evt);
            }
        });
        this.sldWidth.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PLOTJ.this.sldWidthMouseDragged(evt);
            }
        });
        this.sldWidth.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                PLOTJ.this.sldWidthMouseWheelMoved(evt);
            }
        });
        this.sldWidth.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PLOTJ.this.sldWidthMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PLOTJ.this.sldWidthMouseReleased(evt);
            }
        });
        this.spinWidth.setModel(new SpinnerNumberModel(1, 1, 255, 1));
        this.spinWidth.setToolTipText("The width of the current feature's graphic.");
        this.spinWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.spinWidthStateChanged(evt);
            }
        });
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Order");
        this.sldDrawingOrder.setBackground(new Color(214, 223, 247));
        this.sldDrawingOrder.setMaximum(255);
        this.sldDrawingOrder.setToolTipText("The position of the feature in the drawing order.  Later features are drawn over earlier features.");
        this.sldDrawingOrder.setValue(255);
        this.sldDrawingOrder.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.sldDrawingOrderStateChanged(evt);
            }
        });
        this.sldDrawingOrder.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PLOTJ.this.sldDrawingOrderMouseDragged(evt);
            }
        });
        this.sldDrawingOrder.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                PLOTJ.this.sldDrawingOrderMouseWheelMoved(evt);
            }
        });
        this.sldDrawingOrder.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PLOTJ.this.sldDrawingOrderMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PLOTJ.this.sldDrawingOrderMouseReleased(evt);
            }
        });
        this.chkDrawGraphic.setBackground(new Color(214, 223, 247));
        this.chkDrawGraphic.setText("Show");
        this.chkDrawGraphic.setToolTipText("Toggle show/hide the feature's graphic on the map.");
        this.chkDrawGraphic.setContentAreaFilled(false);
        this.chkDrawGraphic.setHorizontalTextPosition(4);
        this.cmbGraphic.setToolTipText("The current feature's graphic style to display on the map.");
        this.cmbGraphic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmbGraphicActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.chkDrawGraphic, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblColorGraphic, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleLink, -2, 23, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel13, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sldWidth, GroupLayout.Alignment.TRAILING, -2, 105, -2).addComponent(this.sldRadius, GroupLayout.Alignment.TRAILING, -2, 105, -2).addComponent(this.sldAlpha, -2, 105, -2).addComponent(this.sldDrawingOrder, -2, 105, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.spinAlpha).addComponent(this.spinRadius).addComponent(this.spinWidth))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbGraphic, 0, -1, Short.MAX_VALUE).addGap(24, 24, 24)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.cmbGraphic, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.chkDrawGraphic).addComponent(this.lblColorGraphic, -2, -1, -2).addComponent(this.toggleLink, -2, 23, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel10).addComponent(this.sldAlpha, -2, 16, -2).addComponent(this.spinAlpha, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel11).addComponent(this.sldRadius, -2, 16, -2).addComponent(this.spinRadius, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel12).addComponent(this.sldWidth, -2, 16, -2).addComponent(this.spinWidth, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel13).addComponent(this.sldDrawingOrder, -2, 16, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Label Options"));
        this.jPanel2.setOpaque(false);
        this.txtCaption.setBlankText("Label Caption");
        this.txtCaption.setToolTipText("The current feature's label caption displayed on the map.  If empty, the feature's name is displayed on the map instead.");
        this.txtCaption.setBackcolor(Color.white);
        this.txtCaption.setDeselectOnFocus(true);
        this.txtCaption.setMaximumSize(new Dimension(64, 24));
        this.txtCaption.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PLOTJ.this.txtCaptionFocusLost(evt);
            }
        });
        this.chkShowLabel.setBackground(new Color(214, 223, 247));
        this.chkShowLabel.setText("Show");
        this.chkShowLabel.setToolTipText("Toggle show/hide the feature's label on the map.");
        this.chkShowLabel.setContentAreaFilled(false);
        this.chkShowLabel.setHorizontalTextPosition(4);
        this.chkShowLabel.setPreferredSize(new Dimension(96, 20));
        this.lblColorLabel.setText("Color");
        this.lblColorLabel.setToolTipText("Click to select the current feature's label color.");
        this.lblColorLabel.setColor(Color.black);
        this.lblColorLabel.setHorizontalTextPosition(2);
        this.lblColorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PLOTJ.this.lblColorLabelMouseClicked(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtCaption, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.chkShowLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblColorLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.txtCaption, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkShowLabel, -2, -1, -2).addComponent(this.lblColorLabel, -2, -1, -2)).addGap(0, 9, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.jPanel3.setOpaque(false);
        this.jScrollPane4.setBorder(null);
        this.txtNotes.setBlankText("Feature Notes/Comment");
        this.txtNotes.setBorder(null);
        this.txtNotes.setColumns(20);
        this.txtNotes.setRows(5);
        this.txtNotes.setToolTipText("The current feature's comments or notes.");
        this.txtNotes.setBackcolor(Color.white);
        this.txtNotes.setDeselectOnFocus(true);
        this.txtNotes.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PLOTJ.this.txtNotesFocusLost(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.txtNotes);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane4).addGap(2, 2, 2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 133, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelFMainOptions.setBorder(BorderFactory.createTitledBorder("Main Options"));
        this.panelFMainOptions.setOpaque(false);
        this.lblFName.setText("Name");
        this.txtFName.setBlankText("Feature Name");
        this.txtFName.setSelectionOnFocus(true);
        this.txtFName.setToolTipText("The current feature's name.  This is what is displayed on the map unless the label caption is not empty.");
        this.txtFName.setBackcolor(Color.white);
        this.lblStart.setHorizontalAlignment(0);
        this.lblStart.setText("Start");
        this.txtStart.setBlankText("Start");
        this.txtStart.setHorizontalAlignment(0);
        this.txtStart.setSelectionOnFocus(true);
        this.txtStart.setToolTipText("The current feature's 5' mose base position.");
        this.txtStart.setBackcolor(Color.white);
        this.txtStart.setDeselectOnFocus(true);
        this.txtEnd.setBlankText("End");
        this.txtEnd.setHorizontalAlignment(0);
        this.txtEnd.setSelectionOnFocus(true);
        this.txtEnd.setToolTipText("The current feature's 3' mose base position.");
        this.txtEnd.setBackcolor(Color.white);
        this.txtEnd.setDeselectOnFocus(true);
        this.lblEnd.setHorizontalAlignment(0);
        this.lblEnd.setText("End");
        this.jLabel7.setText("Orientation");
        this.jLabel5.setText("Genbank Type");
        this.cmbGBType.setEditable(true);
        this.cmbGBType.setToolTipText("The current feature's genbank entry type");
        this.cmbGBType.setMinimumSize(new Dimension(100, 22));
        this.cmbGBType.setPreferredSize(new Dimension(100, 22));
        this.cmbGBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmbGBTypeActionPerformed(evt);
            }
        });
        this.cmbOrient.setToolTipText("Whether the current feature is on the sense or antisense strand relative to the sequence.");
        this.cmbOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmbOrientActionPerformed(evt);
            }
        });
        GroupLayout panelFMainOptionsLayout = new GroupLayout(this.panelFMainOptions);
        this.panelFMainOptions.setLayout(panelFMainOptionsLayout);
        panelFMainOptionsLayout.setHorizontalGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFMainOptionsLayout.createSequentialGroup().addContainerGap().addGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtFName, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addComponent(this.jLabel7).addGroup(panelFMainOptionsLayout.createSequentialGroup().addGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblFName, GroupLayout.Alignment.LEADING).addComponent(this.lblStart, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.txtStart, GroupLayout.Alignment.LEADING, -1, 91, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtEnd, -1, -1, Short.MAX_VALUE).addComponent(this.lblEnd, -2, 86, -2))).addComponent(this.cmbGBType, -2, 119, -2).addComponent(this.cmbOrient, -2, 119, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panelFMainOptionsLayout.setVerticalGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFMainOptionsLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblFName).addGap(1, 1, 1).addComponent(this.txtFName, -2, -1, -2).addGap(6, 6, 6).addGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStart).addComponent(this.lblEnd)).addGap(2, 2, 2).addGroup(panelFMainOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtStart, -2, -1, -2).addComponent(this.txtEnd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addGap(2, 2, 2).addComponent(this.cmbOrient, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(2, 2, 2).addComponent(this.cmbGBType, -2, -1, -2).addGap(0, 10, Short.MAX_VALUE)));
        GroupLayout panelFeatureToolsLayout = new GroupLayout(this.panelFeatureTools);
        this.panelFeatureTools.setLayout(panelFeatureToolsLayout);
        panelFeatureToolsLayout.setHorizontalGroup(panelFeatureToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFeatureToolsLayout.createSequentialGroup().addGroup(panelFeatureToolsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelFMainOptions, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        panelFeatureToolsLayout.setVerticalGroup(panelFeatureToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFeatureToolsLayout.createSequentialGroup().addComponent(this.panelFMainOptions, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.taskPaneContainer.add(this.panelFeatureTools);
        this.scrollPaneTools.setViewportView(this.taskPaneContainer);
        GroupLayout dockToolsLayout = new GroupLayout(this.dockTools.getContentPane());
        this.dockTools.getContentPane().setLayout(dockToolsLayout);
        dockToolsLayout.setHorizontalGroup(dockToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dockToolsLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPaneTools).addGap(0, 0, 0)));
        dockToolsLayout.setVerticalGroup(dockToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockToolsLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPaneTools, -1, 549, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.hSplitPane.setLeftComponent(this.dockTools);
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.mainMenuBar.setBackground(new Color(255, 255, 255));
        this.mainMenuBar.setBorder(null);
        this.mnuFile.setText("File");
        this.mnuFile.setToolTipText("Project load and save items");
        this.mnuFile.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuFileMenuSelected(evt);
            }
        });
        this.jSeparator7.setToolTipText("New Project /Open Existing Project");
        this.mnuFile.add(this.jSeparator7);
        this.mnuNew.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.mnuNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.mnuNew.setText("Start a New Project");
        this.mnuNew.setToolTipText("Start a new project.");
        this.mnuNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuNewActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuNew);
        this.mnuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.mnuOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.mnuOpen.setText("Open Existing Project");
        this.mnuOpen.setToolTipText("Open an existing project");
        this.mnuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuOpenActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuOpen);
        this.mnuNewWindow.setAccelerator(KeyStroke.getKeyStroke(61, 128));
        this.mnuNewWindow.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.mnuNewWindow.setText("Open a New Window");
        this.mnuNewWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuNewWindowActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuNewWindow);
        this.jSeparator8.setToolTipText("Download Sequence From Genbank");
        this.mnuFile.add(this.jSeparator8);
        this.mnuGetGB.setIcon(new ImageIcon(this.getClass().getResource("/images24/FOLDER_DL.png")));
        this.mnuGetGB.setText("Download Genbank Entry");
        this.mnuGetGB.setToolTipText("Download an entry from Genbank");
        this.mnuGetGB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuGetGBActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuGetGB);
        this.jSeparator12.setToolTipText("Save Current Project");
        this.mnuFile.add(this.jSeparator12);
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSave.setText("Save Project");
        this.mnuSave.setToolTipText("Save the current project.");
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuSave);
        this.mnuSaveAs.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSaveAs.setText("Save Project As...");
        this.mnuSaveAs.setToolTipText("Save the current project as...");
        this.mnuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSaveAsActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuSaveAs);
        this.jSeparator9.setToolTipText("Recently Opened Projects");
        this.mnuFile.add(this.jSeparator9);
        this.mnuRecent.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.mnuRecent.setText("Recent files");
        this.mnuRecent.setToolTipText("Open a recently opened project");
        this.mnuRecent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.mnuRecentStateChanged(evt);
            }
        });
        this.mnuFile.add(this.mnuRecent);
        this.jSeparator11.setToolTipText("Exit pLOT");
        this.mnuFile.add(this.jSeparator11);
        this.mnuExit.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.mnuExit.setText("Quit");
        this.mnuExit.setToolTipText("Exit pLOT");
        this.mnuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuExitActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuExit);
        this.jSeparator44.setToolTipText("New Project /Open Existing Project");
        this.mnuFile.add(this.jSeparator44);
        this.mainMenuBar.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.mnuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuEditMenuSelected(evt);
            }
        });
        this.jSeparator13.setToolTipText("Undo/Redo");
        this.mnuEdit.add(this.jSeparator13);
        this.mnuUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.mnuUndo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Undo.png")));
        this.mnuUndo.setText("Undo");
        this.mnuUndo.setToolTipText("Undo the last action performed.");
        this.mnuUndo.setEnabled(false);
        this.mnuUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuUndoActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuUndo);
        this.mnuRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.mnuRedo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Redo.png")));
        this.mnuRedo.setText("Redo");
        this.mnuRedo.setToolTipText("Redo the last undone action.");
        this.mnuRedo.setEnabled(false);
        this.mnuRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRedoActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuRedo);
        this.jSeparator14.setToolTipText("Copy/Paste");
        this.mnuEdit.add(this.jSeparator14);
        this.mnuCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.mnuCut.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuCut.setText("Cut");
        this.mnuCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCutActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCut);
        this.mnuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuCopy.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuCopy.setText("Copy");
        this.mnuCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCopyActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopy);
        this.mnuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.mnuPaste.setIcon(new ImageIcon(this.getClass().getResource("/images24/Paste.png")));
        this.mnuPaste.setText("Paste");
        this.mnuPaste.setToolTipText("Paste the clipboard contents as sequence at a nucliotide position.");
        this.mnuPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuPasteActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuPaste);
        this.jSeparator15.setToolTipText("Edit Sequence/Annotations");
        this.mnuEdit.add(this.jSeparator15);
        this.mnuEditAnnotations.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.mnuEditAnnotations.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.mnuEditAnnotations.setText("Edit Annotations");
        this.mnuEditAnnotations.setToolTipText("Open the Annotations editor.");
        this.mnuEditAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuEditAnnotationsActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuEditAnnotations);
        this.mnuEditSeq.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.mnuEditSeq.setIcon(new ImageIcon(this.getClass().getResource("/images24/Paste.png")));
        this.mnuEditSeq.setText("View/Edit Sequence");
        this.mnuEditSeq.setToolTipText("Open the View/Edit Sequence window.");
        this.mnuEditSeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuEditSeqActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuEditSeq);
        this.jSeparator16.setToolTipText("Feature Options");
        this.mnuEdit.add(this.jSeparator16);
        this.mnuNewFeature.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.mnuNewFeature.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.mnuNewFeature.setText("Create New Feature");
        this.mnuNewFeature.setToolTipText("Create a new feature annotation in this project.");
        this.mnuNewFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuNewFeatureActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuNewFeature);
        this.mnuDupFeature.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.mnuDupFeature.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy.png")));
        this.mnuDupFeature.setText("Duplicate Selected Feature");
        this.mnuDupFeature.setToolTipText("Duplicate the currently selected feature annotation.");
        this.mnuDupFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDupFeatureActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuDupFeature);
        this.cmdDelFeature.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.cmdDelFeature.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        this.cmdDelFeature.setText("Remove Selected Annotation(s)");
        this.cmdDelFeature.setToolTipText("Delete the currently selected feature annotation.");
        this.cmdDelFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdDelFeatureActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.cmdDelFeature);
        this.cmdDelSequence.setAccelerator(KeyStroke.getKeyStroke(127, 64));
        this.cmdDelSequence.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        this.cmdDelSequence.setText("Delete Selected Sequence");
        this.cmdDelSequence.setToolTipText("Delete the currently selected annotation and sequence.");
        this.cmdDelSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.cmdDelSequenceActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.cmdDelSequence);
        this.jSeparator18.setToolTipText("Rotate/Complement Sequence");
        this.mnuEdit.add(this.jSeparator18);
        this.mnuRotate.setIcon(new ImageIcon(this.getClass().getResource("/images24/Rotate.png")));
        this.mnuRotate.setText("Rotate DNA");
        this.mnuRotate.setToolTipText("Set a nucliotide position as the new origin for this sequence.");
        this.mnuRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRotateActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuRotate);
        this.mnuAntisenseSeq.setIcon(new ImageIcon(this.getClass().getResource("/images24/Reverse.png")));
        this.mnuAntisenseSeq.setText("Reverse Complement");
        this.mnuAntisenseSeq.setToolTipText("Reverse/Complement the entire sequence.");
        this.mnuAntisenseSeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAntisenseSeqActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuAntisenseSeq);
        this.mnuAntisenseRegion.setIcon(new ImageIcon(this.getClass().getResource("/images24/Reverse.png")));
        this.mnuAntisenseRegion.setText("Reverse & complement a Region");
        this.mnuAntisenseRegion.setToolTipText("Reverse & complement the a portion of this sequence.");
        this.mnuAntisenseRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAntisenseRegionActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuAntisenseRegion);
        this.jSeparator19.setToolTipText("Search");
        this.mnuEdit.add(this.jSeparator19);
        this.mnuFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.mnuFind.setIcon(new ImageIcon(this.getClass().getResource("/images24/Find2.png")));
        this.mnuFind.setText("Find a Sequence");
        this.mnuFind.setToolTipText("Open the Find Sequence window to search for DNA or amino acid sequences.");
        this.mnuFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuFindActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuFind);
        this.jSeparator51.setToolTipText("");
        this.mnuEdit.add(this.jSeparator51);
        this.mainMenuBar.add(this.mnuEdit);
        this.mnuView.setText("View");
        this.mnuView.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuViewMenuSelected(evt);
            }
        });
        this.jSeparator10.setToolTipText("Map Mode");
        this.mnuView.add(this.jSeparator10);
        this.mnuCircular.setIcon(new ImageIcon(this.getClass().getResource("/images24/Circle.png")));
        this.mnuCircular.setText("Toggle Linear/Circular");
        this.mnuCircular.setToolTipText("Toggle map view between linear and circular mode.");
        this.mnuCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCircularActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuCircular);
        this.jSeparator22.setToolTipText("View Features/Sequence");
        this.mnuView.add(this.jSeparator22);
        this.mnuViewFeaturesList.setText("View Features List");
        this.mnuViewFeaturesList.setToolTipText("View a text list of features and their coordinates in a new window.");
        this.mnuViewFeaturesList.setEnabled(false);
        this.mnuViewFeaturesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuViewFeaturesListActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuViewFeaturesList);
        this.jSeparator34.setToolTipText("Change Feature Viewer Format");
        this.mnuView.add(this.jSeparator34);
        this.chkToggleOverlay.setSelected(true);
        this.chkToggleOverlay.setText("Toggle Dimmer Maps");
        this.chkToggleOverlay.setIcon(new ImageIcon(this.getClass().getResource("/images24/overlay.png")));
        this.chkToggleOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.chkToggleOverlayActionPerformed(evt);
            }
        });
        this.mnuView.add(this.chkToggleOverlay);
        this.jSeparator23.setToolTipText("Map Mode");
        this.mnuView.add(this.jSeparator23);
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setSelected(true);
        this.mnuToggleFrame1.setText("Show Frame 1 Translation");
        this.mnuToggleFrame1.setToolTipText("Toggle showing reading frame 1.");
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/T1.png")));
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setSelected(true);
        this.mnuToggleFrame2.setText("Show Frame 2 Translation");
        this.mnuToggleFrame2.setToolTipText("Toggle showing reading frame 2.");
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/T2.png")));
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setSelected(true);
        this.mnuToggleFrame3.setText("Show Frame 3 Translation");
        this.mnuToggleFrame3.setToolTipText("Toggle showing reading frame 3.");
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/T3.png")));
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame3);
        this.mnuToggleFrame4.setAccelerator(KeyStroke.getKeyStroke(112, 128));
        this.mnuToggleFrame4.setSelected(true);
        this.mnuToggleFrame4.setText("Show Frame -1 Translation");
        this.mnuToggleFrame4.setToolTipText("Toggle showing reading frame 1.");
        this.mnuToggleFrame4.setIcon(new ImageIcon(this.getClass().getResource("/images24/T1.png")));
        this.mnuToggleFrame4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame4ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame4);
        this.mnuToggleFrame5.setAccelerator(KeyStroke.getKeyStroke(113, 128));
        this.mnuToggleFrame5.setSelected(true);
        this.mnuToggleFrame5.setText("Show Frame -2 Translation");
        this.mnuToggleFrame5.setToolTipText("Toggle showing reading frame 2.");
        this.mnuToggleFrame5.setIcon(new ImageIcon(this.getClass().getResource("/images24/T2.png")));
        this.mnuToggleFrame5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame5ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame5);
        this.mnuToggleFrame6.setAccelerator(KeyStroke.getKeyStroke(114, 128));
        this.mnuToggleFrame6.setSelected(true);
        this.mnuToggleFrame6.setText("Show Frame -3 Translation");
        this.mnuToggleFrame6.setToolTipText("Toggle showing reading frame 3.");
        this.mnuToggleFrame6.setIcon(new ImageIcon(this.getClass().getResource("/images24/T3.png")));
        this.mnuToggleFrame6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleFrame6ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame6);
        this.mnuToggleAntisense.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAntisense.setSelected(true);
        this.mnuToggleAntisense.setText("Show Antisense");
        this.mnuToggleAntisense.setToolTipText("Toggle showing the antisense strand.");
        this.mnuToggleAntisense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleAntisenseActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleAntisense);
        this.mnuToggleNumbers.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mnuToggleNumbers.setSelected(true);
        this.mnuToggleNumbers.setText("Show Numbers");
        this.mnuToggleNumbers.setToolTipText("Toggle showing line numbers.");
        this.mnuToggleNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuToggleNumbersActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleNumbers);
        this.mainMenuBar.add(this.mnuView);
        this.mnuTools.setText("Tools");
        this.mnuTools.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuToolsMenuSelected(evt);
            }
        });
        this.jSeparator25.setToolTipText("Convert to exons");
        this.mnuTools.add(this.jSeparator25);
        this.mnuConvertExons.setIcon(new ImageIcon(this.getClass().getResource("/images24/Exon.png")));
        this.mnuConvertExons.setText("Convert Uppercase to Exons");
        this.mnuConvertExons.setToolTipText("Annotate uppercased sequences as exons, numbering sequentially.");
        this.mnuConvertExons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuConvertExonsActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuConvertExons);
        this.jSeparator26.setToolTipText("Element Finder");
        this.mnuTools.add(this.jSeparator26);
        this.mnuDNAElements.setAccelerator(KeyStroke.getKeyStroke(80, 640));
        this.mnuDNAElements.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.mnuDNAElements.setText("DNA Elements Search Tool");
        this.mnuDNAElements.setToolTipText("Search sequence for DNA elements such as promoters, Kozak signals, etc...");
        this.mnuDNAElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDNAElementsActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuDNAElements);
        this.jSeparator27.setToolTipText("Codon/Bp Conversion");
        this.mnuTools.add(this.jSeparator27);
        this.mnuCalcCodon.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.mnuCalcCodon.setText("Convert Bp to Codon #");
        this.mnuCalcCodon.setToolTipText("Get the codon # corresponding to a nucliotide position.");
        this.mnuCalcCodon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCalcCodonActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuCalcCodon);
        this.mnuCalcCodon2.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.mnuCalcCodon2.setText("Convert Codon # to Bp");
        this.mnuCalcCodon2.setToolTipText("Get the nucliotide position corresponding to a codon #.");
        this.mnuCalcCodon2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCalcCodon2ActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuCalcCodon2);
        this.jSeparator28.setToolTipText("Restriction Analysis");
        this.mnuTools.add(this.jSeparator28);
        this.mnuRE.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.mnuRE.setIcon(new ImageIcon(this.getClass().getResource("/images24/RE.png")));
        this.mnuRE.setText("Select Restriction Enzymes");
        this.mnuRE.setToolTipText("Open the Restriction Enzyme window to select enzymes to display.");
        this.mnuRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuREActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuRE);
        this.mnuCutters.setIcon(new ImageIcon(this.getClass().getResource("/images24/RE.png")));
        this.mnuCutters.setText("View List of Cutters");
        this.mnuCutters.setToolTipText("Opens a window that displays all restriction enzymes enzymes that cut this sequence.");
        this.mnuCutters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuCuttersActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuCutters);
        this.mnuNonCutters.setIcon(new ImageIcon(this.getClass().getResource("/images24/RE.png")));
        this.mnuNonCutters.setText("View List of Non-Cutters");
        this.mnuNonCutters.setToolTipText("Opens a window that displays all restriction enzymes enzymes that do not cut this sequence.");
        this.mnuNonCutters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuNonCuttersActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuNonCutters);
        this.jSeparator29.setToolTipText("Amino Acid Tools");
        this.mnuTools.add(this.jSeparator29);
        this.mnuSetProjectCodonTable.setText("Set Project Codon Table");
        this.mnuSetProjectCodonTable.setToolTipText("Set a codon table for this project");
        this.mnuSetProjectCodonTable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PLOTJ.this.mnuSetProjectCodonTableStateChanged(evt);
            }
        });
        this.mnuTools.add(this.mnuSetProjectCodonTable);
        this.mnuAAtoDNA.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToDNA.png")));
        this.mnuAAtoDNA.setText("Amino Acid-to-DNA Tool");
        this.mnuAAtoDNA.setToolTipText("Opens the reverse translation window.");
        this.mnuAAtoDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAAtoDNAActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuAAtoDNA);
        this.mnuAnnotate.setText("Auto-Annotate from Library");
        this.mnuAnnotate.setToolTipText("Automatically annotate features using the default and user feature libraries.");
        this.mnuAnnotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAnnotateActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuAnnotate);
        this.jSeparator31.setToolTipText("Feature Tools");
        this.mnuTools.add(this.jSeparator31);
        this.mnuRemoveAll.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.mnuRemoveAll.setText("Erase All Features");
        this.mnuRemoveAll.setToolTipText("Remove all annotations from this project.");
        this.mnuRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuRemoveAllActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuRemoveAll);
        this.jSeparator35.setToolTipText("Manage Libraries");
        this.mnuTools.add(this.jSeparator35);
        this.mainMenuBar.add(this.mnuTools);
        this.mnuPlugins.setText("PlugIns");
        this.sepLoadTools.setToolTipText("Load Tools");
        this.mnuPlugins.add(this.sepLoadTools);
        this.mnuLoadPlugins.setIcon(new ImageIcon(this.getClass().getResource("/images24/FOLDER_DL.png")));
        this.mnuLoadPlugins.setText("Load from .jar file");
        this.mnuLoadPlugins.setToolTipText("Load tools from a .Jar in a different location.");
        this.mnuLoadPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuLoadPluginsActionPerformed(evt);
            }
        });
        this.mnuPlugins.add(this.mnuLoadPlugins);
        this.sepPlugins.setToolTipText("Plugin Tools");
        this.mnuPlugins.add(this.sepPlugins);
        this.sepPlugins1.setToolTipText("Plugin Tools");
        this.mnuPlugins.add(this.sepPlugins1);
        this.mainMenuBar.add(this.mnuPlugins);
        this.mnuFeatures.setText("Features");
        this.mnuFeatures.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuFeaturesMenuSelected(evt);
            }
        });
        this.jSeparator32.setToolTipText("Change Selected Feature");
        this.mnuFeatures.add(this.jSeparator32);
        this.mnuIncFeatureWidth.setAccelerator(KeyStroke.getKeyStroke(39, 128));
        this.mnuIncFeatureWidth.setText("Increase Selected Feature Width");
        this.mnuIncFeatureWidth.setToolTipText("Increase the width of the selected feature.");
        this.mnuIncFeatureWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuIncFeatureWidthActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuIncFeatureWidth);
        this.mnuDecFeatureWidth.setAccelerator(KeyStroke.getKeyStroke(37, 128));
        this.mnuDecFeatureWidth.setText("Decrease Selected Feature Width");
        this.mnuDecFeatureWidth.setToolTipText("Decrease the width of the selected feature.");
        this.mnuDecFeatureWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDecFeatureWidthActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuDecFeatureWidth);
        this.mnuIncFeatureOffset.setAccelerator(KeyStroke.getKeyStroke(38, 128));
        this.mnuIncFeatureOffset.setText("Increase Selected Feature's Offset");
        this.mnuIncFeatureOffset.setToolTipText("Increase the offset of the selected feature from the DNA line.");
        this.mnuIncFeatureOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuIncFeatureOffsetActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuIncFeatureOffset);
        this.mnuDecFeatureOffset.setAccelerator(KeyStroke.getKeyStroke(40, 128));
        this.mnuDecFeatureOffset.setText("Decrease Selected Feature's Offset");
        this.mnuDecFeatureOffset.setToolTipText("Decrease the width of the selected feature.");
        this.mnuDecFeatureOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDecFeatureOffsetActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuDecFeatureOffset);
        this.jSeparator33.setToolTipText("Change All Features");
        this.mnuFeatures.add(this.jSeparator33);
        this.mnuIncFeatureWidths.setAccelerator(KeyStroke.getKeyStroke(39, 512));
        this.mnuIncFeatureWidths.setText("Increase All Feature Widths");
        this.mnuIncFeatureWidths.setToolTipText("Increase the width of all feature.");
        this.mnuIncFeatureWidths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuIncFeatureWidthsActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuIncFeatureWidths);
        this.mnuDecFeatureWidths.setAccelerator(KeyStroke.getKeyStroke(37, 512));
        this.mnuDecFeatureWidths.setText("Decrease All Feature Widths");
        this.mnuDecFeatureWidths.setToolTipText("Decrease the width of all feature.");
        this.mnuDecFeatureWidths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDecFeatureWidthsActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuDecFeatureWidths);
        this.mnuIncFeatureOffsets.setAccelerator(KeyStroke.getKeyStroke(38, 512));
        this.mnuIncFeatureOffsets.setText("Increase All Feature Offsets");
        this.mnuIncFeatureOffsets.setToolTipText("Increase the offset of all features from the DNA line.");
        this.mnuIncFeatureOffsets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuIncFeatureOffsetsActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuIncFeatureOffsets);
        this.mnuDecFeatureOffsets.setAccelerator(KeyStroke.getKeyStroke(40, 512));
        this.mnuDecFeatureOffsets.setText("Decrease All Feature Offsets");
        this.mnuDecFeatureOffsets.setToolTipText("Decrease the offset of all features from the DNA line.");
        this.mnuDecFeatureOffsets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuDecFeatureOffsetsActionPerformed(evt);
            }
        });
        this.mnuFeatures.add(this.mnuDecFeatureOffsets);
        this.jSeparator39.setToolTipText("Change Selected Feature");
        this.mnuFeatures.add(this.jSeparator39);
        this.mainMenuBar.add(this.mnuFeatures);
        this.mnuLibraries.setText("Libraries");
        this.jSeparator24.setToolTipText("Manage Libraries");
        this.mnuLibraries.add(this.jSeparator24);
        this.mnuEditFeaturesLib.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.mnuEditFeaturesLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.mnuEditFeaturesLib.setText("Manage Features Library");
        this.mnuEditFeaturesLib.setToolTipText("Edit the user features library.");
        this.mnuEditFeaturesLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuEditFeaturesLibActionPerformed(evt);
            }
        });
        this.mnuLibraries.add(this.mnuEditFeaturesLib);
        this.mnuEditPrimersLib.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.mnuEditPrimersLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Primers.png")));
        this.mnuEditPrimersLib.setText("Manage Primers Library");
        this.mnuEditPrimersLib.setToolTipText("Edit the user primers library.");
        this.mnuEditPrimersLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuEditPrimersLibActionPerformed(evt);
            }
        });
        this.mnuLibraries.add(this.mnuEditPrimersLib);
        this.mnuEditLaddersLib.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        this.mnuEditLaddersLib.setIcon(new ImageIcon(this.getClass().getResource("/images24/Gel.png")));
        this.mnuEditLaddersLib.setText("Manage Ladders Library");
        this.mnuEditLaddersLib.setToolTipText("Edit the user gel ladder library.");
        this.mnuEditLaddersLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuEditLaddersLibActionPerformed(evt);
            }
        });
        this.mnuLibraries.add(this.mnuEditLaddersLib);
        this.jSeparator30.setToolTipText("Set libraries files");
        this.mnuLibraries.add(this.jSeparator30);
        this.mnuSetDatabaseLocations.setIcon(new ImageIcon(this.getClass().getResource("/images24/Gear.png")));
        this.mnuSetDatabaseLocations.setText("Set external database locations");
        this.mnuSetDatabaseLocations.setToolTipText("Edit pLOT preferences.");
        this.mnuSetDatabaseLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuSetDatabaseLocationsActionPerformed(evt);
            }
        });
        this.mnuLibraries.add(this.mnuSetDatabaseLocations);
        this.jSeparator52.setToolTipText("Manage Libraries");
        this.mnuLibraries.add(this.jSeparator52);
        this.mainMenuBar.add(this.mnuLibraries);
        this.mnuWindows.setText("Window");
        this.mnuWindows.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuWindowsMenuSelected(evt);
            }
        });
        this.sepShowWindows.setToolTipText("Show/Hide Windows");
        this.mnuWindows.add(this.sepShowWindows);
        this.mnuShowToolWindow.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.mnuShowToolWindow.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToolWindow.png")));
        this.mnuShowToolWindow.setText("Dock/Undock Tools Window");
        this.mnuShowToolWindow.setToolTipText("Toggle the display of the Tools window.");
        this.mnuShowToolWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuShowToolWindowActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuShowToolWindow);
        this.mnuShowSplitWindow.setAccelerator(KeyStroke.getKeyStroke(88, 192));
        this.mnuShowSplitWindow.setIcon(new ImageIcon(this.getClass().getResource("/images24/Split.png")));
        this.mnuShowSplitWindow.setText("Dock/Undock Split Window");
        this.mnuShowSplitWindow.setToolTipText("Dock/undock the split window.");
        this.mnuShowSplitWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuShowSplitWindowActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuShowSplitWindow);
        this.sepGel.setToolTipText("Virtual Gel");
        this.mnuWindows.add(this.sepGel);
        this.mnuGel.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.mnuGel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Gel.png")));
        this.mnuGel.setText("Show Virtual Gel");
        this.mnuGel.setToolTipText("Opens and displays the virtual gel window.");
        this.mnuGel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuGelActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuGel);
        this.mnuMobileBlocks.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.mnuMobileBlocks.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.mnuMobileBlocks.setText("Show Sequence Blocks");
        this.mnuMobileBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuMobileBlocksActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuMobileBlocks);
        this.sepShowWindows1.setToolTipText("Show/Hide Windows");
        this.mnuWindows.add(this.sepShowWindows1);
        this.mainMenuBar.add(this.mnuWindows);
        this.mnuAbout.setText("About");
        this.mnuAbout.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PLOTJ.this.mnuAboutMenuSelected(evt);
            }
        });
        this.jSeparator36.setToolTipText("Help");
        this.mnuAbout.add(this.jSeparator36);
        this.mnuShowHelp.setIcon(new ImageIcon(this.getClass().getResource("/images24/QUESTION.png")));
        this.mnuShowHelp.setText("Show help");
        this.mnuShowHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuShowHelpActionPerformed(evt);
            }
        });
        this.mnuAbout.add(this.mnuShowHelp);
        this.mnuAboutpLOT.setIcon(new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png")));
        this.mnuAboutpLOT.setText("About pLOT");
        this.mnuAboutpLOT.setToolTipText("Show pLOT version and information.");
        this.mnuAboutpLOT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLOTJ.this.mnuAboutpLOTActionPerformed(evt);
            }
        });
        this.mnuAbout.add(this.mnuAboutpLOT);
        this.jSeparator42.setToolTipText("Update Checker");
        this.mnuAbout.add(this.jSeparator42);
        this.mainMenuBar.add(this.mnuAbout);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.hSplitPane, -1, 902, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 902, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainToolBar, -2, -1, -2).addGap(0, 0, 0).addComponent(this.hSplitPane).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2)));
        this.pack();
    }

    private void getNewSequence() {
        if (this.project.length() > 0) {
            PLOTJ newFrm = Globals.newWindow();
            newFrm.getNewSequence();
        } else {
            FrmNewSeq f = new FrmNewSeq(this);
            this.toolTip.setText(null);
            f.setVisible(true);
        }
    }

    private void cmdNewActionPerformed(ActionEvent evt) {
        this.getNewSequence();
    }

    private void sldAlphaStateChanged(javax.swing.event.ChangeEvent evt) {
        this.applyAlpha(true);
    }

    private void applyPName() {
        this.txtPlasmidName.setCaretPosition(0);
        final String newValue = this.txtPlasmidName.getText();
        final String oldValue = this.project.getName();
        if (newValue == null || newValue.length() == 0) {
            this.txtPlasmidName.setText(oldValue);
            return;
        }
        if (!newValue.equals(oldValue)) {
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(0), new ChangeEvent(106)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.txtPlasmidName.setText(oldValue);
                    PLOTJ.this.project.setName(oldValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.setName(newValue);
                    PLOTJ.this.txtPlasmidName.setText(newValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo sequence name";
            edit.undoName = "Undo sequence name";
            this.project.runEdit(edit);
        }
    }

    private void applySource() {
        this.txtSource.setCaretPosition(0);
        final String newValue = this.txtSource.getText();
        final String oldValue = this.project.getSource();
        if (!newValue.equals(oldValue)) {
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(2)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.setSource(oldValue, false);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.setSource(newValue, false);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo sequence source";
            edit.undoName = "Undo sequence source";
            this.project.runEdit(edit);
        }
    }

    private void applyOrganism() {
        this.txtOrg.setCaretPosition(0);
        final String newValue = this.txtOrg.getText();
        final String oldValue = this.project.getOrganism();
        if (!newValue.equals(oldValue)) {
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(1)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.setOrganism(oldValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.setOrganism(newValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo sequence organism";
            edit.undoName = "Undo sequence organism";
            this.project.runEdit(edit);
        }
    }

    private void applyFName() {
        this.txtFName.setCaretPosition(0);
        final Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            String oldValue;
            String oText = this.txtFName.getText();
            final String newValue = Globals.trimmer.trim(oText, "New Feature");
            if (newValue != oText) {
                this.txtFName.setText(newValue);
            }
            if (!newValue.equals(oldValue = selectedItem.getName())) {
                final boolean changed = this.project.isChanged();
                final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(112)};
                Undoable edit = new Undoable(){

                    @Override
                    public boolean undo() {
                        selectedItem.setName(oldValue);
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(changed);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        selectedItem.setName(newValue);
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(true);
                        return true;
                    }
                };
                edit.redoName = "Redo feature name";
                edit.undoName = "Undo feature name";
                this.project.runEdit(edit);
            }
        }
    }

    private void applyAlpha(boolean redraw) {
        Feature[] features = this.project.getSelectedItems(0);
        if (features == null) {
            return;
        }
        int value = this.sldAlpha.getValue();
        this.spinAlpha.setValue(value);
        for (Feature f : features) {
            f.setAlpha(value);
        }
        if (redraw) {
            this.resetMap();
        }
    }

    private void applyRadius(boolean redraw) {
        Feature[] features = this.project.getSelectedItems(0);
        if (features == null) {
            return;
        }
        int value = this.sldRadius.getValue();
        this.spinRadius.setValue(value);
        for (Feature f : features) {
            f.setOffset(value);
        }
        if (redraw) {
            this.resetMap();
        }
    }

    private void applyWidth(boolean redraw) {
        Feature[] features = this.project.getSelectedItems(0);
        if (features == null) {
            return;
        }
        int value = this.sldWidth.getValue();
        this.spinWidth.setValue(value);
        for (Feature f : features) {
            f.setWidth(value);
        }
        if (redraw) {
            this.resetMap();
        }
    }

    private void applyDrawingOrder(boolean redraw) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            int newIndex = this.sldDrawingOrder.getValue();
            int index = this.project.getFeatures().indexOf(selectedItem);
            if (index > -1) {
                this.project.getFeatures().remove(index);
                this.project.getFeatures().insert(selectedItem, newIndex);
                if (redraw) {
                    this.resetMap();
                }
            }
        }
    }

    private void sldRadiusStateChanged(javax.swing.event.ChangeEvent evt) {
        this.applyRadius(true);
    }

    private void sldWidthStateChanged(javax.swing.event.ChangeEvent evt) {
        this.applyWidth(true);
    }

    private void sldDrawingOrderStateChanged(javax.swing.event.ChangeEvent evt) {
        this.applyDrawingOrder(true);
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private boolean saveFile() {
        String ext = this.lastWriter.getWriteFileExtension();
        if (this.project.getFile() == null || !this.project.getFile().getName().toLowerCase().endsWith(ext)) {
            return this.saveFileAs();
        }
        return this.saveFile(this.project.getFile(), this.lastWriter);
    }

    private boolean saveFileAs() {
        ImpFileWriter writer = this.lastWriter;
        String ext = writer.getWriteFileExtension().startsWith(".") ? writer.getWriteFileExtension() : "." + writer.getWriteFileExtension();
        File defFile = this.project.getFile();
        if (defFile != null) {
            if (!defFile.getName().toLowerCase().endsWith(ext)) {
                String newName = FilenameUtils.removeExtension(defFile.getAbsolutePath()) + ext;
                defFile = new File(newName);
            }
        } else {
            defFile = new File(this.project.getName());
        }
        JFileChooser fc = new JFileChooser();
        FileWriters.setFilters(fc);
        fc.setSelectedFile(defFile);
        if (fc.showSaveDialog(this) == 0) {
            File file = fc.getSelectedFile();
            FileWriters.WriterFileFilter filter = (FileWriters.WriterFileFilter)fc.getFileFilter();
            writer = filter.getConverter();
            String string = ext = writer.getWriteFileExtension().startsWith(".") ? writer.getWriteFileExtension() : "." + writer.getWriteFileExtension();
            if (!file.getName().toLowerCase().endsWith(ext)) {
                String newName = FilenameUtils.removeExtension(file.getAbsolutePath()) + ext;
                file = new File(newName);
            }
            if (file.exists() && JOptionPanes.showConfirmDialog((Component)this, (Object)"File exists.  Overwrite?", "Confirm overwrite", this.displayType) != 0) {
                return false;
            }
            return this.saveFile(file, writer);
        }
        return false;
    }

    private boolean saveFile(File file, ImpFileWriter writer) {
        if (!(!file.exists() || file.isFile() && file.canWrite())) {
            return false;
        }
        File outFile = writer.write(file, this.project);
        if (outFile == null) {
            System.err.println("Save error: " + writer.getWriteError());
            return false;
        }
        if (outFile != file) {
            this.project.setFile(outFile);
        }
        Globals.history.insertFirst("pLOT_FilePath", file.getAbsolutePath(), 200);
        this.project.setFile(file);
        this.project.setChanged(false);
        this.statusLabel.setText("File saved", 2000);
        this.lastWriter = writer;
        return true;
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser();
        FileReaders.setFilters(fc);
        fc.setSelectedFile(this.project.getFile());
        if (fc.showOpenDialog(this) == 0 && fc.getFileFilter() instanceof FileReaders.LoaderFileFilter) {
            GenBankFile f = ((FileReaders.LoaderFileFilter)fc.getFileFilter()).getConverter().loadFile(fc.getSelectedFile());
            if (f != null) {
                this.loadFile(f);
            } else {
                this.openFile(fc.getSelectedFile());
            }
        }
    }

    void openFile(File file) {
        if (!file.exists()) {
            if (JOptionPanes.showConfirmDialog((Component)this, (Object)"File was not found.  Remove from Recent?", "File open failed.", 0) == 0) {
                Globals.history.deleteByValue("pLOT_FilePath", file.getAbsolutePath(), 200);
            }
            return;
        }
        GenBankFile gbFile = GenBankFile.loadGBFile(file);
        this.loadFile(gbFile);
    }

    boolean loadFile(GenBankFile genBankFile) {
        if (genBankFile == null) {
            return false;
        }
        ProjectDocument document = new ProjectDocument();
        ProjectDocument.fromGenbankFile(genBankFile, document);
        document.setFile(genBankFile.getFile());
        boolean success = false;
        if (this.project.length() == 0) {
            success = this.setProject(document);
            if (success) {
                this.project.setFile(genBankFile.getFile());
            }
        } else {
            PLOTJ newMain = Globals.newWindow();
            success = newMain.setProject(document);
            if (success) {
                newMain.project.setFile(genBankFile.getFile());
            }
        }
        if (success && genBankFile.getFile() != null) {
            Globals.history.insertFirst("pLOT_FilePath", genBankFile.getFile().getAbsolutePath(), 200);
        }
        return success;
    }

    public boolean setProject(ProjectDocument document) {
        if (this.project == document || document == null) {
            return false;
        }
        if (this.project != null) {
            this.project.removeListener(this);
        }
        this.findEnzymes(document);
        this.findPrimers(document);
        this.project = document;
        this.project.addListener(this);
        this.project.setListenersEnabled(false);
        this.project.showEnzymes = this.cmdShowRE.isSelected();
        this.project.showPrimers = this.cmdShowPrimers.isSelected();
        this.project.showLabels = this.cmdShowLabels.isSelected();
        this.project.setListenersEnabled(true);
        this.project.setChanged(false);
        this.project.fireEvents(116);
        this.setProjectMenusEnabled(this.project.length() > 0);
        return true;
    }

    void findEnzymes(final ProjectDocument project) {
        if (project.length() == 0) {
            return;
        }
        this.statusBarForm.setTitle("Finding Restriction Sites");
        this.statusBarForm.setMaximum(DefaultLibraries.defaultEnzymes.items.size());
        this.statusBarForm.setValue(0);
        this.statusBarForm.setBarFillColor(Color.orange);
        this.statusBarForm.run(new ThreadRunner(){

            @Override
            public void run() {
                if (project.defaultEnzymes.size() > 0) {
                    project.defaultEnzymes.sort(ProjectEnzyme.schizoComp);
                    DegenerateFinder finder = new DegenerateFinder(project.getSequence(), project.isCircular());
                    int progress = 0;
                    for (ProjectEnzyme e : project.defaultEnzymes) {
                        if (e.enzyme.isoschizomer && e.proto != null) {
                            e.cuts = e.proto.cuts;
                            continue;
                        }
                        e.cuts = finder.findDNASequence(e.enzyme.filteredSeq, true, e.enzyme.asymetrical);
                        PLOTJ.this.statusBarForm.setValue(progress++);
                    }
                }
            }
        });
        project.updateREs();
    }

    void findPrimers(ProjectDocument project) {
        project.foundPrimers.clear();
        project.clearFoundCategories();
        this.primersPopupMenu.removeAllSearchItems();
        DefaultLibraries.findPrimers(project, this.statusBarForm);
        project.foundCategories.sort(this.catSort);
        for (PrimerCategory cat : project.foundCategories) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(cat.name + " (" + cat.count + ")");
            item.setSelected(cat.shown);
            item.addActionListener(new CatActionListener(cat));
            this.primersPopupMenu.add(item);
        }
    }

    private void cmdOpenActionPerformed(ActionEvent evt) {
        this.openFile();
    }

    private void sldAlphaMouseWheelMoved(MouseWheelEvent evt) {
        if (!this.sldAlpha.isEnabled()) {
            return;
        }
        if (evt.getWheelRotation() > 0) {
            this.sldAlpha.setValue(this.sldAlpha.getValue() + 1);
        } else if (evt.getWheelRotation() < 0) {
            this.sldAlpha.setValue(this.sldAlpha.getValue() - 1);
        }
    }

    private void sldRadiusMouseWheelMoved(MouseWheelEvent evt) {
        if (!this.sldRadius.isEnabled()) {
            return;
        }
        if (evt.getWheelRotation() > 0) {
            this.sldRadius.setValue(this.sldRadius.getValue() + 1);
        } else if (evt.getWheelRotation() < 0) {
            this.sldRadius.setValue(this.sldRadius.getValue() - 1);
        }
    }

    private void sldWidthMouseWheelMoved(MouseWheelEvent evt) {
        if (!this.sldWidth.isEnabled()) {
            return;
        }
        if (evt.getWheelRotation() > 0) {
            this.sldWidth.setValue(this.sldWidth.getValue() + 1);
        } else if (evt.getWheelRotation() < 0) {
            this.sldWidth.setValue(this.sldWidth.getValue() - 1);
        }
    }

    private void sldDrawingOrderMouseWheelMoved(MouseWheelEvent evt) {
        if (!this.sldDrawingOrder.isEnabled()) {
            return;
        }
        if (evt.getWheelRotation() > 0) {
            this.sldDrawingOrder.setValue(this.sldDrawingOrder.getValue() + 1);
        } else if (evt.getWheelRotation() < 0) {
            this.sldDrawingOrder.setValue(this.sldDrawingOrder.getValue() - 1);
        }
    }

    private void cmdCircularActionPerformed(ActionEvent evt) {
        this.toggleCircular(!this.cmdCircular.isSelected());
    }

    public void toggleCircular(boolean circle) {
        this.project.setCircular(circle);
    }

    private void spinAlphaStateChanged(javax.swing.event.ChangeEvent evt) {
        this.sldAlpha.setValue((Integer)this.spinAlpha.getValue());
    }

    private void spinRadiusStateChanged(javax.swing.event.ChangeEvent evt) {
        this.sldRadius.setValue((Integer)this.spinRadius.getValue());
    }

    private void spinWidthStateChanged(javax.swing.event.ChangeEvent evt) {
        this.sldWidth.setValue((Integer)this.spinWidth.getValue());
    }

    private void selectColor(int src, Color defColor) {
        Color[] origLColor;
        int x;
        Color[] origGColor;
        final Feature selectedItem = this.project.getSelectedItem();
        final Color newColor = JColorChooser.showDialog(this, "Select new color", defColor);
        if (newColor == null) {
            return;
        }
        final boolean changed = this.project.isChanged();
        final Feature[] features = new Feature[this.project.selectedItems.size()];
        if (src == 0 || src == 2) {
            origGColor = new Color[this.project.selectedItems.size()];
            for (x = 0; x < this.project.selectedItems.size(); ++x) {
                features[x] = this.project.selectedItems.get(x);
                origGColor[x] = features[x].getBackColor();
            }
        } else {
            origGColor = null;
        }
        if (src == 1 || src == 2) {
            origLColor = new Color[this.project.selectedItems.size()];
            for (x = 0; x < this.project.selectedItems.size(); ++x) {
                features[x] = this.project.selectedItems.get(x);
                origLColor[x] = features[x].getTextColor();
            }
        } else {
            origLColor = null;
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                boolean isSelected = false;
                for (int x = 0; x < features.length; ++x) {
                    if (origGColor != null) {
                        features[x].setBackColor(origGColor[x]);
                    }
                    if (origLColor != null) {
                        features[x].setTextColor(origLColor[x]);
                    }
                    if (selectedItem != PLOTJ.this.project.getSelectedItem()) continue;
                    isSelected = true;
                }
                if (isSelected) {
                    PLOTJ.this.propertyChanged(new ChangeEvent(113), new ChangeEvent(106), new ChangeEvent(112));
                } else {
                    PLOTJ.this.propertyChanged(new ChangeEvent(106));
                }
                PLOTJ.this.project.setChanged(changed);
                return true;
            }

            @Override
            public boolean redo() {
                boolean isSelected = false;
                for (int x = 0; x < features.length; ++x) {
                    if (origGColor != null) {
                        features[x].setBackColor(newColor);
                    }
                    if (origLColor != null) {
                        features[x].setTextColor(newColor);
                    }
                    if (selectedItem != PLOTJ.this.project.getSelectedItem()) continue;
                    isSelected = true;
                }
                if (isSelected) {
                    PLOTJ.this.propertyChanged(new ChangeEvent(113), new ChangeEvent(106), new ChangeEvent(112));
                } else {
                    PLOTJ.this.propertyChanged(new ChangeEvent(106));
                }
                PLOTJ.this.project.setChanged(true);
                return true;
            }
        };
        edit.redoName = "Redo feature color change.";
        edit.undoName = "Undo feature color change.";
        this.project.runEdit(edit);
    }

    void setPlasmidToolsEnabled(boolean enabled) {
        this.txtPlasmidName.setEnabled(enabled);
        this.txtSource.setEnabled(enabled);
        this.txtOrg.setEnabled(enabled);
    }

    void setProjectMenusEnabled(boolean enabled) {
        this.mnuViewFeaturesList.setEnabled(enabled);
        this.mnuIncFeatureWidths.setEnabled(enabled);
        this.mnuDecFeatureWidths.setEnabled(enabled);
        this.mnuIncFeatureOffsets.setEnabled(enabled);
        this.mnuDecFeatureOffsets.setEnabled(enabled);
        this.mnuConvertExons.setEnabled(enabled);
        this.mnuDNAElements.setEnabled(enabled);
        this.mnuRE.setEnabled(enabled);
        this.mnuCutters.setEnabled(enabled);
        this.mnuNonCutters.setEnabled(enabled);
        this.mnuSetProjectCodonTable.setEnabled(enabled);
        this.mnuRemoveAll.setEnabled(enabled);
        this.mnuAnnotate.setEnabled(enabled);
        this.mnuUndo.setEnabled(enabled);
        this.mnuRedo.setEnabled(enabled);
        this.mnuEditAnnotations.setEnabled(enabled);
        this.mnuEditSeq.setEnabled(enabled);
        this.mnuNewFeature.setEnabled(enabled);
        this.mnuRotate.setEnabled(enabled);
        this.mnuAntisenseSeq.setEnabled(enabled);
        this.mnuAntisenseRegion.setEnabled(enabled);
        this.mnuFind.setEnabled(enabled);
        this.mnuSave.setEnabled(enabled);
        this.mnuSaveAs.setEnabled(enabled);
        this.mnuGel.setEnabled(enabled);
        this.cmdShowRE.setEnabled(enabled);
        this.cmdShowLabels.setEnabled(enabled);
        this.cmdShowPrimers.setEnabled(enabled);
        this.cmdZoomIn.setEnabled(enabled);
        this.cmdZoomOut.setEnabled(enabled);
        this.cmdZoom100.setEnabled(enabled);
        this.cmdCircular.setEnabled(enabled);
        this.chkCircular.setEnabled(enabled);
        this.mnuCircular.setEnabled(enabled);
        this.cmdSave.setEnabled(enabled);
        if (!enabled) {
            this.setFeatureMenusEnabled(false);
            this.setFeatureToolsEnabled(false);
        }
    }

    void setFeatureMenusEnabled(boolean enabled) {
        this.mnuCut.setEnabled(enabled);
        this.mnuDupFeature.setEnabled(enabled);
        this.cmdDelFeature.setEnabled(enabled);
        this.cmdDelSequence.setEnabled(enabled);
        this.mnuAntisenseRegion.setEnabled(enabled);
        this.mnuIncFeatureWidth.setEnabled(enabled);
        this.mnuDecFeatureWidth.setEnabled(enabled);
        this.mnuIncFeatureOffset.setEnabled(enabled);
        this.mnuDecFeatureOffset.setEnabled(enabled);
    }

    void setFeatureToolsEnabled(boolean enabled) {
        this.txtFName.setEnabled(enabled);
        this.txtStart.setEnabled(enabled);
        this.txtEnd.setEnabled(enabled);
        this.cmbOrient.setEnabled(enabled);
        this.cmbGBType.setEnabled(enabled);
        this.lblColorGraphic.setEnabled(enabled);
        this.lblColorLabel.setEnabled(enabled);
        this.cmbGraphic.setEnabled(enabled);
        this.sldAlpha.setEnabled(enabled);
        this.sldWidth.setEnabled(enabled);
        this.sldRadius.setEnabled(enabled);
        this.sldDrawingOrder.setEnabled(enabled);
        this.chkDrawGraphic.setEnabled(enabled);
        this.txtCaption.setEnabled(enabled);
        this.chkShowLabel.setEnabled(enabled);
        this.txtNotes.setEnabled(enabled);
        this.spinAlpha.setEnabled(enabled);
        this.spinRadius.setEnabled(enabled);
        this.spinWidth.setEnabled(enabled);
        this.toggleLink.setEnabled(enabled);
    }

    private void displayFeature(Feature selectedItem) {
        Color efColor;
        this.editor.clear();
        Color ebColor = UIManager.getColor("SequenceEditor.background");
        if (ebColor != null) {
            this.editor.setBackground(ebColor);
        }
        if ((efColor = UIManager.getColor("SequenceEditor.foreground")) != null) {
            this.editor.setForeground(efColor);
        }
        if (selectedItem == null || !(selectedItem instanceof Feature)) {
            this.setFViewCaption(null);
        } else {
            if (this.project.length() > 0) {
                SequenceExportFormat sef = this.project.getSEF(selectedItem.getStart(), selectedItem.getStop());
                this.editor.getDocument().setSequence(sef);
                this.editor.setBaseOffset(selectedItem.getStart());
                this.editor.select(0);
                this.editor.setSelectionLength(0);
            }
            this.setFViewCaption(selectedItem);
        }
    }

    private void setFViewCaption(Feature f) {
        if (f == null) {
            this.dockFeatures.getGradientBar().setText("Feature Viewer (Ctrl+X)");
        } else if (f.isAntisense()) {
            this.dockFeatures.getGradientBar().setText("Feature Viewer (Ctrl+X) - " + f.getName() + " complement(" + f.getStop() + " .. " + f.getStart() + ") " + f.getLength(this.project.length()) + "bp");
        } else {
            this.dockFeatures.getGradientBar().setText("Feature Viewer (Ctrl+X) - " + f.getName() + " (" + f.getStart() + " .. " + f.getStop() + ") " + f.getLength(this.project.length()) + "bp");
        }
        Frame parent = this.dockFeatures.getParentWindow();
        if (parent instanceof JFrame && parent != this) {
            parent.setTitle(this.dockFeatures.getTitle());
        }
    }

    private void mnuLowerCaseActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            String newSeq;
            int last;
            final int first = selectedItem.getStart();
            String oldSeq = this.project.getSequence(first, last = selectedItem.getStop());
            if (oldSeq.equals(newSeq = oldSeq.toLowerCase())) {
                return;
            }
            this.project.runRestorePointUndoable(new UndoableAction(){

                @Override
                public boolean run() {
                    PLOTJ.this.project.lowercase(first, last);
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.setSelectedItem(PLOTJ.this.project.getSelectedItem());
                    return true;
                }
            }, "lowercase.");
        }
    }

    private void mnuUpperCaseActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            String newSeq;
            int last;
            final int first = selectedItem.getStart();
            String oldSeq = this.project.getSequence(first, last = selectedItem.getStop());
            if (oldSeq.equals(newSeq = oldSeq.toUpperCase())) {
                return;
            }
            this.project.runRestorePointUndoable(new UndoableAction(){

                @Override
                public boolean run() {
                    PLOTJ.this.project.uppercase(first, last);
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.setSelectedItem(PLOTJ.this.project.getSelectedItem());
                    return true;
                }
            }, "uppercase.");
        }
    }

    private void mnuToLineActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[0]);
    }

    private void mnuToBoxActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[1]);
    }

    private void mnuToArrowActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[2]);
    }

    private void mnuToHeadlessArrowActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[3]);
    }

    private void mnuToLineArrowActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[4]);
    }

    private void mnuToTickMarkActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[5]);
    }

    private void mnuToBracketsActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[6]);
    }

    private void mnuToNoGraphicActionPerformed(ActionEvent evt) {
        this.setFeatureGraphic(FeatureRenderer.drawFeatures[7]);
    }

    private void mnuGraphicColorActionPerformed(ActionEvent evt) {
        if (this.project.selectedItem != null) {
            this.selectColor(0, this.project.selectedItem.getTextColor());
        }
    }

    private void mnuLabelColorActionPerformed(ActionEvent evt) {
        if (this.project.selectedItem != null) {
            this.selectColor(1, this.project.selectedItem.getTextColor());
        }
    }

    private void applyGraphic() {
        this.setFeatureGraphic((FeatureRenderer)this.cmbGraphic.getSelectedItem());
    }

    private void applyStart() {
        int oldValue;
        int newValue;
        final Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null && (newValue = StringTools.filterStringToInt(this.txtStart.getText(), 1, this.project.length(), this.project.length(), 1, this.project.length())) != (oldValue = selectedItem.getStart())) {
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(113), new ChangeEvent(106), new ChangeEvent(112)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    selectedItem.setStart(oldValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    selectedItem.setStart(newValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature start";
            edit.undoName = "Undo feature start";
            this.project.runEdit(edit);
        }
    }

    private void applyStop() {
        int oldValue;
        int newValue;
        final Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null && (newValue = StringTools.filterStringToInt(this.txtEnd.getText(), 1, this.project.length(), this.project.length(), 1, this.project.length())) != (oldValue = selectedItem.getStop())) {
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(113), new ChangeEvent(106), new ChangeEvent(112)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    selectedItem.setStop(oldValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    selectedItem.setStop(newValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature stop";
            edit.undoName = "Undo feature stop";
            this.project.runEdit(edit);
        }
    }

    private void chkCircularActionPerformed(ActionEvent evt) {
        this.toggleCircular(this.chkCircular.isSelected());
    }

    private void applyOrient() {
        final Feature[] features = this.project.getSelectedItems(0);
        if (features != null) {
            final boolean[] oStates = new boolean[features.length];
            final boolean newValue = this.cmbOrient.getSelectedIndex() == 1;
            int index = 0;
            boolean isValid = false;
            for (Feature f : features) {
                if (f.isAntisense()) {
                    oStates[index] = true;
                }
                if (newValue != f.isAntisense()) {
                    isValid = true;
                }
                ++index;
            }
            if (!isValid) {
                return;
            }
            final boolean changed = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    int index = 0;
                    for (Feature f : features) {
                        f.setAntisense(oStates[index]);
                        ++index;
                    }
                    PLOTJ.this.propertyChanged(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (Feature f : features) {
                        f.setAntisense(newValue);
                    }
                    PLOTJ.this.propertyChanged(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature orientation";
            edit.undoName = "Undo feature orientation";
            this.project.runEdit(edit);
        }
    }

    private void applyGBType() {
        final Feature[] features = this.project.getSelectedItems(0);
        if (features != null) {
            final String[] oStates = new String[features.length];
            final String newValue = (String)this.cmbGBType.getEditor().getItem();
            int index = 0;
            boolean isValid = false;
            for (Feature f : features) {
                oStates[index] = f.getGBType();
                if (!f.getGBType().equalsIgnoreCase(newValue)) {
                    isValid = true;
                }
                ++index;
            }
            if (!isValid) {
                return;
            }
            final boolean changed = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    int index = 0;
                    for (Feature f : features) {
                        f.setGBType(oStates[index]);
                        ++index;
                    }
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (Feature f : features) {
                        f.setGBType(newValue);
                    }
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature genbank type";
            edit.undoName = "Undo feature genbank type";
            this.project.runEdit(edit);
            this.project.setChanged(true);
        }
    }

    private void cmbGBTypeActionPerformed(ActionEvent evt) {
        this.applyGBType();
    }

    void editFeature() {
        if (this.project.getSelectedItem() != null) {
            FrmNewEditFeature f = new FrmNewEditFeature(this, true, this.project.getSelectedItem());
            f.setVisible(true);
        }
    }

    private void mnuMoveTopActionPerformed(ActionEvent evt) {
        if (this.project.getFeatures().size() > 1) {
            Feature selectedItem = this.project.getSelectedItem();
            this.undoRedoChangeFeatureIndex(selectedItem, this.project.getFeatures().indexOf(selectedItem), 0);
        }
    }

    private void undoRedoChangeFeatureIndex(final Feature item, final int oldIndex, final int newIndex) {
        if (item != null && newIndex >= 0 && newIndex < this.project.getFeatures().size() && oldIndex >= 0 && oldIndex < this.project.getFeatures().size() && oldIndex != newIndex) {
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(113), new ChangeEvent(10)};
            final boolean isChanged = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.getFeatures().remove(item);
                    PLOTJ.this.project.getFeatures().insert(item, oldIndex);
                    PLOTJ.this.project.setChanged(isChanged);
                    if (item == PLOTJ.this.project.getSelectedItem()) {
                        PLOTJ.this.propertyChanged(new ChangeEvent(112));
                    }
                    PLOTJ.this.propertyChanged(events);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.getFeatures().remove(item);
                    PLOTJ.this.project.getFeatures().insert(item, newIndex);
                    PLOTJ.this.project.setChanged(true);
                    if (item == PLOTJ.this.project.getSelectedItem()) {
                        PLOTJ.this.propertyChanged(new ChangeEvent(112));
                    }
                    PLOTJ.this.propertyChanged(events);
                    return true;
                }
            };
            edit.redoName = "Redo feature drawing order";
            edit.undoName = "Undo feature drawing order";
            this.project.runEdit(edit);
        }
    }

    private void mnuMoveDownActionPerformed(ActionEvent evt) {
        if (this.project.getFeatures().size() > 1) {
            Feature selectedItem = this.project.getSelectedItem();
            this.undoRedoChangeFeatureIndex(selectedItem, this.project.getFeatures().indexOf(selectedItem), this.project.getFeatures().indexOf(selectedItem) + 1);
        }
    }

    private void mnuMoveUpActionPerformed(ActionEvent evt) {
        if (this.project.getFeatures().size() > 1) {
            Feature selectedItem = this.project.getSelectedItem();
            this.undoRedoChangeFeatureIndex(selectedItem, this.project.getFeatures().indexOf(selectedItem), this.project.getFeatures().indexOf(selectedItem) - 1);
        }
    }

    private void mnuMoveBottomActionPerformed(ActionEvent evt) {
        if (this.project.getFeatures().size() > 1) {
            Feature selectedItem = this.project.getSelectedItem();
            this.undoRedoChangeFeatureIndex(selectedItem, this.project.getFeatures().indexOf(selectedItem), this.project.getFeatures().size() - 1);
        }
    }

    private void mnuRenameFeatureActionPerformed(ActionEvent evt) {
        this.editFeature();
    }

    private void mnuRemFeatureActionPerformed(ActionEvent evt) {
        this.deleteSelectedFeatures();
    }

    private void deleteSelectedFeatures() {
        final Feature selectedItem = this.project.getSelectedItem();
        if (this.project.selectedItems.size() == 1 && JOptionPanes.showOptionDialog(this, "Remove this annotation?", "Confirm Remove Feature", 2, 3, null, null, null) == 0) {
            final int index = this.project.getFeatures().indexOf(selectedItem);
            final boolean changed = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.getFeatures().insert(selectedItem, index);
                    PLOTJ.this.project.setSelectedItem(null);
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.getFeatures().remove(selectedItem);
                    PLOTJ.this.project.setSelectedItem(null);
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106), new ChangeEvent(108), new ChangeEvent(112));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo remove feature";
            edit.undoName = "Undo remove feature";
            this.project.runEdit(edit);
        } else if (this.project.selectedItems.size() > 1 && JOptionPanes.showOptionDialog(this, "Remove selected annotations?", "Confirm Remove Features", 2, 3, null, null, null) == 0) {
            final ExtensibleArray<ROI> undoFeatures = new ExtensibleArray<ROI>(ROI.class);
            undoFeatures.copyFrom(this.project.getFeatures());
            final ExtensibleArray<ROI> redoFeatures = new ExtensibleArray<ROI>(ROI.class);
            redoFeatures.copyFrom(this.project.getFeatures());
            for (ROI rOI : this.project.selectedItems) {
                redoFeatures.remove(rOI);
            }
            final boolean changed = this.project.isChanged();
            Undoable undoable = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.getFeatures().clear();
                    PLOTJ.this.project.getFeatures().copyFrom(undoFeatures);
                    PLOTJ.this.project.setSelectedItem(null);
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.getFeatures().clear();
                    PLOTJ.this.project.getFeatures().copyFrom(redoFeatures);
                    PLOTJ.this.project.setSelectedItem(null);
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106), new ChangeEvent(108), new ChangeEvent(112));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            undoable.redoName = "Redo remove feature";
            undoable.undoName = "Undo remove feature";
            this.project.runEdit(undoable);
        }
    }

    private void mnuCopyFpLOTActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            this.copyCut(false);
            this.statusLabel.setText("Copied to clipboard", 2000);
        }
    }

    private void mnuFCopyssDNAActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            myClipboard.set(this.project.getSequence(selectedItem.getStart(), selectedItem.getStop(), selectedItem.isAntisense()));
            this.statusLabel.setText("Copied to clipboard", 2000);
        }
    }

    private void mnuFCopydsDNAActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(5);
    }

    private void mnuFCopyFormattedSSActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(10);
    }

    private void mnuFCopyssDNA_ASActionPerformed(ActionEvent evt) {
        if (!this.canCopyCut()) {
            return;
        }
        Feature selectedItem = this.project.getSelectedItem();
        SequenceExportFormat sef = this.project.getSEF(selectedItem.getStart(), selectedItem.getStop(), selectedItem.isAntisense());
        sef.antisense();
        SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(sef);
        if (transferable != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
        }
        this.statusLabel.setText("Copied to clipboard", 2000);
    }

    private void mnuFCopyAAF1ActionPerformed(ActionEvent evt) {
        this.copySelectedItemTransAs(1);
    }

    private void mnuFCopyAAF2ActionPerformed(ActionEvent evt) {
        this.copySelectedItemTransAs(2);
    }

    private void mnuFCopyAAF3ActionPerformed(ActionEvent evt) {
        this.copySelectedItemTransAs(3);
    }

    private void mnuFCopyAAssF1ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(1);
    }

    private void mnuFCopyAAssF2ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(2);
    }

    private void mnuFCopyAAssF3ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(3);
    }

    private void mnuFCopyAAssF123ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(4);
    }

    private void mnuFCopyAAdsF1ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(6);
    }

    private void mnuFCopyAAdsF2ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(7);
    }

    private void mnuFCopyAAdsF3ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(8);
    }

    private void mnuFCopyAAdsF123ActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(9);
    }

    private void mnuFCopyFormattedDSActionPerformed(ActionEvent evt) {
        this.copySelectedItemAs(11);
    }

    private void copySelectedItemAs(int type) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            String formattedDNA = DNA.getFormattedSequence(this.project.getSequence(selectedItem.getStart(), selectedItem.getStop()), selectedItem.getStart(), this.project.length(), type);
            myClipboard.set(formattedDNA);
        }
        this.statusLabel.setText("Copied to clipboard", 3000);
    }

    private void copySelectedItemTransAs(int type) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            CodonTable.setCodonFormat(CodonTable.LetterCode.e1_Letter_Code);
            myClipboard.set(this.project.getCodonTable().translate(this.project.getSequence(selectedItem.getStart(), selectedItem.getStop()), type));
        }
        this.statusLabel.setText("Copied to clipboard", 3000);
    }

    private void mnuRevCompActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            this.antisenseRegion(selectedItem.getStart(), selectedItem.getStop());
        }
    }

    private void txtCaptionFocusLost(FocusEvent evt) {
        this.applyCaption();
    }

    private void applyCaption() {
        this.txtCaption.setCaretPosition(0);
        final Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            final String newValue = Globals.trimmer.trim(this.txtCaption.getText());
            final String oldValue = selectedItem.getCaption();
            if (oldValue.equals(newValue)) {
                return;
            }
            final boolean isChanged = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(108), new ChangeEvent(112)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    selectedItem.setCaption(oldValue);
                    PLOTJ.this.project.fireEvents(events);
                    PLOTJ.this.project.setChanged(isChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    selectedItem.setCaption(newValue);
                    PLOTJ.this.project.fireEvents(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.undoName = "Undo feature name";
            edit.redoName = "Redo feature name";
            this.project.runEdit(edit);
        }
    }

    private void applyNotes() {
        this.txtNotes.setCaretPosition(0);
        final Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            final boolean isChanged = this.project.isChanged();
            final String oldValue = selectedItem.note;
            final String newValue = this.txtNotes.getText();
            if (oldValue.equals(newValue)) {
                return;
            }
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    selectedItem.setNote(oldValue);
                    PLOTJ.this.project.setChanged(isChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    selectedItem.setNote(newValue);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.undoName = "Undo feature note";
            edit.redoName = "Redo feature note";
            this.project.runEdit(edit);
        }
    }

    private void txtNotesFocusLost(FocusEvent evt) {
        this.applyNotes();
    }

    private void rotateTo(int newOrigin) {
        int seqLen = this.project.length();
        if (newOrigin < 2 || newOrigin > seqLen) {
            return;
        }
        final boolean isChanged = this.project.isChanged();
        final int newStart = newOrigin;
        final int oldStart = seqLen - newOrigin + 2;
        final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(112), new ChangeEvent(113), new ChangeEvent(10)};
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                if (PLOTJ.this.project.setOrigin(oldStart)) {
                    PLOTJ.this.project.setChanged(isChanged);
                    PLOTJ.this.project.fireEvents(events);
                    return true;
                }
                return false;
            }

            @Override
            public boolean redo() {
                if (PLOTJ.this.project.setOrigin(newStart)) {
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.fireEvents(events);
                    return true;
                }
                return false;
            }
        };
        edit.undoName = "Undo rotate";
        edit.redoName = "Redo rotate";
        this.project.runEdit(edit);
    }

    private void mnuRotate1ActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            this.rotateTo(selectedItem.getStart());
        }
    }

    private void mnuRotate2ActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            this.rotateTo(selectedItem.getStop());
        }
    }

    private void setScrollbarValues() {
        if (this.project.zoomFactor > 1.0f) {
            int newpanelWidth = (int)((float)this.panelWidth * this.project.zoomFactor);
            int newpanelHeight = (int)((float)this.panelHeight * this.project.zoomFactor);
            this.project.xOffset = (newpanelWidth - this.panelWidth) / 2;
            this.project.yOffset = (newpanelHeight - this.panelHeight) / 2;
            this.picMap.getHScrollBar().setValues(this.project.xOffset, 10, 0, this.project.xOffset * 2);
            this.picMap.getVScrollBar().setValues(this.project.yOffset, 10, 0, this.project.yOffset * 2);
        }
    }

    private void setZoom(float zoomFactor, boolean redraw) {
        if (this.project.length() > 0 && zoomFactor >= 0.1f && zoomFactor <= 4.0f) {
            this.project.zoomFactor = zoomFactor;
            if (this.project.zoomFactor > 1.0f) {
                this.setScrollbarValues();
                this.picMap.setScrollBars(2);
            } else {
                this.picMap.setScrollBars(-1);
                this.project.xOffset = 0;
                this.project.yOffset = 0;
            }
            if (redraw) {
                this.resetMap();
            }
            this.statusLabel.setText(" (" + (int)(this.project.zoomFactor * 100.0f) + "%)", 3000);
        }
    }

    private void adjustZoom(float delta) {
        this.setZoom(this.project.zoomFactor + delta, true);
    }

    private void cmdZoomInActionPerformed(ActionEvent evt) {
        this.adjustZoom(0.1f);
    }

    private void cmdZoomOutActionPerformed(ActionEvent evt) {
        this.adjustZoom(-0.1f);
    }

    private void lblEditNotesMouseClicked(MouseEvent evt) {
        FrmAnnotations f = new FrmAnnotations(this);
        f.tabPanel.setSelectedIndex(1);
        f.setVisible(true);
    }

    private void lblEditAnnotationsMouseClicked(MouseEvent evt) {
        FrmAnnotations f = new FrmAnnotations(this);
        f.tabPanel.setSelectedIndex(0);
        f.setVisible(true);
    }

    private void lblEditReferencesMouseClicked(MouseEvent evt) {
    }

    private void mnuZoom075ActionPerformed(ActionEvent evt) {
        this.setZoom(0.75f, true);
    }

    private void mnuZoom050ActionPerformed(ActionEvent evt) {
        this.setZoom(0.5f, true);
    }

    private void mnuZoom090ActionPerformed(ActionEvent evt) {
        this.setZoom(0.9f, true);
    }

    private void mnuZoom100ActionPerformed(ActionEvent evt) {
        this.setZoom(1.0f, true);
    }

    private void mnuZoom110ActionPerformed(ActionEvent evt) {
        this.setZoom(1.1f, true);
    }

    private void mnuZoom125ActionPerformed(ActionEvent evt) {
        this.setZoom(1.25f, true);
    }

    private void mnuZoom150ActionPerformed(ActionEvent evt) {
        this.setZoom(1.5f, true);
    }

    private void mnuZoom200ActionPerformed(ActionEvent evt) {
        this.setZoom(2.0f, true);
    }

    private void mnuZoom300ActionPerformed(ActionEvent evt) {
        this.setZoom(3.0f, true);
    }

    private void mnuZoom400ActionPerformed(ActionEvent evt) {
        this.setZoom(4.0f, true);
    }

    private void mnuSetFeatureCodonTableStateChanged(javax.swing.event.ChangeEvent evt) {
    }

    private void lblColorGraphicMouseClicked(MouseEvent evt) {
        if (this.project.selectedItem != null) {
            this.selectColor(this.toggleLink.isSelected() ? 2 : 0, this.project.selectedItem.getBackColor());
        }
    }

    private void lblColorLabelMouseClicked(MouseEvent evt) {
        if (this.project.selectedItem != null) {
            this.selectColor(this.toggleLink.isSelected() ? 2 : 1, this.project.selectedItem.getTextColor());
        }
    }

    private void sldAlphaMouseDragged(MouseEvent evt) {
        this.sldAlpha.repaint();
    }

    private void sldRadiusMouseDragged(MouseEvent evt) {
        this.sldRadius.repaint();
    }

    private void sldWidthMouseDragged(MouseEvent evt) {
        this.sldWidth.repaint();
    }

    private void sldDrawingOrderMouseDragged(MouseEvent evt) {
        this.sldDrawingOrder.repaint();
    }

    private void cmdZoom100ActionPerformed(ActionEvent evt) {
        this.setZoom(1.0f, true);
    }

    private void mnuNewWindowActionPerformed(ActionEvent evt) {
        Globals.newWindow();
        this.toolTip.setText(null);
    }

    private void mnuMiscActionPerformed(ActionEvent evt) {
        DefaultLibraries.userFeatures.open("");
        DefaultLibraries.userLibrary.open("");
        DefaultLibraries.userLadders.open("");
    }

    private void cmdShowREActionPerformed(ActionEvent evt) {
        this.project.showEnzymes = this.cmdShowRE.isSelected();
        Feature f = this.project.getSelectedItem();
        if (f != null && f instanceof EnzymeFeature) {
            this.project.setSelectedItem(null);
        }
        Globals.history.getUserPref().putBoolean("showEnzymes", this.project.showEnzymes);
        this.resetMap();
    }

    private void formWindowLostFocus(WindowEvent evt) {
        if (this.toolTip != null) {
            this.toolTip.hide();
        }
    }

    private void formMouseExited(MouseEvent evt) {
        if (this.toolTip != null) {
            this.toolTip.hide();
        }
    }

    private void mnuSaveToLibDNAActionPerformed(ActionEvent evt) {
        this.saveFeatureToLib(true);
    }

    private void saveAllFeaturesToLib(boolean isDNA) {
        File libFile = new File(DefaultLibraries.userFeatures.getLoadedFilePath());
        try {
            FileWriter fr = new FileWriter(libFile, true);
            for (ROI roi : this.project.getFeatures()) {
                Feature f = (Feature)roi;
                LibraryFeature lf = isDNA ? LibraryFeature.fromFeature(f, 0, this.project) : LibraryFeature.fromFeature(f, 1, this.project);
                DefaultLibraries.userFeatures.items.add(lf);
                fr.write("\n" + lf.exportToString());
            }
            fr.close();
            DefaultLibraries.userFeatures.resetModificationTag();
        }
        catch (IOException ex) {
            Logger.getLogger(PLOTJ.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void saveFeatureToLib(boolean isDNA) {
        if (!this.project.selectedItems.isEmpty()) {
            File libFile = new File(DefaultLibraries.userFeatures.getLoadedFilePath());
            try {
                FileWriter fr = new FileWriter(libFile, true);
                for (Feature f : this.project.selectedItems) {
                    LibraryFeature lf = isDNA ? LibraryFeature.fromFeature(f, 0, this.project) : LibraryFeature.fromFeature(f, 1, this.project);
                    DefaultLibraries.userFeatures.items.add(lf);
                    fr.write("\n" + lf.exportToString());
                }
                fr.close();
                DefaultLibraries.userFeatures.resetModificationTag();
            }
            catch (IOException ex) {
                Logger.getLogger(PLOTJ.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void mnuSaveAllToLibDNAActionPerformed(ActionEvent evt) {
        this.saveAllFeaturesToLib(true);
    }

    private void cmdShowLabelsActionPerformed(ActionEvent evt) {
        this.project.showLabels = this.cmdShowLabels.isSelected();
        Globals.history.getUserPref().putBoolean("showLabels", this.project.showLabels);
        this.resetMap();
    }

    private void mnuPrimerToFeatureActionPerformed(ActionEvent evt) {
        if (this.project.selectedItem != null && this.project.selectedItem instanceof PrimerFeature) {
            final Feature[] addedFeatures = new Feature[this.project.selectedItems.size()];
            int fIndex = 0;
            for (Feature selectedItem : this.project.selectedItems) {
                PlotPrimer primer = ((PrimerFeature)selectedItem).foundPrimer.refPrimer;
                Feature f = new Feature();
                f.setName(primer.name);
                f.set(selectedItem.getStart(), selectedItem.getStop(), selectedItem.isAntisense());
                f.setGBType("primer_bind");
                f.setGraphicStyle(3);
                f.setNote("Catagory: " + primer.category.name + "\nSequence: " + primer.sequence + "\nLocation: " + primer.location + "\n" + primer.comment);
                f.setTextColor(ProjectDocument.primerColor);
                f.setBackColor(ProjectDocument.primerColor);
                addedFeatures[fIndex] = f;
                ++fIndex;
            }
            final boolean changed = this.project.isChanged();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(112), new ChangeEvent(113), new ChangeEvent(10)};
            Undoable event = new Undoable(){

                @Override
                public boolean undo() {
                    for (Feature f : addedFeatures) {
                        PLOTJ.this.project.getFeatures().remove(f);
                    }
                    PLOTJ.this.project.setSelectedItem(null, false);
                    PLOTJ.this.project.setChanged(changed);
                    PLOTJ.this.project.fireEvents(events);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (Feature f : addedFeatures) {
                        PLOTJ.this.project.getFeatures().add(f);
                    }
                    PLOTJ.this.project.setSelectedItem(null, false);
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.fireEvents(events);
                    return true;
                }
            };
            this.project.runEdit(event);
        }
    }

    private void mnuRemovePrimerActionPerformed(ActionEvent evt) {
        boolean updateLib = false;
        if (this.project.selectedItem != null && this.project.selectedItem instanceof PrimerFeature && JOptionPanes.showConfirmDialog(this, "Remove the selected primers from the user database?", "Confirm remove primers", 1, 2) == 0) {
            for (Feature selectedItem : this.project.selectedItems) {
                PlotPrimer primer = ((PrimerFeature)selectedItem).foundPrimer.refPrimer;
                if (primer.isDefault) continue;
                DefaultLibraries.userLibrary.items.remove(primer);
                updateLib = true;
            }
        }
        if (updateLib) {
            DefaultLibraries.userLibrary.save();
        }
    }

    private void mnuSaveToLibAAActionPerformed(ActionEvent evt) {
        this.saveFeatureToLib(false);
    }

    private void mnuSaveAllToLibAAActionPerformed(ActionEvent evt) {
        this.saveAllFeaturesToLib(false);
    }

    private void mnuRecentStateChanged(javax.swing.event.ChangeEvent evt) {
        this.mnuRecent.removeAll();
        final String[] files = Globals.history.getAll("pLOT_FilePath", 200);
        if (files == null) {
            return;
        }
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png"));
        JPopupMenu.Separator filesSep = new JPopupMenu.Separator();
        filesSep.setToolTipText("History");
        filesSep.setUI(new RenderedMenuSeparatorUI(1));
        filesSep.addMouseListener(this.menuMouseListener);
        this.mnuRecent.add(filesSep);
        JMenuItem searchLinks = new JMenuItem("Search Recents", new ImageIcon(this.getClass().getResource("/images24/Find.png")));
        searchLinks.setToolTipText("Search for recent files containing specified text.");
        searchLinks.addMouseListener(this.menuMouseListener);
        this.mnuRecent.add(searchLinks);
        searchLinks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<File> filesList = new ArrayList<File>();
                for (int x = 0; x < files.length; ++x) {
                    if (files[x] == null || files[x].length() <= 0) continue;
                    filesList.add(new File(files[x]));
                }
                if (!filesList.isEmpty()) {
                    FrmSearchRecents f = new FrmSearchRecents((Frame)PLOTJ.this, true, filesList);
                    f.setIconImage(PLOTJ.this.getIconImage());
                    f.setVisible(true);
                }
            }
        });
        JMenuItem remDeadLinks = new JMenuItem("Remove dead file links", new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        remDeadLinks.setToolTipText("Remove links for files that no longer exist.");
        remDeadLinks.addMouseListener(this.menuMouseListener);
        this.mnuRecent.add(remDeadLinks);
        remDeadLinks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < files.length; ++x) {
                    File file;
                    if (files[x] == null || files[x].length() <= 0 || (file = new File(files[x])).exists()) continue;
                    Globals.history.deleteByValue("pLOT_FilePath", file.getAbsolutePath(), 200);
                }
            }
        });
        for (int x = 0; x < files.length; ++x) {
            if (files[x] == null || files[x].length() <= 0) continue;
            File file = new File(files[x]);
            JMenuItem newMenu = new JMenuItem(file.getName(), icon);
            newMenu.addActionListener(new FileActionListener(file));
            newMenu.setToolTipText(" Open " + file.getAbsolutePath());
            newMenu.addMouseListener(this.menuMouseListener);
            this.mnuRecent.add(newMenu);
        }
        this.mnuRecent.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuSaveAsActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void mnuGetGBActionPerformed(ActionEvent evt) {
        FrmGBDownload f = new FrmGBDownload(this);
        f.setVisible(true);
    }

    private void mnuOpenActionPerformed(ActionEvent evt) {
        this.openFile();
    }

    private void mnuNewActionPerformed(ActionEvent evt) {
        this.getNewSequence();
    }

    private void mnuFindActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            new FrmFind(this).setVisible(true);
        }
    }

    private void mnuAntisenseRegionActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            this.antisenseRegion(selectedItem.getStart(), selectedItem.getStop());
        }
    }

    private void antisenseRegion(final int start, final int stop) {
        final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(113), new ChangeEvent(112), new ChangeEvent(4), new ChangeEvent(10), new ChangeEvent(107), new ChangeEvent(106), new ChangeEvent(107)};
        final boolean isChanged = this.project.isChanged();
        final UndoableAction redoAction = new UndoableAction(){

            @Override
            public boolean run() {
                if (PLOTJ.this.project.antisense(start, stop)) {
                    PLOTJ.this.project.setSelectedItem(PLOTJ.this.project.getSelectedItem());
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
                return false;
            }
        };
        if (redoAction.run()) {
            final UndoableAction undoAction = new UndoableAction(){

                @Override
                public boolean run() {
                    if (PLOTJ.this.project.antisense(start, stop)) {
                        PLOTJ.this.project.setSelectedItem(PLOTJ.this.project.getSelectedItem());
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(isChanged);
                        return true;
                    }
                    return false;
                }
            };
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    return redoAction.run();
                }

                @Override
                public boolean redo() {
                    return undoAction.run();
                }
            };
            this.project.addEdit(edit);
        }
    }

    private void mnuAntisenseSeqActionPerformed(ActionEvent evt) {
        final boolean wasChanged = this.project.isChanged();
        final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(112)};
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                if (PLOTJ.this.project.antisense()) {
                    PLOTJ.this.project.fireEvents(events);
                    PLOTJ.this.project.setChanged(wasChanged);
                    return true;
                }
                return false;
            }

            @Override
            public boolean redo() {
                if (PLOTJ.this.project.antisense()) {
                    PLOTJ.this.project.fireEvents(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
                return false;
            }
        };
        this.project.runEdit(edit);
    }

    private void mnuRotateActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        String s = JOptionPanes.showInputDialog(this, "Enter Bp position of the new origin", "Rotate Sequence", -1, null, null, selectedItem != null ? Integer.valueOf(selectedItem.getStart()) : "1");
        int newOrigin = StringTools.filterStringToInt(s, 0);
        this.rotateTo(newOrigin);
    }

    private void mnuAddChromatActionPerformed(ActionEvent evt) {
    }

    private void cmdDelFeatureActionPerformed(ActionEvent evt) {
        this.deleteSelectedFeatures();
    }

    private void mnuDupFeatureActionPerformed(ActionEvent evt) {
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null) {
            final Feature newFeature = selectedItem.clone();
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(112)};
            final boolean isChanged = this.project.isChanged();
            Undoable main = new Undoable(){

                @Override
                public boolean undo() {
                    PLOTJ.this.project.getFeatures().remove(newFeature);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(isChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.getFeatures().add(newFeature);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            main.redoName = "redo feature duplication";
            main.undoName = "undo feature duplication";
            this.project.runEdit(main);
        }
    }

    private void mnuNewFeatureActionPerformed(ActionEvent evt) {
        if (this.project.length() == 0) {
            return;
        }
        Feature feat = new Feature();
        feat.set(1, 1, false);
        feat.setName("New Feature");
        FrmNewEditFeature f = new FrmNewEditFeature(this, true);
        f.setVisible(true);
    }

    private void mnuEditSeqActionPerformed(ActionEvent evt) {
        FrmEditSeq f = new FrmEditSeq(this);
        this.toolTip.setText(null);
        f.setVisible(true);
    }

    private void mnuEditAnnotationsActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            new FrmAnnotations(this).setVisible(true);
        }
    }

    private void mnuPasteActionPerformed(ActionEvent evt) {
        SequenceExportFormat data;
        block6: {
            try {
                if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(SequenceExportFormat.copiedSequenceFlavor)) {
                    data = (SequenceExportFormat)Toolkit.getDefaultToolkit().getSystemClipboard().getData(SequenceExportFormat.copiedSequenceFlavor);
                    if (data == null || data.sequence.length() == 0) {
                        return;
                    }
                    break block6;
                }
                if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    String seq = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    if (seq == null || seq.length() == 0) {
                        return;
                    }
                    data = new SequenceExportFormat();
                    data.sequence = DNA.filterSequence(seq);
                    break block6;
                }
                return;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                return;
            }
        }
        this.pasteInsert(data);
    }

    private void mnuCopyActionPerformed(ActionEvent evt) {
        if (this.getActiveComponent() == this.picMap) {
            this.copyCut(false);
        } else if (this.getActiveComponent() == this.editor) {
            this.editor.copySelectionToClipboard();
        }
    }

    private boolean canCopyCut() {
        return this.project.getSelectedItem() != null;
    }

    private void copyCut(boolean cut) {
        if (!this.canCopyCut()) {
            return;
        }
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem instanceof PrimerFeature) {
            SequenceExportFormat sef = this.project.getSEF((PrimerFeature)selectedItem);
            SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(sef);
            if (transferable != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
            }
        } else {
            SequenceExportFormat sef = this.project.getSEF(selectedItem.getStart(), selectedItem.getStop(), selectedItem.isAntisense());
            sef.name = selectedItem.getName();
            SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(sef);
            if (transferable != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
                if (cut) {
                    this.deleteSelectedSequence();
                }
            }
        }
        this.statusLabel.setText("Copied to clipboard", 3000);
    }

    private void pasteInsert(final SequenceExportFormat data) {
        Integer insPos = 1;
        if (this.project.length() > 0) {
            Object[] ints = new Integer[this.project.length() + 1];
            for (int x = 0; x < ints.length; ++x) {
                ints[x] = x + 1;
            }
            Feature selectedItem = this.project.getSelectedItem();
            if (selectedItem != null) {
                insPos = selectedItem.getStart();
            }
            this.toolTip.hide();
            String retVal = JOptionPanes.showInputDialog(this, "Set which position as bp #1 of the pasted sequence?", "Insert at which position?", 2, null, ints, insPos);
            if (retVal == null) {
                return;
            }
            insPos = (Integer)((Object)retVal);
            final int insPos2 = insPos;
            this.project.runRestorePointUndoable(new UndoableAction(){

                @Override
                public boolean run() {
                    PLOTJ.this.project.insert(insPos2, data);
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.setSelectedItem(null);
                    ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                    PLOTJ.this.toolTip.setText(null);
                    PLOTJ.this.editor.setDNASequence("");
                    PLOTJ.this.findPrimers(PLOTJ.this.project);
                    PLOTJ.this.findEnzymes(PLOTJ.this.project);
                    return true;
                }
            }, "insert.");
        } else {
            this.project.setSequence(data);
            if (this.project.getName() == null || this.project.getName().length() == 0) {
                this.project.setName(data.name != null && data.name.length() > 0 ? data.name : "New Sequence");
            }
            this.project.setChanged(true);
            this.propertyChanged(new ChangeEvent(111), new ChangeEvent(110), new ChangeEvent(0), new ChangeEvent(1), new ChangeEvent(2), new ChangeEvent(106), new ChangeEvent(114), new ChangeEvent(10));
        }
    }

    private void mnuLabelsLinearActionPerformed(ActionEvent evt) {
        if (this.project.labelsCircular) {
            this.project.labelsCircular = false;
            if (this.project.isCircular()) {
                this.project.isLabelChanged = true;
                this.resetMap();
            }
        }
    }

    private void mnuLabelsCircleActionPerformed(ActionEvent evt) {
        if (!this.project.labelsCircular) {
            this.project.labelsCircular = true;
            if (this.project.isCircular()) {
                this.project.isLabelChanged = true;
                this.resetMap();
            }
        }
    }

    private void mnuCircularActionPerformed(ActionEvent evt) {
        this.project.setCircular(!this.project.isCircular());
    }

    private void mnuEditFeaturesLibActionPerformed(ActionEvent evt) {
        DefaultLibraries.userFeatures.update();
        FrmFLibEditor f = new FrmFLibEditor(this);
        f.setVisible(true);
    }

    private void mnuEditPrimersLibActionPerformed(ActionEvent evt) {
        if (FrmEditPrimers.showEditor(this)) {
            this.findPrimers(this.project);
        }
    }

    private void mnuEditLaddersLibActionPerformed(ActionEvent evt) {
        FrmLadders f = new FrmLadders(this);
        f.setVisible(true);
    }

    private void mnuConvertExonsActionPerformed(ActionEvent evt) {
        if (this.project.length() == 0) {
            return;
        }
        final ArrayList<Feature> addedFeatures = new ArrayList<Feature>();
        char[] pSeq = this.project.getSequenceChar(0, this.project.length());
        int exonNum = 1;
        int exStart = 0;
        boolean onExon = pSeq[0] < '`';
        for (int x = 0; x < pSeq.length; ++x) {
            if (pSeq[x] < '`' && !onExon) {
                exStart = x;
                onExon = true;
                continue;
            }
            if (pSeq[x] <= '`' || !onExon) continue;
            Feature newExon = new Feature();
            newExon.renderer = FeatureRenderer.drawFeatures[1];
            newExon.set(exStart + 1, x, false);
            newExon.setName("Exon " + exonNum);
            newExon.setBackColor(Color.black);
            newExon.setGBType("exon");
            newExon.setWidth(10);
            ++exonNum;
            onExon = false;
            addedFeatures.add(newExon);
        }
        if (onExon) {
            Feature newExon = new Feature();
            newExon.renderer = FeatureRenderer.drawFeatures[1];
            newExon.set(exStart + 1, this.project.length(), false);
            newExon.setName("Exon " + exonNum);
            newExon.setGBType("exon");
            newExon.setWidth(10);
            newExon.setBackColor(Color.black);
            addedFeatures.add(newExon);
        }
        if (!addedFeatures.isEmpty()) {
            final boolean changed = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    for (Feature feature : addedFeatures) {
                        PLOTJ.this.project.getFeatures().remove(feature);
                    }
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (Feature feature : addedFeatures) {
                        PLOTJ.this.project.getFeatures().add(feature);
                    }
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo find exons";
            edit.undoName = "Undo find exons";
            this.project.runEdit(edit);
        }
    }

    private void mnuDNAElementsActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            FrmElementFinder p = new FrmElementFinder(this);
            Feature selectedItem = this.project.getSelectedItem();
            if (selectedItem != null) {
                p.txtStart.setText("" + selectedItem.getStart());
                p.txtEnd.setText("" + selectedItem.getStop());
            }
            p.setVisible(true);
        }
    }

    private void mnuCalcCodonActionPerformed(ActionEvent evt) {
        FrmBpToCodon f = new FrmBpToCodon(this);
        f.setVisible(true);
    }

    private void mnuCalcCodon2ActionPerformed(ActionEvent evt) {
        FrmCodonToBp f = new FrmCodonToBp(this);
        f.setVisible(true);
    }

    private void mnuREActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            FrmEnzymes f = new FrmEnzymes(this);
            f.setVisible(true);
        }
    }

    private void mnuCuttersActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            if (this.outputWindow == null) {
                this.outputWindow = new FrmOutput(this);
            }
            String output = "";
            this.project.defaultEnzymes.sort(ProjectEnzyme.sortComparator);
            for (ProjectEnzyme e : this.project.defaultEnzymes) {
                if (e.getCutCount() <= 0) continue;
                output = output + e.enzyme.name + ", [" + e.enzyme.sequence + "](" + e.getCutCount() + ")\n";
            }
            this.outputWindow.setTitle("List of cutters in the current project.");
            this.outputWindow.txtArea.setText(output);
            this.outputWindow.txtArea.select(0, 0);
            this.outputWindow.setVisible(true);
        }
    }

    private void mnuNonCuttersActionPerformed(ActionEvent evt) {
        if (this.project.length() > 0) {
            if (this.outputWindow == null) {
                new FrmOutput(this);
            }
            String output = "";
            this.project.defaultEnzymes.sort(ProjectEnzyme.sortComparator);
            for (ProjectEnzyme e : this.project.defaultEnzymes) {
                if (e.getCutCount() != 0) continue;
                output = output + e.enzyme.name + ", [" + e.enzyme.sequence + "](" + e.getCutCount() + ")\n";
            }
            this.outputWindow.setTitle("List of non-cutters in the current project.");
            this.outputWindow.txtArea.setText(output);
            this.outputWindow.txtArea.select(0, 0);
            this.outputWindow.setVisible(true);
        }
    }

    private void mnuSetProjectCodonTableStateChanged(javax.swing.event.ChangeEvent evt) {
    }

    private void mnuAAtoDNAActionPerformed(ActionEvent evt) {
        FrmAAToDNA f = new FrmAAToDNA(this);
        f.setVisible(true);
    }

    private void mnuGelActionPerformed(ActionEvent evt) {
        if (this.gelForm == null) {
            this.gelForm = new FrmGel(this);
            this.gelForm.useOverlay = this.useOverlay;
            this.gelForm.setTitle("Gel - " + this.baseTitle);
        }
        this.gelForm.setVisible(true);
    }

    private void mnuRemoveAllActionPerformed(ActionEvent evt) {
        if (!this.project.getFeatures().isEmpty() && JOptionPanes.showOptionDialog(this, "Remove all features?", "Confirm Remove Features", 2, 3, null, null, null) == 0) {
            Object tmp = this.project.getFeatures().clone();
            ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(108)};
            Undoable edit = new Undoable((ExtensibleArray)tmp, events){
                final /* synthetic */ ExtensibleArray val$tmp;
                final /* synthetic */ ChangeEvent[] val$events;
                {
                    this.val$tmp = extensibleArray;
                    this.val$events = changeEventArray;
                }

                @Override
                public boolean undo() {
                    PLOTJ.this.project.getFeatures().copyFrom(this.val$tmp);
                    PLOTJ.this.project.setSelectedItem(null);
                    ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                    PLOTJ.this.project.fireEvents(this.val$events);
                    return true;
                }

                @Override
                public boolean redo() {
                    PLOTJ.this.project.getFeatures().clear();
                    PLOTJ.this.project.setSelectedItem(null);
                    ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                    PLOTJ.this.project.fireEvents(this.val$events);
                    return true;
                }
            };
            edit.undoName = "Undo unannnotate all";
            edit.redoName = "Redo unannnotate all";
            this.project.runEdit(edit);
        }
    }

    private void mnuAnnotateActionPerformed(ActionEvent evt) {
        ArrayList<Feature> f = DefaultLibraries.findFeaturesAsArrayList(this);
        if (f == null || f.isEmpty()) {
            JOptionPanes.showMessageDialog(this, "No library features were found.", "No Features Found", 1);
            return;
        }
        FrmAutoAnnotate frm = new FrmAutoAnnotate(this, true);
        frm.loadFeatures(f);
        frm.setVisible(true);
    }

    private void mnuIncFeatureWidthActionPerformed(ActionEvent evt) {
        this.adjustWidth(1);
    }

    private void adjustOffset(final int byVal) {
        final Feature selectedItem = this.project.getSelectedItem();
        Feature[] selectedItems = this.project.getSelectedItems();
        if (selectedItem == null || selectedItems == null) {
            return;
        }
        final ArrayList<Feature> adjustedFeatures = new ArrayList<Feature>();
        for (Feature f : selectedItems) {
            if (selectedItem.getOffset() + byVal > 150 || selectedItem.getOffset() + byVal < 50) continue;
            adjustedFeatures.add(f);
        }
        if (adjustedFeatures.isEmpty()) {
            return;
        }
        final boolean changed = this.project.isChanged();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                for (Feature f : adjustedFeatures) {
                    f.setOffset(f.getOffset() - byVal);
                }
                if (selectedItem == PLOTJ.this.project.getSelectedItem()) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }

            @Override
            public boolean redo() {
                for (Feature f : adjustedFeatures) {
                    f.setOffset(f.getOffset() + byVal);
                }
                if (selectedItem == PLOTJ.this.project.getSelectedItem()) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(true);
                return true;
            }
        };
        edit.redoName = "Redo feature offset";
        edit.undoName = "Undo feature offset";
        this.project.runEdit(edit);
    }

    private void adjustWidth(final int byVal) {
        final Feature selectedItem = this.project.getSelectedItem();
        Feature[] selectedItems = this.project.getSelectedItems();
        if (selectedItem == null || selectedItems == null) {
            return;
        }
        final ArrayList<Feature> adjustedFeatures = new ArrayList<Feature>();
        for (Feature f : selectedItems) {
            if (!((float)(f.width + byVal) <= f.renderer.maxWidth) || !((float)(f.width + byVal) >= f.renderer.minWidth)) continue;
            adjustedFeatures.add(f);
        }
        if (adjustedFeatures.isEmpty()) {
            return;
        }
        final boolean changed = this.project.isChanged();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                for (Feature f : adjustedFeatures) {
                    f.setWidth(f.getWidth() - byVal);
                }
                if (selectedItem == PLOTJ.this.project.getSelectedItem()) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }

            @Override
            public boolean redo() {
                for (Feature f : adjustedFeatures) {
                    f.setWidth(f.getWidth() + byVal);
                }
                if (selectedItem == PLOTJ.this.project.getSelectedItem()) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(true);
                return true;
            }
        };
        edit.redoName = "Redo feature width";
        edit.undoName = "Undo feature width";
        this.project.runEdit(edit);
    }

    private void adjustWidths(final int byVal) {
        final boolean changed = this.project.isChanged();
        final ArrayList<Feature> adjusted = new ArrayList<Feature>();
        ExtensibleArray<ROI> selF = this.project.getFeatures();
        for (ROI roi : selF) {
            Feature f = (Feature)roi;
            int value1 = f.getWidth();
            f.setWidth(value1 + byVal);
            int value2 = f.getWidth();
            if (value1 == value2) continue;
            f.setWidth(value1);
            adjusted.add(f);
        }
        if (adjusted.isEmpty()) {
            return;
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                boolean adjustSelProps = false;
                for (Feature feat : adjusted) {
                    feat.setWidth(feat.getWidth() - byVal);
                    if (feat != PLOTJ.this.project.getSelectedItem()) continue;
                    adjustSelProps = true;
                }
                if (adjustSelProps) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }

            @Override
            public boolean redo() {
                boolean adjustSelProps = false;
                for (Feature feat : adjusted) {
                    feat.setWidth(feat.getWidth() + byVal);
                    if (feat != PLOTJ.this.project.getSelectedItem()) continue;
                    adjustSelProps = true;
                }
                if (adjustSelProps) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }
        };
        edit.redoName = "Redo feature width";
        edit.undoName = "Undo feature width";
        this.project.runEdit(edit);
    }

    private void adjustOffsets(final int byVal) {
        final boolean changed = this.project.isChanged();
        final ArrayList<Feature> adjusted = new ArrayList<Feature>();
        ExtensibleArray<ROI> features = this.project.getFeatures();
        for (ROI roi : features) {
            Feature f = (Feature)roi;
            int value1 = f.getOffset();
            f.setOffset(value1 + byVal);
            int value2 = f.getOffset();
            if (value1 == value2) continue;
            f.setOffset(value1);
            adjusted.add(f);
        }
        if (adjusted.isEmpty()) {
            return;
        }
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                boolean adjustSelProps = false;
                for (Feature feat : adjusted) {
                    feat.setOffset(feat.getOffset() - byVal);
                    if (feat != PLOTJ.this.project.getSelectedItem()) continue;
                    adjustSelProps = true;
                }
                if (adjustSelProps) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }

            @Override
            public boolean redo() {
                boolean adjustSelProps = false;
                for (Feature feat : adjusted) {
                    feat.setOffset(feat.getOffset() + byVal);
                    if (feat != PLOTJ.this.project.getSelectedItem()) continue;
                    adjustSelProps = true;
                }
                if (adjustSelProps) {
                    PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                }
                PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                PLOTJ.this.project.setChanged(changed);
                return true;
            }
        };
        edit.redoName = "Redo feature offsets";
        edit.undoName = "Undo feature offsets";
        this.project.runEdit(edit);
    }

    private void mnuDecFeatureWidthActionPerformed(ActionEvent evt) {
        this.adjustWidth(-1);
    }

    private void mnuDecFeatureOffsetActionPerformed(ActionEvent evt) {
        this.adjustOffset(-1);
    }

    private void mnuIncFeatureOffsetActionPerformed(ActionEvent evt) {
        this.adjustOffset(1);
    }

    private void mnuIncFeatureWidthsActionPerformed(ActionEvent evt) {
        this.adjustWidths(1);
    }

    private void mnuDecFeatureWidthsActionPerformed(ActionEvent evt) {
        this.adjustWidths(-1);
    }

    private void mnuIncFeatureOffsetsActionPerformed(ActionEvent evt) {
        this.adjustOffsets(1);
    }

    private void mnuDecFeatureOffsetsActionPerformed(ActionEvent evt) {
        this.adjustOffsets(-1);
    }

    private void mnuShowToolWindowActionPerformed(ActionEvent evt) {
        this.dockTools.setDocked(!this.dockTools.isDocked());
        this.requestFocus();
    }

    private void mnuShowSplitWindowActionPerformed(ActionEvent evt) {
        this.dockFeatures.setDocked(!this.dockFeatures.isDocked());
        this.requestFocus();
    }

    private void mnuCheckForUpdatesActionPerformed(ActionEvent evt) {
        FrmUpdate f = new FrmUpdate((Frame)this, true);
        f.setVisible(true);
    }

    private void mnuAboutpLOTActionPerformed(ActionEvent evt) {
        AboutForm f = new AboutForm((Frame)this, true);
        f.setInformation("pLOT Plasmid Plotter", "Version: " + Globals.getVersion(), "Copyright Jean-Marc DeKeyser (C) 2012 - 3012", "Go to the pLOT Facebook page", "https://www.facebook.com/pLOTPlasmidMapper/", "Go to the pLOT blog", "http://www.plasmidplotter.com", Globals.icon);
        f.addLinkLabel("pLOT Wikie Page", "http://www.plasmidplotter.com/wiki/doku.php");
        f.setVisible(true);
    }

    private void mnuSetDatabaseLocationsActionPerformed(ActionEvent evt) {
        PrefsPanel p = new PrefsPanel();
        p.chkShow.setVisible(true);
        if (((Boolean)JMOptionPane.showInputDialog((Component)this, p, "Set pLOT database file locations", null, null, null)).booleanValue()) {
            if (p.uLibChanged) {
                DefaultLibraries.userLibrary.open(p.newULibPath);
                this.findPrimers(this.project);
                this.resetMap();
            }
            if (p.fLibChanged) {
                DefaultLibraries.userFeatures.open(p.newFLibPath);
            }
            if (p.lLibChanged) {
                DefaultLibraries.userLadders.open(p.newLLibPath);
            }
        }
    }

    private void mnuSetFeaturesLibActionPerformed(ActionEvent evt) {
        DefaultLibraries.userFeatures.openFile();
    }

    private void mnuUndockFeaturesActionPerformed(ActionEvent evt) {
        this.dockFeatures.setDocked(false);
    }

    private void mnuDockFeaturesActionPerformed(ActionEvent evt) {
        this.dockFeatures.setDocked(true);
    }

    private void mnuFileMenuSelected(MenuEvent evt) {
        this.mnuFile.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuEditMenuSelected(MenuEvent evt) {
        this.mnuEdit.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuViewMenuSelected(MenuEvent evt) {
        this.mnuView.getPopupMenu().setLightWeightPopupEnabled(false);
        this.updateFrameChecks();
    }

    private void updateFrameChecks() {
        this.chkToggleOverlay.setEnabled(Globals.overlay != null);
        this.chkToggleOverlay.setSelected(this.useOverlay);
        this.mnuToggleFrame1.setSelected(this.editor.isShowFrame1());
        this.mnuToggleFrame2.setSelected(this.editor.isShowFrame2());
        this.mnuToggleFrame3.setSelected(this.editor.isShowFrame3());
        this.mnuToggleFrame4.setSelected(this.editor.isShowFrameA1());
        this.mnuToggleFrame5.setSelected(this.editor.isShowFrameA2());
        this.mnuToggleFrame6.setSelected(this.editor.isShowFrameA3());
        this.mnuToggleAntisense.setSelected(this.editor.isShowAntisense());
        this.mnuToggleNumbers.setSelected(this.editor.isShowNumbers());
    }

    private void mnuToolsMenuSelected(MenuEvent evt) {
        this.mnuTools.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuFeaturesMenuSelected(MenuEvent evt) {
        this.mnuFeatures.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuWindowsMenuSelected(MenuEvent evt) {
        this.mnuWindows.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuAboutMenuSelected(MenuEvent evt) {
        this.mnuAbout.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void mnuCutActionPerformed(ActionEvent evt) {
        this.copyCut(true);
    }

    private void cmdDelSequenceActionPerformed(ActionEvent evt) {
        if (this.canCopyCut() && JOptionPanes.showOptionDialog(this, "Delete the selected sequence?", "Confirm Deletion", 2, 3, null, null, null) == 0) {
            this.deleteSelectedSequence();
            this.statusLabel.setText("Sequence deleted", 3000);
        }
    }

    private void mnuMobileBlocksActionPerformed(ActionEvent evt) {
        Globals.showMolBlocksWindow();
    }

    private void mnuExitActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void mnuCloneWindowActionPerformed(ActionEvent evt) {
        PLOTJ neWindow = Globals.newWindow();
        neWindow.setProject(this.project.clone());
    }

    private void cmbGraphicActionPerformed(ActionEvent evt) {
        this.applyGraphic();
    }

    private void cmbOrientActionPerformed(ActionEvent evt) {
        this.applyOrient();
    }

    private void cmdUndoActionPerformed(ActionEvent evt) {
        if (this.project.canUndo()) {
            this.project.undo();
        }
    }

    private void cmdRedoActionPerformed(ActionEvent evt) {
        if (this.project.canRedo()) {
            this.project.redo();
        }
    }

    private void mnuUndoActionPerformed(ActionEvent evt) {
        this.cmdUndoActionPerformed(null);
    }

    private void mnuRedoActionPerformed(ActionEvent evt) {
        this.cmdRedoActionPerformed(null);
    }

    private void startOffset() {
        if (this.project.getSelectedItem() != null) {
            this.startVal = this.project.getSelectedItem().getOffset();
        }
    }

    private void commitOffset() {
        int stopVal;
        if (this.project.getSelectedItem() != null && this.startVal != (stopVal = this.project.getSelectedItem().getOffset())) {
            final int originalValue = this.startVal;
            final Feature target = this.project.getSelectedItem();
            final boolean changed = this.project.isFeatureChanged;
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(113)};
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    target.setOffset(originalValue);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    target.setOffset(stopVal);
                    PLOTJ.this.propertyChanged(events);
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature offsets";
            edit.undoName = "Undo feature offsets";
            this.project.addEdit(edit);
        }
    }

    private void startDrawOrder() {
        if (this.project.getSelectedItem() != null) {
            this.startVal = this.project.getFeatures().indexOf(this.project.getSelectedItem());
        }
    }

    private void commitDrawOrder() {
        this.undoRedoChangeFeatureIndex(this.project.getSelectedItem(), this.startVal, this.project.getFeatures().indexOf(this.project.getSelectedItem()));
    }

    private void startWidth() {
        if (this.project.getSelectedItem() != null) {
            this.startVal = this.project.getSelectedItem().getWidth();
        }
    }

    private void commitWidth() {
        int stopVal;
        if (this.project.getSelectedItem() != null && this.startVal != (stopVal = this.project.getSelectedItem().getWidth())) {
            final int originalValue = this.startVal;
            final Feature target = this.project.getSelectedItem();
            final boolean changed = this.project.isFeatureChanged;
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    target.setWidth(originalValue);
                    PLOTJ.this.propertyChanged(new ChangeEvent(106), new ChangeEvent(113));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    target.setWidth(stopVal);
                    PLOTJ.this.propertyChanged(new ChangeEvent(106), new ChangeEvent(113));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature width";
            edit.undoName = "Undo feature width";
            this.project.addEdit(edit);
        }
    }

    private void startAlpha() {
        if (this.project.getSelectedItem() != null) {
            this.startVal = this.project.getSelectedItem().getAlpha();
        }
    }

    private void commitAlpha() {
        int stopVal;
        if (this.project.getSelectedItem() != null && this.startVal != (stopVal = this.project.getSelectedItem().getAlpha())) {
            final int originalValue = this.startVal;
            final Feature target = this.project.getSelectedItem();
            final boolean changed = this.project.isFeatureChanged;
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    target.setAlpha(originalValue);
                    PLOTJ.this.propertyChanged(new ChangeEvent(106), new ChangeEvent(108));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    target.setAlpha(stopVal);
                    PLOTJ.this.propertyChanged(new ChangeEvent(106), new ChangeEvent(108));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature alpha";
            edit.undoName = "Undo feature alpha";
            this.project.addEdit(edit);
        }
    }

    private void sldAlphaMousePressed(MouseEvent evt) {
        this.startAlpha();
    }

    private void sldAlphaMouseReleased(MouseEvent evt) {
        this.commitAlpha();
    }

    private void sldRadiusMousePressed(MouseEvent evt) {
        this.startOffset();
    }

    private void sldWidthMousePressed(MouseEvent evt) {
        this.startWidth();
    }

    private void sldWidthMouseReleased(MouseEvent evt) {
        this.commitWidth();
    }

    private void sldRadiusMouseReleased(MouseEvent evt) {
        this.commitOffset();
    }

    private void sldDrawingOrderMousePressed(MouseEvent evt) {
        this.startDrawOrder();
    }

    private void sldDrawingOrderMouseReleased(MouseEvent evt) {
        this.commitDrawOrder();
    }

    private void mnuViewFeaturesListActionPerformed(ActionEvent evt) {
    }

    private void mnuUpperCaseREActionPerformed(ActionEvent evt) {
        this.mnuUpperCaseActionPerformed(evt);
    }

    private void mnuLowerCaseREActionPerformed(ActionEvent evt) {
        this.mnuLowerCaseActionPerformed(evt);
    }

    private void mnuCopyREActionPerformed(ActionEvent evt) {
    }

    private void mnuAddREActionPerformed(ActionEvent evt) {
        if (this.project.getSelectedItem() instanceof EnzymeFeature) {
            EnzymeFeature selFeature = (EnzymeFeature)this.project.getSelectedItem();
            final ProjectEnzyme e = selFeature.enzyme;
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(108)};
            final boolean changed = this.project.isChanged();
            if (!this.project.selectedEnzymes.containsKey(e.enzyme.name)) {
                this.project.runEdit(new Undoable(){

                    @Override
                    public boolean undo() {
                        ((PLOTJ)PLOTJ.this).project.selectedEnzymes.remove(e.enzyme.name);
                        PLOTJ.this.project.setSelectedItem(null, false);
                        ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                        PLOTJ.this.project.updateREs();
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(changed);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        ((PLOTJ)PLOTJ.this).project.selectedEnzymes.add(e);
                        PLOTJ.this.project.setSelectedItem(null, false);
                        ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                        PLOTJ.this.project.updateREs();
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(true);
                        return true;
                    }
                });
            }
        }
    }

    private void mnuRemoveREActionPerformed(ActionEvent evt) {
        if (this.project.getSelectedItem() instanceof EnzymeFeature) {
            EnzymeFeature selFeature = (EnzymeFeature)this.project.getSelectedItem();
            final ProjectEnzyme e = selFeature.enzyme;
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(108)};
            final boolean changed = this.project.isChanged();
            if (this.project.selectedEnzymes.containsKey(e.enzyme.name)) {
                this.project.runEdit(new Undoable(){

                    @Override
                    public boolean undo() {
                        ((PLOTJ)PLOTJ.this).project.selectedEnzymes.add(e);
                        ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                        PLOTJ.this.project.updateREs();
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(changed);
                        PLOTJ.this.project.setSelectedItem(null);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        ((PLOTJ)PLOTJ.this).project.selectedEnzymes.remove(e.enzyme.name);
                        ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                        PLOTJ.this.project.updateREs();
                        PLOTJ.this.propertyChanged(events);
                        PLOTJ.this.project.setChanged(true);
                        PLOTJ.this.project.setSelectedItem(null);
                        return true;
                    }
                });
            }
        }
    }

    private void mnuShowHelpActionPerformed(ActionEvent evt) {
        this.showHelp("plot_main");
    }

    private void setTheme(String themeName) {
        Themes.setTheme(themeName, "pLOT", "plot_theme", this, true);
    }

    private void mnuAddAsMixActionPerformed(ActionEvent evt) {
        if (this.project.selectedItems.size() > 1) {
            final EnzymeMix newMix = new EnzymeMix();
            for (Feature f : this.project.selectedItems) {
                if (!(f instanceof EnzymeFeature)) continue;
                newMix.addEnzyme(((EnzymeFeature)f).enzyme.enzyme.name);
            }
            if (newMix.enzymes.length > 1 && !this.project.enzymeMixes.containsKey(newMix.getName())) {
                final boolean changed = this.project.isChanged();
                Undoable edit = new Undoable(){

                    @Override
                    public boolean undo() {
                        ((PLOTJ)PLOTJ.this).project.enzymeMixes.remove(newMix.getName());
                        PLOTJ.this.propertyChanged(new ChangeEvent(107));
                        PLOTJ.this.project.setChanged(changed);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        ((PLOTJ)PLOTJ.this).project.enzymeMixes.add(newMix, newMix.getName());
                        PLOTJ.this.propertyChanged(new ChangeEvent(107));
                        PLOTJ.this.project.setChanged(true);
                        return true;
                    }
                };
                this.project.runEdit(edit);
            }
        }
    }

    private void mnuFontTestActionPerformed(ActionEvent evt) {
        Font cFont;
        this.editor.setFont(cFont.deriveFont((cFont = this.editor.getFont()).getSize() == 24 ? 18.0f : 24.0f));
    }

    private void chkToggleOverlayActionPerformed(ActionEvent evt) {
        this.toggleOverlay(!this.useOverlay);
    }

    private void toggleOverlay(boolean useOverlay) {
        if (useOverlay != this.useOverlay) {
            this.useOverlay = useOverlay;
            this.picMap.repaint();
            if (this.gelForm != null) {
                this.gelForm.useOverlay = useOverlay;
                this.gelForm.reDraw(true);
            }
        }
    }

    private void cmdToggleOverlayActionPerformed(ActionEvent evt) {
        this.toggleOverlay(this.cmdToggleOverlay.isSelected());
    }

    void updateToolPlugins() {
        PluginLoader.removePluginsFrom(this.mainMenuBar);
        PluginLoader.removePluginsFrom(this.mainToolBar);
        this.mnuPlugins.removeAll();
        boolean foundMenuPlugin = false;
        boolean foundMenuBarPlugin = false;
        ArrayList<PluginsObject> packages = new ArrayList<PluginsObject>();
        ArrayList<JMenuItem> menuBarItems = new ArrayList<JMenuItem>();
        for (PluginPackage pluginPackage : Globals.defaultPluginPackages) {
            packages.add(pluginPackage);
        }
        for (PluginPackage pluginPackage : Globals.loadedPluginPackages) {
            packages.add(pluginPackage);
        }
        packages.sort(new Comparator<PluginsObject>(){

            @Override
            public int compare(PluginsObject o1, PluginsObject o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        if (!packages.isEmpty()) {
            for (PluginPackage pluginPackage : packages) {
                PluginCollection[] collections = pluginPackage.getCollections();
                Plugin[] pPlugins = pluginPackage.getPlugins();
                if (collections == null && pPlugins == null) continue;
                JMenu packMenu = null;
                menuBarItems.clear();
                if (collections != null) {
                    boolean newDefMenu = false;
                    PluginCollection[] pluginCollectionArray = collections;
                    int n = pluginCollectionArray.length;
                    for (int i = 0; i < n; ++i) {
                        PluginCollection c = pluginCollectionArray[i];
                        boolean toolBarItem = c.getProperty("ToolBarItem", false);
                        boolean menuBarItem = c.getProperty("MenuBarItem", false);
                        boolean defaultMenuItem = c.getProperty("DefaultMenuItem", true);
                        if (toolBarItem) {
                            List<JButton> buttons = Globals.loader.addPluginPackageTo(c, this.mainToolBar);
                            for (JButton b : buttons) {
                                b.addMouseListener(this.menuMouseListener);
                                b.setOpaque(false);
                                b.setContentAreaFilled(false);
                            }
                        }
                        if (menuBarItem) {
                            menuBarItems.add(c.getMenu(this.menuMouseListener));
                            continue;
                        }
                        if (!defaultMenuItem && toolBarItem) continue;
                        if (packMenu == null) {
                            packMenu = PluginLoader.menuItemFor(pluginPackage, this.menuMouseListener);
                        }
                        packMenu.add(c.getMenu(this.menuMouseListener));
                    }
                    if (newDefMenu) {
                        this.mnuPlugins.add(packMenu);
                    }
                }
                if (pPlugins != null) {
                    for (Plugin p : pPlugins) {
                        boolean toolBarItem = p.getProperty("ToolBarItem", false);
                        boolean menuBarItem = p.getProperty("MenuBarItem", false);
                        boolean defaultMenuItem = p.getProperty("DefaultMenuItem", true);
                        if (toolBarItem) {
                            JButton button = PluginLoader.buttonFor(p, this.menuMouseListener);
                            button.setContentAreaFilled(false);
                            this.mainToolBar.add(button);
                        }
                        if (menuBarItem) {
                            menuBarItems.add(PluginLoader.menuItemFor(p, this.menuMouseListener));
                            foundMenuBarPlugin = true;
                            continue;
                        }
                        if (!defaultMenuItem && toolBarItem) continue;
                        if (packMenu == null) {
                            packMenu = PluginLoader.menuItemFor(pluginPackage, this.menuMouseListener);
                        }
                        packMenu.add(PluginLoader.menuItemFor(p, this.menuMouseListener));
                        foundMenuPlugin = true;
                    }
                }
                if (!menuBarItems.isEmpty()) {
                    if (menuBarItems.size() == 1 && menuBarItems.get(0) instanceof JMenu) {
                        this.mainMenuBar.add((JMenu)menuBarItems.get(0), this.mainMenuBar, this.mainMenuBar.getComponentCount() - 1);
                    } else {
                        JMenu barMenu = PluginLoader.menuItemFor(pluginPackage, this.menuMouseListener);
                        barMenu.setIcon(null);
                        for (JMenuItem item : menuBarItems) {
                            barMenu.add(item);
                        }
                        this.mainMenuBar.add(barMenu, this.mainMenuBar, this.mainMenuBar.getComponentCount() - 1);
                    }
                    foundMenuBarPlugin = true;
                }
                if (packMenu == null) continue;
                this.mnuPlugins.add(packMenu);
                foundMenuPlugin = true;
            }
        }
        if (foundMenuPlugin) {
            this.mnuPlugins.add((Component)this.sepPlugins, 0);
        }
        this.mnuPlugins.add((Component)this.mnuLoadPlugins, 0);
        this.mnuPlugins.add((Component)this.sepLoadTools, 0);
        this.mnuPlugins.add(this.sepPlugins1);
        if (foundMenuBarPlugin) {
            PluginLoader.sortMenuBarMenusOnly(this.mainMenuBar);
        }
    }

    private void loadPackagesFromArray(ArrayList<PluginPackage> found) {
        int loaded = 0;
        int notLoaded = 0;
        if (found != null && !found.isEmpty()) {
            for (PluginPackage p : found) {
                boolean foundPack = false;
                for (PluginPackage pack : Globals.defaultPluginPackages) {
                    if (!pack.getName().equals(p.getName()) || !pack.getAuthor().equals(p.getAuthor()) || !pack.getDescription().equals(p.getDescription())) continue;
                    foundPack = true;
                    break;
                }
                if (!foundPack) {
                    for (PluginPackage pack : Globals.loadedPluginPackages) {
                        if (!pack.getName().equals(p.getName()) || !pack.getAuthor().equals(p.getAuthor()) || !pack.getDescription().equals(p.getDescription())) continue;
                        foundPack = true;
                        break;
                    }
                }
                if (foundPack) continue;
                Globals.loadedPluginPackages.add(p);
                loaded += p.getAllPluginCount();
            }
            if (loaded > 0 || notLoaded > 0) {
                JOptionPanes.showMessageDialog(this, loaded + " plugins loaded.  " + (notLoaded > 0 ? "\n" + notLoaded + " plugins not loaded due to conflicting path/name" : ""), "Plugins loaded", 1);
                if (loaded > 0) {
                    this.updateToolPlugins();
                }
            } else {
                JOptionPanes.showMessageDialog(this, "No plugins found.", "Plugins load failed", 1);
            }
        }
    }

    private void mnuLoadPluginsActionPerformed(ActionEvent evt) {
        ArrayList<PluginPackage> foundPackages = Globals.loader.loadPluginPackagesFrom(this);
        this.loadPackagesFromArray(foundPackages);
    }

    private void formWindowActivated(WindowEvent evt) {
        Globals.instance = this;
    }

    private void mnuExportMapActionPerformed(ActionEvent evt) {
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame1(!this.editor.isShowFrame1());
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame2(!this.editor.isShowFrame2());
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame3(!this.editor.isShowFrame3());
    }

    private void mnuToggleFrame4ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA1(!this.editor.isShowFrameA1());
    }

    private void mnuToggleFrame5ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA2(!this.editor.isShowFrameA2());
    }

    private void mnuToggleFrame6ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA3(!this.editor.isShowFrameA3());
    }

    private void mnuToggleAntisenseActionPerformed(ActionEvent evt) {
        this.editor.setShowAntisense(!this.editor.isShowAntisense());
    }

    private void mnuToggleNumbersActionPerformed(ActionEvent evt) {
        this.editor.setShowNumbers(!this.editor.isShowNumbers());
    }

    private void cmdOpenMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            ImageIcon searchIcon = new ImageIcon(ScrollSearchPopupMenu.class.getResource("/images24/Search2.png"));
            ScrollSearchPopupMenu popupMenu = new ScrollSearchPopupMenu(searchIcon);
            this.cmdOpen.setComponentPopupMenu(popupMenu);
            String[] files = Globals.history.getAll("pLOT_FilePath", 200);
            if (files == null || files.length < 1) {
                return;
            }
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images24/pLOT_Icon.png"));
            JPopupMenu.Separator filesSep = new JPopupMenu.Separator();
            filesSep.setToolTipText("History");
            filesSep.setUI(new RenderedMenuSeparatorUI(1));
            filesSep.addMouseListener(this.menuMouseListener);
            popupMenu.add(filesSep);
            for (int x = 0; x < files.length; ++x) {
                if (files[x] == null || files[x].length() <= 0) continue;
                File file = new File(files[x]);
                JMenuItem newMenu = new JMenuItem(file.getName(), icon);
                newMenu.addActionListener(new FileActionListener(file));
                newMenu.setToolTipText(" Open " + file.getAbsolutePath());
                newMenu.addMouseListener(this.menuMouseListener);
                popupMenu.add(newMenu);
            }
            popupMenu.setLightWeightPopupEnabled(false);
            popupMenu.showPopup(this.cmdOpen, 0, this.cmdOpen.getHeight());
        }
    }

    private void cmdShowPrimersActionPerformed(ActionEvent evt) {
        this.updatePrimers();
    }

    private void updatePrimers() {
        this.project.showPrimers = this.cmdShowPrimers.isSelected();
        Feature f = this.project.getSelectedItem();
        if (f != null && f instanceof PrimerFeature) {
            this.project.setSelectedItem(null);
        }
        Globals.history.getUserPref().putBoolean("showPrimers", this.project.showPrimers);
        this.resetMap();
    }

    private void cmdShowPrimersMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.primersPopupMenu.setSearchText("");
            this.primersPopupMenu.showPopup(this.cmdShowPrimers, 0, this.cmdShowPrimers.getHeight());
        }
    }

    void showHelp(String linkName) {
        if (this.frmHelp == null) {
            this.frmHelp = new FrmHelp();
            this.frmHelp.setTitle("pLOT Help");
            this.frmHelp.setIconImage(Globals.icon.getImage());
        }
        if (linkName != null && linkName.length() > 0) {
            this.frmHelp.openLink(linkName);
        }
        this.frmHelp.setVisible(true);
    }

    private void deleteSelectedSequence() {
        if (this.canCopyCut()) {
            this.project.runRestorePointUndoable(new UndoableAction(){

                @Override
                public boolean run() {
                    Feature selectedItem = PLOTJ.this.project.getSelectedItem();
                    PLOTJ.this.project.delete(selectedItem.getStart(), selectedItem.getStop());
                    PLOTJ.this.project.setChanged(true);
                    PLOTJ.this.project.setSelectedItem(null);
                    ((PLOTJ)PLOTJ.this).project.mouseoverItem = null;
                    PLOTJ.this.toolTip.setText(null);
                    PLOTJ.this.editor.setDNASequence("");
                    PLOTJ.this.findPrimers(PLOTJ.this.project);
                    PLOTJ.this.findEnzymes(PLOTJ.this.project);
                    return true;
                }
            }, "remove feature.");
        }
    }

    private void setFeatureGraphic(final FeatureRenderer feature) {
        final Feature[] features = this.project.getSelectedItems(0);
        if (features == null) {
            return;
        }
        final FeatureRenderer[] origAbstractFeature = new FeatureRenderer[features.length];
        for (int x = 0; x < features.length; ++x) {
            origAbstractFeature[x] = features[x].renderer;
        }
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null && !selectedItem.renderer.equals(feature)) {
            final boolean changed = this.project.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    boolean isSelected = false;
                    for (int x = 0; x < features.length; ++x) {
                        features[x].setGraphicStyle(origAbstractFeature[x]);
                        if (features[x] != PLOTJ.this.project.getSelectedItem()) continue;
                        isSelected = true;
                    }
                    if (isSelected) {
                        PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                    }
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(changed);
                    return true;
                }

                @Override
                public boolean redo() {
                    boolean isSelected = false;
                    for (int x = 0; x < features.length; ++x) {
                        features[x].setGraphicStyle(feature);
                        if (features[x] != PLOTJ.this.project.getSelectedItem()) continue;
                        isSelected = true;
                    }
                    if (isSelected) {
                        PLOTJ.this.project.fireEvents(new ChangeEvent(113));
                    }
                    PLOTJ.this.project.fireEvents(new ChangeEvent(106));
                    PLOTJ.this.project.setChanged(true);
                    return true;
                }
            };
            edit.redoName = "Redo feature graphic";
            edit.undoName = "Undo feature graphic";
            this.project.runEdit(edit);
        }
    }

    private boolean OKtoClose() {
        if (this.project.isChanged()) {
            int val = JOptionPanes.showConfirmDialog(this, "Save changes before closing project?", "Save changes?", 3, 1);
            switch (val) {
                case -1: 
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 0: {
                    return this.saveFile();
                }
            }
        }
        return true;
    }

    void resetMap() {
        this.canvasBuffer = null;
        this.picMap.displayPanel.repaint();
    }

    private void regenMap() {
        this.canvasBuffer = new BufferedImage(this.panelWidth, this.panelHeight, 6);
        this.canvasGraphics = (Graphics2D)this.canvasBuffer.getGraphics();
        this.canvasGraphics.setFont(this.picMap.getFont());
        this.fontMetric = this.canvasGraphics.getFontMetrics();
        this.canvasGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.canvasGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.project.length() == 0 && Globals.watermark != null) {
            Globals.watermark.paintIcon(this, this.canvasGraphics, (this.panelWidth - Globals.watermark.getIconWidth()) / 2, (this.panelHeight - Globals.watermark.getIconHeight()) / 2);
            return;
        }
        this.project.setMapSize(this.panelWidth, this.panelHeight);
        if (this.project.isCircular()) {
            this.regenMapCircular();
        } else {
            this.regenMapLinear();
        }
    }

    private void regenMapLinear() {
        int labelY = this.panelHeight / 2;
        int bendY = (labelY + this.project.centerLinY) / 2;
        atLinear = this.canvasGraphics.getTransform();
        this.cAT = (AffineTransform)atLinear.clone();
        this.rAT = (AffineTransform)atLinear.clone();
        this.rAT.setToRotation(-1.5707963267948966, labelY, 0.0);
        if (this.project.zoomFactor != 1.0f) {
            if (this.project.zoomFactor > 1.0f) {
                this.cAT.translate(-this.project.xOffset, -this.project.yOffset);
                this.rAT.translate((double)this.project.yOffset + this.project.pCircle.getCenterY() - this.project.pCircle.getCenterY() * (double)this.project.zoomFactor, -labelY - this.project.xOffset);
            } else {
                this.cAT.translate(this.project.pCircle.getCenterX() - this.project.pCircle.getCenterX() * (double)this.project.zoomFactor, this.project.pCircle.getCenterY() - this.project.pCircle.getCenterY() * (double)this.project.zoomFactor);
                this.rAT.translate(this.project.yOffset, (double)(-labelY - this.project.xOffset) + (this.project.pCircle.getCenterX() - this.project.pCircle.getCenterX() * (double)this.project.zoomFactor));
            }
            this.cAT.scale(this.project.zoomFactor, this.project.zoomFactor);
            this.rAT.scale(this.project.zoomFactor, this.project.zoomFactor);
            this.canvasGraphics.setTransform(this.cAT);
        } else {
            this.rAT.translate(0.0, -labelY);
        }
        if (this.project.length() > 0) {
            int x;
            this.canvasGraphics.setColor(Color.BLACK);
            this.canvasGraphics.setStroke(new BasicStroke(2.0f));
            this.canvasGraphics.setFont(this.picMap.getFont());
            FontMetrics fm = this.canvasGraphics.getFontMetrics();
            this.titleRect.width = fm.stringWidth(this.project.getName());
            this.titleRect.height = fm.getAscent();
            this.titleRect.x = (int)(this.project.pCircle.centerX - (double)(this.titleRect.width / 2));
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
            String SizeString = numberFormat.format(this.project.length()) + "bp";
            int sizeWidth = fm.stringWidth(SizeString);
            this.project.centerLinY = this.panelHeight * 3 / 4;
            this.canvasGraphics.setStroke(new BasicStroke(2.0f));
            this.canvasGraphics.setColor(Color.BLACK);
            this.canvasGraphics.drawLine(10, this.project.centerLinY, this.panelWidth - 10, this.project.centerLinY);
            this.titleRect.y = this.panelHeight - this.titleRect.height - 10;
            this.canvasGraphics.setFont(Globals.LABELFONTB);
            this.canvasGraphics.drawString(this.project.getName(), this.titleRect.x, this.titleRect.y);
            this.canvasGraphics.drawString(SizeString, (int)(this.project.pCircle.centerX - (double)(sizeWidth / 2)), (int)((double)this.titleRect.y + (double)this.titleRect.height * 1.5));
            int titleHighlightBuffer = 3;
            this.titleRect.x -= titleHighlightBuffer;
            this.titleRect.y = this.titleRect.y - this.titleRect.height - titleHighlightBuffer;
            this.titleRect.width += 2 * titleHighlightBuffer;
            this.titleRect.height = (this.titleRect.height + titleHighlightBuffer) * 2;
            this.canvasGraphics.setFont(Globals.LABELFONT);
            if (this.project.needPaths) {
                for (x = this.project.getFeatures().size() - 1; x >= 0; --x) {
                    this.generatePaths((Feature)this.project.getFeatures().get(x));
                }
                this.project.needPaths = false;
            }
            this.space_Labels_Horizontal();
            if (!this.left.isEmpty()) {
                for (Feature f : this.left) {
                    String caption = f.getLabelText();
                    f.label.labelRect.width = this.canvasGraphics.getFontMetrics().stringWidth(caption);
                    f.label.labelRect.x += f.label.labelRect.height / 2;
                    f.label.point3.x = f.label.labelRect.y - f.label.labelRect.height / 2;
                    f.label.point1.y = this.project.centerLinY;
                    f.label.point2.y = bendY;
                    f.label.point3.x = f.label.labelRect.x - f.label.labelRect.height / 2;
                    f.label.point3.y = labelY + 3;
                    f.label.labelRect = new Rectangle(f.label.labelRect.x - f.label.labelRect.height, labelY - f.label.labelRect.width, f.label.labelRect.height, f.label.labelRect.width);
                    if (f instanceof PrimerFeature) {
                        this.canvasGraphics.setFont(this.leftPrimerFont);
                    } else if (f instanceof EnzymeFeature) {
                        this.canvasGraphics.setFont(this.leftREFont);
                    } else {
                        this.canvasGraphics.setFont(this.leftFont);
                    }
                    this.drawLabel(f, this.canvasGraphics, false);
                }
            }
            for (x = this.project.getFeatures().size() - 1; x >= 0; --x) {
                this.draw((Feature)this.project.getFeatures().get(x), this.canvasGraphics);
            }
        }
        this.project.needPaths = false;
        this.canvasGraphics.setTransform(atLinear);
    }

    private void regenMapCircular() {
        this.project.calcRadians();
        AffineTransform AT = this.canvasGraphics.getTransform();
        this.cAT = (AffineTransform)AT.clone();
        if (this.project.zoomFactor != 1.0f) {
            if (this.project.zoomFactor > 1.0f) {
                this.cAT.translate(-this.project.xOffset, -this.project.yOffset);
            } else {
                this.cAT.translate(this.project.pCircle.getCenterX() - this.project.pCircle.getCenterX() * (double)this.project.zoomFactor, this.project.pCircle.getCenterY() - this.project.pCircle.getCenterY() * (double)this.project.zoomFactor);
            }
            this.cAT.scale(this.project.zoomFactor, this.project.zoomFactor);
            this.canvasGraphics.setTransform(this.cAT);
        }
        if (this.project.length() > 0) {
            this.canvasGraphics.setColor(Color.BLACK);
            this.canvasGraphics.setStroke(new BasicStroke(2.0f));
            this.canvasGraphics.setFont(this.picMap.getFont());
            FontMetrics fm = this.canvasGraphics.getFontMetrics();
            this.titleRect.width = fm.stringWidth(this.project.getName());
            this.titleRect.height = fm.getAscent();
            this.titleRect.x = (int)(this.project.pCircle.centerX - (double)(this.titleRect.width / 2));
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
            String SizeString = numberFormat.format(this.project.length()) + "bp";
            int sizeWidth = fm.stringWidth(SizeString);
            this.canvasGraphics.draw(this.project.pCircle);
            this.titleRect.y = (int)(this.project.pCircle.centerY - (double)(this.titleRect.height / 2));
            this.canvasGraphics.setFont(Globals.LABELFONTB);
            this.canvasGraphics.drawString(this.project.getName(), this.titleRect.x, this.titleRect.y);
            this.canvasGraphics.drawString(SizeString, (int)(this.project.pCircle.centerX - (double)(sizeWidth / 2)), (int)((double)this.titleRect.y + (double)this.titleRect.height * 1.5));
            int titleHighlightBuffer = 3;
            this.titleRect.x -= titleHighlightBuffer;
            this.titleRect.y = this.titleRect.y - this.titleRect.height - titleHighlightBuffer;
            this.titleRect.width += 2 * titleHighlightBuffer;
            this.titleRect.height = (this.titleRect.height + titleHighlightBuffer) * 2;
            ExtensibleArray<ROI> features = this.project.getFeatures();
            if (!(features.isEmpty() && this.project.foundEnzymes.isEmpty() && this.project.foundPrimers.isEmpty())) {
                Feature f;
                int x;
                this.canvasGraphics.setFont(Globals.LABELFONT);
                if (this.project.needPaths) {
                    for (x = features.size() - 1; x >= 0; --x) {
                        this.generatePaths((Feature)features.get(x));
                    }
                    this.project.needPaths = false;
                }
                if (!this.project.labelsCircular) {
                    this.space_Labels_Circle();
                }
                if (!this.left.isEmpty()) {
                    for (x = this.left.size() - 1; x >= 0; --x) {
                        f = this.left.get(x);
                        if (f instanceof PrimerFeature) {
                            this.canvasGraphics.setFont(this.leftPrimerFont);
                        } else if (f instanceof EnzymeFeature) {
                            this.canvasGraphics.setFont(this.leftREFont);
                        } else {
                            this.canvasGraphics.setFont(this.leftFont);
                        }
                        this.drawLabel(f, this.canvasGraphics);
                    }
                }
                if (!this.right.isEmpty()) {
                    for (x = this.right.size() - 1; x >= 0; --x) {
                        f = this.right.get(x);
                        if (f instanceof PrimerFeature) {
                            this.canvasGraphics.setFont(this.rightPrimerFont);
                        } else if (f instanceof EnzymeFeature) {
                            this.canvasGraphics.setFont(this.rightREFont);
                        } else {
                            this.canvasGraphics.setFont(this.rightFont);
                        }
                        this.drawLabel(f, this.canvasGraphics);
                    }
                }
                for (x = features.size() - 1; x >= 0; --x) {
                    this.draw((Feature)features.get(x), this.canvasGraphics);
                }
            }
        }
        this.project.needPaths = false;
        if (AT != null) {
            this.canvasGraphics.setTransform(AT);
        }
    }

    private void drawMap(Graphics gImage, int width, int height) {
        if (this.canvasBuffer == null || width != this.panelWidth || height != this.panelHeight) {
            this.panelHeight = height;
            this.panelWidth = width;
            this.regenMap();
        }
        gImage.setColor(Color.white);
        gImage.fillRect(0, 0, this.panelWidth, this.panelHeight);
        Graphics2D g2d = (Graphics2D)gImage;
        if (this.gelBand != null) {
            AffineTransform AT = null;
            if (this.cAT != null) {
                AT = g2d.getTransform();
                g2d.setTransform(this.cAT);
            }
            gImage.setColor(Globals.gelBandColor);
            if (this.project.isCircular()) {
                Circle circle = Globals.extendArc ? this.project.jCircle : this.project.pCircle;
                double start = FeatureRenderer.bpToDegree(this.gelBand.getStart(), this.project.length());
                double stop = FeatureRenderer.bpToDegree(this.gelBand.getStop(), this.project.length());
                double arc = start > stop ? stop - start : -(360.0 - stop + start);
                g2d.fillArc((int)circle.x, (int)circle.y, (int)circle.width, (int)circle.height, (int)start, (int)arc);
            } else {
                int startX = this.project.bpToX(this.gelBand.getStart());
                if (this.gelBand.getStart() < this.gelBand.getStop()) {
                    g2d.fillRect(startX, 0, this.project.bpToX(this.gelBand.getStop()) - startX, this.project.centerLinY);
                } else {
                    g2d.fillRect(10, 0, this.project.bpToX(this.gelBand.getStop()) - 10, this.project.centerLinY);
                    g2d.fillRect(startX, 0, this.project.bpToX(this.project.length()) - startX, this.project.centerLinY);
                }
            }
            if (AT != null) {
                g2d.setTransform(AT);
            }
        }
        gImage.drawImage(this.canvasBuffer, 0, 0, null);
        Feature selectedItem = this.project.getSelectedItem();
        if (selectedItem != null || this.project.mouseoverItem != null) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            AffineTransform AT = null;
            if (this.cAT != null) {
                AT = g2d.getTransform();
                g2d.setTransform(this.cAT);
            }
            if (!this.project.selectedItems.isEmpty()) {
                for (Feature f : this.project.selectedItems) {
                    if (f == null) continue;
                    this.drawFocusedItem(g2d, f, f == this.project.mouseoverItem);
                }
            }
            if (this.project.mouseoverItem != null && this.project.getSelectedItem() != this.project.mouseoverItem) {
                this.drawFocusedItem(g2d, this.project.mouseoverItem, true);
            }
            if (AT != null) {
                g2d.setTransform(AT);
            }
        }
        if (this.useOverlay) {
            gImage.setColor(Globals.overlay);
            gImage.fillRect(0, 0, this.panelWidth, this.panelHeight);
        }
    }

    private void drawFocusedItem(Graphics2D g2d, Feature f, boolean highlightLinked) {
        if (f instanceof PrimerFeature) {
            PrimerFeature[] list;
            g2d.setFont(this.isOnLeft(f) ? this.leftPrimerFont : this.rightPrimerFont);
            this.drawLabel(f, g2d, true);
            if (highlightLinked && (list = this.project.linkedPrimers.get(((PrimerFeature)f).foundPrimer.refPrimer.searchSeq)) != null) {
                for (PrimerFeature pf : list) {
                    if (f == pf || !this.shownPrimer(pf)) continue;
                    g2d.setFont(this.isOnLeft(pf) ? this.leftPrimerFont : this.rightPrimerFont);
                    this.drawLabel(pf, g2d, true);
                }
            }
        } else if (f instanceof EnzymeFeature) {
            EnzymeFeature[] list;
            g2d.setFont(this.isOnLeft(f) ? this.leftREFont : this.rightREFont);
            this.drawLabel(f, g2d, true);
            EnzymeFeature e = (EnzymeFeature)f;
            if (highlightLinked && (list = this.project.linkedEnzymes.get(e.enzyme.enzyme.name)) != null) {
                for (EnzymeFeature ef : list) {
                    if (f == ef) continue;
                    g2d.setFont(this.isOnLeft(ef) ? this.leftREFont : this.rightREFont);
                    this.drawLabel(ef, g2d, true);
                }
            }
        } else {
            if (this.project.showLabels) {
                g2d.setFont(this.isOnLeft(f) ? this.leftFont : this.rightFont);
                this.drawLabel(f, g2d, true);
            }
            this.draw(f, g2d);
            this.draw(f, g2d, true);
        }
    }

    void updateMain() {
        if (this.project.getSelectedItem() != null) {
            this.propertyChanged(new ChangeEvent(106), new ChangeEvent(108));
        } else {
            this.propertyChanged(new ChangeEvent(106));
        }
    }

    private void hScrollChanged(int value) {
        this.project.xOffset = value;
        this.resetMap();
    }

    private void vScrollChanged(int value) {
        this.project.yOffset = value;
        this.resetMap();
    }

    void setPlasmidEditEnabled(boolean enabled) {
        this.chkCircular.setEnabled(enabled);
        this.txtPlasmidName.setEnabled(enabled);
        this.txtSource.setEnabled(enabled);
        this.txtOrg.setEnabled(enabled);
        this.lblEditNotes.setEnabled(enabled);
        this.lblEditAnnotations.setEnabled(enabled);
        this.lblEditReferences.setEnabled(enabled);
    }

    void setEditorSourceValue(String value) {
        this.txtSource.setText(this.project.getSource());
    }

    void setEditorOrgValue(String value) {
        this.txtOrg.setText(this.project.getOrganism());
    }

    void setEditorAccessionValue(String value) {
    }

    private boolean isOnLeft(Feature f) {
        return !this.project.isCircular() || (f.isAntisense() ? f.getStop() : f.getStart()) > this.project.length() / 2;
    }

    private void getSizedFont(int availableSize, int itemCount, boolean left) {
        Font f = this.canvasGraphics.getFont().deriveFont(1);
        FontMetrics fm = this.canvasGraphics.getFontMetrics(f);
        int ascent = fm.getAscent() + fm.getDescent() + fm.getLeading();
        float size = f.getSize();
        while (size > 0.0f && itemCount * ascent > availableSize) {
            f = f.deriveFont(size -= 1.0f);
            fm = this.canvasGraphics.getFontMetrics(f);
            ascent = fm.getAscent() + fm.getDescent() + fm.getLeading();
        }
        if (left) {
            this.leftFont = f;
            this.leftPrimerFont = f.deriveFont(2);
            this.leftREFont = f.deriveFont(0);
            this.leftFontHt = ascent;
            this.leftFM = fm;
            this.leftFMP = this.canvasGraphics.getFontMetrics(this.leftPrimerFont);
            this.leftFME = this.canvasGraphics.getFontMetrics(this.leftREFont);
        } else {
            this.rightFont = f;
            this.rightPrimerFont = f.deriveFont(2);
            this.rightREFont = f.deriveFont(0);
            this.rightFontHt = ascent;
            this.rightFM = fm;
            this.rightFMP = this.canvasGraphics.getFontMetrics(this.rightPrimerFont);
            this.rightFME = this.canvasGraphics.getFontMetrics(this.rightREFont);
        }
    }

    private boolean shownPrimer(PrimerFeature pFeature) {
        return pFeature.foundPrimer.refPrimer.category.shown && pFeature.showLabel() && (pFeature.isAntisense() && this.showAntisensePrimers || !pFeature.isAntisense() && this.showSensePrimers) && (pFeature.foundPrimer.refPrimer.isDefault && this.project.showDefaultPrimers || !pFeature.foundPrimer.refPrimer.isDefault && this.project.showUserPrimers);
    }

    private void space_Labels_Horizontal() {
        ExtensibleArray<Feature> tmpLeft = new ExtensibleArray<Feature>(Feature.class);
        this.left.clear();
        this.right.clear();
        ExtensibleArray<ROI> features = this.project.getFeatures();
        if (this.project.length() == 0 || this.project.foundEnzymes.isEmpty() && this.project.foundPrimers.isEmpty() && features.isEmpty()) {
            return;
        }
        for (int x = features.size() - 1; x >= 0; --x) {
            Feature feature = (Feature)features.get(x);
            if (!this.project.showLabels || feature == null || !feature.showLabel()) continue;
            tmpLeft.add(feature);
            this.left.add(feature);
        }
        if (this.project.showPrimers && !this.project.foundPrimers.isEmpty()) {
            for (PrimerFeature primer : this.project.foundPrimers) {
                if (!this.shownPrimer(primer)) continue;
                tmpLeft.add(primer);
                this.left.add(primer);
            }
        }
        if (this.project.showEnzymes && !this.project.foundEnzymes.isEmpty()) {
            for (EnzymeFeature enzyme : this.project.foundEnzymes) {
                if (!enzyme.showLabel()) continue;
                tmpLeft.add(enzyme);
                this.left.add(enzyme);
            }
        }
        if (!tmpLeft.isEmpty()) {
            int min = 4;
            int lblY1 = this.panelWidth / 4;
            int lblY2 = this.panelWidth / 3;
            tmpLeft.sort(this.c2);
            this.getSizedFont(this.panelWidth - 8, tmpLeft.size(), true);
            ObjectSpacer.clearList();
            ObjectSpacer.setMinMax(min, this.panelWidth - 4);
            for (Feature feature : tmpLeft) {
                int x = this.project.bpToX(feature.isAntisense() ? (double)feature.getStop() : (double)feature.getStart());
                feature.label.point1 = new Point2D.Double(x, this.project.centerLinY);
                feature.label.point2 = new Point2D.Double(x, lblY2);
                feature.label.point3 = new Point2D.Double(x, lblY1);
                feature.label.labelRect = feature instanceof EnzymeFeature ? new Rectangle(x, lblY1, this.leftFME.stringWidth(feature.getLabelText()), this.leftFontHt) : (feature instanceof PrimerFeature ? new Rectangle(x, lblY1, this.leftFMP.stringWidth(feature.getLabelText()), this.leftFontHt) : new Rectangle(x, lblY1, this.leftFM.stringWidth(feature.getLabelText()), this.leftFontHt));
                ObjectSpacer.add(new SpacedRectV(feature.label.labelRect));
            }
            ObjectSpacer.spaceObjects();
        }
    }

    private void space_Labels_Circle() {
        double offset;
        int start;
        ExtensibleArray<Feature> tmpLeft = new ExtensibleArray<Feature>(Feature.class);
        ExtensibleArray<Feature> tmpRight = new ExtensibleArray<Feature>(Feature.class);
        int len = this.project.length();
        this.left.clear();
        this.right.clear();
        ExtensibleArray<ROI> features = this.project.getFeatures();
        if (this.project.length() == 0 || this.project.foundEnzymes.isEmpty() && this.project.foundPrimers.isEmpty() && features.isEmpty()) {
            return;
        }
        int halfLen = this.project.length() / 2;
        if (!features.isEmpty() && this.project.showLabels) {
            for (int x = features.size() - 1; x >= 0; --x) {
                Feature feature = (Feature)features.get(x);
                if (feature == null || !feature.showLabel()) continue;
                start = feature.isAntisense() ? feature.getStop() : feature.getStart();
                feature.startDegree = FeatureRenderer.bpToDegree(start, len);
                if (start <= halfLen) {
                    tmpRight.add(feature);
                    this.right.add(feature);
                    continue;
                }
                tmpLeft.add(feature);
                this.left.add(feature);
            }
        }
        if (this.project.showPrimers && !this.project.foundPrimers.isEmpty()) {
            for (PrimerFeature primer : this.project.foundPrimers) {
                if (!this.shownPrimer(primer)) continue;
                start = primer.isAntisense() ? primer.getStop() : primer.getStart();
                primer.startDegree = FeatureRenderer.bpToDegree(start, len);
                if (start <= halfLen) {
                    tmpRight.add(primer);
                    this.right.add(primer);
                    continue;
                }
                tmpLeft.add(primer);
                this.left.add(primer);
            }
        }
        if (this.project.showEnzymes && !this.project.foundEnzymes.isEmpty()) {
            for (EnzymeFeature enzyme : this.project.foundEnzymes) {
                if (!enzyme.showLabel()) continue;
                start = enzyme.isAntisense() ? enzyme.getStop() : enzyme.getStart();
                enzyme.startDegree = FeatureRenderer.bpToDegree(start, len);
                if (start <= halfLen) {
                    tmpRight.add(enzyme);
                    this.right.add(enzyme);
                    continue;
                }
                tmpLeft.add(enzyme);
                this.left.add(enzyme);
            }
        }
        int min = 4;
        ObjectSpacer.setMinMax(min, this.panelHeight - 4);
        if (!tmpLeft.isEmpty()) {
            tmpLeft.sort(this.c1);
            this.getSizedFont(this.panelHeight - 8, tmpLeft.size(), true);
            ObjectSpacer.clearList();
            for (Feature feature : tmpLeft) {
                feature.label.point1 = this.project.pCircle.getXY(feature.startDegree + 90.0);
                feature.label.point2 = this.project.jCircle.getXY(feature.startDegree + 90.0);
                feature.label.point3 = this.project.lCircle.getXY(feature.startDegree + 90.0);
                feature.label.labelRect = feature instanceof EnzymeFeature ? new Rectangle(0, (int)feature.label.point3.y, this.leftFME.stringWidth(feature.getLabelText()), this.leftFontHt) : (feature instanceof PrimerFeature ? new Rectangle(0, (int)feature.label.point3.y, this.leftFMP.stringWidth(feature.getLabelText()), this.leftFontHt) : new Rectangle(0, (int)feature.label.point3.y, this.leftFM.stringWidth(feature.getLabelText()), this.leftFontHt));
                ObjectSpacer.add(new SpacedRect(feature.label.labelRect));
            }
            ObjectSpacer.spaceObjects();
            for (Feature f : tmpLeft) {
                offset = this.project.lCircle.getX(f.label.labelRect.y, true);
                f.label.point3.x = (int)offset - 2;
                f.label.labelRect.x = (int)(offset - (double)f.label.labelRect.width - 5.0);
                f.label.point3.y = f.label.labelRect.y + this.leftFontHt / 3;
            }
        } else {
            tmpLeft.clear();
            this.left.clear();
        }
        if (!tmpRight.isEmpty()) {
            tmpRight.sort(this.c2);
            this.getSizedFont(this.panelHeight - 8, tmpRight.size(), false);
            ObjectSpacer.clearList();
            for (Feature feature : tmpRight) {
                feature.label.point1 = this.project.pCircle.getXY(feature.startDegree + 90.0);
                feature.label.point2 = this.project.jCircle.getXY(feature.startDegree + 90.0);
                feature.label.point3 = this.project.lCircle.getXY(feature.startDegree + 90.0);
                feature.label.labelRect = feature instanceof EnzymeFeature ? new Rectangle(0, Math.min(Math.max(min, (int)feature.label.point3.y), this.panelHeight - this.rightFontHt - min), this.rightFME.stringWidth(feature.getLabelText()), this.rightFontHt) : (feature instanceof PrimerFeature ? new Rectangle(0, Math.min(Math.max(min, (int)feature.label.point3.y), this.panelHeight - this.rightFontHt - min), this.rightFMP.stringWidth(feature.getLabelText()), this.rightFontHt) : new Rectangle(0, Math.min(Math.max(min, (int)feature.label.point3.y), this.panelHeight - this.rightFontHt - min), this.rightFM.stringWidth(feature.getLabelText()), this.rightFontHt));
                ObjectSpacer.add(new SpacedRect(feature.label.labelRect));
            }
            ObjectSpacer.spaceObjects();
            for (Feature f : tmpRight) {
                offset = this.project.lCircle.getX(f.label.labelRect.y, false);
                f.label.labelRect.x = (int)offset + 5;
                f.label.point3.x = (int)offset + 2;
                f.label.point3.y = f.label.labelRect.y + this.rightFontHt / 3;
            }
        } else {
            tmpRight.clear();
            this.right.clear();
        }
    }

    private void draw(Feature feature, Graphics2D gfx) {
        this.pDraw(feature, gfx, false);
    }

    private void draw(Feature feature, Graphics2D gfx, boolean highlight) {
        this.pDraw(feature, gfx, highlight);
    }

    private void drawLabel(Feature feature, Graphics2D gfx) {
        this.drawLabel(feature, gfx, false);
    }

    private void drawLabel(Feature feature, Graphics2D gfx, boolean highlight) {
        if (!feature.showLabel || this.getName().length() == 0 || feature.renderer instanceof FeatureRenderer.NoGraphicFeature) {
            return;
        }
        boolean circular = this.project.isCircular();
        if (circular && this.project.labelsCircular) {
            this.pGenLabel(feature, gfx, highlight);
        } else {
            this.generatePaths(feature);
            if (highlight) {
                gfx.setColor(Globals.highlightedColor);
                gfx.fill(feature.label.labelRect);
                gfx.setStroke(new BasicStroke(3.0f));
            } else {
                gfx.setColor(Color.black);
                gfx.setStroke(new BasicStroke(1.0f));
            }
            Label label = feature.label;
            if (label != null) {
                if (circular) {
                    gfx.drawLine((int)label.point1.x, (int)label.point1.y, (int)label.point2.x, (int)label.point2.y);
                    gfx.drawLine((int)label.point2.x, (int)label.point2.y, (int)label.point3.x, (int)label.point3.y + label.labelRect.height / 2);
                    gfx.setColor(highlight ? Color.black : feature.getTextColor());
                    gfx.drawString(feature.getLabelText(), label.labelRect.x, label.labelRect.y + label.labelRect.height - 2);
                } else {
                    if (highlight) {
                        gfx.setColor(Globals.highlightedColor);
                        gfx.setStroke(new BasicStroke(3.0f));
                    } else {
                        gfx.setColor(Color.black);
                        gfx.setStroke(new BasicStroke(1.0f));
                    }
                    gfx.drawLine((int)label.point1.x, (int)label.point1.y, (int)label.point2.x, (int)label.point2.y);
                    gfx.drawLine((int)label.point2.x, (int)label.point2.y, (int)label.point3.x, (int)label.point3.y);
                    gfx.setTransform(this.rAT);
                    gfx.setColor(highlight ? Color.black : feature.getTextColor());
                    gfx.drawString(feature.getLabelText(), 0, label.labelRect.x + label.labelRect.width - 2);
                    gfx.setTransform(this.cAT);
                }
            }
        }
    }

    private void pDraw(Feature feature, Graphics2D gfx, boolean highlight) {
        if (feature == null || feature.isHidden() || feature.renderer instanceof FeatureRenderer.NoGraphicFeature) {
            return;
        }
        if (feature.shapes[0] == null || this.project.needPaths) {
            this.generatePaths(feature);
        }
        feature.renderer.paint(gfx, feature.getStart(), feature.getStop(), feature.fWidth, feature.rOffset, feature.isAntisense(), highlight, feature.getColor(), feature.shapes);
    }

    private void pGenLabel(Feature feature, Graphics2D gfx, boolean highlight) {
        if (this.project.isCircular() && this.project.labelsCircular) {
            this.generateCircleLabel(feature, highlight, gfx);
        }
    }

    private void generateCircleLabel(Feature feature, boolean highlight, Graphics2D gfx) {
        if (feature.renderer instanceof FeatureRenderer.TickMarkFeature) {
            feature.label.midLabelAngle = !feature.isAntisense() ? (int)((float)feature.getStart() * 360.0f / (float)this.project.length()) : (int)((float)feature.getStop() * 360.0f / (float)this.project.length());
            feature.label.labelOffset = feature.rOffset >= 1.0f ? (double)feature.rOffset * this.project.pCircle.getRadius() + 2.0 : (double)feature.rOffset * this.project.pCircle.getRadius();
        } else {
            int midBp = feature.getStart() + feature.getLength(this.project.length()) / 2;
            float mBP = midBp <= this.project.length() ? (float)midBp : (float)(this.project.length() - midBp);
            feature.label.midLabelAngle = (int)(mBP * 360.0f / (float)this.project.length());
            feature.label.labelOffset = feature.rOffset >= 1.0f ? (double)feature.rOffset * this.project.pCircle.getRadius() + (double)feature.fWidth + 2.0 : (double)feature.rOffset * this.project.pCircle.getRadius() - (double)feature.fWidth;
        }
        AffineTransform oldTransform = gfx.getTransform();
        this.drawTextAroundCircle(gfx, feature, false, highlight ? Globals.highlightedColor : null);
        gfx.setTransform(oldTransform);
    }

    private void generatePaths(Feature feature) {
        if (feature == null || feature.renderer == null || feature.renderer instanceof FeatureRenderer.NoGraphicFeature) {
            return;
        }
        feature.fWidth = (int)((double)((float)feature.width / 10.0f) * this.project.box_Height);
        if (feature.shapes[0] == null || this.project.needPaths) {
            feature.renderer.getShapes(feature.shapes, feature.getStart(), feature.getStop(), feature.fWidth, feature.rOffset, feature.isAntisense(), this.project);
            if (feature.label != null) {
                int x = 0;
                int y = 0;
                if (feature.renderer.getStart() != null) {
                    x = (int)feature.renderer.getStart().getX();
                    y = (int)feature.renderer.getStart().getY();
                }
                feature.label.point1 = new Point2D.Double(x, y);
            }
        }
    }

    private double adjustAngle(double angle) {
        return angle <= 90.0 ? 90.0 - angle : 360.0 - (angle - 90.0);
    }

    private GeneralPath genToHitShape(Label label) {
        double degreeAngleStop = this.adjustAngle(label.degreeAngleStart);
        GeneralPath newShape = new GeneralPath();
        Arc2D.Double topArc = new Arc2D.Double(this.project.pCircle.centerX - label.outerRadius, this.project.pCircle.centerY - label.outerRadius, label.outerRadius * 2.0, label.outerRadius * 2.0, degreeAngleStop - label.degreeAngleSweep, label.degreeAngleSweep, 0);
        Arc2D.Double botArc = new Arc2D.Double(this.project.pCircle.centerX - label.innerRadius, this.project.pCircle.centerY - label.innerRadius, label.innerRadius * 2.0, label.innerRadius * 2.0, degreeAngleStop, -label.degreeAngleSweep, 0);
        Point2D topStart = topArc.getStartPoint();
        Point2D botStart = botArc.getStartPoint();
        newShape.moveTo(topStart.getX(), topStart.getY());
        newShape.append(topArc, false);
        newShape.lineTo(botStart.getX(), botStart.getY());
        newShape.append(botArc, true);
        newShape.closePath();
        return newShape;
    }

    void drawTextAroundCircle(Graphics2D g, Feature feature, boolean squash, Color highlightColor) {
        double maxDescent;
        double maxAscent;
        boolean flip = feature.label.midLabelAngle >= 90 && feature.label.midLabelAngle <= 270;
        AffineTransform oldTransform = g.getTransform();
        this.LabelGlyph.saveGraphicsStateBeforeDraw(g);
        FontMetrics fm = g.getFontMetrics(Globals.LABELFONT);
        FontRenderContext frc = g.getFontRenderContext();
        char[] characters = feature.getName().toCharArray();
        int characterCount = characters.length;
        if (flip) {
            char[] reversedCharacters = new char[characterCount];
            for (int index = 0; index < characterCount; ++index) {
                reversedCharacters[index] = characters[characterCount - index - 1];
            }
            characters = reversedCharacters;
        }
        if (squash) {
            maxAscent = 0.0;
            maxDescent = 0.0;
        } else {
            maxAscent = fm.getMaxAscent();
            maxDescent = fm.getMaxDescent();
        }
        double spaceCharacterWidth = fm.charWidth('.');
        double leading = fm.getLeading();
        boolean[] charactersAreSpaces = new boolean[characterCount];
        GlyphVector[] characterGlyphVectors = new GlyphVector[characterCount];
        Rectangle2D[] characterGlyphBounds = new Rectangle2D[characterCount];
        double[] characterWidths = new double[characterCount + 1];
        double[] characterAscents = new double[characterCount];
        double[] characterDescents = new double[characterCount];
        for (int index = 0; index < characterCount; ++index) {
            char character = characters[index];
            boolean isSpace = character == ' ' || Character.isSpaceChar(character);
            GlyphVector glyphVector = Globals.LABELFONT.createGlyphVector(frc, Character.toString(character));
            Rectangle2D glyphBounds = glyphVector.getVisualBounds();
            double width = isSpace ? spaceCharacterWidth : glyphBounds.getWidth();
            double ascent = -glyphBounds.getY();
            double descent = glyphBounds.getHeight() - ascent;
            charactersAreSpaces[index] = isSpace;
            characterGlyphVectors[index] = glyphVector;
            characterGlyphBounds[index] = glyphBounds;
            characterWidths[index] = width;
            characterAscents[index] = ascent;
            characterDescents[index] = descent;
            if (!squash) continue;
            maxAscent = Math.max(maxAscent, ascent) * 1.25;
            maxDescent = Math.max(maxDescent, descent);
        }
        CircularTextPosition circularTextPosition = feature.rOffset >= 1.0f ? CircularTextPosition.OUTSIDE_CIRCLE : CircularTextPosition.INSIDE_CIRCLE;
        double actualRadius = circularTextPosition.calculateActualRadius(feature.label.labelOffset, maxAscent, maxDescent, flip);
        double currentAngleInRadians = 0.0;
        double charWidthInRadians = 0.0;
        double[] characterAnglesInRadians = new double[characterCount];
        characterAnglesInRadians[0] = currentAngleInRadians;
        double firstcharWidthInRadians = Math.sin((characterWidths[0] / 2.0 + leading + characterWidths[1] / 2.0) / actualRadius);
        currentAngleInRadians += firstcharWidthInRadians;
        for (int index = 1; index < characterCount; ++index) {
            characterAnglesInRadians[index] = currentAngleInRadians;
            charWidthInRadians = Math.sin((characterWidths[index] / 2.0 + leading + characterWidths[index + 1] / 2.0) / actualRadius);
            currentAngleInRadians += charWidthInRadians;
        }
        feature.label.degreeAngleSweep = (firstcharWidthInRadians + charWidthInRadians + characterAnglesInRadians[characterCount - 1] - characterAnglesInRadians[0]) * 57.2958;
        feature.label.degreeAngleStart = (double)feature.label.midLabelAngle - feature.label.degreeAngleSweep / 2.0;
        feature.label.degreeAngleStop = (double)feature.label.midLabelAngle + feature.label.degreeAngleSweep;
        feature.label.innerRadius = actualRadius;
        feature.label.outerRadius = actualRadius + maxAscent;
        feature.label.hitTestShape = this.genToHitShape(feature.label);
        if (highlightColor != null) {
            g.setColor(highlightColor);
            g.fill(feature.label.hitTestShape);
            this.LabelGlyph.drawOutline = 0;
        } else {
            this.LabelGlyph.drawOutline = 1;
        }
        double angleAdjustment = (double)feature.label.midLabelAngle * 0.0174533 - (characterAnglesInRadians[characterCount - 1] - characterAnglesInRadians[0]) / 2.0;
        int index = 0;
        while (index < characterCount) {
            int n = index++;
            characterAnglesInRadians[n] = characterAnglesInRadians[n] + angleAdjustment;
        }
        AffineTransform stringTransform = oldTransform;
        if (stringTransform == null) {
            stringTransform = new AffineTransform();
        }
        for (int index2 = 0; index2 < characterCount; ++index2) {
            if (charactersAreSpaces[index2]) continue;
            GlyphVector glyphVector = characterGlyphVectors[index2];
            Rectangle2D glyphBounds = characterGlyphBounds[index2];
            if (flip) {
                AffineTransform oldGlyphVectorTransform = glyphVector.getGlyphTransform(0);
                if (oldGlyphVectorTransform == null) {
                    oldGlyphVectorTransform = new AffineTransform();
                }
                AffineTransform newGlyphVectorTransform = new AffineTransform(oldGlyphVectorTransform);
                newGlyphVectorTransform.scale(-1.0, -1.0);
                newGlyphVectorTransform.translate(-(glyphBounds.getWidth() + glyphBounds.getX() + glyphBounds.getX()), glyphBounds.getHeight() + (maxAscent - characterAscents[index2]) - characterDescents[index2] - maxDescent);
                glyphVector.setGlyphTransform(0, newGlyphVectorTransform);
            }
            AffineTransform characterTransform = new AffineTransform(stringTransform);
            characterTransform.translate(this.project.pCircle.centerX, this.project.pCircle.centerY);
            characterTransform.rotate(characterAnglesInRadians[index2]);
            characterTransform.translate(-(glyphBounds.getX() + glyphBounds.getWidth() / 2.0), -(actualRadius + maxDescent));
            g.setTransform(characterTransform);
            this.LabelGlyph.drawGlyph(g, glyphVector.getOutline(0.0f, 0.0f));
        }
        this.LabelGlyph.restoreGraphicsStateAfterDraw(g);
        g.setTransform(oldTransform);
    }

    boolean featureContains(Feature feature, Rectangle selectionRect) {
        return feature.shapes != null && feature.shapes[0] != null && feature.shapes[0].intersects(selectionRect) || feature.shapes[1] != null && feature.shapes[1].intersects(selectionRect) || feature.label != null && this.labelIntersects(feature.label, selectionRect);
    }

    boolean featureContains(Feature feature, int x, int y) {
        return feature.shapes != null && (feature.shapes[0] != null && feature.shapes[0].contains(x, y) || feature.shapes[1] != null && feature.shapes[1].contains(x, y) || feature.label != null && this.labelContains(feature.label, x, y));
    }

    boolean labelIntersects(Label label, Rectangle selectionRect) {
        if (this.project.isCircular() && this.project.labelsCircular) {
            return label.hitTestShape != null && label.hitTestShape.intersects(selectionRect);
        }
        return label.labelRect != null && label.labelRect.intersects(selectionRect);
    }

    boolean labelContains(Label label, int x, int y) {
        if (this.project.isCircular() && this.project.labelsCircular) {
            return label.hitTestShape != null && label.hitTestShape.contains(x, y);
        }
        return label.labelRect != null && label.labelRect.contains(x, y);
    }

    void featureSelectionChanged(Feature f) {
        this.project.selectedItem = null;
        boolean settingFeature = this.isFeatureEditable(f);
        this.setFeatureToolsEnabled(settingFeature);
        this.setFeatureMenusEnabled(settingFeature);
        this.project.selectedItem = f;
        this.mnuCopy.setEnabled(f != null);
        this.displayFeature(f);
    }

    private boolean isFeatureEditable(Feature f) {
        return f != null && !(f instanceof PrimerFeature) && !(f instanceof EnzymeFeature);
    }

    private void updateProperties(Feature f) {
        this.project.selectedItem = null;
        if (this.isFeatureEditable(f)) {
            this.txtFName.setText(f.getName(), false);
            this.txtFName.select(0, 0);
            this.txtStart.setText("" + f.getStart(), false);
            this.txtStart.select(0, 0);
            this.txtEnd.setText("" + f.getStop(), false);
            this.txtEnd.select(0, 0);
            this.cmbOrient.setSelectedIndex(f.isAntisense() ? 1 : 0);
            this.cmbGBType.getModel().setSelectedItem(f.getGBType());
            this.lblColorGraphic.setColor(f.getBackColor());
            this.lblColorLabel.setColor(f.getTextColor());
            this.cmbGraphic.setSelectedIndex(f.getGraphicStyle().getSortIndex());
            this.sldAlpha.setValue(f.getAlpha());
            this.uiAlpha.setTrackGradientColor(f.getBackColor());
            int minWd = (int)f.renderer.minWidth;
            int maxWd = (int)f.renderer.maxWidth;
            int fWid = f.getWidth();
            if (minWd >= maxWd) {
                JOptionPanes.showMessageDialog(this, "Error setting width min (" + minWd + ") and max (" + maxWd + ")");
                this.updateProperties(null);
                return;
            }
            if (fWid < minWd) {
                fWid = minWd;
                f.setWidth(fWid);
            } else if (fWid > maxWd) {
                fWid = maxWd;
                f.setWidth(fWid);
            }
            this.sldWidth.setMinimum(minWd);
            this.sldWidth.setMaximum(maxWd);
            this.spinWidth.setModel(new SpinnerNumberModel(fWid, minWd, maxWd, 1));
            this.sldWidth.setValue(f.getWidth());
            this.sldRadius.setValue(f.getOffset());
            this.spinRadius.setValue(f.getOffset());
            this.sldDrawingOrder.setMaximum(this.project.getFeatures().size() - 1);
            this.sldDrawingOrder.setValue(this.project.getFeatures().indexOf(f));
            this.chkDrawGraphic.setSelected(true);
            this.txtCaption.setText(f.getCaption(), false);
            this.txtFName.select(0, 0);
            this.chkShowLabel.setSelected(f.showLabel());
            this.txtNotes.setText(f.getNote(), false);
            this.txtNotes.select(0, 0);
        } else {
            this.txtFName.setText("", false);
            this.txtStart.setText("", false);
            this.txtEnd.setText("", false);
            this.cmbOrient.setSelectedIndex(0);
            this.cmbGBType.getModel().setSelectedItem("");
            this.cmbGraphic.setSelectedIndex(-1);
            this.lblColorGraphic.setColor(Color.LIGHT_GRAY);
            this.lblColorLabel.setColor(Color.LIGHT_GRAY);
            this.sldAlpha.setValue(0);
            this.uiAlpha.setTrackGradientColor(Color.LIGHT_GRAY);
            this.sldWidth.setValue(0);
            this.sldRadius.setValue(0);
            this.sldDrawingOrder.setValue(0);
            this.txtCaption.setText("", false);
            this.txtNotes.setText("", false);
            this.editor.clear();
            this.toolTip.setText(null);
        }
        this.project.selectedItem = f;
    }

    @Override
    public final void propertyChanged(ChangeEvent ... events) {
        block21: for (ChangeEvent event : events) {
            switch (event.propertyID) {
                case 113: {
                    this.updateProperties(this.project.getSelectedItem());
                    continue block21;
                }
                case 115: {
                    this.project.selectedItem = null;
                    this.project.selectedItems.clear();
                    continue block21;
                }
                case 108: {
                    this.updateProperties(this.project.getSelectedItem());
                    this.featureSelectionChanged(this.project.getSelectedItem());
                    continue block21;
                }
                case 112: {
                    this.displayFeature(this.project.getSelectedItem());
                    continue block21;
                }
                case 100: {
                    this.cmdUndo.setEnabled(this.project.canUndo());
                    this.cmdUndo.setToolTipText(this.project.getUndoText());
                    this.cmdRedo.setEnabled(this.project.canRedo());
                    this.cmdRedo.setToolTipText(this.project.getRedoText());
                    this.mnuUndo.setEnabled(this.project.canUndo());
                    this.mnuUndo.setToolTipText(this.project.getUndoText());
                    this.mnuRedo.setEnabled(this.project.canRedo());
                    this.mnuRedo.setToolTipText(this.project.getRedoText());
                    continue block21;
                }
                case 106: {
                    this.resetMap();
                    continue block21;
                }
                case 0: {
                    this.txtPlasmidName.setText(this.project.getName());
                    this.txtPlasmidName.select(0, 0);
                    this.setTitle(this.project.getName());
                    continue block21;
                }
                case 10: {
                    if (this.project.getFile() != null) {
                        this.setTitle(this.project.getFile().getAbsolutePath());
                        continue block21;
                    }
                    this.setTitle(this.project.getName());
                    continue block21;
                }
                case 3: {
                    this.setEditorAccessionValue((String)event.newValue);
                    continue block21;
                }
                case 1: {
                    this.setEditorOrgValue(this.project.getOrganism());
                    continue block21;
                }
                case 2: {
                    this.setEditorSourceValue(this.project.getSource());
                    continue block21;
                }
                case 104: {
                    if (this.project.getFile() == null) continue block21;
                    this.setTitle(this.project.getFile() != null ? this.project.getFile().getAbsolutePath() : "");
                    continue block21;
                }
                case 6: {
                    boolean circle = this.project.isCircular();
                    this.chkCircular.setSelected(circle);
                    if (circle) {
                        this.cmdCircular.setRolloverIcon(Globals.iconCircle);
                        this.cmdCircular.setPressedIcon(Globals.iconLinear);
                    } else {
                        this.cmdCircular.setPressedIcon(Globals.iconCircle);
                        this.cmdCircular.setRolloverIcon(Globals.iconLinear);
                    }
                    this.cmdCircular.setSelected(!circle);
                    this.project.needPaths = true;
                    this.resetMap();
                    continue block21;
                }
                case 110: {
                    this.findPrimers(this.project);
                    continue block21;
                }
                case 111: {
                    this.findEnzymes(this.project);
                    continue block21;
                }
                case 103: {
                    if (this.outputWindow == null) continue block21;
                    this.outputWindow.dispose();
                    continue block21;
                }
                case 107: {
                    if (this.gelForm == null) continue block21;
                    this.gelForm.resetEnzymes();
                    this.gelForm.regenerateWells();
                    this.gelForm.reDraw(true);
                    continue block21;
                }
                case 114: {
                    this.setProjectMenusEnabled(this.project.length() > 0);
                    continue block21;
                }
                case 116: {
                    this.project.fireEvents(0, 2, 3, 1, 108, 104, 6, 111, 110, 106, 107, 112, 114, 10);
                    continue block21;
                }
            }
        }
    }

    private JPopupMenu getEditorPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText("Copy Options");
        sep.addMouseListener(this.menuMouseListener);
        menu.add(sep);
        JMenuItem item = new JMenuItem("Copy selection");
        item.setToolTipText("Copy feature viewer's selection to the clipboard.");
        item.addMouseListener(this.menuMouseListener);
        menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PLOTJ.this.editor.copySelectionToClipboard();
            }
        });
        item = new JMenuItem("Copy selection as antisense");
        menu.add(item);
        item.setToolTipText("Copy feature viewer's selection to the clipboard as antisense.");
        item.addMouseListener(this.menuMouseListener);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceExportFormat selection = PLOTJ.this.editor.getSelection();
                DNA.antisense(selection);
                SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(selection);
                if (transferable != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
                }
            }
        });
        item = new JMenuItem("Copy selection translation");
        menu.add(item);
        item.setToolTipText("Copy the translation of feature viewer's selection to the clipboard.");
        item.addMouseListener(this.menuMouseListener);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String seq = PLOTJ.this.editor.getTranslation(PLOTJ.this.editor.getSelectionStart(), PLOTJ.this.editor.getSelectionStop());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(seq), null);
            }
        });
        sep = new JPopupMenu.Separator();
        sep.setToolTipText("Copy Options");
        sep.addMouseListener(this.menuMouseListener);
        menu.add(sep);
        Defaults.setMenuHeaderFooterUIs(menu, new RenderedMenuSeparatorUI(1), new RenderedMenuSeparatorUI(3));
        return menu;
    }

    private class CodonActionListener
    implements ActionListener {
        public boolean featureTable = false;
        public int index = 0;

        public void setIndex(int index) {
            this.index = index;
        }

        public CodonActionListener() {
        }

        public CodonActionListener(int index) {
            this.index = index;
        }

        public CodonActionListener(String orgName, boolean featureTable) {
            this.index = CodonTable.getOrganismIndex(orgName);
            this.featureTable = featureTable;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.featureTable) {
                PLOTJ.this.project.getCodonTable().setOrganism(this.index);
            } else if (PLOTJ.this.project.getSelectedItem() != null) {
                // empty if block
            }
            PLOTJ.this.displayFeature(PLOTJ.this.project.getSelectedItem());
        }
    }

    static class OutlinedFilledGlyphDrawer
    implements GlyphDrawer {
        public static final int USE_NO_HIGHLIGHT_COLOR = 0;
        public static final int USE_PRIVATE_HIGHLIGHT_COLOR = 1;
        public static final int USE_GLOBAL_HIGHLIGHT_COLOR = 2;
        public static Color globalOutlineColor = Color.YELLOW;
        Color oldGraphicsStateColor;
        Stroke oldGraphicsStateStroke;
        Color fillColor;
        public Color privateOutlineColor = Color.white;
        Stroke stroke = new BasicStroke(1.0f, 0, 1);
        Stroke strokeHighlight = new BasicStroke(2.0f, 0, 1);
        int drawOutline = 2;
        boolean drawFill = true;

        public Color getDrawOutlineColor() {
            return this.privateOutlineColor;
        }

        public void setDrawOutlineColor(Color outlineColor) {
            this.privateOutlineColor = outlineColor;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void setDrawOutline(int drawOutline) {
            this.drawOutline = drawOutline;
        }

        public int getDrawOutline() {
            return this.drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor) {
            this.fillColor = textColor;
            this.drawOutline = 2;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, int drawOutline) {
            this.fillColor = textColor;
            this.drawOutline = drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor) {
            this.fillColor = textColor;
            this.privateOutlineColor = outlineColor;
            this.drawOutline = 1;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke) {
            this.fillColor = textColor;
            this.privateOutlineColor = outlineColor;
            this.drawOutline = 1;
            this.stroke = stroke;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke, int drawOutline) {
            this.fillColor = textColor;
            globalOutlineColor = outlineColor;
            this.stroke = stroke;
            this.drawOutline = drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke, int drawOutline, boolean drawFill) {
            this.fillColor = textColor;
            globalOutlineColor = outlineColor;
            this.stroke = stroke;
            this.drawOutline = drawOutline;
            this.drawFill = drawFill;
        }

        @Override
        public void saveGraphicsStateBeforeDraw(Graphics2D g) {
            this.oldGraphicsStateColor = g.getColor();
            this.oldGraphicsStateStroke = g.getStroke();
        }

        @Override
        public void drawGlyph(Graphics2D preTransformedG, Shape glyph) {
            if (this.drawOutline > 0) {
                preTransformedG.setColor(this.drawOutline == 2 ? globalOutlineColor : this.privateOutlineColor);
                preTransformedG.setStroke(this.strokeHighlight);
                preTransformedG.draw(glyph);
            }
            if (this.drawFill) {
                preTransformedG.setColor(this.fillColor);
                preTransformedG.fill(glyph);
            }
        }

        @Override
        public void restoreGraphicsStateAfterDraw(Graphics2D g) {
            g.setColor(this.oldGraphicsStateColor);
            g.setStroke(this.oldGraphicsStateStroke);
        }
    }

    private class CatActionListener
    implements ActionListener {
        PrimerCategory cat;

        public CatActionListener(PrimerCategory cat) {
            this.cat = cat;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.cat.shown = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                PLOTJ.this.resetMap();
            }
        }
    }

    class FrmNewEditFeature
    extends FrmNewFeature {
        public FrmNewEditFeature(PLOTJ parent, boolean modal) {
            super((Window)parent);
        }

        public FrmNewEditFeature(PLOTJ parent, boolean modal, Feature feature) {
            super(parent, modal, feature);
        }

        @Override
        public void doOK() {
            Undoable edit;
            boolean isNewFeature = this.loadedFeature == null;
            final Feature redoFeature = (Feature)this.getROI();
            final Feature undoFeature = new Feature();
            final ProjectDocument project = this.getProject();
            if (!isNewFeature) {
                undoFeature.cloneFrom(this.loadedFeature);
            }
            final ChangeEvent[] events = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(113), new ChangeEvent(112), new ChangeEvent(10)};
            final ChangeEvent[] events2 = new ChangeEvent[]{new ChangeEvent(106), new ChangeEvent(10)};
            final boolean isChanged = project.isChanged();
            if (isNewFeature) {
                edit = new Undoable(){

                    @Override
                    public boolean undo() {
                        project.getFeatures().remove(redoFeature);
                        project.setChanged(isChanged);
                        project.setSelectedItem(null, false);
                        project.mouseoverItem = null;
                        project.fireEvents(events);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        project.getFeatures().add(redoFeature);
                        project.mouseoverItem = null;
                        project.setChanged(true);
                        project.fireEvents(events);
                        return true;
                    }
                };
                edit.redoName = "redo new feature";
                edit.undoName = "undo new feature";
            } else {
                edit = new Undoable(){

                    @Override
                    public boolean undo() {
                        FrmNewEditFeature.this.loadedFeature.cloneFrom(undoFeature);
                        project.setChanged(isChanged);
                        if (project.getSelectedItem() == FrmNewEditFeature.this.loadedFeature) {
                            project.fireEvents(events);
                        } else {
                            project.fireEvents(events2);
                        }
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        FrmNewEditFeature.this.loadedFeature.cloneFrom(redoFeature);
                        project.setChanged(true);
                        if (project.getSelectedItem() == FrmNewEditFeature.this.loadedFeature) {
                            project.fireEvents(events);
                        } else {
                            project.fireEvents(events2);
                        }
                        return true;
                    }
                };
                edit.redoName = "redo feature changes";
                edit.undoName = "undo feature changes";
            }
            project.runEdit(edit);
            this.setVisible(false);
            this.dispose();
        }
    }

    private class FileActionListener
    implements ActionListener {
        File file;

        public FileActionListener(File file) {
            this.file = file;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PLOTJ.this.openFile(this.file);
        }
    }

    public static enum CircularTextPosition {
        OUTSIDE_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius;
            }
        }
        ,
        BASELINE_ON_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius - (flip ? maxAscent : maxDescent);
            }
        }
        ,
        INSIDE_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius - maxAscent - maxDescent;
            }
        };


        abstract double calculateActualRadius(double var1, double var3, double var5, boolean var7);
    }

    static interface GlyphDrawer {
        public void saveGraphicsStateBeforeDraw(Graphics2D var1);

        public void drawGlyph(Graphics2D var1, Shape var2);

        public void restoreGraphicsStateAfterDraw(Graphics2D var1);
    }
}

