/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Defaults.DefaultValues;
import Defaults.GenbankType;
import GenbankFileReader.Qualifier;
import IconListBoxes.IconListItem;
import MiscTools.ColorTools;
import MiscTools.StringTools;
import SequenceEditorPanels.ROI;
import Sequences.SequenceExportFormat;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import plot.Feature;

public class MobileBlock
extends IconListItem<SequenceExportFormat> {
    private static final int iconWidth = 24;
    private static final int iconHeight = 24;
    private static final int iconMidX = 12;
    private static final int iconMidY = 12;
    private static final Color defColor = Color.GREEN.darker();
    private int style = 1;
    private Icon icon;
    private String name = "";
    private Color color = null;
    private Color borderColor = Color.black;
    public static final Comparator sortComparator = new Comparator<MobileBlock>(){

        @Override
        public int compare(MobileBlock o1, MobileBlock o2) {
            return o1.name.compareTo(o2.name);
        }
    };
    public static int tineHt = 2;
    public static int arrowHt = 2;
    public static int lineHt = 2;

    public MobileBlock(SequenceExportFormat sef) {
        this.setItem(sef);
        this.name = sef.name;
    }

    @Override
    public void setItem(SequenceExportFormat item) {
        super.setItem(item);
        this.style = 6;
        boolean colorFound = false;
        boolean styleFound = false;
        if (item.qualifiers != null) {
            for (Qualifier qual : item.qualifiers) {
                if (qual.key.equalsIgnoreCase("name")) {
                    this.name = qual.value;
                    continue;
                }
                if (qual.key.equalsIgnoreCase("plot_ftype")) {
                    this.style = Integer.parseInt(qual.value);
                    styleFound = true;
                    continue;
                }
                if (!qual.key.equalsIgnoreCase("color")) continue;
                int bcolVal = StringTools.filterStringToInt(qual.value, 0);
                this.color = ColorTools.intToColor(bcolVal);
                colorFound = true;
            }
        }
        if (!colorFound || !styleFound) {
            int seqLen = item.sequence.length();
            for (ROI roi : item.annotations) {
                if (roi.getStart() == 1 && roi.getStop() == seqLen && roi.getColor() != null) {
                    if (!colorFound) {
                        this.color = roi.getColor();
                    }
                    if (!styleFound) {
                        this.style = MobileBlock.getDefaultROIGraphic(roi);
                    }
                    return;
                }
                if (this.color != null || roi.getColor() == null) continue;
                if (!colorFound) {
                    this.color = roi.getColor();
                }
                if (styleFound) continue;
                this.style = MobileBlock.getDefaultROIGraphic(roi);
            }
        }
    }

    public static int getDefaultROIGraphic(ROI roi) {
        if (roi instanceof Feature) {
            return ((Feature)roi).renderer.getLoadIndex();
        }
        int retVal = 1;
        GenbankType gbtype = DefaultValues.GBTYPES.get(roi.getGBType());
        if (gbtype != null) {
            retVal = gbtype.loadedGraphicIndex;
        }
        for (Qualifier qual : roi.qualifiers) {
            if (!qual.key.equalsIgnoreCase("plot_ftype")) continue;
            return Integer.parseInt(qual.value);
        }
        return retVal;
    }

    @Override
    public String getText() {
        return this.name != null ? this.name : ((SequenceExportFormat)this.getItem()).name;
    }

    @Override
    public Icon getIcon() {
        return this.icon != null ? this.icon : this.genIcon(this.style);
    }

    private Icon genIcon(int style) {
        Color iconColor = this.color != null ? this.color : defColor;
        BufferedImage icon = new BufferedImage(24, 24, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        switch (style) {
            case 2: 
            case 6: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 6.0f);
                path2.lineTo(13.0f, 6.0f);
                if (style != 6) {
                    path2.lineTo(13.0f, 3.0f);
                }
                path2.lineTo(23.0f, 12.0f);
                if (style != 6) {
                    path2.lineTo(13.0f, 21.0f);
                }
                path2.lineTo(13.0f, 18.0f);
                path2.lineTo(0.0f, 18.0f);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 7: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 12 - lineHt);
                path2.lineTo(13.0f, 12 - lineHt);
                path2.lineTo(13.0f, 12 - lineHt - tineHt);
                path2.lineTo(23.0f, 12.0f);
                path2.lineTo(13.0f, 12 + lineHt + tineHt);
                path2.lineTo(13.0f, 12 + lineHt);
                path2.lineTo(0.0f, 12 + lineHt);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 0: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 12 - lineHt);
                path2.lineTo(23.0f, 12 - lineHt);
                path2.lineTo(23.0f, 12 + lineHt);
                path2.lineTo(0.0f, 12 + lineHt);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 3: {
                g2d.setColor(Color.black);
                g2d.drawLine(0, 15, 23, 15);
                g2d.setColor(this.color);
                g2d.drawLine(12, 9, 12, 15);
                break;
            }
            case 4: {
                g2d.setColor(Color.black);
                g2d.drawLine(0, 15, 23, 15);
                g2d.setColor(this.color);
                g2d.drawLine(7, 9, 7, 15);
                g2d.drawLine(7, 9, 17, 9);
                g2d.drawLine(17, 9, 17, 15);
                break;
            }
            default: {
                g2d.setColor(iconColor);
                g2d.fillRect(0, 6, 23, 12);
                g2d.setColor(this.borderColor);
                g2d.drawRect(0, 6, 23, 12);
            }
        }
        this.icon = new ImageIcon(icon);
        return this.icon;
    }
}

