/*
 * Decompiled with CFR 0.152.
 */
package plot;

import MiscTools.StringTools;
import java.io.Serializable;
import java.util.Comparator;

class Ladder
implements Serializable {
    public static final Comparator sortComparator = new Comparator<Ladder>(){

        @Override
        public int compare(Ladder o1, Ladder o2) {
            return o1.name.compareTo(o2.name);
        }
    };
    private static final long serialVersionUID = 1L;
    public transient boolean isDefault = false;
    public String name = "";
    public int[] bands;

    public Ladder(String Name2, int ... bands) {
        this.name = Name2;
        this.bands = bands;
    }

    public Ladder() {
        this.name = "Ladder";
        this.bands = new int[0];
    }

    public void setBands(int ... bands) {
        this.bands = bands;
    }

    public boolean equals(Ladder ladder) {
        return this.name.equals(ladder.name);
    }

    public String toString() {
        return this.name;
    }

    public String bandsToText() {
        return Ladder.pBandsToText(this.bands, "\n");
    }

    public String bandsToText(String delimiter) {
        return Ladder.pBandsToText(this.bands, delimiter);
    }

    public void textToBands(String text) {
        this.bands = Ladder.pTextToBands(text, "\n");
    }

    public void textToBands(String text, String delimiter) {
        this.bands = Ladder.pTextToBands(text, delimiter);
    }

    public Ladder clone() {
        if (this.bands != null && this.bands.length > 0) {
            int[] cloneBands = new int[this.bands.length];
            System.arraycopy(this.bands, 0, cloneBands, 0, this.bands.length);
            return new Ladder(this.name, cloneBands);
        }
        return new Ladder(this.name, this.bands);
    }

    private static int[] pTextToBands(String text, String delimiter) {
        String[] splitBands = text.split(delimiter);
        int bandCount = 0;
        for (int x = 0; x < splitBands.length; ++x) {
            if (splitBands[x].length() <= 0) continue;
            ++bandCount;
        }
        int[] outBands = new int[bandCount];
        int bandIndex = 0;
        for (int x = 0; x < splitBands.length; ++x) {
            if (splitBands[x].length() <= 0) continue;
            outBands[bandIndex] = StringTools.filterStringToInt(splitBands[x], 1);
            ++bandIndex;
        }
        return outBands;
    }

    private static String pBandsToText(int[] bands, String delimiter) {
        StringBuilder sBands = new StringBuilder();
        int lastIndex = bands.length - 1;
        for (int x = 0; x < bands.length; ++x) {
            sBands.append(String.valueOf(bands[x]));
            if (x >= lastIndex) continue;
            sBands.append(delimiter);
        }
        return sBands.toString();
    }

    public String toSaveString(Ladder ladder) {
        return ladder.name + "\t" + ladder.bandsToText(",");
    }

    public static Ladder fromString(String line) {
        String cur = "";
        try {
            String[] s1;
            if (line != null && line.length() > 0 && !line.startsWith(";") && (s1 = line.split("\t")).length == 2) {
                int x;
                Ladder ladder = new Ladder();
                ladder.name = s1[0].trim();
                String[] s2 = s1[1].split(",");
                int[] tmp = new int[s2.length];
                int index = 0;
                for (x = 1; x < s2.length; ++x) {
                    if (s2[x].length() <= 0) continue;
                    cur = s2[x];
                    tmp[index] = StringTools.filterStringToInt(s2[x], 0);
                    ++index;
                }
                if (index > 0) {
                    ladder.bands = new int[index];
                    for (x = 0; x < index; ++x) {
                        ladder.bands[x] = tmp[x];
                    }
                    return ladder;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            return null;
        }
    }
}

