/*
 * Decompiled with CFR 0.152.
 */
package plot;

import AppHistory.History;
import BuildDater.BuildDate;
import GenbankFileReader.Annotation;
import IconRenderers.ControlButtonRenderer;
import IconRenderers.DockIconRenderer;
import JMConstants.Constants;
import JMOptionPanes.JMOptionPane;
import JMScrollBars.JMProgressBar;
import MiscTools.StringTrimmer;
import Plugins.PluginLoader;
import Plugins.PluginPackage;
import StatusBarDialogs.SplashScreen;
import StatusBarDialogs.ThreadRunner;
import ToolTip.BasicTextToolTip;
import Tools.UITools;
import UIRenderers.RenderedMenuSeparatorUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import plaf.Defaults;
import plaf.Themes;
import plot.DefaultEnzymes;
import plot.DefaultFeatures;
import plot.DefaultLadders;
import plot.DefaultLibraries;
import plot.DefaultPrimers;
import plot.FrmMolBlocks;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.PrefsPanel;
import plot.StaticArrayComboModel;

final class Globals {
    static final String APPNAME = "pLOT Plasmid Plotter";
    static final String APP_THEME_KEY = "plot_theme";
    static final String LINK_1 = "https://www.facebook.com/pLOTPlasmidMapper/";
    static final String LINK_2 = "http://www.plasmidplotter.com";
    static final String COPYRIGHT = "Copyright Jean-Marc DeKeyser (C) 2012 - 3012";
    static final String PLOTVERSION = "1.0.0";
    private static final boolean DEBUG_MODE_ENABLED = true;
    static boolean debugMode;
    public static boolean extendArc;
    static String buildDate;
    static PLOTJ instance;
    static final History history;
    static StringTrimmer trimmer;
    static Color buttonBorderColor;
    static Color toolTipGreen;
    static Color toolTipBlue;
    static Color toolTipYellow;
    static Color toolTipRed;
    static final Font LABELFONTB;
    static final Font LABELFONTBI;
    static final Font LABELFONTI;
    static final Font LABELFONT;
    static Font titleFont;
    static Font titleFontBold;
    public static final float ZOOM_MIN = 0.1f;
    public static final float ZOOM_MAX = 4.0f;
    public static final float BOX_WIDTH_MAX = 16.0f;
    public static final float BOX_WIDTH_DEF = 3.0f;
    public static final float BOX_WIDTH_MIN = 2.0f;
    public static final float LINE_WIDTH_MIN = 3.0f;
    public static final float LINE_WIDTH_DEF = 5.0f;
    public static final float LINE_WIDTH_MAX = 16.0f;
    public static final float OFFSET_PLASMID = 0.75f;
    public static final float OFFSET_LABELS = 1.25f;
    public static final float OFFSET_MIN = 0.5f;
    public static final float OFFSET_MID = 0.625f;
    public static final int OFFSET_MIN_INT = 50;
    public static final int OFFSET_MAX_INT = 150;
    public static final int OFFSET_MID_INT = 100;
    public static final float ARROWHEADLEN_MAX = 0.5f;
    public static final int BUFFERSIZE = 10;
    public static final int BUFFERSIZE2 = 20;
    public static final int MAXFILECOUNT = 200;
    public static Color highlightedColor;
    public static Color selectedColor;
    public static ImageIcon icon;
    static final String[] graphicNames;
    static final String[] graphicIconNames;
    static final Icon[] graphicIcons;
    static final String[] orientIconNames;
    static final Icon[] orientIcons;
    static final Integer[] orientItemValues;
    static final String[] typeTitles;
    static final String[] typeIconPaths;
    static final Icon[] typeIcons;
    static final Integer[] typeItemValues;
    static Color mapBackcolor;
    static final Color overlay;
    static Boolean useOverlay;
    static ImageIcon iconRE;
    static ImageIcon iconPrimer;
    static ImageIcon iconFeature;
    static ImageIcon iconMisc;
    static ImageIcon iconIntronExon;
    static ImageIcon iconCircle;
    static ImageIcon iconLinear;
    static Color gelBandColor;
    static final int[] graphicItemData;
    static final ArrayList<PLOTJ> windows;
    static Icon watermark;
    static JFrame frmMolBlocks;
    static final int MIDDLE = 0;
    static final int HEADER = 1;
    static final int FOOTER = 2;
    static final PluginLoader<PLOTJPlugin> loader;
    static final ArrayList<PluginPackage> defaultPluginPackages;
    static final ArrayList<PluginPackage> loadedPluginPackages;

    Globals() {
    }

    public static final String getBuildDate() {
        return buildDate;
    }

    static final Icon getGraphicIcons(int type) {
        return type >= 0 && type < graphicIcons.length ? graphicIcons[type] : null;
    }

    public static String getVersion() {
        if (debugMode) {
            return "1.0.0, Build Date: " + buildDate + " (Debug Mode)";
        }
        return "1.0.0, Build Date: " + buildDate;
    }

    static ControlButtonRenderer genDockRenderer(final boolean isTools) {
        return new DockIconRenderer(){

            @Override
            public void paintIcon(Graphics g, Component c, int direction, Rectangle rect, int state) {
                if (this.isWindows) {
                    int cHt = c.getHeight();
                    int cWd = c.getWidth();
                    Color lineColor = this.colors.getActiveColor(2);
                    if (lineColor == null) {
                        lineColor = Color.lightGray;
                    }
                    g.setColor(lineColor);
                    int iconHt = 10;
                    int midX = cWd / 2;
                    int midY = cHt / 2;
                    int left = midX - 5;
                    int top = midY - 5;
                    int toolWd = 3;
                    int featHt = 3;
                    int featWd = iconHt - toolWd;
                    int featTop = top + iconHt - featHt;
                    if (isTools) {
                        g.fillRect(left, top, toolWd, iconHt);
                    }
                    g.drawRect(left, top, toolWd, iconHt);
                    g.drawRect(left + toolWd, featTop, featWd, featHt);
                    if (!isTools) {
                        g.fillRect(left + toolWd, featTop, featWd, featHt);
                    }
                    g.drawRect(left, top, iconHt, iconHt);
                } else {
                    super.paintIcon(g, c, direction, rect, state);
                }
            }
        };
    }

    public static void populateGenbankTypes(JComboBox cmb) {
        StaticArrayComboModel<String> gbTypeModel = new StaticArrayComboModel<String>();
        gbTypeModel.setItems(Annotation.GBTYPES);
        cmb.setModel(gbTypeModel);
    }

    public static int getInstanceCount() {
        return windows.size();
    }

    static PLOTJ newWindow() {
        PLOTJ newMain = new PLOTJ();
        Globals.addWindow(newMain);
        newMain.setVisible(true);
        newMain.genToolTip();
        newMain.updateToolPlugins();
        return newMain;
    }

    static void addWindow(PLOTJ window) {
        if (!windows.contains(window)) {
            windows.add(window);
        }
    }

    static void removeWindow(PLOTJ window) {
        windows.remove(window);
        if (windows.isEmpty()) {
            history.save();
            System.exit(0);
        } else {
            window.dispose();
        }
    }

    static void setMapBackcolor(Color color) {
        if (color != null) {
            mapBackcolor = color;
            history.insert("mapcolor", mapBackcolor.toString(), 1, 1);
            for (PLOTJ window : windows) {
                window.resetMap();
                if (window.gelForm == null) continue;
                window.gelForm.reDraw(true);
            }
        }
    }

    private static void initMain(JMProgressBar bar, JLabel ssStatusLabel) {
        int loadedItemCount = 4;
        int val = -1;
        bar.setShowValueStyle(0);
        bar.setMaximum(loadedItemCount);
        bar.setValue(++val);
        ssStatusLabel.setText("Initiating UI");
        String theme = Themes.getTheme(APP_THEME_KEY);
        Defaults.setUI(theme);
        useOverlay = UIManager.getBoolean("Plot.map.useoverlay");
        Color color = UIManager.getColor("Plot.tooltip.green");
        if (color != null) {
            toolTipGreen = color;
        }
        if ((color = UIManager.getColor("Plot.tooltip.blue")) != null) {
            toolTipGreen = color;
        }
        if ((color = UIManager.getColor("Plot.tooltip.yellow")) != null) {
            toolTipGreen = color;
        }
        if ((color = UIManager.getColor("Plot.tooltip.red")) != null) {
            toolTipRed = color;
        }
        if ((color = UIManager.getColor("Button.bordercolor")) != null) {
            buttonBorderColor = color;
        }
        if ((color = UIManager.getColor("Plot.gelbandcolor")) != null) {
            gelBandColor = color;
        }
        history.setApp(PLOTJ.class, "pLOT");
        watermark = new ImageIcon(Globals.class.getResource("/images256/Watermark.png"));
        buildDate = BuildDate.getBuild();
        icon = new ImageIcon(PLOTJ.class.getResource("/images64/pLOT_Icon.png"));
        bar.setValue(++val);
        ssStatusLabel.setText("Loading Default Libraries");
        DefaultLibraries.userFeatures.setHistory(history);
        DefaultLibraries.userLadders.setHistory(history);
        DefaultLibraries.userLibrary.setHistory(history);
        DefaultLibraries.defaultFeatures = new DefaultFeatures();
        DefaultLibraries.defaultPrimers = new DefaultPrimers();
        DefaultLibraries.defaultLadders = new DefaultLadders();
        DefaultLibraries.defaultEnzymes = new DefaultEnzymes();
        String userLib = history.getUserPref().get("userlibpath", "");
        String userFeaturesLib = history.getUserPref().get("userfeatureslibpath", "");
        String userLaddersLib = history.getUserPref().get("userladderlibpath", "");
        bar.setValue(++val);
        ssStatusLabel.setText("Loading User Libraries");
        if (!(!history.getUserPref().getBoolean("showFilesPrompt", true) || userLib.length() != 0 && new File(userLib).exists() && userFeaturesLib.length() != 0 && new File(userFeaturesLib).exists() && userLaddersLib.length() != 0 && new File(userLaddersLib).exists())) {
            JCheckBox chkShow = new JCheckBox();
            chkShow.setText("Show at startup if library path(s) are not found");
            chkShow.setSelected(true);
            if (JMOptionPane.showConfirmDialog(null, "<html>One or more external user database locations have not been set.<br>Would you like to set these now?</html>", "Set file locations?", null, 0, chkShow) == 0) {
                history.getUserPref().putBoolean("showFilesPrompt", chkShow.isSelected());
                PrefsPanel p = new PrefsPanel(){

                    @Override
                    public void selectInitialValue() {
                    }
                };
                p.txtFLib.setText(userFeaturesLib);
                p.txtLadders.setText(userLaddersLib);
                p.txtPrimers.setText(userLib);
                p.chkShow.setVisible(true);
                if (((Boolean)JMOptionPane.showInputDialog(null, p, "Set pLOT database file locations", null, null, null)).booleanValue()) {
                    if (p.fLibChanged) {
                        userFeaturesLib = p.newFLibPath;
                    }
                    if (p.uLibChanged) {
                        userLib = p.newULibPath;
                    }
                    if (p.lLibChanged) {
                        userLaddersLib = p.newLLibPath;
                    }
                } else {
                    history.getUserPref().putBoolean("showFilesPrompt", chkShow.isSelected());
                }
            } else if (!chkShow.isSelected()) {
                JMOptionPane.showConfirmDialog(null, "<html>File locations can set at any time <br>from the <b>Edit>Preferences>Set external databases</b> menu item</html>", "", null, 3);
            }
        }
        if (userLib.length() > 0) {
            DefaultLibraries.userLibrary.open(userLib);
        }
        if (userFeaturesLib.length() > 0) {
            DefaultLibraries.userFeatures.open(userFeaturesLib);
        }
        if (userLaddersLib.length() > 0) {
            DefaultLibraries.userLadders.open(userLaddersLib);
        }
        bar.setValue(++val);
        ssStatusLabel.setText("Loading plugins");
        Globals.updatePlugins();
        bar.setValue(++val);
    }

    public static void main(final String[] args) {
        SplashScreen splashScreen = new SplashScreen(null, new ImageIcon(PLOTJ.class.getResource("/images67/SplashScreen.png")));
        final JMProgressBar bar = splashScreen.addJMProgressBar(168, 248, 215, 20);
        bar.setTrackStyle(Constants.DEFAULTRENDERERS.JavT);
        bar.setProgressBarStyle(Constants.DEFAULTRENDERERS.Metallic);
        bar.setThumbColors(Color.GREEN);
        splashScreen.addLabel("pLOT-J", 206, 96, 152, 51, 2, new Font("Segoe UI", 3, 36)).setForeground(Color.black);
        splashScreen.addLabel("Plasmid Mapper", 208, 152, 195, 29, 2, new Font("Segoe UI", 1, 24)).setForeground(Color.black);
        splashScreen.addLabel("Version " + Globals.getVersion(), 208, 192, 185, 29, 4, new Font("Segoe UI", 1, 18)).setForeground(Color.black);
        final JLabel ssStatusLabel = splashScreen.addLabel("Initializing main window", 71, 224, splashScreen.getWidth() - 71, 17, 0, new Font("Segoe UI", 0, 14));
        ssStatusLabel.setForeground(Color.black);
        splashScreen.addLabel("Copyright Jean-Marc DeKeyser", 0, 278, splashScreen.getWidth() - 25, 17, 4, new Font("Segoe UI", 0, 12)).setForeground(Color.black);
        if (UITools.isWindows() || UITools.isMacOSX() || UITools.isMacintosh()) {
            splashScreen.run(new ThreadRunner(){

                @Override
                public void run() {
                    Globals.initMain(bar, ssStatusLabel);
                }
            });
        } else {
            Globals.initMain(bar, ssStatusLabel);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file;
                PLOTJ newMain = Globals.newWindow();
                titleFont = newMain.getFont();
                titleFontBold = titleFont.deriveFont(1);
                if (args.length > 0 && (file = new File(args[0])).exists()) {
                    newMain.openFile(file);
                }
            }
        });
    }

    static void showMolBlocksWindow() {
        if (frmMolBlocks == null) {
            frmMolBlocks = new FrmMolBlocks();
        }
        frmMolBlocks.setVisible(true);
    }

    static JPopupMenu.Separator genToolTipSep(String toolTipText, int type, MouseListener menuMouseListener) {
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText(toolTipText);
        sep.addMouseListener(menuMouseListener);
        switch (type) {
            case 1: {
                sep.setUI(new RenderedMenuSeparatorUI(1));
                break;
            }
            case 2: {
                sep.setUI(new RenderedMenuSeparatorUI(3));
                break;
            }
            default: {
                sep.setUI(new RenderedMenuSeparatorUI(0));
            }
        }
        return sep;
    }

    static void updatePlugins() {
        defaultPluginPackages.clear();
        loader.loadPackageFromFolder(defaultPluginPackages);
        for (PLOTJ p : windows) {
            p.updateToolPlugins();
        }
    }

    static {
        int x;
        debugMode = false;
        extendArc = true;
        buildDate = "2023-11-07";
        history = new History();
        trimmer = new StringTrimmer(32, 9);
        buttonBorderColor = Color.black;
        toolTipGreen = BasicTextToolTip.TOOLTIP_GREEN;
        toolTipBlue = BasicTextToolTip.TOOLTIP_BLUE;
        toolTipYellow = BasicTextToolTip.TOOLTIP_YELLOW;
        toolTipRed = Color.red;
        LABELFONTB = new Font("Arial", 1, 14);
        LABELFONTBI = new Font("Arial", 3, 14);
        LABELFONTI = new Font("Arial", 2, 14);
        LABELFONT = new Font("Arial", 0, 14);
        titleFont = new Font("Arial", 0, 14);
        titleFontBold = new Font("Arial", 1, 14);
        highlightedColor = Color.yellow;
        selectedColor = Color.GREEN;
        graphicNames = new String[]{"Line", "Box", "Box Arrow", "Headless Arrow", "Line Arrow", "Tick Mark", "Bracketed", "Not Shown"};
        graphicIconNames = new String[]{"/images24/ToLine.png", "/images24/ToBox.png", "/images24/ToBoxArrow.png", "/images24/ToHeadlessArrow.png", "/images24/ToLineArrow.png", "/images24/ToTickMark.png", "/images24/ToBracketed.png", "/images24/ToNoGraphic.png"};
        graphicIcons = new Icon[graphicIconNames.length];
        orientIconNames = new String[]{"/images67/Sense.png", "/images67/Antisense.png"};
        orientIcons = new Icon[orientIconNames.length];
        orientItemValues = new Integer[]{0, 1};
        typeTitles = new String[]{"DNA", "Protein"};
        typeIconPaths = new String[]{"/images24/DNA2.png", "/images24/GFP2.png"};
        typeIcons = new Icon[typeIconPaths.length];
        typeItemValues = new Integer[]{0, 1};
        mapBackcolor = Color.white;
        overlay = new Color(0, 0, 0, 80);
        useOverlay = false;
        iconRE = new ImageIcon(Globals.class.getResource("/images24/RE.png"));
        iconPrimer = new ImageIcon(Globals.class.getResource("/images24/Primers.png"));
        iconFeature = new ImageIcon(Globals.class.getResource("/images24/Arrow.png"));
        iconMisc = new ImageIcon(Globals.class.getResource("/images24/ToBox.png"));
        iconIntronExon = new ImageIcon(Globals.class.getResource("/images24/Exon.png"));
        iconCircle = new ImageIcon(Globals.class.getResource("/images24/Circle.png"));
        iconLinear = new ImageIcon(Globals.class.getResource("/images24/Linear.png"));
        gelBandColor = Color.cyan;
        for (x = 0; x < graphicIconNames.length; ++x) {
            Globals.graphicIcons[x] = new ImageIcon(Globals.class.getResource(graphicIconNames[x]));
        }
        for (x = 0; x < orientIconNames.length; ++x) {
            Globals.orientIcons[x] = new ImageIcon(Globals.class.getResource(orientIconNames[x]));
        }
        for (x = 0; x < typeIconPaths.length; ++x) {
            Globals.typeIcons[x] = new ImageIcon(Globals.class.getResource(typeIconPaths[x]));
        }
        graphicItemData = new int[]{0, 1, 2, 6, 7, 3, 4, 5};
        windows = new ArrayList();
        frmMolBlocks = null;
        loader = new PluginLoader<PLOTJPlugin>(PLOTJPlugin.class, "Plugins", "PLOT_Plugin_");
        defaultPluginPackages = new ArrayList();
        loadedPluginPackages = new ArrayList();
    }
}

