/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DocumentFilters.DocumentKeyFilter;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import MiscTools.StringTools;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.AnnotationEditor;
import SequenceEditorPanels.ROI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import plot.Feature;
import plot.FeatureRenderer;
import plot.Globals;
import plot.GraphicsListRenderer;
import plot.IconListRenderer;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.StaticArrayComboModel;

abstract class FrmNewFeature
extends MainExclusiveDlg
implements AnnotationEditor {
    protected Feature loadedFeature = null;
    protected int start = 1;
    protected int stop = 1;
    protected boolean saved = false;
    private ArrayList<FeaturePreset> presets = new ArrayList();
    private JCheckBox chkDrawGraphic;
    private JCheckBox chkPreview;
    private JCheckBox chkShowLabel;
    JComboBox<String> cmbGBType;
    JComboBox<FeatureRenderer> cmbGraphic;
    public JComboBox<Integer> cmbOrient;
    private GlossyButton cmdCancel;
    protected GlossyButton cmdGColor;
    protected GlossyButton cmdLColor;
    private GlossyButton cmdSave;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane4;
    private JLabel lblEnd;
    private JLabel lblStart;
    private JMenu mnuPresets;
    JSpinner spinAlpha;
    JSpinner spinRadius;
    JSpinner spinWidth;
    StatusLabel statusLabel;
    private JToggleButton toggleLink;
    public GhostTextBox txtEnd;
    public GhostTextBox txtFName;
    public GhostTextArea txtNotes;
    public GhostTextBox txtStart;

    public boolean isFeatureSaved() {
        return this.saved;
    }

    public FrmNewFeature(Window parent) {
        super(parent);
        this.init(parent);
    }

    public FrmNewFeature(PLOTJ parent, Feature feature) {
        super((Window)parent);
        this.init(parent);
        this.loadFeature(feature);
    }

    public FrmNewFeature(PLOTJ parent, boolean modal, Feature feature) {
        super((Window)parent);
        this.init(parent);
        this.loadFeature(feature);
    }

    private void init(Window parent) {
        this.initComponents();
        this.populatePresets();
        this.chkPreview.setVisible(false);
        if (this.getParent() instanceof PLOTJ) {
            this.toggleLink.setSelected(((PLOTJ)this.getParent()).toggleLinkModel.isSelected());
        }
        Globals.populateGenbankTypes(this.cmbGBType);
        this.cmbGBType.setSelectedItem("misc_feature");
        this.setIconImage(Globals.icon.getImage());
        StaticArrayComboModel<FeatureRenderer> modelGraphicTypes = new StaticArrayComboModel<FeatureRenderer>(FeatureRenderer.drawFeatures);
        GraphicsListRenderer rendererGraphicTypes = new GraphicsListRenderer();
        this.cmbGraphic.setModel(modelGraphicTypes);
        this.cmbGraphic.setRenderer(rendererGraphicTypes);
        this.cmbGraphic.setSelectedIndex(0);
        StaticArrayComboModel<Integer> modelOrient = new StaticArrayComboModel<Integer>(Globals.orientItemValues);
        IconListRenderer rendererOrient = new IconListRenderer();
        rendererOrient.setValues(null, Globals.orientIcons);
        this.cmbOrient.setModel(modelOrient);
        this.cmbOrient.setRenderer(rendererOrient);
        this.cmbOrient.setSelectedIndex(0);
        this.cmbOrient.setSelectedIndex(0);
        this.spinRadius.setValue(100);
        this.txtStart.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtEnd.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        ((AbstractDocument)((JTextComponent)this.cmbGBType.getEditor().getEditorComponent()).getDocument()).setDocumentFilter(DocumentKeyFilter.GenbankNameFilter);
        ((AbstractDocument)((JSpinner.NumberEditor)this.spinWidth.getEditor()).getTextField().getDocument()).setDocumentFilter(DocumentKeyFilter.NumberFilter);
        ((AbstractDocument)((JSpinner.NumberEditor)this.spinRadius.getEditor()).getTextField().getDocument()).setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.setLocationRelativeTo(parent);
        this.setCtrlS_DoOK();
    }

    @Override
    public void doCancel() {
        this.saved = false;
        this.setVisible(false);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setCmbGBType(String gbType) {
        if (gbType == null || gbType.length() == 0) {
            this.cmbGBType.setSelectedItem("misc_feature");
        } else if (gbType != null) {
            int count = this.cmbGBType.getItemCount();
            for (int index = 0; index < count; ++index) {
                if (!this.cmbGBType.getItemAt(index).equalsIgnoreCase(gbType)) continue;
                this.cmbGBType.setSelectedIndex(index);
                break;
            }
        }
    }

    public void loadFeature(Feature feature) {
        this.loadedFeature = feature;
        this.txtFName.setText(feature.getName());
        this.txtStart.setText(String.valueOf(feature.getStart()));
        this.txtEnd.setText(String.valueOf(feature.getStop()));
        this.cmdGColor.setAllBackColors(feature.getBackColor());
        this.cmdLColor.setAllBackColors(feature.getTextColor());
        this.setCmbGBType(feature.getGBType());
        this.cmbOrient.setSelectedIndex(feature.isAntisense() ? 1 : 0);
        if (feature.renderer != null) {
            this.cmbGraphic.setSelectedItem(feature.renderer);
        }
        this.spinWidth.setValue(feature.getWidth());
        this.spinRadius.setValue(feature.getOffset());
        this.txtNotes.setText(feature.getNote());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtFName = new GhostTextBox();
        this.jLabel10 = new JLabel();
        this.txtStart = new GhostTextBox();
        this.txtEnd = new GhostTextBox();
        this.lblStart = new JLabel();
        this.lblEnd = new JLabel();
        this.jPanel2 = new JPanel();
        this.cmdGColor = new GlossyButton();
        this.cmdLColor = new GlossyButton();
        this.toggleLink = new JToggleButton();
        this.jLabel16 = new JLabel();
        this.jLabel15 = new JLabel();
        this.cmbGBType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.chkShowLabel = new JCheckBox();
        this.chkDrawGraphic = new JCheckBox();
        this.jScrollPane4 = new JScrollPane();
        this.txtNotes = new GhostTextArea();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cmdSave = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.spinAlpha = new JSpinner();
        this.spinRadius = new JSpinner();
        this.spinWidth = new JSpinner();
        this.chkPreview = new JCheckBox();
        this.cmbGraphic = new JComboBox();
        this.cmbOrient = new JComboBox();
        this.statusLabel = new StatusLabel();
        this.jMenuBar1 = new JMenuBar();
        this.mnuPresets = new JMenu();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Feature Properties");
        this.setResizable(false);
        this.txtFName.setBlankText("Feature Name *Required*");
        this.txtFName.setSelectionOnFocus(true);
        this.txtFName.setText("New Feature");
        this.txtFName.setDeselectOnFocus(true);
        this.txtFName.setFont(new Font("Segoe UI", 0, 14));
        this.txtFName.setNextFocusableComponent(this.txtStart);
        this.txtFName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmNewFeature.this.txtFNameFocusLost(evt);
            }
        });
        this.jLabel10.setText("Feature Name");
        this.jLabel10.setHorizontalTextPosition(0);
        this.txtStart.setBlankText("Start");
        this.txtStart.setHorizontalAlignment(0);
        this.txtStart.setSelectionOnFocus(true);
        this.txtStart.setText("1");
        this.txtStart.setDeselectOnFocus(true);
        this.txtStart.setFont(new Font("Segoe UI", 0, 14));
        this.txtStart.setNextFocusableComponent(this.txtEnd);
        this.txtStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmNewFeature.this.txtStartFocusLost(evt);
            }
        });
        this.txtEnd.setBlankText("End");
        this.txtEnd.setHorizontalAlignment(0);
        this.txtEnd.setSelectionOnFocus(true);
        this.txtEnd.setText("1");
        this.txtEnd.setDeselectOnFocus(true);
        this.txtEnd.setFont(new Font("Segoe UI", 0, 14));
        this.txtEnd.setNextFocusableComponent(this.cmbGBType);
        this.txtEnd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmNewFeature.this.txtEndFocusLost(evt);
            }
        });
        this.lblStart.setHorizontalAlignment(0);
        this.lblStart.setText("Start");
        this.lblEnd.setHorizontalAlignment(0);
        this.lblEnd.setText("End");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Color Options"));
        this.cmdGColor.setButtonStyle(ButtonRenderer.ButtonStyle.Flat);
        this.cmdGColor.setMaximumSize(new Dimension(20, 20));
        this.cmdGColor.setMinimumSize(new Dimension(20, 20));
        this.cmdGColor.setNextFocusableComponent(this.cmdLColor);
        this.cmdGColor.setPreferredSize(new Dimension(20, 20));
        this.cmdGColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmdGColorActionPerformed(evt);
            }
        });
        this.cmdLColor.setButtonStyle(ButtonRenderer.ButtonStyle.Flat);
        this.cmdLColor.setColorHot(new Color(0, 0, 0));
        this.cmdLColor.setColorNormal(new Color(0, 0, 0));
        this.cmdLColor.setColorPressed(new Color(0, 0, 0));
        this.cmdLColor.setMaximumSize(new Dimension(20, 20));
        this.cmdLColor.setMinimumSize(new Dimension(20, 20));
        this.cmdLColor.setNextFocusableComponent(this.toggleLink);
        this.cmdLColor.setPreferredSize(new Dimension(20, 20));
        this.cmdLColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmdLColorActionPerformed(evt);
            }
        });
        this.toggleLink.setIcon(new ImageIcon(this.getClass().getResource("/images24/24x24_Unlink.png")));
        this.toggleLink.setBorder(BorderFactory.createLineBorder(Globals.buttonBorderColor));
        this.toggleLink.setNextFocusableComponent(this.cmdSave);
        this.toggleLink.setPressedIcon(new ImageIcon(this.getClass().getResource("/images24/24x24_Link.png")));
        this.toggleLink.setRolloverIcon(new ImageIcon(this.getClass().getResource("/images24/24x24_Unlink.png")));
        this.toggleLink.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/images24/24x24_Link.png")));
        this.jLabel16.setHorizontalAlignment(2);
        this.jLabel16.setText("Graphic");
        this.jLabel16.setHorizontalTextPosition(0);
        this.jLabel15.setHorizontalAlignment(2);
        this.jLabel15.setText("Text");
        this.jLabel15.setHorizontalTextPosition(0);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdGColor, -1, -1, Short.MAX_VALUE).addComponent(this.cmdLColor, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16).addComponent(this.jLabel15, -2, 29, -2)).addGap(18, 18, 18).addComponent(this.toggleLink, -2, 23, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -2, 22, -2).addComponent(this.cmdGColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 22, -2).addComponent(this.cmdLColor, -2, -1, -2))).addComponent(this.toggleLink, -2, 44, -2));
        this.cmbGBType.setEditable(true);
        this.cmbGBType.setFont(new Font("Segoe UI", 0, 14));
        this.cmbGBType.setNextFocusableComponent(this.spinAlpha);
        this.cmbGBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmbGBTypeActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Orientation");
        this.jLabel8.setText("Graphics Style");
        this.chkShowLabel.setSelected(true);
        this.chkShowLabel.setText("Show Label");
        this.chkShowLabel.setNextFocusableComponent(this.spinWidth);
        this.chkShowLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.chkShowLabelActionPerformed(evt);
            }
        });
        this.chkDrawGraphic.setSelected(true);
        this.chkDrawGraphic.setText("Show Graphic");
        this.chkDrawGraphic.setNextFocusableComponent(this.chkShowLabel);
        this.chkDrawGraphic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.chkDrawGraphicActionPerformed(evt);
            }
        });
        this.txtNotes.setBlankText("Feature Notes/Comment");
        this.txtNotes.setColumns(20);
        this.txtNotes.setRows(5);
        this.txtNotes.setNextFocusableComponent(this.cmdGColor);
        this.jScrollPane4.setViewportView(this.txtNotes);
        this.jLabel4.setText("Feature Notes");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Width");
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Offset");
        this.cmdSave.setText("Save and Close");
        this.cmdSave.setColorHot(new Color(204, 204, 255));
        this.cmdSave.setColorNormal(new Color(204, 204, 204));
        this.cmdSave.setColorPressed(new Color(204, 204, 255));
        this.cmdSave.setNextFocusableComponent(this.cmdCancel);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmdSaveActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setColorHot(new Color(204, 204, 255));
        this.cmdCancel.setColorNormal(new Color(204, 204, 204));
        this.cmdCancel.setColorPressed(new Color(204, 204, 255));
        this.cmdCancel.setNextFocusableComponent(this.txtFName);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Alpha");
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Genbank Type");
        this.spinAlpha.setFont(new Font("Segoe UI", 0, 14));
        this.spinAlpha.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinAlpha.setNextFocusableComponent(this.chkDrawGraphic);
        this.spinAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmNewFeature.this.spinAlphaStateChanged(evt);
            }
        });
        this.spinRadius.setFont(new Font("Segoe UI", 0, 14));
        this.spinRadius.setModel(new SpinnerNumberModel(100, 50, 150, 1));
        this.spinRadius.setNextFocusableComponent(this.cmbGraphic);
        this.spinRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmNewFeature.this.spinRadiusStateChanged(evt);
            }
        });
        this.spinWidth.setFont(new Font("Segoe UI", 0, 14));
        this.spinWidth.setModel(new SpinnerNumberModel(1, 1, 255, 1));
        this.spinWidth.setNextFocusableComponent(this.spinRadius);
        this.spinWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmNewFeature.this.spinWidthStateChanged(evt);
            }
        });
        this.chkPreview.setSelected(true);
        this.chkPreview.setText("Preview");
        this.chkPreview.setEnabled(false);
        this.chkPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.chkPreviewActionPerformed(evt);
            }
        });
        this.cmbGraphic.setNextFocusableComponent(this.cmbOrient);
        this.cmbOrient.setNextFocusableComponent(this.txtNotes);
        this.cmbOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewFeature.this.cmbOrientActionPerformed(evt);
            }
        });
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -2, 108, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbGBType, -2, 264, -2).addComponent(this.jLabel5, -2, 128, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.spinAlpha, -2, 62, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkShowLabel).addComponent(this.chkDrawGraphic)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkPreview, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtFName, -2, 264, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtStart, -1, 128, Short.MAX_VALUE).addComponent(this.lblStart, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtEnd, -1, 115, Short.MAX_VALUE).addComponent(this.lblEnd, -1, -1, Short.MAX_VALUE)))).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdSave, -2, 106, -2).addComponent(this.cmdCancel, -2, 106, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 56, -2).addComponent(this.spinWidth, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 56, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.spinRadius)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.cmbGraphic, -2, 184, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.cmbOrient, -2, 119, -2)).addGap(85, 85, 85)))).addGap(6, 6, 6)).addComponent(this.statusLabel, -1, 542, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.txtFName, -2, 30, -2).addGap(3, 3, 3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEnd).addComponent(this.lblStart)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtStart, -2, 30, -2).addComponent(this.txtEnd, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbGBType, -2, 30, -2).addComponent(this.spinAlpha, -2, 30, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkDrawGraphic).addComponent(this.chkPreview)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkShowLabel)))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(5, 5, 5)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdSave, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 32, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.spinWidth, -1, 30, Short.MAX_VALUE).addComponent(this.spinRadius).addComponent(this.cmbOrient).addComponent(this.cmbGraphic))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(37, 37, 37))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 139, -2).addGap(0, 0, 0).addComponent(this.statusLabel, -2, 21, -2).addGap(0, 0, 0)));
        this.mnuPresets.setText("Preset Formats");
        this.jMenuBar1.add(this.mnuPresets);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void cmdGColorActionPerformed(ActionEvent evt) {
        this.selectGraphicColor();
    }

    private void cmdLColorActionPerformed(ActionEvent evt) {
        this.selectLabelColor();
    }

    private void txtStartFocusLost(FocusEvent evt) {
        ProjectDocument project = this.getProject();
        int newStart = StringTools.filterStringToInt(this.txtStart.getText(), 1, project.length(), 1, 1, project.length());
        this.txtStart.setText(String.valueOf(newStart));
    }

    private void txtEndFocusLost(FocusEvent evt) {
        ProjectDocument project = this.getProject();
        int newStop = StringTools.filterStringToInt(this.txtEnd.getText(), 1, project.length(), project.length(), 1, project.length());
        this.txtEnd.setText(String.valueOf(newStop));
    }

    private void cmbGBTypeActionPerformed(ActionEvent evt) {
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void spinAlphaStateChanged(ChangeEvent evt) {
    }

    private void spinWidthStateChanged(ChangeEvent evt) {
    }

    private void spinRadiusStateChanged(ChangeEvent evt) {
    }

    private void txtFNameFocusLost(FocusEvent evt) {
        String trimmed;
        String untrimmed = this.txtFName.getText();
        if (untrimmed != (trimmed = Globals.trimmer.trim(untrimmed, "New Feature"))) {
            this.txtFName.setText(trimmed);
        }
    }

    private void chkDrawGraphicActionPerformed(ActionEvent evt) {
    }

    private void chkShowLabelActionPerformed(ActionEvent evt) {
    }

    private void chkPreviewActionPerformed(ActionEvent evt) {
    }

    private void cmbOrientActionPerformed(ActionEvent evt) {
    }

    private void populatePresets() {
        this.presets.add(new FeaturePreset("Primer Binding Site", ProjectDocument.primerColor, ProjectDocument.primerColor, "primer_bind", FeatureRenderer.drawFeatures[3]));
        this.presets.add(new FeaturePreset("Replication Origin", new Color(204, 204, 204), null, "rep_origin", FeatureRenderer.drawFeatures[1]));
        this.presets.add(new FeaturePreset("Selection Marker ORF", Color.yellow, null, "cds", FeatureRenderer.drawFeatures[2]));
        this.presets.add(new FeaturePreset("PolyA Signal", Color.red, null, "polyA_signal", FeatureRenderer.drawFeatures[3]));
        this.presets.add(new FeaturePreset("Terminator", Color.red, null, "terminator", FeatureRenderer.drawFeatures[3]));
        this.presets.add(new FeaturePreset("Promoter", Color.green, null, "promoter", FeatureRenderer.drawFeatures[3]));
        this.presets.add(new FeaturePreset("Intron", Color.lightGray, null, "intron", FeatureRenderer.drawFeatures[1]));
        this.presets.add(new FeaturePreset("Epitope Tag", Color.gray, null, "cds", FeatureRenderer.drawFeatures[1]));
        this.presets.add(new FeaturePreset("Affinity Tag", new Color(102, 255, 51), null, "cds", FeatureRenderer.drawFeatures[1]));
        this.presets.add(new FeaturePreset("Multiple Cloning Site", new Color(255, 176, 95), null, "mult_cloning_site", FeatureRenderer.drawFeatures[1]));
        this.presets.add(new FeaturePreset("LTR", Color.BLUE.brighter(), null, "LTR", FeatureRenderer.drawFeatures[1]));
        this.presets.sort(new Comparator<FeaturePreset>(){

            @Override
            public int compare(FeaturePreset o1, FeaturePreset o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        for (final FeaturePreset f : this.presets) {
            JMenuItem menu = new JMenuItem(f.name);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    f.set();
                }
            });
            this.mnuPresets.add(menu);
        }
    }

    private void selectGraphicColor() {
        Color newColor = JColorChooser.showDialog(this, "Select New Feature Graphic Color", this.cmdGColor.getColorNormal());
        if (newColor != null) {
            this.cmdGColor.setAllBackColors(newColor);
            if (this.toggleLink.isSelected()) {
                this.cmdLColor.setAllBackColors(newColor);
            }
        }
    }

    private void selectLabelColor() {
        Color newColor = JColorChooser.showDialog(this, "Select New Feature Label Color", this.cmdLColor.getColorNormal());
        if (newColor != null) {
            this.cmdLColor.setAllBackColors(newColor);
            if (this.toggleLink.isSelected()) {
                this.cmdGColor.setAllBackColors(newColor);
            }
        }
    }

    private void selectColor(int src) {
        Color defColor = src == 0 ? this.cmdGColor.getColorNormal() : this.cmdLColor.getColorNormal();
        Color newColor = JColorChooser.showDialog(this, "Select New Feature Graphic Color", defColor);
        if (newColor != null) {
            this.cmdGColor.setAllBackColors(newColor);
            if (this.toggleLink.isSelected()) {
                this.cmdLColor.setAllBackColors(newColor);
            }
        }
    }

    @Override
    public ROI getROI() {
        Feature f = new Feature();
        f.setStart(StringTools.filterStringToInt(this.txtStart.getText()));
        f.setStop(StringTools.filterStringToInt(this.txtEnd.getText()));
        f.setAntisense(this.cmbOrient.getSelectedIndex() == 1);
        f.setName(this.txtFName.getText());
        f.renderer = (FeatureRenderer)this.cmbGraphic.getSelectedItem();
        f.setWidth((int)f.renderer.defWidth);
        f.setNote(this.txtNotes.getText());
        f.setGBType((String)this.cmbGBType.getSelectedItem());
        f.setAlpha((Integer)this.spinAlpha.getValue());
        f.setTextColor(this.cmdLColor.getColorNormal());
        f.setOffset((Integer)this.spinRadius.getValue());
        f.setBackColor(this.cmdGColor.getColorNormal());
        f.setHidden(!this.chkDrawGraphic.isSelected());
        f.setShowLabel(this.chkShowLabel.isSelected());
        return f;
    }

    @Override
    public void setROI(ROI roi) {
        if (roi != null) {
            this.loadedFeature = roi instanceof Feature ? (Feature)roi : Feature.fromAnnotation(roi);
            this.start = roi.getStart();
            this.stop = roi.getStop();
            this.txtFName.setText(roi.getName());
            this.cmbOrient.setSelectedIndex(roi.isAntisense() ? 1 : 0);
            this.cmdGColor.setAllBackColors(roi.getColor());
            this.cmdLColor.setAllBackColors(this.loadedFeature.getTextColor());
            this.cmbGBType.getModel().setSelectedItem(this.loadedFeature.getGBType());
            this.txtFName.setText(this.loadedFeature.getName(), false);
            this.cmbOrient.setSelectedIndex(this.loadedFeature.isAntisense() ? 1 : 0);
            this.cmbGBType.getModel().setSelectedItem(this.loadedFeature.getGBType());
            this.cmbGraphic.setSelectedItem(this.loadedFeature.renderer);
            int minWd = (int)this.loadedFeature.renderer.minWidth;
            int maxWd = (int)this.loadedFeature.renderer.maxWidth;
            this.spinWidth.setModel(new SpinnerNumberModel(this.loadedFeature.getWidth(), minWd, maxWd, 1));
            this.chkDrawGraphic.setSelected(true);
            this.chkShowLabel.setSelected(this.loadedFeature.showLabel());
            this.txtNotes.setText(this.loadedFeature.getNote(), false);
            this.txtNotes.select(0, 0);
        } else {
            this.loadedFeature = null;
            this.txtFName.setText("New Feature");
            this.start = 1;
            this.stop = 1;
            this.cmbOrient.setSelectedIndex(0);
            this.cmdGColor.setBackground(Color.cyan);
        }
        this.txtStart.setText("" + this.start);
        this.txtEnd.setText("" + this.stop);
    }

    @Override
    public void setLength(int length) {
    }

    public class FeaturePreset {
        String name;
        Color backColor;
        Color textColor;
        String gbType;
        FeatureRenderer graphic;

        public FeaturePreset(String name, Color backColor, Color textColor, String gbType, FeatureRenderer graphic) {
            this.name = name;
            if (this.name == null || this.name.length() == 0) {
                this.name = "Unnamed Preset";
            }
            this.backColor = backColor;
            this.textColor = textColor;
            this.gbType = gbType;
            this.graphic = graphic;
        }

        public void set() {
            if (this.backColor != null) {
                FrmNewFeature.this.cmdGColor.setAllBackColors(this.backColor);
            }
            if (this.textColor != null) {
                FrmNewFeature.this.cmdLColor.setAllBackColors(this.textColor);
            }
            FrmNewFeature.this.setCmbGBType(this.gbType);
            if (this.graphic != null) {
                FrmNewFeature.this.cmbGraphic.setSelectedItem(this.graphic);
            }
        }
    }
}

