/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BlockTree.BlocksTree;
import BlockTree.NodeBlock;
import BlockTree.NodeFile;
import BlockTree.NodeFolder;
import BlockTree.NodeRoot;
import GraphicTreeClass.GraphicTreeNode;
import MouseMenuListeners.Listeners;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.SeqDragListener;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.SequenceExportFormat;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import plaf.BaseRootPaneUI;
import plot.Globals;
import plot.JOptionPanes;
import plot.MobileBlock;
import plot.SEFTransferHandler;

class FrmMolBlocksTree
extends JFrame {
    File currentFile;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmMolBlocksTree.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmMolBlocksTree.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private static final String helpText = "<html><b><u>Sequence Blocks</u></b><br>Drag and drop annotations from a project to the list to store the sequence, <br>and annotations properties.  These blocks can be dragged and dropped <br>into projects to insert the sequence and proterties into that project. <br><br>The list of stored sequence blocks can be saved to an external file and <br>loaded at a later timer using the Save, Save as, and Open buttons.<br><br>Sequence can be removed using the Delete button or the delete key.</html>";
    private final FileFilter blocksFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String lc = file.getAbsolutePath().toLowerCase();
            return lc.endsWith(".block");
        }

        @Override
        public String getDescription() {
            return "pLOT Sequence Blocks XML File";
        }
    };
    final String ext = ".block";
    private JButton cmdAddGroup;
    private JButton cmdDelete;
    private JButton cmdNew;
    private JButton cmdOpen;
    private JButton cmdSave;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator34;
    private JSplitPane jSplitPane1;
    private JLabel lblHelp;
    private JMenuBar menuBar;
    private JMenuItem mnuNew;
    private JMenuItem mnuOpen;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuToggleAS;
    private JMenuItem mnuToggleFrame1;
    private JMenuItem mnuToggleFrame2;
    private JMenuItem mnuToggleFrame3;
    private JMenu mnuView;
    private SequenceEditorPanel seqView;
    private StatusLabel statusLabel;
    private JToolBar toolBar;
    private BlocksTree tree;

    public FrmMolBlocksTree() {
        this.initComponents();
        this.setIconImage(Globals.icon.getImage());
        BaseRootPaneUI.addAlwaysOnTop(this, this.menuMouseListener);
        this.toolBar.setFloatable(false);
        Listeners.setMenuBarListeners(this.menuBar, this.menuMouseListener);
        Listeners.setToolbarListeners(this.toolBar, this.menuMouseListener);
        this.lblHelp.setToolTipText(helpText);
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setTransferHandler(new SEFTransferHandler(this.tree){

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return super.canImport(support);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    SequenceExportFormat[] sef = (SequenceExportFormat[])support.getTransferable().getTransferData(SequenceExportFormat.copiedSequencesFlavor);
                    if (sef == null) {
                        return false;
                    }
                    this.droppedItems(sef, support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
            }

            @Override
            public void droppedItems(SequenceExportFormat[] sef, int x, int y) {
                GraphicTreeNode parentNode = null;
                int index = 0;
                TreePath parentPath = FrmMolBlocksTree.this.tree.getPathForLocation(x, y);
                if (parentPath != null) {
                    parentNode = (GraphicTreeNode)parentPath.getLastPathComponent();
                }
                if (parentNode instanceof NodeBlock) {
                    index = parentNode.getParent().getIndex(parentNode);
                    parentNode = (GraphicTreeNode)parentNode.getParent();
                } else if (parentNode == null || parentNode instanceof NodeRoot) {
                    NodeFolder newNode = new NodeFolder("New Category");
                    FrmMolBlocksTree.this.tree.addNode(newNode, FrmMolBlocksTree.this.tree.getRoot());
                    parentNode = newNode;
                } else if (parentNode instanceof NodeFolder) {
                    index = parentNode.getChildCount();
                }
                for (SequenceExportFormat sef1 : sef) {
                    FrmMolBlocksTree.this.tree.addNode(new MobileBlock(sef1), parentNode, index);
                    ++index;
                }
                FrmMolBlocksTree.this.tree.expandNode(parentNode);
            }
        });
        SeqDragListener listener = new SeqDragListener(this.tree){

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }

            @Override
            public SequenceExportFormat[] getSEF() {
                return FrmMolBlocksTree.this.tree.getSelectedSEF();
            }
        };
        this.setKeys();
        this.updateEnables();
    }

    private void setKeys() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMolBlocksTree.this.delete();
            }
        });
    }

    public void delete() {
        GraphicTreeNode[] nodes;
        for (GraphicTreeNode node : nodes = this.tree.getSelectedNodes()) {
            if (node instanceof NodeRoot) continue;
            this.tree.removeNode(node);
        }
    }

    private void rightNodeClick(GraphicTreeNode node, int x, int y) {
        if (!(node instanceof NodeRoot)) {
            if (node instanceof NodeBlock) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new JMenuItem("Remove"));
                menu.show(this.tree, x, y);
            } else if (node instanceof NodeFolder) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new JMenuItem("Copy as a single sequence"));
                JMenuItem mnuGibson = new JMenuItem("Create Gibson primers");
                mnuGibson.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
                menu.add(new JMenuItem("Create Gibson primers"));
                menu.add(new JMenuItem("Remove"));
                menu.show(this.tree, x, y);
            }
        }
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.cmdNew = new JButton();
        this.cmdOpen = new JButton();
        this.cmdSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.cmdAddGroup = new JButton();
        this.cmdDelete = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.lblHelp = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.seqView = new SequenceEditorPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new BlocksTree(){

            @Override
            public void nodeSelected(GraphicTreeNode node) {
                if (node instanceof NodeBlock) {
                    FrmMolBlocksTree.this.seqView.getDocument().setSequence((SequenceExportFormat)((NodeBlock)node).getBlock().getItem());
                    FrmMolBlocksTree.this.seqView.select(0);
                    FrmMolBlocksTree.this.seqView.setSelectionLength(0);
                } else {
                    FrmMolBlocksTree.this.seqView.clear();
                }
            }

            @Override
            public void nodeRightClicked(GraphicTreeNode node, int x, int y) {
                FrmMolBlocksTree.this.rightNodeClick(node, x, y);
            }
        };
        this.statusLabel = new StatusLabel();
        this.menuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuNew = new JMenuItem();
        this.mnuOpen = new JMenuItem();
        this.mnuSave = new JMenuItem();
        this.mnuSaveAs = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.mnuView = new JMenu();
        this.jSeparator34 = new JPopupMenu.Separator();
        this.mnuToggleFrame1 = new JMenuItem();
        this.mnuToggleFrame2 = new JMenuItem();
        this.mnuToggleFrame3 = new JMenuItem();
        this.mnuToggleAS = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.setTitle("Sequence Blocks");
        this.toolBar.setRollover(true);
        this.cmdNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.cmdNew.setToolTipText("Start a new project.");
        this.cmdNew.setContentAreaFilled(false);
        this.cmdNew.setFocusable(false);
        this.cmdNew.setHorizontalTextPosition(0);
        this.cmdNew.setVerticalTextPosition(3);
        this.cmdNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.cmdNewActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdNew);
        this.cmdOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.cmdOpen.setToolTipText("Open an existing project");
        this.cmdOpen.setContentAreaFilled(false);
        this.cmdOpen.setFocusable(false);
        this.cmdOpen.setHorizontalTextPosition(0);
        this.cmdOpen.setVerticalTextPosition(3);
        this.cmdOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.cmdOpenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdOpen);
        this.cmdSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.cmdSave.setToolTipText("Save the current project.");
        this.cmdSave.setContentAreaFilled(false);
        this.cmdSave.setFocusable(false);
        this.cmdSave.setHorizontalTextPosition(0);
        this.cmdSave.setVerticalTextPosition(3);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.cmdSaveActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSave);
        this.toolBar.add(this.jSeparator1);
        this.cmdAddGroup.setIcon(new ImageIcon(this.getClass().getResource("/images24/PLUS_1.png")));
        this.cmdAddGroup.setToolTipText("Add a group");
        this.cmdAddGroup.setContentAreaFilled(false);
        this.cmdAddGroup.setFocusable(false);
        this.cmdAddGroup.setHorizontalTextPosition(0);
        this.cmdAddGroup.setVerticalTextPosition(3);
        this.cmdAddGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.cmdAddGroupActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdAddGroup);
        this.cmdDelete.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.cmdDelete.setToolTipText("Remove selected items");
        this.cmdDelete.setContentAreaFilled(false);
        this.cmdDelete.setFocusable(false);
        this.cmdDelete.setHorizontalTextPosition(0);
        this.cmdDelete.setVerticalTextPosition(3);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdDelete);
        this.toolBar.add(this.jSeparator2);
        this.lblHelp.setHorizontalAlignment(0);
        this.lblHelp.setIcon(new ImageIcon(this.getClass().getResource("/images24/QUESTION.png")));
        this.toolBar.add(this.lblHelp);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.7);
        this.jLabel1.setText("Sequence Preview");
        this.seqView.setAutoColumnCount(true);
        this.seqView.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.seqView, -2, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 116, -2).addGap(0, 158, Short.MAX_VALUE))).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.seqView, -1, 135, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.jScrollPane1.setViewportView(this.tree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 434, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.jMenu1.setText("File");
        this.mnuNew.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.mnuNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.mnuNew.setText("Start a New File");
        this.mnuNew.setToolTipText("Start a new sequence blocks xml file.");
        this.mnuNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuNewActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuNew);
        this.mnuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.mnuOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.mnuOpen.setText("Open Existing Project");
        this.mnuOpen.setToolTipText("Open an existing sequence blocks xml file");
        this.mnuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuOpenActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuOpen);
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSave.setText("Save List");
        this.mnuSave.setToolTipText("Save the current blocks");
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSave);
        this.mnuSaveAs.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSaveAs.setText("Save Project As...");
        this.mnuSaveAs.setToolTipText("Save the current blocks to an xml file.");
        this.mnuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuSaveAsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSaveAs);
        this.menuBar.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.menuBar.add(this.jMenu2);
        this.mnuView.setText("View");
        this.mnuView.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                FrmMolBlocksTree.this.mnuViewMenuSelected(evt);
            }
        });
        this.jSeparator34.setToolTipText("Change Feature Viewer Format");
        this.mnuView.add(this.jSeparator34);
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame1.setText("Toggle Feature Viewer Reading Frame 1");
        this.mnuToggleFrame1.setToolTipText("Toggle showing reading frame 1 translation in the Feature Viewer window.");
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame2.setText("Toggle Feature Viewer Reading Frame 2");
        this.mnuToggleFrame2.setToolTipText("Toggle showing reading frame 2 translation in the Feature Viewer window.");
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame3.setText("Toggle Feature Viewer Reading Frame 3");
        this.mnuToggleFrame3.setToolTipText("Toggle showing reading frame 3 translation in the Feature Viewer window.");
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame3);
        this.mnuToggleAS.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAS.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.mnuToggleAS.setText("Toggle Feature Viewer Antisense");
        this.mnuToggleAS.setToolTipText("Toggle showing the antisense strand in the Feature Viewer window.");
        this.mnuToggleAS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.mnuToggleASActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleAS);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.jMenuItem2.setText("Toggle Feature Viewer Numbers");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocksTree.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.jMenuItem2);
        this.jSeparator23.setToolTipText("");
        this.mnuView.add(this.jSeparator23);
        this.menuBar.add(this.mnuView);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 286, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolBar, -2, 32, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmdNewActionPerformed(ActionEvent evt) {
        this.newList();
    }

    private void cmdOpenActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void newList() {
        this.tree.clear();
    }

    private void open(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object obj = objectInputStream.readObject();
            NodeFile fileFolder = new NodeFile(file.getName());
            fileFolder.setFile(file);
            this.tree.addNode(fileFolder);
            if (obj instanceof SequenceExportFormat[]) {
                SequenceExportFormat[] blocks = (SequenceExportFormat[])obj;
                NodeFolder defFolder = this.tree.addFolder("New Group");
                this.tree.addNode(defFolder, (GraphicTreeNode)fileFolder);
                for (SequenceExportFormat block : blocks) {
                    this.tree.addNode(new MobileBlock(block), (GraphicTreeNode)defFolder, 0);
                }
            } else if (!(obj instanceof NodeRoot)) {
                if (obj instanceof NodeFolder) {
                    this.tree.addNode(fileFolder);
                    this.tree.addNode((NodeFolder)obj, (GraphicTreeNode)fileFolder);
                } else {
                    objectInputStream.close();
                    return;
                }
            }
            this.currentFile = file;
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void save() {
        if (this.currentFile == null) {
            this.saveAs();
        } else {
            try {
                NodeRoot cRoot = (NodeRoot)this.tree.getRoot();
                FileOutputStream fileOutputStream = new FileOutputStream(this.currentFile);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(cRoot);
                objectOutputStream.flush();
                objectOutputStream.close();
                this.statusLabel.setText("Saved to: " + this.currentFile.getAbsolutePath());
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                this.statusLabel.setText("Save failed!");
            }
        }
    }

    public void open() {
        int val;
        JFileChooser c = new JFileChooser();
        c.setFileFilter(this.blocksFilter);
        if (this.currentFile != null) {
            c.setSelectedFile(this.currentFile);
        }
        if ((val = c.showOpenDialog(null)) != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null && file.getName().toLowerCase().endsWith(".block")) {
            this.open(file);
        }
    }

    private void saveAs() {
        JFileChooser c = new JFileChooser();
        c.setFileFilter(this.blocksFilter);
        if (c.showSaveDialog(null) != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null) {
            if (!file.getName().toLowerCase().endsWith(".block")) {
                file = new File(file.getAbsoluteFile() + ".block");
            }
            this.currentFile = file;
            if (!this.currentFile.exists() || this.currentFile.exists() && JOptionPanes.showConfirmDialog(null, (Object)"Overwrite existing file?", "File exists", 0) == 0) {
                this.save();
            }
        }
    }

    private void updateEnables() {
    }

    private void mnuNewActionPerformed(ActionEvent evt) {
        this.newList();
    }

    private void mnuOpenActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void mnuSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.seqView.setShowFrame1(!this.seqView.isShowFrame1());
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.seqView.setShowFrame2(!this.seqView.isShowFrame2());
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.seqView.setShowFrame3(!this.seqView.isShowFrame3());
    }

    private void mnuToggleASActionPerformed(ActionEvent evt) {
        this.seqView.setShowAntisense(!this.seqView.isShowAntisense());
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.seqView.setShowNumbers(!this.seqView.isShowNumbers());
    }

    private void mnuViewMenuSelected(MenuEvent evt) {
        this.mnuView.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void cmdAddGroupActionPerformed(ActionEvent evt) {
        this.tree.addNode(new NodeFolder("New Group"));
    }
}

