/*
 * Decompiled with CFR 0.152.
 */
package plot;

import JMWiki.JWikiPane;
import JMWiki.WikiDocument;
import JMWiki.WikiEvent;
import JMWiki.WikiModelListener;
import JMWiki.WikiPage;
import JMWiki.WikiPaneListener;
import ScrollPanels.StatusLabel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import plaf.BaseRootPaneUI;
import plot.ChangesMade;
import plot.Globals;

class FrmHelp
extends JFrame
implements WikiPaneListener,
WikiModelListener {
    private static final int I_TITLECOLOR = 0;
    private static final int I_TITLEBACKCOLOR = 1;
    private static final int I_FORECOLOR = 2;
    private static final int I_BACKCOLOR = 3;
    private static final int I_VISITEDLINKCOLOR = 4;
    private static final int I_UNVISITEDLINKCOLOR = 5;
    private static final int I_HOVERLINKCOLOR = 6;
    private static final int I_SELECTEDLINKCOLOR = 7;
    private static final String[] UIKeys = new String[]{"wikipane.titlecolor", "wikipane.titlebackcolor", "wikipane.forecolor", "wikipane.backcolor", "wikipane.visitedlinkcolor", "wikipane.linkcolor", "wikipane.hoverlinkcolor", "wikipane.activelinkcolor"};
    private final String[] wikiColors = new String[]{"black", "gray", "black", "white", "blue", "red", "yellow", "red"};
    static String headerCSS;
    static String header;
    private static String genHeader;
    public static final String footer = "</html>";
    public static final String divMain = "<div class=main>";
    private static final String indexRE = "<div class=main><br><b>Restriction Enzymes Related</b><br><a href=\"re_userlist\">Using user lists</a><br><a href=\"re_usermixlist\">Using user mix lists</a><br><a href=\"re_filters\">Using filters</a>";
    private static final String indexPrimers = "<br><br><b>Primers Related</b><br><a href=\"primers_adding\">Adding new primers</a><br><a href=\"primers_editing\">Editing existing primers</a><br><a href=\"primers_removing\">Removing primers</a><br><a href=\"primers_toggling\">Toggling primers on the map</a>";
    private static final String indexVersion = "<br><br><b>Version Information</b><br><a href=\"version_info\">Updates to this version</a>";
    private static String genHelp;
    private static final String errorHelp = "<b><u>Page has not yet been made.</u></b>";
    private static final String reMain = "<a href=\"re_userlist\">User Lists</a><br><a href=\"re_usermixlist\">User Mix Lists</a><br><a href=\"re_filters\">User Filters</a>";
    private static final String userMixListHelp = "<b><u>User Mix Lists</u></b><br> User Mix Lists are lists of enzyme mixes grouped together for ease of use.  For example, a list could be made to commonly used digest mixes for plasmid verification.  Selecting an existing  list from the '<i>Manual / Custom Mixes</i>' dropdown box will display the currently saved mixes or the option to manually select enzyme mixes.<br><br> <b>Creating a mix list</b>:<br> Once the desired enzyme mixes are in the '<i>Enzyme Mix</i>' list box, a mix lists can be creating by clicking the <i>'Add'</i> button to add the selected enzymes as a new  mix.  This will open a prompt to enter a name for the new list <b><i>*Names must be unique*</i></b>. Pressing enter will make the list. Cancelling will abort making the list.<br><br> <b>Editing a mix list's enzymes</b>:<br> Mix lists can be edited by selecting list in the dropdown box and manually setting the mixes you want in the '<i>Enzyme Mix</i>' tab.  Clicking the button next to the dropdown box will pop up the menu. Select the <i>Update current mix list</i> menu item to set the enzymes mixes currently in the '<i>Enzyme Mix</i>' listbox as the user mix list's new contents.  Enzymes not in the '<i>Enzyme Mix</i>' listbox will be removedfrom the user mix list.<br><br><b>Renaming or deleting a mix list</b>:<br> Mix lists can be renamed or deleted by selecting list in the dropdown box and clicking the button next to the dropdown box to pop up the menu.  Select the '<i>Rename selected enzyme mix list</i>' or  '<i>Delete selected enzyme mix list</i>' menu item to proceed.";
    private static final String userListHelp = "<b><u>User Lists</u></b><br> User Lists are lists of enzymes grouped together for ease of use.  For example, a user list could be made to show GoldenGate enzymes or enzymes in stock in your lab.  Selecting an existing  list from  the dropdown box in the upper right hand corner of the Restriction Enzyme window causes only those enzymes to show up in the selectable enzymes lists assuming they meet the other criteria in the <i>Filter Site Selection panel</i>.<br><br> <b>Creating a list</b>:<br> Lists can be creating by manually selecting the enzymes you want from the '<i>Manual Selection</i>' tab and then click the button next to the dropdown box in the upper right hand corner of the window to show the popup menu. Click the <i>'Add selected enzymes as a new list'</i> menu item to be prompted to enter a name for the new list. <b>*Names must be unique*</b>  Pressing enter will make the list.  Cancelling will abort making the list.<br><br> <b>Editing a list's enzymes</b>:<br> Lists can be edited by selecting list in the dropdown box and manually setting the enzymes you want from the '<i>Manual Selection</i>' tab.  Clicking the button next to the dropbox will pop up the menu.  Select the <i>Update current list</i> menu item to set the enzymes currently in the '<i>Selected Enzymes</i>' listbox as the user list's new contents.  Enzymes not in the '<i>Selected Enzymes</i>' listbox will be removed from the user list.<br><br><b>Renaming or deleting a list</b>:<br> Lists can be renamed or deleted by selecting list in the dropbox and clicking the button next to the dropbox to pop up the menu. Select the '<i>Rename selected enzymes list</i>' or '<i>Delete selected enzymes list</i>' menu item to proceed.";
    private static final String filterHelp = "<b> Enzyme Filters</b><br> Filters show enzymes that are not otherwise selected based on the number of times they cut in a specific interval.  Multiple filters can be used at once provided they are not mutually exclusive.<br><br> <b><u>Example</u></b>:<br> Adding a single filter with min cuts = 1, max cuts = 5, minbp = 200, maxbp = 500 would show any enzymes that cut 1 to 5 times from bp 200 to 500 (inclusive).  The number of sites outside the specified region do not affect the filter's result.<br><br> Adding a second filter single filter with min cuts = 0, max cuts = 0, minbp = 1, maxbp = 199<br> Would show enzymes that fulfill both of the filters' criteria.  In this case they must:<br> &nbsp&nbsp - cut 1 to 5 times from bps 200 to 500 (inclusive) <b>AND</b><br> &nbsp&nbsp - do not cut from bps 1 - 199 (inclusive).<br><br> Using mutually exclusive filters results in no enzyme fulfilling the criteria, for example adding another with min cuts = 0, max cuts = 0, minbp = 200, maxbp = 500 to the first filter. as an enzyme cannot both have 1 to 5 and 0 cuts in the same interval.";
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmHelp.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmHelp.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private JButton cmdBack;
    private JButton cmdFwd;
    private JButton cmdHome;
    private JMenu jMenu1;
    private JScrollPane jScrollPane2;
    private JMenuBar menubarMain;
    private JMenuItem mnuBack;
    private JMenuItem mnuFwd;
    private JMenu mnuNav;
    private StatusLabel statusLabel;
    private JToolBar toolbarMain;
    private JWikiPane wikiPane;

    private void genHTML() {
        for (int index = 0; index < UIKeys.length; ++index) {
            Color color = UIManager.getColor(UIKeys[index]);
            if (color == null) continue;
            this.wikiColors[index] = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        }
        ((HTMLDocument)this.wikiPane.getDocument()).getStyleSheet().addRule("a{color: " + this.wikiColors[5] + "; text-decoration: none;}");
        ((HTMLDocument)this.wikiPane.getDocument()).getStyleSheet().addRule("a:visited{color: " + this.wikiColors[4] + ";}");
        ((HTMLDocument)this.wikiPane.getDocument()).getStyleSheet().addRule("a:hover{color: " + this.wikiColors[6] + ";}");
        ((HTMLDocument)this.wikiPane.getDocument()).getStyleSheet().addRule("a:active{color: " + this.wikiColors[7] + ";}");
        headerCSS = "<style type=\"text/css\">\n.title {\n  color: " + this.wikiColors[0] + ";\n  background-color: " + this.wikiColors[1] + ";\n  padding: 10px; \n}\n.main {\n  color: " + this.wikiColors[2] + ";\n  background-color: " + this.wikiColors[3] + ";\n  padding: 5px; \n}\n</style>";
        header = headerCSS + "<html><div class=title><b><font color=\"" + this.wikiColors[0] + "\">Main links: </b></font><a href=\"plot_main\">Home</a>, <a href=\"reMain\">Restriction Enzymes</a><br><br>";
        genHeader = header + divMain + "<b><u>" + "pLOT Plasmid Plotter" + "</u></b> build " + Globals.getBuildDate() + "<br>" + "Copyright Jean-Marc DeKeyser (C) 2012 - 3012" + "<br><a href = \"" + "http://www.plasmidplotter.com" + "\">Homepage</a>, <a href = \"" + "https://www.facebook.com/pLOTPlasmidMapper/" + "\">Facebook page</a><br>" + divMain;
        genHelp = genHeader + "<b><u>Index</u></b>" + indexRE + indexPrimers + indexVersion + footer;
    }

    private String getErrorHelp() {
        return header + divMain + errorHelp + footer;
    }

    private String getMainHelp() {
        return header + divMain + reMain + footer;
    }

    private String getUserMixListHelp() {
        return header + divMain + userMixListHelp + footer;
    }

    private String getUserListHelp() {
        return header + divMain + userListHelp + footer;
    }

    private String getFilterHelp() {
        return header + divMain + filterHelp + footer;
    }

    public FrmHelp() {
        this.initComponents();
        this.genHTML();
        BaseRootPaneUI.addAlwaysOnTop(this, this.menuMouseListener);
        this.cmdBack.addMouseListener(this.menuMouseListener);
        this.cmdFwd.addMouseListener(this.menuMouseListener);
        this.cmdHome.addMouseListener(this.menuMouseListener);
        this.toolbarMain.setFloatable(false);
        this.wikiPane.getModel().setTitle("pLOT Wiki");
        this.wikiPane.getModel().setDescription("pLOT help wiki.");
        this.wikiPane.getModel().setHomePage(new WikiPage("plot_main", "pLOT Wiki Homepage", genHelp));
        this.wikiPane.getModel().setErrorPage(new WikiPage("plot_error", "pLOT Wiki Error.", this.getErrorHelp()));
        this.wikiPane.getModel().addPage("re_userlist", "Restriction Enzyme User Lists", this.getUserListHelp());
        this.wikiPane.getModel().addPage("re_usermixlist", "Restriction Enzyme User Mix Lists", this.getUserMixListHelp());
        this.wikiPane.getModel().addPage("re_filters", "Restriction Enzyme Filters", this.getFilterHelp());
        this.wikiPane.getModel().addPage("reMain", "Restriction Enzymes Help", this.getMainHelp());
        this.wikiPane.getModel().addPage("version_info", "Version Information", ChangesMade.getHTML());
        this.wikiPane.setListener(this);
        this.wikiPane.getModel().addListener(this);
        this.wikiPane.clearHistory();
        this.wikiPane.openPage("plot_main");
    }

    public void openLink(String link) {
        this.wikiPane.openPage(link);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.wikiPane = new JWikiPane();
        this.toolbarMain = new JToolBar();
        this.cmdHome = new JButton();
        this.cmdBack = new JButton();
        this.cmdFwd = new JButton();
        this.statusLabel = new StatusLabel();
        this.menubarMain = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuNav = new JMenu();
        this.mnuBack = new JMenuItem();
        this.mnuFwd = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Help");
        this.jScrollPane2.setViewportView(this.wikiPane);
        this.toolbarMain.setRollover(true);
        this.cmdHome.setIcon(new ImageIcon(this.getClass().getResource("/images24/home.png")));
        this.cmdHome.setToolTipText("Go back to the help homepage.");
        this.cmdHome.setFocusable(false);
        this.cmdHome.setHorizontalTextPosition(0);
        this.cmdHome.setVerticalTextPosition(3);
        this.cmdHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmHelp.this.cmdHomeActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdHome);
        this.cmdBack.setIcon(new ImageIcon(this.getClass().getResource("/images24/back.png")));
        this.cmdBack.setFocusable(false);
        this.cmdBack.setHorizontalTextPosition(0);
        this.cmdBack.setVerticalTextPosition(3);
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmHelp.this.cmdBackActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdBack);
        this.cmdFwd.setIcon(new ImageIcon(this.getClass().getResource("/images24/forward.png")));
        this.cmdFwd.setFocusable(false);
        this.cmdFwd.setHorizontalTextPosition(0);
        this.cmdFwd.setVerticalTextPosition(3);
        this.cmdFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmHelp.this.cmdFwdActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdFwd);
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 440, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.jMenu1.setText("File");
        this.menubarMain.add(this.jMenu1);
        this.mnuNav.setText("Navigation");
        this.mnuBack.setIcon(new ImageIcon(this.getClass().getResource("/images24/back.png")));
        this.mnuBack.setText("Go back");
        this.mnuBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmHelp.this.mnuBackActionPerformed(evt);
            }
        });
        this.mnuNav.add(this.mnuBack);
        this.mnuFwd.setIcon(new ImageIcon(this.getClass().getResource("/images24/forward.png")));
        this.mnuFwd.setText("Go forward");
        this.mnuFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmHelp.this.mnuFwdActionPerformed(evt);
            }
        });
        this.mnuNav.add(this.mnuFwd);
        this.menubarMain.add(this.mnuNav);
        this.setJMenuBar(this.menubarMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 440, Short.MAX_VALUE).addContainerGap()).addComponent(this.toolbarMain, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -1, 440, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolbarMain, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 287, Short.MAX_VALUE).addGap(29, 29, 29)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 333, Short.MAX_VALUE).addComponent(this.statusLabel, -2, 25, -2))));
        this.pack();
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
        this.goBack();
    }

    private void mnuBackActionPerformed(ActionEvent evt) {
        this.goBack();
    }

    private void mnuFwdActionPerformed(ActionEvent evt) {
        this.goFwd();
    }

    private void cmdFwdActionPerformed(ActionEvent evt) {
        this.goFwd();
    }

    private void cmdHomeActionPerformed(ActionEvent evt) {
        this.wikiPane.displayPage(this.wikiPane.getModel().getHomePage());
    }

    private void goBack() {
        this.wikiPane.goBack();
        this.cmdBack.setToolTipText(this.wikiPane.getBackPageName());
        this.cmdFwd.setToolTipText(this.wikiPane.getForwardPageName());
    }

    private void goFwd() {
        this.wikiPane.goForward();
        this.cmdBack.setToolTipText(this.wikiPane.getBackPageName());
        this.cmdFwd.setToolTipText(this.wikiPane.getForwardPageName());
    }

    @Override
    public void wikiPanelEvent(WikiEvent ... events) {
        block3: for (WikiEvent event : events) {
            switch (event.value) {
                case 0: {
                    boolean hasPrev = this.wikiPane.canGoBack();
                    boolean hasNext = this.wikiPane.canGoForward();
                    this.cmdFwd.setEnabled(hasNext);
                    this.mnuFwd.setEnabled(hasNext);
                    this.cmdBack.setEnabled(hasPrev);
                    this.mnuBack.setEnabled(hasPrev);
                    WikiPage currentPage = this.wikiPane.getCurrentPage();
                    if (currentPage != null) {
                        this.setTitle(this.wikiPane.getModel().getTitle() + " - " + currentPage.getTitle());
                        continue block3;
                    }
                    this.setTitle(this.wikiPane.getModel().getTitle());
                }
            }
        }
    }

    @Override
    public void wikiModelPropertyChanged(WikiEvent ... events) {
        block4: for (WikiEvent event : events) {
            switch (event.value) {
                case 11: {
                    if (WikiDocument.isExternalURL((String)event.data1)) {
                        this.statusLabel.setText("Go to " + (String)event.data1);
                        continue block4;
                    }
                    WikiPage page = this.wikiPane.getModel().getPage((String)event.data1);
                    if (page == null) continue block4;
                    if (page == this.wikiPane.getModel().getErrorPage()) {
                        this.statusLabel.setText("Link page missing");
                        continue block4;
                    }
                    this.statusLabel.setText("Go to " + page.getTitle());
                    continue block4;
                }
                case 12: {
                    this.statusLabel.setText("");
                }
            }
        }
    }

    static {
        genHelp = genHeader + "<b><u>Index</u></b>" + indexRE + indexPrimers + indexVersion + footer;
    }
}

