/*
 * Decompiled with CFR 0.152.
 */
package plot;

import MouseMenuListeners.Listeners;
import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.AnnotationEditor;
import SequenceEditorPanels.CursorSelectionChangeListener;
import SequenceEditorPanels.DNASequenceDocument;
import SequenceEditorPanels.ROI;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.DNA;
import Sequences.SequenceExportFormat;
import UndoRedo.UndoableAction;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import plot.Feature;
import plot.FrmGoTo;
import plot.FrmNewFeature;
import plot.Globals;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;

class FrmEditSeq
extends MainExclusiveDlg
implements CursorSelectionChangeListener {
    Icon backIcon;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmEditSeq.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            ToolTipManager.sharedInstance().setEnabled(true);
            FrmEditSeq.this.statusLabel.setText("");
        }
    };
    private boolean changed = false;
    private boolean applyChanges = false;
    private SequenceEditorPanel editor;
    private ButtonGroup groupCodonMenu;
    private ButtonGroup groupSpacing;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JMenuBar mainMenuBar;
    private JRadioButtonMenuItem mnuAcidic1;
    private JMenuItem mnuAddNew;
    private JRadioButtonMenuItem mnuAmidic1;
    private JRadioButtonMenuItem mnuBasic1;
    private JCheckBoxMenuItem mnuCheckBlend;
    private JMenu mnuCodonTable;
    private JMenu mnuColorByProperty;
    private JMenu mnuColorByResidue;
    private JMenu mnuCopy;
    private JMenuItem mnuCopySel;
    private JMenuItem mnuCut;
    private JMenu mnuEdit;
    private JMenu mnuEditFeature;
    private JRadioButtonMenuItem mnuEssential1;
    private JMenuItem mnuFCopyAAF1;
    private JMenuItem mnuFCopyAAdsF1;
    private JMenuItem mnuFCopyAAssF1;
    private JMenuItem mnuFCopyFormattedAS;
    private JMenuItem mnuFCopydsDNA;
    private JMenuItem mnuFCopyssDNA;
    private JMenuItem mnuFCopyssDNA_AS;
    private JMenu mnuFile;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuGoToBp;
    private JRadioButtonMenuItem mnuHydrophobic1;
    private JRadioButtonMenuItem mnuHydroxilic1;
    private JRadioButtonMenuItem mnuIP1;
    private JMenuItem mnuLowercase;
    private JMenuItem mnuLowercaseSel;
    private JRadioButtonMenuItem mnuMolWt1;
    private JRadioButtonMenuItem mnuNonPolar1;
    private JRadioButtonMenuItem mnuNone1;
    private JRadioButtonMenuItem mnuNone2;
    private JRadioButtonMenuItem mnuOpLargeSpace;
    private JRadioButtonMenuItem mnuOpNoSpace;
    private JRadioButtonMenuItem mnuOpSmallSpace;
    private JMenu mnuOptions;
    private JMenuItem mnuPaste;
    private JRadioButtonMenuItem mnuPolar1;
    private JPopupMenu mnuPopup;
    private JRadioButtonMenuItem mnuPositive1;
    private JMenuItem mnuRevComp;
    private JMenuItem mnuSelectAll;
    private JPopupMenu.Separator mnuSep;
    private JPopupMenu.Separator mnuSep1;
    private JPopupMenu.Separator mnuSep2;
    private JPopupMenu.Separator mnuSep3;
    private JPopupMenu.Separator mnuSep4;
    private JPopupMenu.Separator mnuSep5;
    private JPopupMenu.Separator mnuSep6;
    private JPopupMenu.Separator mnuSep7;
    private JMenu mnuSetColors;
    private JRadioButtonMenuItem mnuSolubility1;
    private JRadioButtonMenuItem mnuSulfur1;
    private JRadioButtonMenuItem mnuSurface1;
    private JCheckBoxMenuItem mnuToggleAntisense;
    private JCheckBoxMenuItem mnuToggleFrame1;
    private JCheckBoxMenuItem mnuToggleFrame2;
    private JCheckBoxMenuItem mnuToggleFrame3;
    private JCheckBoxMenuItem mnuToggleFrame4;
    private JCheckBoxMenuItem mnuToggleFrame5;
    private JCheckBoxMenuItem mnuToggleFrame6;
    private JCheckBoxMenuItem mnuToggleIcon;
    private JCheckBoxMenuItem mnuToggleNumbers;
    private JMenu mnuUnannotate;
    private JMenuItem mnuUpperCaseSel;
    private JMenuItem mnuUppercase;
    private JRadioButtonMenuItem mnuVolume1;
    private JPopupMenu.Separator sepCodon;
    private JPopupMenu.Separator sepColors;
    private StatusLabel statusLabel;

    public FrmEditSeq(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        Object eColor = UIManager.get("SequenceEditor.background");
        if (eColor instanceof Color) {
            this.editor.setBackground((Color)eColor);
        }
        this.sepColors.setVisible(Globals.debugMode);
        this.mnuSetColors.setVisible(Globals.debugMode);
        this.sepCodon.setVisible(Globals.debugMode);
        this.mnuCodonTable.setVisible(Globals.debugMode);
        Listeners.setMenuBarListeners(this.mainMenuBar, this.menuMouseListener);
        this.backIcon = this.editor.getIcon();
        this.editor.setSelectionChangeListener(this);
        this.editor.setBlinking(true);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
            }

            @Override
            public void windowLostFocus(WindowEvent arg0) {
                FrmEditSeq.this.editor.hideToolTip();
            }
        });
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(parent);
        ProjectDocument project = this.getProject();
        this.setTitle(project.getName());
        this.editor.setShowFrame1(false);
        this.editor.setShowFrame2(false);
        this.editor.setShowFrame3(false);
        this.editor.getDocument().setSequence(project.getSEF(1, project.length()));
        this.editor.setCircular(project.isCircular());
        Feature selectedItem = project.getSelectedItem();
        if (selectedItem == null) {
            this.editor.select(0);
            this.editor.setSelectionLength(0);
        } else {
            this.editor.select(selectedItem.getStart(), selectedItem.getStop());
        }
        this.changed = false;
        this.applyChanges = true;
        this.editor.requestFocus();
        this.editor.setAutoColumnCount(true);
        this.sepColors.setVisible(Globals.debugMode);
        this.mnuSetColors.setVisible(Globals.debugMode);
    }

    private void updateFrameChecks() {
        this.mnuToggleFrame1.setSelected(this.editor.isShowFrame1());
        this.mnuToggleFrame2.setSelected(this.editor.isShowFrame2());
        this.mnuToggleFrame3.setSelected(this.editor.isShowFrame3());
        this.mnuToggleFrame4.setSelected(this.editor.isShowFrameA1());
        this.mnuToggleFrame5.setSelected(this.editor.isShowFrameA2());
        this.mnuToggleFrame6.setSelected(this.editor.isShowFrameA3());
        this.mnuToggleAntisense.setSelected(this.editor.isShowAntisense());
        this.mnuToggleNumbers.setSelected(this.editor.isShowNumbers());
        this.mnuToggleIcon.setSelected(this.editor.getIcon() != null);
    }

    void reselectSelection() {
        this.editor.gotoSelection(false);
    }

    private void initComponents() {
        this.mnuPopup = new JPopupMenu();
        this.mnuSep6 = new JPopupMenu.Separator();
        this.mnuAddNew = new JMenuItem();
        this.mnuSep7 = new JPopupMenu.Separator();
        this.mnuEditFeature = new JMenu();
        this.mnuSep3 = new JPopupMenu.Separator();
        this.mnuUnannotate = new JMenu();
        this.mnuSep4 = new JPopupMenu.Separator();
        this.mnuCopy = new JMenu();
        this.mnuSep = new JPopupMenu.Separator();
        this.mnuFCopyssDNA = new JMenuItem();
        this.mnuFCopyssDNA_AS = new JMenuItem();
        this.mnuFCopyFormattedAS = new JMenuItem();
        this.mnuFCopydsDNA = new JMenuItem();
        this.mnuSep1 = new JPopupMenu.Separator();
        this.mnuFCopyAAF1 = new JMenuItem();
        this.mnuFCopyAAssF1 = new JMenuItem();
        this.mnuFCopyAAdsF1 = new JMenuItem();
        this.mnuSep5 = new JPopupMenu.Separator();
        this.mnuRevComp = new JMenuItem();
        this.mnuSep2 = new JPopupMenu.Separator();
        this.mnuUppercase = new JMenuItem();
        this.mnuLowercase = new JMenuItem();
        this.groupCodonMenu = new ButtonGroup();
        this.groupSpacing = new ButtonGroup();
        this.editor = new SequenceEditorPanel(){

            @Override
            public AnnotationEditor showROIEditor(final ROI roi, int length) {
                FrmNewFeature f = new FrmNewFeature(FrmEditSeq.this){

                    @Override
                    public void doOK() {
                        this.saved = true;
                        if (FrmEditSeq.this.editor.containsROI(roi)) {
                            roi.cloneFrom(this.getROI());
                        } else {
                            FrmEditSeq.this.editor.addROI(this.getROI());
                        }
                        FrmEditSeq.this.editor.reDraw();
                        this.dispose();
                    }
                };
                f.setLength(length);
                f.setROI(roi);
                f.setLocationRelativeTo(this);
                f.setVisible(true);
                return null;
            }

            @Override
            public JPopupMenu getPopupMenu(int x, int y) {
                if (this.isShowFrame1() || this.isShowFrame2() || this.isShowFrame3()) {
                    return super.getPopupMenu(x, y);
                }
                return null;
            }

            @Override
            public JPopupMenu.Separator genMenuSeparator(String text) {
                JPopupMenu.Separator sep = super.genMenuSeparator(text);
                sep.addMouseListener(FrmEditSeq.this.menuMouseListener);
                return sep;
            }

            @Override
            public JMenuItem genMenuItem(String text, String tooltiptext, ActionListener l) {
                JMenuItem item = super.genMenuItem(text, tooltiptext, l);
                item.addMouseListener(FrmEditSeq.this.menuMouseListener);
                return item;
            }

            @Override
            public JMenu genMenu(String text, String tooltiptext, ActionListener l) {
                JMenu item = super.genMenu(text, tooltiptext, l);
                item.addMouseListener(FrmEditSeq.this.menuMouseListener);
                return item;
            }
        };
        this.statusLabel = new StatusLabel();
        this.mainMenuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.mnuEdit = new JMenu();
        this.mnuGoToBp = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnuSelectAll = new JMenuItem();
        this.mnuCopySel = new JMenuItem();
        this.mnuCut = new JMenuItem();
        this.mnuPaste = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnuFind = new JMenuItem();
        this.mnuFindNext = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mnuUpperCaseSel = new JMenuItem();
        this.mnuLowercaseSel = new JMenuItem();
        this.mnuOptions = new JMenu();
        this.mnuToggleFrame1 = new JCheckBoxMenuItem();
        this.mnuToggleFrame2 = new JCheckBoxMenuItem();
        this.mnuToggleFrame3 = new JCheckBoxMenuItem();
        this.mnuToggleFrame4 = new JCheckBoxMenuItem();
        this.mnuToggleFrame5 = new JCheckBoxMenuItem();
        this.mnuToggleFrame6 = new JCheckBoxMenuItem();
        this.mnuToggleAntisense = new JCheckBoxMenuItem();
        this.mnuToggleNumbers = new JCheckBoxMenuItem();
        this.mnuToggleIcon = new JCheckBoxMenuItem();
        this.mnuCheckBlend = new JCheckBoxMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.mnuOpNoSpace = new JRadioButtonMenuItem();
        this.mnuOpSmallSpace = new JRadioButtonMenuItem();
        this.mnuOpLargeSpace = new JRadioButtonMenuItem();
        this.sepCodon = new JPopupMenu.Separator();
        this.mnuCodonTable = new JMenu();
        this.sepColors = new JPopupMenu.Separator();
        this.mnuSetColors = new JMenu();
        this.mnuNone1 = new JRadioButtonMenuItem();
        this.mnuNone2 = new JRadioButtonMenuItem();
        this.mnuColorByProperty = new JMenu();
        this.mnuAcidic1 = new JRadioButtonMenuItem();
        this.mnuAmidic1 = new JRadioButtonMenuItem();
        this.mnuBasic1 = new JRadioButtonMenuItem();
        this.mnuPositive1 = new JRadioButtonMenuItem();
        this.mnuEssential1 = new JRadioButtonMenuItem();
        this.mnuHydrophobic1 = new JRadioButtonMenuItem();
        this.mnuHydroxilic1 = new JRadioButtonMenuItem();
        this.mnuIP1 = new JRadioButtonMenuItem();
        this.mnuMolWt1 = new JRadioButtonMenuItem();
        this.mnuNonPolar1 = new JRadioButtonMenuItem();
        this.mnuPolar1 = new JRadioButtonMenuItem();
        this.mnuSolubility1 = new JRadioButtonMenuItem();
        this.mnuSulfur1 = new JRadioButtonMenuItem();
        this.mnuSurface1 = new JRadioButtonMenuItem();
        this.mnuVolume1 = new JRadioButtonMenuItem();
        this.mnuColorByResidue = new JMenu();
        this.mnuSep6.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep6);
        this.mnuAddNew.setText("Add as New Feature");
        this.mnuAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuAddNewActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuAddNew);
        this.mnuSep7.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep7);
        this.mnuEditFeature.setText("Edit Feature");
        this.mnuPopup.add(this.mnuEditFeature);
        this.mnuSep3.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep3);
        this.mnuUnannotate.setText("Unannotate from Current Selection");
        this.mnuPopup.add(this.mnuUnannotate);
        this.mnuSep4.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep4);
        this.mnuCopy.setText("Copy to Clipboard as...");
        this.mnuSep.setToolTipText("Copy as DNA");
        this.mnuCopy.add(this.mnuSep);
        this.mnuFCopyssDNA.setText("DNA: Single Stranded (Sense)");
        this.mnuFCopyssDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyssDNAActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyssDNA);
        this.mnuFCopyssDNA_AS.setText("DNA: Single Stranded (Antisense)");
        this.mnuFCopyssDNA_AS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyssDNA_ASActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyssDNA_AS);
        this.mnuFCopyFormattedAS.setText("DNA: Formatted, Single Stranded");
        this.mnuFCopyFormattedAS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyFormattedASActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyFormattedAS);
        this.mnuFCopydsDNA.setText("DNA: Double Stranded");
        this.mnuFCopydsDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopydsDNAActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopydsDNA);
        this.mnuSep1.setToolTipText("Copy as Amino Acids");
        this.mnuCopy.add(this.mnuSep1);
        this.mnuFCopyAAF1.setText("Protein: Translation");
        this.mnuFCopyAAF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyAAF1ActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyAAF1);
        this.mnuFCopyAAssF1.setText("Protein: ssDNA + Translation Frame 1");
        this.mnuFCopyAAssF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyAAssF1ActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyAAssF1);
        this.mnuFCopyAAdsF1.setText("Protein: dsDNA + Translation Frame 1");
        this.mnuFCopyAAdsF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuFCopyAAdsF1ActionPerformed(evt);
            }
        });
        this.mnuCopy.add(this.mnuFCopyAAdsF1);
        this.mnuPopup.add(this.mnuCopy);
        this.mnuSep5.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep5);
        this.mnuRevComp.setText("Reverse/Complement Selection");
        this.mnuRevComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuRevCompActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuRevComp);
        this.mnuSep2.setToolTipText("tooltip");
        this.mnuPopup.add(this.mnuSep2);
        this.mnuUppercase.setAccelerator(KeyStroke.getKeyStroke(85, 0));
        this.mnuUppercase.setText("Uppercase Selection");
        this.mnuPopup.add(this.mnuUppercase);
        this.mnuLowercase.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        this.mnuLowercase.setText("Lowercase Selection");
        this.mnuPopup.add(this.mnuLowercase);
        this.setTitle("Edit Sequence");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmEditSeq.this.closeDialog(evt);
            }
        });
        this.editor.setAutoColumnCount(true);
        this.editor.setBlinking(true);
        this.editor.setDisplayPanelBackground(new Color(204, 204, 255));
        this.editor.setHandleFocusGained(true);
        this.editor.setHandleFocusLost(true);
        this.editor.setHorizontalIconAlignment(SequenceEditorPanel.HorizontalAlignment.TILED);
        this.editor.setIcon(new ImageIcon(this.getClass().getResource("/TextBoxBackgrounds/DNATiled.png")));
        this.editor.setScrollbarThumbColorOut(new Color(143, 143, 245));
        this.editor.setScrollbarThumbColorPressed(new Color(143, 143, 245));
        this.editor.setScrollbarThumbColorRollOver(new Color(143, 143, 245));
        this.editor.setScrollbarTrackColor(new Color(165, 169, 200));
        this.editor.setScrollbarTrackColorPressed(new Color(165, 169, 200));
        this.editor.setScrollbarTrackColorRollover(new Color(165, 169, 200));
        this.editor.setShowFrame1(false);
        this.editor.setShowFrame2(false);
        this.editor.setShowFrame3(false);
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.mnuFile.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.jMenuItem1.setText("Save and Close");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        this.jMenuItem2.setText("Cancel Changes and Close");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.jMenuItem2);
        this.mainMenuBar.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.mnuGoToBp.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.mnuGoToBp.setText("Go to Bp Position");
        this.mnuGoToBp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuGoToBpActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuGoToBp);
        this.mnuEdit.add(this.jSeparator1);
        this.mnuSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuSelectAll.setText("Select all");
        this.mnuSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuSelectAllActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuSelectAll);
        this.mnuCopySel.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuCopySel.setText("Copy Selection");
        this.mnuCopySel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuCopySelActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopySel);
        this.mnuCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.mnuCut.setText("Cut Selection");
        this.mnuCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuCutActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCut);
        this.mnuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.mnuPaste.setText("Paste from Clipboard");
        this.mnuPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuPasteActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuPaste);
        this.mnuEdit.add(this.jSeparator2);
        this.mnuFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.mnuFind.setText("Find Sequence");
        this.mnuEdit.add(this.mnuFind);
        this.mnuFindNext.setText("Find Next");
        this.mnuEdit.add(this.mnuFindNext);
        this.mnuEdit.add(this.jSeparator3);
        this.mnuUpperCaseSel.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.mnuUpperCaseSel.setText("Convert to Uppercase");
        this.mnuUpperCaseSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuUpperCaseSelActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuUpperCaseSel);
        this.mnuLowercaseSel.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.mnuLowercaseSel.setText("Convert to Lowercase");
        this.mnuLowercaseSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuLowercaseSelActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuLowercaseSel);
        this.mainMenuBar.add(this.mnuEdit);
        this.mnuOptions.setText("Options");
        this.mnuOptions.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                FrmEditSeq.this.mnuOptionsMenuSelected(evt);
            }
        });
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setSelected(true);
        this.mnuToggleFrame1.setText("Show Frame 1 Translation");
        this.mnuToggleFrame1.setToolTipText("Toggle showing reading frame 1.");
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/T1.png")));
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setSelected(true);
        this.mnuToggleFrame2.setText("Show Frame 2 Translation");
        this.mnuToggleFrame2.setToolTipText("Toggle showing reading frame 2.");
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/T2.png")));
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setSelected(true);
        this.mnuToggleFrame3.setText("Show Frame 3 Translation");
        this.mnuToggleFrame3.setToolTipText("Toggle showing reading frame 3.");
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/T3.png")));
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame3);
        this.mnuToggleFrame4.setAccelerator(KeyStroke.getKeyStroke(112, 128));
        this.mnuToggleFrame4.setSelected(true);
        this.mnuToggleFrame4.setText("Show Frame -1 Translation");
        this.mnuToggleFrame4.setToolTipText("Toggle showing reading frame 1.");
        this.mnuToggleFrame4.setIcon(new ImageIcon(this.getClass().getResource("/images24/T1.png")));
        this.mnuToggleFrame4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame4ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame4);
        this.mnuToggleFrame5.setAccelerator(KeyStroke.getKeyStroke(113, 128));
        this.mnuToggleFrame5.setSelected(true);
        this.mnuToggleFrame5.setText("Show Frame -2 Translation");
        this.mnuToggleFrame5.setToolTipText("Toggle showing reading frame 2.");
        this.mnuToggleFrame5.setIcon(new ImageIcon(this.getClass().getResource("/images24/T2.png")));
        this.mnuToggleFrame5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame5ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame5);
        this.mnuToggleFrame6.setAccelerator(KeyStroke.getKeyStroke(114, 128));
        this.mnuToggleFrame6.setSelected(true);
        this.mnuToggleFrame6.setText("Show Frame -3 Translation");
        this.mnuToggleFrame6.setToolTipText("Toggle showing reading frame 3.");
        this.mnuToggleFrame6.setIcon(new ImageIcon(this.getClass().getResource("/images24/T3.png")));
        this.mnuToggleFrame6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleFrame6ActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleFrame6);
        this.mnuToggleAntisense.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAntisense.setSelected(true);
        this.mnuToggleAntisense.setText("Show Antisense");
        this.mnuToggleAntisense.setToolTipText("Toggle showing the antisense strand.");
        this.mnuToggleAntisense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleAntisenseActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleAntisense);
        this.mnuToggleNumbers.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mnuToggleNumbers.setSelected(true);
        this.mnuToggleNumbers.setText("Show Numbers");
        this.mnuToggleNumbers.setToolTipText("Toggle showing line numbers.");
        this.mnuToggleNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleNumbersActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleNumbers);
        this.mnuToggleIcon.setSelected(true);
        this.mnuToggleIcon.setText("Show Background Icon");
        this.mnuToggleIcon.setToolTipText("Toggles the background Icon in the editor.");
        this.mnuToggleIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuToggleIconActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuToggleIcon);
        this.mnuCheckBlend.setSelected(true);
        this.mnuCheckBlend.setText("Blend ROI Colors");
        this.mnuCheckBlend.setToolTipText("If checked, colors will be blended.  Otherwise only the topmost ROI's color is shown at a position.");
        this.mnuCheckBlend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuCheckBlendActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuCheckBlend);
        this.jSeparator4.setToolTipText("Color Spacing");
        this.mnuOptions.add(this.jSeparator4);
        this.groupSpacing.add(this.mnuOpNoSpace);
        this.mnuOpNoSpace.setText("No Spacing");
        this.mnuOpNoSpace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuOpNoSpaceActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuOpNoSpace);
        this.groupSpacing.add(this.mnuOpSmallSpace);
        this.mnuOpSmallSpace.setSelected(true);
        this.mnuOpSmallSpace.setText("Small Spacing");
        this.mnuOpSmallSpace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuOpSmallSpaceActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuOpSmallSpace);
        this.groupSpacing.add(this.mnuOpLargeSpace);
        this.mnuOpLargeSpace.setText("Large Spacing");
        this.mnuOpLargeSpace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuOpLargeSpaceActionPerformed(evt);
            }
        });
        this.mnuOptions.add(this.mnuOpLargeSpace);
        this.mnuOptions.add(this.sepCodon);
        this.mnuCodonTable.setText("Set Codon Table");
        this.mnuCodonTable.setToolTipText("Select the organism to use for translation.");
        this.mnuCodonTable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmEditSeq.this.mnuCodonTableStateChanged(evt);
            }
        });
        this.mnuOptions.add(this.mnuCodonTable);
        this.mnuOptions.add(this.sepColors);
        this.mnuSetColors.setText("Set Codon Colors");
        this.mnuSetColors.setToolTipText("Select coloring options for specific amino acid properties.");
        this.mnuNone1.setText("Default");
        this.mnuNone1.setToolTipText("");
        this.mnuNone1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuNone1ActionPerformed(evt);
            }
        });
        this.mnuSetColors.add(this.mnuNone1);
        this.mnuNone2.setSelected(true);
        this.mnuNone2.setText("By Codon Frequency");
        this.mnuNone2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuNone2ActionPerformed(evt);
            }
        });
        this.mnuSetColors.add(this.mnuNone2);
        this.mnuColorByProperty.setText("Color by Property");
        this.mnuAcidic1.setText("Acidic");
        this.mnuAcidic1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuAcidic1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuAcidic1);
        this.mnuAmidic1.setText("Amidic");
        this.mnuAmidic1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuAmidic1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuAmidic1);
        this.mnuBasic1.setText("Basic");
        this.mnuBasic1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuBasic1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuBasic1);
        this.mnuPositive1.setText("Charge");
        this.mnuPositive1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuPositive1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuPositive1);
        this.mnuEssential1.setText("Essential");
        this.mnuEssential1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuEssential1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuEssential1);
        this.mnuHydrophobic1.setText("Hydrophobic");
        this.mnuHydrophobic1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuHydrophobic1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuHydrophobic1);
        this.mnuHydroxilic1.setText("Hydroxilic");
        this.mnuHydroxilic1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuHydroxilic1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuHydroxilic1);
        this.mnuIP1.setText("Isoelectric Point");
        this.mnuIP1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuIP1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuIP1);
        this.mnuMolWt1.setText("Mol. wt");
        this.mnuMolWt1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuMolWt1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuMolWt1);
        this.mnuNonPolar1.setText("Polarity");
        this.mnuNonPolar1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuNonPolar1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuNonPolar1);
        this.mnuPolar1.setText("Polar Uncharged");
        this.mnuPolar1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuPolar1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuPolar1);
        this.mnuSolubility1.setText("Solubility");
        this.mnuSolubility1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuSolubility1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSolubility1);
        this.mnuSulfur1.setText("Sulfur-containing");
        this.mnuSulfur1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuSulfur1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSulfur1);
        this.mnuSurface1.setText("Surface area");
        this.mnuSurface1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuSurface1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSurface1);
        this.mnuVolume1.setText("Volume");
        this.mnuVolume1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditSeq.this.mnuVolume1ActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuVolume1);
        this.mnuSetColors.add(this.mnuColorByProperty);
        this.mnuColorByResidue.setText("Color by Residue");
        this.mnuSetColors.add(this.mnuColorByResidue);
        this.mnuOptions.add(this.mnuSetColors);
        this.mainMenuBar.add(this.mnuOptions);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editor, -1, 659, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 659, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editor, -1, 497, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.statusLabel, -2, -1, -2)));
        this.pack();
    }

    public DNASequenceDocument getDocument() {
        return this.editor.getDocument();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void mnuFCopyssDNAActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopyssDNA_ASActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopydsDNAActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopyAAF1ActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopyAAssF1ActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopyAAdsF1ActionPerformed(ActionEvent evt) {
    }

    private void mnuFCopyFormattedASActionPerformed(ActionEvent evt) {
        SequenceExportFormat selection = this.editor.getSelection();
        DNA.antisense(selection);
        SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(selection);
        if (transferable != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
        }
    }

    private void save() {
        final ProjectDocument mainDoc = ((PLOTJ)this.getParent()).getProject();
        final boolean seqChanged = !mainDoc.getSequence().equalsIgnoreCase(this.editor.getDocument().getSequence());
        final UndoRedo.ChangeEvent[] events = !seqChanged ? new UndoRedo.ChangeEvent[]{new UndoRedo.ChangeEvent(106), new UndoRedo.ChangeEvent(10)} : new UndoRedo.ChangeEvent[]{new UndoRedo.ChangeEvent(111), new UndoRedo.ChangeEvent(110), new UndoRedo.ChangeEvent(106), new UndoRedo.ChangeEvent(10), new UndoRedo.ChangeEvent(107)};
        mainDoc.runRestorePointUndoable(new UndoableAction(){

            @Override
            public boolean run() {
                SequenceExportFormat newSEF = FrmEditSeq.this.editor.getDocument().getSEF(1, FrmEditSeq.this.editor.getDocument().length());
                boolean isEnabled = mainDoc.disableListeners();
                mainDoc.setListenersEnabled(false);
                mainDoc.setSequence(newSEF, seqChanged, seqChanged);
                mainDoc.setChanged(true);
                mainDoc.setListenersEnabled(true);
                mainDoc.fireEvents(events);
                mainDoc.setListenersEnabled(isEnabled);
                return true;
            }
        }, "sequence edits.");
        this.hide();
        this.dispose();
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame1(!this.editor.isShowFrame1());
        this.reselectSelection();
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame2(!this.editor.isShowFrame2());
        this.reselectSelection();
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame3(!this.editor.isShowFrame3());
        this.reselectSelection();
    }

    private void mnuToggleAntisenseActionPerformed(ActionEvent evt) {
        this.editor.setShowAntisense(!this.editor.isShowAntisense());
        this.reselectSelection();
    }

    private void mnuToggleNumbersActionPerformed(ActionEvent evt) {
        this.editor.setShowNumbers(!this.editor.isShowNumbers());
        this.reselectSelection();
    }

    private void mnuCodonTableStateChanged(ChangeEvent evt) {
        int org = this.editor.getOrganism();
        this.mnuCodonTable.removeAll();
        ProjectDocument project = this.getProject();
        int x = 0;
        while (true) {
            project.getCodonTable();
            if (x >= CodonTable.getOrganismCount()) break;
            project.getCodonTable();
            String oName = CodonTable.getOrganismName(x);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(oName);
            item.addActionListener(new CodonMenuListener(oName));
            item.setToolTipText("Set codon table to " + oName);
            item.addMouseListener(this.menuMouseListener);
            this.groupCodonMenu.add(item);
            this.mnuCodonTable.add(item);
            if (x == org) {
                item.setSelected(true);
            }
            ++x;
        }
    }

    private void mnuNone1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.None, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuNone2ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.None, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuAcidic1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Acidic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuAmidic1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Amidic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuBasic1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Basic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuPositive1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.R_group_charge, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuEssential1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Essential, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuHydrophobic1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Hydrophobic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuHydroxilic1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Hydroxylic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuIP1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.PI, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuMolWt1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Mwt, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuNonPolar1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.R_group_polarity, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuPolar1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Polar_uncharged, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuSolubility1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Solubility, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuSulfur1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Sulfur_Containing, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuSurface1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Surface, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuVolume1ActionPerformed(ActionEvent evt) {
        this.getProject().getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Volume, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuToggleIconActionPerformed(ActionEvent evt) {
        if (this.mnuToggleIcon.isSelected()) {
            this.editor.setIcon(this.backIcon);
        } else {
            this.editor.setIcon(null);
        }
    }

    private void mnuAddNewActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void mnuSelectAllActionPerformed(ActionEvent evt) {
        this.editor.selectAll();
    }

    private void mnuCopySelActionPerformed(ActionEvent evt) {
        this.editor.copySelectionToClipboard();
    }

    private void mnuCutActionPerformed(ActionEvent evt) {
        this.editor.copySelectionToClipboard();
        this.editor.setSelection("");
    }

    private void mnuPasteActionPerformed(ActionEvent evt) {
        this.editor.pasteFromClipboard();
    }

    private void mnuUpperCaseSelActionPerformed(ActionEvent evt) {
        this.editor.uppercase();
    }

    private void mnuLowercaseSelActionPerformed(ActionEvent evt) {
        this.editor.lowercase();
    }

    private void mnuCheckBlendActionPerformed(ActionEvent evt) {
        this.editor.setBlendROIColors(this.mnuCheckBlend.isSelected());
    }

    private void mnuGoToBpActionPerformed(ActionEvent evt) {
        int count = (this.editor.length() - 1) * 3;
        if (count > 0) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images24/DNA.png"));
            String defValues = "1";
            FrmGoTo f = new FrmGoTo((Frame)this.getParent());
            f.lblBp.setText("Go to which base pair (1 - " + count + ")");
            f.txtBp.setText(defValues);
            f.setIconImage(icon.getImage());
            f.setVisible(true);
            if (f.getValue() > -1) {
                this.editor.select(f.getValue());
            }
        }
    }

    private void mnuRevCompActionPerformed(ActionEvent evt) {
    }

    private void mnuOptionsMenuSelected(MenuEvent evt) {
        this.updateFrameChecks();
    }

    private void mnuOpNoSpaceActionPerformed(ActionEvent evt) {
        this.editor.setColorYOffset(0);
    }

    private void mnuOpLargeSpaceActionPerformed(ActionEvent evt) {
        this.editor.setColorYOffset(3);
    }

    private void mnuOpSmallSpaceActionPerformed(ActionEvent evt) {
        this.editor.setColorYOffset(1);
    }

    private void mnuToggleFrame4ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA1(!this.editor.isShowFrameA1());
        this.reselectSelection();
    }

    private void mnuToggleFrame5ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA2(!this.editor.isShowFrameA2());
        this.reselectSelection();
    }

    private void mnuToggleFrame6ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrameA3(!this.editor.isShowFrameA3());
        this.reselectSelection();
    }

    private void doClose() {
        if (!this.editor.isChanged()) {
            this.setVisible(false);
            this.dispose();
        } else {
            int retVal = JOptionPanes.showConfirmDialog(this, "Sequence has unsaved changes.  Save now?", "Save changes?", 1, 3);
            switch (retVal) {
                case 0: {
                    this.doOK();
                }
                case 1: {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        }
    }

    private void setChanged() {
        if (this.changed) {
            return;
        }
        this.changed = true;
        ProjectDocument project = this.getProject();
        this.setTitle(project.getName() + " *");
    }

    @Override
    public void selectionChanged(int selStart, int selEnd, int selLength) {
        this.statusLabel.setText(this.editor.getSelectionToolTip());
    }

    @Override
    public void doOK() {
        this.save();
    }

    @Override
    public void doCancel() {
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            return;
        }
        if (this.editor.getSelectionLength() > 0) {
            this.editor.setSelectionLength(0);
        } else {
            this.doClose();
        }
    }

    class CodonMenuListener
    implements ActionListener {
        int orgNum = 0;

        public CodonMenuListener(String orgName) {
            this.orgNum = CodonTable.getOrganismIndex(orgName);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FrmEditSeq.this.editor.setOrganism(this.orgNum);
        }
    }
}

