/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DocumentFilters.DocumentKeyFilter;
import GhostTextControls.GhostTextBox;
import JXTableEditorsAndRenderers.ColorCellEditor;
import JXTableEditorsAndRenderers.ColorCellRenderer;
import JXTableEditorsAndRenderers.ComboBoxCellEditor;
import JXTableEditorsAndRenderers.DefaultTableHeaderCellRenderer;
import JXTableEditorsAndRenderers.GhostTextAreaCellEditor;
import JXTableEditorsAndRenderers.GhostTextAreaCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXTable;
import plot.Feature;
import plot.FeatureRenderer;
import plot.Globals;
import plot.GraphicsListRenderer;
import plot.GraphicsTypeCellRenderer;
import plot.IconCellRenderer;
import plot.IconListRenderer;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.StaticArrayComboModel;
import plot.TempFeatureDlg;

class FrmAutoAnnotate
extends TempFeatureDlg {
    private static final int COL_SELECTED = 0;
    private static final int COL_NAME = 1;
    private static final int COL_GRAPHIC = 2;
    private static final int COL_START = 3;
    private static final int COL_STOP = 4;
    private static final int COL_GCOLOR = 5;
    private static final int COL_LCOLOR = 6;
    private static final int COL_ALPHA = 7;
    private static final int COL_WIDTH = 8;
    private static final int COL_OFFSET = 9;
    private static final int COL_ORIENT = 10;
    private static final int COL_SHOWLABEL = 11;
    private static final int COL_SHOWGRAPHIC = 12;
    private static final int COL_GBTYPE = 13;
    private static final int COL_NOTES = 14;
    private FeatureTableModel tblFeaturesModel;
    private final ArrayList<Feature> workingFeatures = new ArrayList();
    private final ArrayList<Boolean> selectedFeatures = new ArrayList();
    private final JPopupMenu mnuPopup = new JPopupMenu();
    private GlossyButton cmdCancel;
    private GlossyButton cmdOK;
    private JScrollPane jScrollPane1;
    private JXTable tblFeatures;

    public FrmAutoAnnotate(PLOTJ parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        JMenuItem mnuSelAll = new JMenuItem("Select all");
        JMenuItem mnuDeselAll = new JMenuItem("Deselect all");
        JMenuItem mnuInvSel = new JMenuItem("Invert Selection");
        mnuSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmAutoAnnotate.this.selectedFeatures.size(); ++x) {
                    FrmAutoAnnotate.this.selectedFeatures.set(x, true);
                }
                FrmAutoAnnotate.this.tblFeatures.repaint();
            }
        });
        mnuDeselAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmAutoAnnotate.this.selectedFeatures.size(); ++x) {
                    FrmAutoAnnotate.this.selectedFeatures.set(x, false);
                }
                FrmAutoAnnotate.this.tblFeatures.repaint();
            }
        });
        mnuInvSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmAutoAnnotate.this.selectedFeatures.size(); ++x) {
                    FrmAutoAnnotate.this.selectedFeatures.set(x, (Boolean)FrmAutoAnnotate.this.selectedFeatures.get(x) == false);
                }
                FrmAutoAnnotate.this.tblFeatures.repaint();
            }
        });
        this.mnuPopup.add(mnuSelAll);
        this.mnuPopup.add(mnuDeselAll);
        this.mnuPopup.add(mnuInvSel);
        this.tblFeaturesModel = new FeatureTableModel();
        this.tblFeatures.setModel(this.tblFeaturesModel);
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setRowSorter(null);
        String cancelName = "cancel";
        String okName = "OK";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), okName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmAutoAnnotate.this.doCancel();
            }
        });
        actionMap.put(okName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmAutoAnnotate.this.doOK();
            }
        });
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        TextCellEditor textEditor = new TextCellEditor();
        NumberCellEditor numEditor = new NumberCellEditor();
        ColorCellEditor gColEditor = new ColorCellEditor();
        gColEditor.setTitle("Select new graphic color.");
        ColorCellEditor lColEditor = new ColorCellEditor();
        lColEditor.setTitle("Select new label text color.");
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        ComboCellEditor alphaEditor = new ComboCellEditor(0, 255);
        DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
        centeredRenderer.setHorizontalAlignment(0);
        GhostTextAreaCellEditor noteEditor = new GhostTextAreaCellEditor();
        noteEditor.getTextArea().setBlankText("(Optional) Feature Notes");
        GhostTextAreaCellRenderer noteRenderer = new GhostTextAreaCellRenderer();
        noteRenderer.getTextArea().setBlankText("(Optional) Feature Notes");
        JComboBox<FeatureRenderer> cmbGraphic = new JComboBox<FeatureRenderer>(new StaticArrayComboModel<FeatureRenderer>(FeatureRenderer.drawFeatures));
        cmbGraphic.setRenderer(new GraphicsListRenderer());
        cmbGraphic.setSelectedIndex(0);
        GraphicsTypeCellRenderer graphicRenderer = new GraphicsTypeCellRenderer();
        ComboBoxCellEditor graphicEditor = new ComboBoxCellEditor(cmbGraphic);
        StaticArrayComboModel<Integer> modelOrient = new StaticArrayComboModel<Integer>(Globals.orientItemValues);
        IconListRenderer rendererOrient = new IconListRenderer(null, Globals.orientIcons);
        JComboBox<Object> cmbOrient = new JComboBox<Object>();
        cmbOrient.setModel(modelOrient);
        cmbOrient.setRenderer(rendererOrient);
        cmbOrient.setSelectedIndex(0);
        rendererOrient.setSelectionBackColor(this.tblFeatures.getSelectionBackground());
        ComboBoxCellEditor orientEditor = new ComboBoxCellEditor(cmbOrient);
        IconCellRenderer orientRenderer = new IconCellRenderer(null, Globals.orientIcons);
        JComboBox cmbGBType = new JComboBox();
        Globals.populateGenbankTypes(cmbGBType);
        ComboBoxCellEditor gbEditor = new ComboBoxCellEditor(cmbGBType);
        DefaultTableColumnModel model = (DefaultTableColumnModel)this.tblFeatures.getColumnModel();
        DefaultTableHeaderCellRenderer lcRenderer = new DefaultTableHeaderCellRenderer();
        lcRenderer.setHorizontalAlignment(2);
        DefaultTableHeaderCellRenderer hcRenderer = new DefaultTableHeaderCellRenderer();
        hcRenderer.setHorizontalAlignment(0);
        model.getColumn(0).setHeaderRenderer(hcRenderer);
        model.getColumn(1).setHeaderRenderer(lcRenderer);
        model.getColumn(2).setHeaderRenderer(lcRenderer);
        model.getColumn(14).setHeaderRenderer(lcRenderer);
        model.getColumn(4).setHeaderRenderer(hcRenderer);
        model.getColumn(3).setHeaderRenderer(hcRenderer);
        model.getColumn(7).setHeaderRenderer(hcRenderer);
        model.getColumn(8).setHeaderRenderer(hcRenderer);
        model.getColumn(9).setHeaderRenderer(hcRenderer);
        model.getColumn(10).setHeaderRenderer(hcRenderer);
        model.getColumn(13).setHeaderRenderer(hcRenderer);
        model.getColumn(5).setHeaderRenderer(hcRenderer);
        model.getColumn(6).setHeaderRenderer(hcRenderer);
        model.getColumn(11).setHeaderRenderer(hcRenderer);
        model.getColumn(12).setHeaderRenderer(hcRenderer);
        model.getColumn(1).setCellEditor(textEditor);
        model.getColumn(2).setCellEditor(graphicEditor);
        model.getColumn(2).setCellRenderer(graphicRenderer);
        model.getColumn(3).setCellEditor(numEditor);
        model.getColumn(3).setCellRenderer(centeredRenderer);
        model.getColumn(4).setCellEditor(numEditor);
        model.getColumn(4).setCellRenderer(centeredRenderer);
        model.getColumn(7).setCellEditor(alphaEditor);
        model.getColumn(7).setCellRenderer(centeredRenderer);
        model.getColumn(8).setCellRenderer(centeredRenderer);
        model.getColumn(9).setCellRenderer(centeredRenderer);
        model.getColumn(10).setCellEditor(orientEditor);
        model.getColumn(10).setCellRenderer(orientRenderer);
        model.getColumn(13).setCellEditor(gbEditor);
        model.getColumn(13).setCellRenderer(centeredRenderer);
        model.getColumn(5).setCellEditor(gColEditor);
        model.getColumn(6).setCellEditor(lColEditor);
        model.getColumn(5).setCellRenderer(colorRenderer);
        model.getColumn(6).setCellRenderer(colorRenderer);
        model.getColumn(14).setCellEditor(noteEditor);
        model.getColumn(14).setCellRenderer(noteRenderer);
    }

    public boolean keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.doOK();
                return true;
            }
            case 27: {
                this.doCancel();
                return true;
            }
        }
        return false;
    }

    public void loadFeatures(ArrayList<Feature> list) {
        for (Feature feature : list) {
            this.tblFeaturesModel.add(feature);
        }
    }

    @Override
    public void doOK() {
        for (int x = 0; x < this.workingFeatures.size(); ++x) {
            if (!this.selectedFeatures.get(x).booleanValue()) continue;
            this.addedFeatures.add(this.workingFeatures.get(x));
        }
        super.doOK();
    }

    @Override
    boolean removeAddedFeatures() {
        return false;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblFeatures = new JXTable();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Auto Annotation Selection");
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setBackground(new Color(255, 255, 255));
        this.tblFeatures.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblFeatures.setColumnSelectionAllowed(true);
        this.tblFeatures.setDoubleBuffered(true);
        this.tblFeatures.setHorizontalScrollEnabled(true);
        this.tblFeatures.setRowHeight(24);
        this.tblFeatures.setShowGrid(true);
        this.tblFeatures.setSortable(false);
        this.tblFeatures.setSortsOnUpdates(false);
        this.tblFeatures.getTableHeader().setReorderingAllowed(false);
        this.tblFeatures.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FrmAutoAnnotate.this.tblFeaturesMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblFeatures);
        this.tblFeatures.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.cmdOK.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdOK.setText("Add Selected");
        this.cmdOK.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdOK.setShiftOnPress(true);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAutoAnnotate.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdCancel.setShiftOnPress(true);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAutoAnnotate.this.cmdCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 502, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdCancel, -2, 93, -2).addComponent(this.cmdOK, -2, 93, -2)).addGap(14, 14, 14)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 459, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cmdOK, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 59, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void tblFeaturesMouseReleased(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mnuPopup.show(this.tblFeatures, evt.getX(), evt.getY());
        }
    }

    private class FeatureTableModel
    extends DefaultTableModel {
        Class[] types;

        public FeatureTableModel() {
            super(null, new String[]{"Add", "Feature Name", "Graphic Type", "Start", "Stop", "Graphic", "Label", "Graphic Alpha", "Width", "Offset", "Strand", "Label", "Graphic", "Genbank Type", "Notes"});
            this.types = new Class[]{Boolean.class, String.class, Integer.class, Integer.class, Integer.class, Color.class, Color.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, String.class, String.class};
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public void removeRow(int row) {
            FrmAutoAnnotate.this.workingFeatures.remove(row);
            FrmAutoAnnotate.this.selectedFeatures.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addRow(Feature feature) {
            int row = FrmAutoAnnotate.this.workingFeatures.size();
            FrmAutoAnnotate.this.workingFeatures.add(feature);
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Feature f = (Feature)FrmAutoAnnotate.this.workingFeatures.get(row);
            switch (col) {
                case 0: {
                    return FrmAutoAnnotate.this.selectedFeatures.get(row);
                }
                case 1: {
                    return f.getName();
                }
                case 2: {
                    return f.renderer;
                }
                case 3: {
                    return f.getStart();
                }
                case 4: {
                    return f.getStop();
                }
                case 5: {
                    return f.getBackColor();
                }
                case 6: {
                    return f.getTextColor();
                }
                case 7: {
                    return f.getAlpha();
                }
                case 8: {
                    return f.getWidth();
                }
                case 9: {
                    return f.getOffset();
                }
                case 10: {
                    return f.isAntisense() ? 1 : 0;
                }
                case 11: {
                    return f.showLabel();
                }
                case 12: {
                    return !f.isHidden();
                }
                case 13: {
                    return f.getGBType();
                }
                case 14: {
                    return f.getNote();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Feature f = (Feature)FrmAutoAnnotate.this.workingFeatures.get(row);
            switch (column) {
                case 0: {
                    FrmAutoAnnotate.this.selectedFeatures.set(row, Boolean.valueOf((Boolean)value));
                    f.setShowLabel((Boolean)value);
                    break;
                }
                case 1: {
                    f.setName((String)value);
                    break;
                }
                case 2: {
                    f.setGraphicStyle((FeatureRenderer)value);
                    break;
                }
                case 3: {
                    f.setStart((Integer)value);
                    break;
                }
                case 4: {
                    f.setStop((Integer)value);
                    break;
                }
                case 5: {
                    f.setBackColor((Color)value);
                    break;
                }
                case 6: {
                    f.setTextColor((Color)value);
                    break;
                }
                case 7: {
                    f.setAlpha(Integer.parseInt((String)value));
                    break;
                }
                case 8: {
                    f.setWidth((Integer)value);
                    break;
                }
                case 9: {
                    f.setOffset((Integer)value);
                    break;
                }
                case 10: {
                    f.setAntisense((Integer)value == 1);
                    break;
                }
                case 11: {
                    f.setShowLabel((Boolean)value);
                    break;
                }
                case 12: {
                    f.setHidden((Boolean)value == false);
                    break;
                }
                case 13: {
                    f.setGBType((String)value);
                    break;
                }
                case 14: {
                    f.setNote((String)value);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public int getColumnCount() {
            return 15;
        }

        @Override
        public int getRowCount() {
            return FrmAutoAnnotate.this.workingFeatures.size();
        }

        public void clear() {
            FrmAutoAnnotate.this.workingFeatures.clear();
        }

        public void add(Feature f) {
            FrmAutoAnnotate.this.workingFeatures.add(f);
            FrmAutoAnnotate.this.selectedFeatures.add(true);
            int row = FrmAutoAnnotate.this.workingFeatures.size();
            this.fireTableRowsInserted(row, row);
        }
    }

    private static class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static GhostTextBox textBox = new GhostTextBox();
        BioAllowedKeyFilter nameFilter = new BioAllowedKeyFilter("\\w\\-'");
        DefaultCellEditor nameTextBox = new DefaultCellEditor(textBox);

        @Override
        public Object getCellEditorValue() {
            return this.nameTextBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (column) {
                case 1: {
                    textBox.setDocumentFilter(this.nameFilter);
                    break;
                }
                default: {
                    textBox.setDocumentFilter(null);
                }
            }
            return this.nameTextBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class NumberCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        GhostTextBox numberBox = new GhostTextBox();
        DefaultCellEditor numberTextBox = new DefaultCellEditor(this.numberBox);
        private int column = 0;

        public NumberCellEditor() {
            this.numberBox.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        }

        @Override
        public Object getCellEditorValue() {
            int val = this.numberBox.getText().length() == 0 ? 1 : Integer.parseInt(this.numberBox.getText());
            if (this.column == 3 || this.column == 4) {
                ProjectDocument project = FrmAutoAnnotate.this.getProject();
                if (val > 0 && val <= project.length()) {
                    return val;
                }
                return this.column == 3 ? 1 : project.length();
            }
            if (this.column == 7) {
                return Math.max(0, Math.min(255, val));
            }
            return this.numberTextBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.column = column;
            return this.numberTextBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class ComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox cmbBox = new JComboBox();
        DefaultCellEditor comboBox = new DefaultCellEditor(this.cmbBox);

        public ComboCellEditor(int min, int max) {
            ++max;
            for (int x = min; x < max; ++x) {
                this.cmbBox.addItem(String.valueOf(x));
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int alpha = (Integer)value;
            if (alpha < 0 || alpha > 255) {
                alpha = 255;
            }
            this.cmbBox.setSelectedIndex(alpha);
            return this.comboBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

