/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.io.File;

class FilenameUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char SYSTEM_NAME_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.flipSeparator(SYSTEM_NAME_SEPARATOR);
    private static final int NOT_FOUND = -1;
    private static final char UNIX_NAME_SEPARATOR = '/';
    private static final char WINDOWS_NAME_SEPARATOR = '\\';

    FilenameUtils() {
    }

    public static String getBaseName(String fileName) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(fileName));
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        FilenameUtils.requireNonNullChars(fileName);
        int index = FilenameUtils.indexOfExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private static String requireNonNullChars(String path) {
        if (path.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null character present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        return path;
    }

    public static int indexOfExtension(String fileName) throws IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (offset = fileName.indexOf(58, FilenameUtils.getAdsCriticalOffset(fileName))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparator = FilenameUtils.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FilenameUtils.requireNonNullChars(fileName).substring(FilenameUtils.indexOfLastSeparator(fileName) + 1);
    }

    public static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static boolean isSystemWindows() {
        return SYSTEM_NAME_SEPARATOR == '\\';
    }

    private static int getAdsCriticalOffset(String fileName) {
        int offset1 = fileName.lastIndexOf(SYSTEM_NAME_SEPARATOR);
        int offset2 = fileName.lastIndexOf(OTHER_SEPARATOR);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    static char flipSeparator(char ch) {
        if (ch == '/') {
            return '\\';
        }
        if (ch == '\\') {
            return '/';
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }
}

