/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import FileConverters.ImpFileWriter;
import Plugins.PluginLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import plot.DefaultConverter;
import plot.PlotFileConverter;

final class FileWriters {
    private static boolean searchExternal = true;
    private static PlotFileConverter pLOTWriter = new PlotFileConverter();
    private static BinaryChain<ImpFileWriter> writers = new BinaryChain();

    FileWriters() {
    }

    public static PlotFileConverter getpLOTWriter() {
        return pLOTWriter;
    }

    public static void loadWriters() {
        writers.clear();
        FileWriters.addWriter(pLOTWriter);
        if (searchExternal) {
            PluginLoader<ImpFileWriter> loader = new PluginLoader<ImpFileWriter>(ImpFileWriter.class);
            loader.setDir("Plugins/FileConverters");
            ArrayList<ImpFileWriter> fWriters = loader.loadAllPlugins();
            if (!fWriters.isEmpty()) {
                for (ImpFileWriter r : fWriters) {
                    FileWriters.addWriter(r);
                }
            }
        }
        Comparator<ImpFileWriter> c = new Comparator<ImpFileWriter>(){

            @Override
            public int compare(ImpFileWriter o1, ImpFileWriter o2) {
                if (o1 instanceof DefaultConverter && !(o2 instanceof DefaultConverter)) {
                    return -1;
                }
                if (o2 instanceof DefaultConverter && !(o1 instanceof DefaultConverter)) {
                    return 1;
                }
                if (o1 instanceof DefaultConverter && o2 instanceof DefaultConverter) {
                    return Integer.compare(((DefaultConverter)((Object)o1)).getSortOrder(), ((DefaultConverter)((Object)o2)).getSortOrder());
                }
                return o1.getWriteFormatDescription().toLowerCase().compareTo(o2.getWriteFormatDescription().toLowerCase());
            }
        };
        writers.sort(c);
    }

    private static void addWriter(ImpFileWriter c) {
        writers.addIfAbsent(c, c.getWriteFormatDescription());
    }

    public static String getExtension(File file) {
        String lc = file.getName();
        int dot = lc.lastIndexOf(".");
        return dot > -1 ? lc.substring(dot) : "";
    }

    public static void setFilters(JFileChooser fc) {
        if (writers == null || writers.isEmpty()) {
            FileWriters.loadWriters();
        }
        int x = 0;
        for (ImpFileWriter r : writers) {
            if (x == 0) {
                fc.setFileFilter(new WriterFileFilter(r));
            } else {
                fc.addChoosableFileFilter(new WriterFileFilter(r));
            }
            ++x;
        }
    }

    public static class WriterFileFilter
    extends FileFilter {
        private String exts;
        ImpFileWriter c;

        public WriterFileFilter(ImpFileWriter c) {
            this.c = c;
            this.exts = c.getWriteFileExtension().toLowerCase();
        }

        public ImpFileWriter getConverter() {
            return this.c;
        }

        @Override
        public String getDescription() {
            return this.c.getWriteFormatDescription() + " (*" + this.c.getWriteFileExtension() + ")";
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(this.exts);
        }
    }
}

