/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import FileConverters.ImpFileReader;
import GenbankFileReader.GenBankFile;
import Plugins.PluginLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import plot.AbiFileReader;
import plot.AllFilesReader;
import plot.CloneManagerFileReader;
import plot.DefaultConverter;
import plot.GBFileReader;
import plot.PlotFileConverter;
import plot.SnapGeneFileReader;

final class FileReaders {
    private static PlotFileConverter pLOTReader = new PlotFileConverter();
    private static boolean searchExternal = true;
    private static String allFilesDescription = "All Supported Files";
    private static String[] allFilesExtensions;
    private static AbiFileReader abiReader;
    private static GBFileReader gbReader;
    private static SnapGeneFileReader snapGeneReader;
    private static CloneManagerFileReader cm5Reader;
    private static BinaryChain<ImpFileReader> readers;
    private static BinaryChain<String> uniqueExtensions;
    private static ArrayList<ImpFileReader> uniqueReaders;
    private static final AllFilesReader allFilesReader;

    FileReaders() {
    }

    public static PlotFileConverter getpLOTReader() {
        return pLOTReader;
    }

    public static void loadReaders() {
        Object loader;
        ArrayList lReaders;
        readers.clear();
        uniqueReaders.clear();
        uniqueReaders.add(allFilesReader);
        FileReaders.addReader(pLOTReader);
        FileReaders.addReader(gbReader);
        FileReaders.addReader(snapGeneReader);
        FileReaders.addReader(cm5Reader);
        FileReaders.addReader(abiReader);
        ArrayList<String> extensions = new ArrayList<String>();
        if (searchExternal && !(lReaders = ((PluginLoader)(loader = new PluginLoader<ImpFileReader>(ImpFileReader.class, "Plugins", "PLOT_PluginFC_"))).loadAllPlugins()).isEmpty()) {
            for (ImpFileReader r : lReaders) {
                FileReaders.addReader(r);
            }
        }
        for (ImpFileReader r : readers) {
            String[] exts = r.getReadFileExtensions();
            extensions.addAll(Arrays.asList(exts));
        }
        Comparator<String> strComp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        extensions.sort(strComp);
        uniqueExtensions.sort(strComp);
        allFilesExtensions = uniqueExtensions.toArray((String[])new String[0]);
        Comparator<ImpFileReader> c = new Comparator<ImpFileReader>(){

            @Override
            public int compare(ImpFileReader o1, ImpFileReader o2) {
                if (o1 instanceof DefaultConverter && !(o2 instanceof DefaultConverter)) {
                    return -1;
                }
                if (o2 instanceof DefaultConverter && !(o1 instanceof DefaultConverter)) {
                    return 1;
                }
                if (o1 instanceof DefaultConverter && o2 instanceof DefaultConverter) {
                    return Integer.compare(((DefaultConverter)((Object)o1)).getSortOrder(), ((DefaultConverter)((Object)o2)).getSortOrder());
                }
                return o1.getReadFormatDescription().toLowerCase().compareTo(o2.getReadFormatDescription().toLowerCase());
            }
        };
        uniqueReaders.sort(c);
    }

    private static void addReader(ImpFileReader c) {
        String[] exts;
        for (String ext : exts = c.getReadFileExtensions()) {
            String keyExt = ext.startsWith(".") ? ext : "." + ext;
            readers.addIfAbsent(c, keyExt.toLowerCase());
            uniqueExtensions.add(keyExt, keyExt);
        }
        uniqueReaders.add(c);
    }

    public static String getExtension(File file) {
        String lc = file.getName();
        int dot = lc.lastIndexOf(".");
        return dot > -1 ? lc.substring(dot) : "";
    }

    public static void setFilters(JFileChooser fc) {
        if (uniqueReaders == null || uniqueReaders.isEmpty()) {
            FileReaders.loadReaders();
        }
        int x = 0;
        for (ImpFileReader r : uniqueReaders) {
            if (x == 0) {
                fc.setFileFilter(new LoaderFileFilter(r));
            } else {
                fc.addChoosableFileFilter(new LoaderFileFilter(r));
            }
            ++x;
        }
    }

    public static ImpFileReader getCompatibleReader(String extension) {
        if (uniqueReaders == null || uniqueReaders.isEmpty()) {
            FileReaders.loadReaders();
        }
        return allFilesReader.getCompatibleReader(extension);
    }

    static {
        abiReader = new AbiFileReader();
        gbReader = new GBFileReader();
        snapGeneReader = new SnapGeneFileReader();
        cm5Reader = new CloneManagerFileReader();
        readers = new BinaryChain();
        uniqueExtensions = new BinaryChain();
        uniqueReaders = new ArrayList();
        allFilesReader = new AllFilesReader(){

            @Override
            public String[] getReadFileExtensions() {
                return allFilesExtensions;
            }

            @Override
            public String getReadFormatDescription() {
                return allFilesDescription;
            }

            @Override
            public GenBankFile loadFile(File file) {
                String ext = FileReaders.getExtension(file);
                ImpFileReader c = this.getCompatibleReader(ext);
                if (c == null) {
                    return null;
                }
                GenBankFile outFile = c.loadFile(file);
                if (outFile == null) {
                    this.error = c.getReadError();
                }
                return outFile;
            }

            @Override
            public boolean acceptFileForRead(File file) {
                String ext = FileReaders.getExtension(file);
                return this.getCompatibleReader(ext) != null;
            }

            @Override
            public int getSortOrder() {
                return -1;
            }

            @Override
            public ImpFileReader getCompatibleReader(String ext) {
                return ext.length() > 0 ? (ImpFileReader)readers.get(ext) : null;
            }
        };
    }

    public static class LoaderFileFilter
    extends FileFilter {
        private String exts;
        ImpFileReader c;

        public LoaderFileFilter(ImpFileReader c) {
            this.c = c;
            this.genExts();
        }

        public ImpFileReader getConverter() {
            return this.c;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.c.acceptFileForRead(f);
        }

        @Override
        public String getDescription() {
            return this.c.getReadFormatDescription() + this.exts;
        }

        private void genExts() {
            String[] ext = this.c.getReadFileExtensions();
            this.exts = " (";
            for (int x = 0; x < ext.length; ++x) {
                String keyExt = ext[x].startsWith(".") ? ext[x] : "." + ext[x];
                this.exts = x == 0 ? this.exts + "*" + keyExt : this.exts + ", *" + keyExt;
            }
            this.exts = this.exts + ")";
        }
    }
}

