/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import plot.Feature;
import plot.Globals;
import plot.ProjectDocument;

public abstract class FeatureRenderer {
    static final float MAXARROWHEADSWEEP = 14.32f;
    static final int UNSELECTEDBORDERWIDTH = 2;
    static final int SELECTEDBORDERWIDTH = 4;
    static final float minTickWidth = 1.0f;
    static final float defTickWidth = 1.0f;
    static final float maxTickWidth = 10.0f;
    static final float minLineWidth = 3.0f;
    static final float defLineWidth = 5.0f;
    static final float maxLineWidth = 16.0f;
    static final int DRAWTYPECOUNT = 8;
    public static final int LINE = 0;
    public static final int BOX = 1;
    public static final int ARROW = 2;
    public static final int HEADLESSARROW = 3;
    public static final int LINEARROW = 4;
    public static final int TICKMARK = 5;
    public static final int BRACKET = 6;
    public static final int HIDDEN = 7;
    static final int LOADED_TYPE_LINE = 0;
    static final int LOADED_TYPE_BOX = 1;
    static final int LOADED_TYPE_ARROW = 2;
    static final int LOADED_TYPE_TICKMARK = 3;
    static final int LOADED_TYPE_BRACKET = 4;
    static final int LOADED_TYPE_NONE = 5;
    static final int LOADED_TYPE_HARROW = 6;
    static final int LOADED_TYPE_LARROW = 7;
    static final FeatureRenderer[] drawFeatures = new FeatureRenderer[]{new LineFeature(), new BoxFeature(), new BoxArrowFeature(), new HeadlessArrowFeature(), new LineArrowFeature(), new TickMarkFeature(), new BracketFeature(), new NoGraphicFeature()};
    static final FeatureRenderer[] loadedDrawFeatures = new FeatureRenderer[]{drawFeatures[0], drawFeatures[1], drawFeatures[2], drawFeatures[5], drawFeatures[6], drawFeatures[7], drawFeatures[3], drawFeatures[4]};
    float minWidth;
    float defWidth;
    float maxWidth;
    float mult;
    protected int sortIndex;
    protected int loadIndex;
    protected int value;
    Point2D start;
    double startDegree;
    boolean hidden = false;
    private static final int OUTVAL_DEGREE_START = 0;
    private static final int OUTVAL_DEGREE_STOP = 1;
    private static final int OUTVAL_DEGREEARC = 2;

    static int sortIndexToLoadIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
        }
        return 5;
    }

    static int loadIndexToSortIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
        }
        return 7;
    }

    static FeatureRenderer getFeatureFromSortIndex(int index) {
        return drawFeatures[index];
    }

    static FeatureRenderer getFeatureFromLoadIndex(int index) {
        return loadedDrawFeatures[index];
    }

    static int getFeatureSortIndex(Feature f) {
        if (f.renderer instanceof LineFeature) {
            return 0;
        }
        if (f.renderer instanceof BoxFeature) {
            return 1;
        }
        if (f.renderer instanceof BoxArrowFeature) {
            return 2;
        }
        if (f.renderer instanceof TickMarkFeature) {
            return 5;
        }
        if (f.renderer instanceof BracketFeature) {
            return 6;
        }
        if (f.renderer instanceof HeadlessArrowFeature) {
            return 3;
        }
        if (f.renderer instanceof LineArrowFeature) {
            return 4;
        }
        return 7;
    }

    static int getFeatureLoadIndex(Feature f) {
        if (f.renderer instanceof LineFeature) {
            return 0;
        }
        if (f.renderer instanceof BoxFeature) {
            return 1;
        }
        if (f.renderer instanceof BoxArrowFeature) {
            return 2;
        }
        if (f.renderer instanceof TickMarkFeature) {
            return 3;
        }
        if (f.renderer instanceof BracketFeature) {
            return 4;
        }
        if (f.renderer instanceof HeadlessArrowFeature) {
            return 6;
        }
        if (f.renderer instanceof LineArrowFeature) {
            return 7;
        }
        return 5;
    }

    public Point2D getStart() {
        return this.start;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public int getLoadIndex() {
        return this.loadIndex;
    }

    public abstract String getName();

    public float getMult() {
        return this.mult;
    }

    public int getValue() {
        return this.value;
    }

    public FeatureRenderer(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
        this.minWidth = minWidth;
        this.defWidth = defWidth;
        this.maxWidth = maxWidth;
        this.mult = mult;
        this.sortIndex = sortIndex;
        this.loadIndex = FeatureRenderer.sortIndexToLoadIndex(sortIndex);
    }

    public abstract void paint(Graphics2D var1, int var2, int var3, float var4, float var5, boolean var6, boolean var7, Color var8, GeneralPath[] var9);

    public abstract void getShapes(GeneralPath[] var1, int var2, int var3, float var4, float var5, boolean var6, ProjectDocument var7);

    static GeneralPath makeCircleLine(int bpStart, int bpStop, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        float offset2 = 2.0f * offset;
        GeneralPath newShape = new GeneralPath();
        double[] values = new double[3];
        FeatureRenderer.calculateDegrees(values, bpStart, bpStop, project.length());
        double degreeStart = values[0];
        double degreeStop = values[1];
        double degreeArc = values[2];
        Arc2D.Double topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2 - 1.0f, offset2 - 1.0f, degreeStart, degreeArc, 0);
        newShape.append(topArc, false);
        if (antisense) {
            dstFeature.start = topArc.getStartPoint();
            dstFeature.startDegree = degreeStart;
        } else {
            dstFeature.start = topArc.getEndPoint();
            dstFeature.startDegree = degreeStop;
        }
        return newShape;
    }

    public static double bpToDegree(double bp, int sequenceLen) {
        double tmpDegree = (bp - 1.0) / ((double)sequenceLen - 1.0) * 360.0;
        return tmpDegree <= 90.0 ? 90.0 - tmpDegree : 360.0 - tmpDegree + 90.0;
    }

    static GeneralPath makeCircleBracket(int bpStart, int bpStop, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        float offset2 = 2.0f * offset;
        GeneralPath newShape = new GeneralPath();
        double[] values = new double[3];
        FeatureRenderer.calculateDegrees(values, bpStart, bpStop, project.length());
        double degreeStart = values[0];
        double degreeStop = values[1];
        double degreeArc = values[2];
        Arc2D.Double topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2, offset2, degreeStart, degreeArc, 0);
        Arc2D.Double plasmidArc = new Arc2D.Double(project.pCircle.x, project.pCircle.y, project.pCircle.diameter, project.pCircle.diameter, degreeStart, degreeArc, 0);
        Point2D topStart = topArc.getStartPoint();
        Point2D pStart = plasmidArc.getStartPoint();
        Point2D pStop = plasmidArc.getEndPoint();
        newShape.moveTo(pStart.getX(), pStart.getY());
        newShape.lineTo(topStart.getX(), topStart.getY());
        newShape.append(topArc, true);
        newShape.lineTo(pStop.getX(), pStop.getY());
        if (antisense) {
            dstFeature.start = topArc.getStartPoint();
            dstFeature.startDegree = degreeStart;
        } else {
            dstFeature.start = topArc.getEndPoint();
            dstFeature.startDegree = degreeStop;
        }
        return newShape;
    }

    static GeneralPath makeCircleBracketBox(int bpStart, int bpStop, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        float offset2 = 2.0f * offset;
        GeneralPath newShape = new GeneralPath();
        double[] values = new double[3];
        FeatureRenderer.calculateDegrees(values, bpStart, bpStop, project.length());
        double degreeStart = values[0];
        double degreeStop = values[1];
        double degreeArc = values[2];
        Arc2D.Double topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2, offset2, degreeStart, degreeArc, 0);
        Arc2D.Double botArc = new Arc2D.Double(project.pCircle.x, project.pCircle.y, project.pCircle.diameter, project.pCircle.diameter, degreeStop, -degreeArc, 0);
        Point2D topStart = topArc.getStartPoint();
        Point2D botStart = botArc.getStartPoint();
        newShape.moveTo(topStart.getX(), topStart.getY());
        newShape.append(topArc, false);
        newShape.lineTo(botStart.getX(), botStart.getY());
        newShape.append(botArc, true);
        newShape.closePath();
        if (antisense) {
            dstFeature.start = topArc.getStartPoint();
            dstFeature.startDegree = degreeStart;
        } else {
            dstFeature.start = topArc.getEndPoint();
            dstFeature.startDegree = degreeStop;
        }
        return newShape;
    }

    static GeneralPath makeCircleBox(int bpStart, int bpStop, float width, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        float width2 = 2.0f * width;
        float offset2 = 2.0f * offset;
        GeneralPath newShape = new GeneralPath();
        double[] values = new double[3];
        FeatureRenderer.calculateDegrees(values, bpStart, bpStop, project.length());
        double degreeStart = values[0];
        double degreeStop = values[1];
        double degreeArc = values[2];
        Arc2D.Double outterArc = new Arc2D.Double(project.pCircle.centerX - (double)offset - (double)width, project.pCircle.centerY - (double)offset - (double)width, offset2 + width2, offset2 + width2, degreeStart, degreeArc, 0);
        Arc2D.Double innerArc = new Arc2D.Double(project.pCircle.centerX - (double)offset + (double)width, project.pCircle.centerY - (double)offset + (double)width, offset2 - width2, offset2 - width2, degreeStop, -degreeArc, 0);
        Point2D topStart = outterArc.getStartPoint();
        Point2D botStart = innerArc.getStartPoint();
        newShape.moveTo(topStart.getX(), topStart.getY());
        newShape.append(outterArc, false);
        newShape.lineTo(botStart.getX(), botStart.getY());
        newShape.append(innerArc, true);
        newShape.closePath();
        if (antisense) {
            dstFeature.start = outterArc.getStartPoint();
            dstFeature.startDegree = degreeStart;
        } else {
            dstFeature.start = outterArc.getEndPoint();
            dstFeature.startDegree = degreeStop;
        }
        return newShape;
    }

    static GeneralPath makeBox(int bpStart, int bpStop, float width, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        GeneralPath newShape = new GeneralPath();
        int x1 = project.bpToX(bpStart);
        int x2 = project.bpToX(bpStop);
        int y1 = (int)((float)project.centerLinY - width - offset);
        int y2 = (int)((float)project.centerLinY + width - offset);
        newShape.moveTo(x1, y1);
        newShape.lineTo(x2, y1);
        newShape.lineTo(x2, y2);
        newShape.lineTo(x1, y2);
        newShape.closePath();
        dstFeature.start = antisense ? new Point(x1, y1) : new Point(x2, y1);
        return newShape;
    }

    static GeneralPath makeCircleTick(int bpStart, int bpStop, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        GeneralPath newShape = new GeneralPath();
        float offset2 = 2.0f * (offset + 1.0f);
        int len = project.length();
        double degreeStart = !antisense ? FeatureRenderer.bpToDegree(bpStart, len) : FeatureRenderer.bpToDegree(bpStop, len);
        Arc2D.Double plasmidArc = new Arc2D.Double(project.pCircle.x, project.pCircle.y, project.pCircle.diameter, project.pCircle.diameter, degreeStart, 0.0, 0);
        Arc2D.Double topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2, offset2, degreeStart, 0.0, 0);
        Point2D startPoint = plasmidArc.getStartPoint();
        Point2D stopPoint = topArc.getStartPoint();
        newShape.moveTo(startPoint.getX(), startPoint.getY());
        newShape.lineTo(stopPoint.getX(), stopPoint.getY());
        dstFeature.start = startPoint;
        dstFeature.startDegree = degreeStart;
        return newShape;
    }

    static GeneralPath makeCircleTickBox(int bpStart, int bpStop, float offset, boolean antisense, FeatureRenderer dstFeature, ProjectDocument project) {
        GeneralPath newShape = new GeneralPath();
        float offset2 = 2.0f * offset;
        int len = project.length();
        double degreeStart = !antisense ? FeatureRenderer.bpToDegree(bpStart, len) : FeatureRenderer.bpToDegree(bpStop, len);
        Arc2D.Double plasmidArc = new Arc2D.Double(project.pCircle.x, project.pCircle.y, project.pCircle.diameter, project.pCircle.diameter, degreeStart - (double)0.01f, 0.01f, 0);
        Arc2D.Double topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2, offset2, degreeStart - (double)0.01f, 0.01f, 0);
        newShape.moveTo(plasmidArc.getStartPoint().getX(), plasmidArc.getStartPoint().getY());
        newShape.lineTo(plasmidArc.getEndPoint().getX(), plasmidArc.getEndPoint().getY());
        newShape.lineTo(topArc.getEndPoint().getX(), topArc.getEndPoint().getY());
        newShape.lineTo(topArc.getStartPoint().getX(), topArc.getStartPoint().getY());
        newShape.closePath();
        dstFeature.start = antisense ? topArc.getStartPoint() : topArc.getEndPoint();
        return newShape;
    }

    static GeneralPath makeArrows(int bpStart, int bpStop, float width, float fOffset, boolean antisense, boolean drawTines, FeatureRenderer dstFeature, ProjectDocument project) {
        int midx;
        int x2;
        int x1;
        int offset = (int)fOffset;
        GeneralPath newShape = new GeneralPath();
        double PointHeight = 0.0;
        int headLen = (int)((double)(width / 10.0f) * project.pointHeight);
        int y1 = (int)((float)project.centerLinY - width - (float)offset);
        int y2 = (int)((float)project.centerLinY + width - (float)offset);
        int y3 = 0;
        int y4 = 0;
        if (drawTines) {
            PointHeight = (double)width / 40.0 * project.pointHeight;
            y3 = (int)((double)((float)project.centerLinY - width - (float)offset) - PointHeight);
            y4 = (int)((double)((float)project.centerLinY + width - (float)offset) + PointHeight);
        }
        int midy = project.centerLinY - offset;
        if (!antisense) {
            x1 = project.bpToX(bpStart);
            x2 = project.bpToX(bpStop);
            midx = x2 - Math.min(headLen, (x2 - x1) / 2);
        } else {
            x1 = project.bpToX(bpStop);
            x2 = project.bpToX(bpStart);
            midx = x2 + Math.min(headLen, (x1 - x2) / 2);
        }
        newShape.moveTo(x1, y1);
        newShape.lineTo(midx, y1);
        if (drawTines) {
            newShape.lineTo(midx, y3);
        }
        newShape.lineTo(x2, midy);
        if (drawTines) {
            newShape.lineTo(midx, y4);
        }
        newShape.lineTo(midx, y2);
        newShape.lineTo(x1, y2);
        newShape.closePath();
        dstFeature.start = new Point(x1, y1);
        return newShape;
    }

    static void calculateDegrees(double[] outVals, int bpStart, int bpStop, int seqLen) {
        double tmpDegree = (double)(bpStart - 1) / ((double)seqLen - 1.0) * 360.0;
        outVals[1] = tmpDegree <= 90.0 ? 90.0 - tmpDegree : 360.0 - tmpDegree + 90.0;
        tmpDegree = (double)(bpStop - 1) / ((double)seqLen - 1.0) * 360.0;
        double d = outVals[0] = tmpDegree <= 90.0 ? 90.0 - tmpDegree : 360.0 - tmpDegree + 90.0;
        if (outVals[0] == outVals[1] && bpStart != bpStop) {
            outVals[1] = outVals[1] - 0.001;
        }
        outVals[2] = outVals[0] == outVals[1] ? 0.5 : (outVals[1] >= outVals[0] ? outVals[1] - outVals[0] : 360.0 - outVals[0] + outVals[1]);
    }

    static GeneralPath makeCircleArrows(int bpStart, int bpStop, float width, float offset, boolean antisense, boolean drawTines, FeatureRenderer dstFeature, ProjectDocument project) {
        Arc2D.Double topArc;
        float width2 = 2.0f * width;
        float offset2 = 2.0f * offset;
        double diameterTop = offset2 + width2;
        double diameterBot = offset2 - width2;
        double PointHeight = 0.0;
        double PointHeight2 = 0.0;
        double diameterTopTine = 0.0;
        double diameterBotTine = 0.0;
        if (drawTines) {
            PointHeight = (double)(width / 40.0f) * project.box_Height;
            PointHeight2 = 2.0 * PointHeight;
            diameterTopTine = diameterTop + PointHeight2;
            diameterBotTine = diameterBot - PointHeight2;
        }
        double arrowHeadSweep = (double)width / 50.0 * project.box_Height;
        GeneralPath newShape = new GeneralPath();
        double[] values = new double[3];
        FeatureRenderer.calculateDegrees(values, bpStart, bpStop, project.length());
        double degreeStart = values[0];
        double degreeStop = values[1];
        double degreeArc = values[2];
        double minArrowHeadLen = drawTines ? degreeArc * 3.0 / 4.0 : degreeArc / 2.0;
        double min = Math.min(minArrowHeadLen, (double)14.32f);
        if (arrowHeadSweep > min) {
            arrowHeadSweep = min;
        }
        Arc2D.Double midArc = new Arc2D.Double(project.pCircle.centerX - (double)offset, project.pCircle.centerY - (double)offset, offset2, offset2, degreeStart, degreeArc, 0);
        if (!antisense) {
            double topY;
            double topX;
            Point2D ptTop;
            Arc2D.Double tineArc;
            topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset - (double)width, project.pCircle.centerY - (double)offset - (double)width, diameterTop, diameterTop, degreeStart + arrowHeadSweep, degreeArc - arrowHeadSweep, 0);
            Arc2D.Double botArc = new Arc2D.Double(project.pCircle.centerX - (double)offset + (double)width, project.pCircle.centerY - (double)offset + (double)width, diameterBot, diameterBot, degreeStop, -degreeArc + arrowHeadSweep, 0);
            dstFeature.start = topArc.getStartPoint();
            Point2D tipPoint = midArc.getStartPoint();
            Point2D topStart = topArc.getStartPoint();
            Point2D botStart = botArc.getStartPoint();
            newShape.moveTo(tipPoint.getX(), tipPoint.getY());
            if (drawTines) {
                tineArc = new Arc2D.Double(project.pCircle.centerX - (double)offset - (double)width - PointHeight, project.pCircle.centerY - (double)offset - (double)width - PointHeight, diameterTopTine, diameterTopTine, degreeStart + arrowHeadSweep, degreeArc - arrowHeadSweep, 0);
                ptTop = tineArc.getStartPoint();
                topX = ptTop.getX();
                topY = ptTop.getY();
                newShape.lineTo(topX, topY);
            }
            newShape.lineTo(topStart.getX(), topStart.getY());
            newShape.append(topArc, true);
            newShape.lineTo(botStart.getX(), botStart.getY());
            newShape.append(botArc, true);
            if (drawTines) {
                tineArc = new Arc2D.Double(project.pCircle.centerX - (double)offset + (double)width + PointHeight, project.pCircle.centerY - (double)offset + (double)width + PointHeight, diameterBotTine, diameterBotTine, degreeStop, -degreeArc + arrowHeadSweep, 0);
                ptTop = tineArc.getEndPoint();
                topX = ptTop.getX();
                topY = ptTop.getY();
                newShape.lineTo(topX, topY);
            }
            newShape.lineTo(tipPoint.getX(), tipPoint.getY());
            newShape.closePath();
        } else {
            topArc = new Arc2D.Double(project.pCircle.centerX - (double)offset - (double)width, project.pCircle.centerY - (double)offset - (double)width, offset2 + width2, offset2 + width2, degreeStart, degreeArc - arrowHeadSweep, 0);
            Arc2D.Double botArc = new Arc2D.Double(project.pCircle.centerX - (double)offset + (double)width, project.pCircle.centerY - (double)offset + (double)width, offset2 - width2, offset2 - width2, degreeStop - arrowHeadSweep, -degreeArc + arrowHeadSweep, 0);
            Point2D tipPoint = midArc.getEndPoint();
            Point2D topStart = topArc.getStartPoint();
            Point2D botStart = botArc.getStartPoint();
            newShape.moveTo(topStart.getX(), topStart.getY());
            newShape.append(topArc, true);
            if (drawTines) {
                Arc2D.Double topTineArc = new Arc2D.Double(project.pCircle.centerX - (double)offset - (double)width - PointHeight, project.pCircle.centerY - (double)offset - (double)width - PointHeight, (double)(offset2 + width2) + PointHeight2, (double)(offset2 + width2) + PointHeight2, degreeStart, degreeArc - arrowHeadSweep, 0);
                newShape.lineTo(topTineArc.getEndPoint().getX(), topTineArc.getEndPoint().getY());
            }
            newShape.lineTo(tipPoint.getX(), tipPoint.getY());
            if (drawTines) {
                Arc2D.Double botTineArc = new Arc2D.Double(project.pCircle.centerX - (double)offset + (double)width + PointHeight, project.pCircle.centerY - (double)offset + (double)width + PointHeight, (double)(offset2 - width2) - PointHeight2, (double)(offset2 - width2) - PointHeight2, degreeStop - arrowHeadSweep, -degreeArc + arrowHeadSweep, 0);
                newShape.lineTo(botTineArc.getStartPoint().getX(), botTineArc.getStartPoint().getY());
            }
            newShape.lineTo(botStart.getX(), botStart.getY());
            newShape.append(botArc, true);
            newShape.lineTo(topStart.getX(), topStart.getY());
            newShape.closePath();
        }
        if (antisense) {
            dstFeature.start = topArc.getStartPoint();
            dstFeature.startDegree = degreeStart;
        } else {
            dstFeature.start = topArc.getEndPoint();
            dstFeature.startDegree = degreeStop;
        }
        return newShape;
    }

    static float offsetToLinearOffset(float offset, ProjectDocument project) {
        return (float)project.box_Height * 10.0f * (offset - 1.0f);
    }

    static float offsetToCircularOffset(float offset, ProjectDocument project) {
        return (float)((double)offset * project.pCircle.radius);
    }

    public static double scale(double valueIn, double minInValue, double maxInValue, double minOutValue, double maxOutValue) {
        return (maxOutValue - minOutValue) * (valueIn - minInValue) / (maxInValue - minInValue) + minOutValue;
    }

    public static class LineFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Line";
        }

        public LineFeature() {
            super(3.0f, 5.0f, 16.0f, 1.0f, 0);
        }

        public LineFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (highlight) {
                gfx.setColor(Globals.highlightedColor);
                gfx.setStroke(new BasicStroke(4.0f, 0, 1));
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            } else {
                gfx.setColor(fColor);
                gfx.setStroke(new BasicStroke(width / 5.0f + 2.0f, 0, 1));
                gfx.draw(shapes[2]);
                if (shapes[3] != null) {
                    gfx.draw(shapes[3]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = LineFeature.offsetToCircularOffset(offset, project);
                shapes[0] = LineFeature.makeCircleBox(bpStart, bpStop, width / 5.0f + 2.0f, rOffset, antisense, this, project);
                shapes[2] = LineFeature.makeCircleLine(bpStart, bpStop, rOffset, antisense, this, project);
            } else {
                float lOffset = LineFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    int x1 = (int)(project.pixPerBp * (double)(bpStart - 1) + 10.0);
                    int x2 = (int)(project.pixPerBp * (double)bpStop + 10.0);
                    int y = (int)((float)project.centerLinY - lOffset);
                    int xStart = 10;
                    int xEnd = project.mapWd - 10;
                    shapes[0] = new GeneralPath();
                    shapes[1] = new GeneralPath();
                    shapes[0].moveTo(x1, (float)y - width / 2.0f);
                    shapes[0].lineTo(xEnd, (float)y - width / 2.0f);
                    shapes[0].lineTo(xEnd, (float)y + width / 2.0f);
                    shapes[0].lineTo(x1, (float)y + width / 2.0f);
                    shapes[0].closePath();
                    shapes[1].moveTo(xStart, (float)y - width / 2.0f);
                    shapes[1].lineTo(x2, (float)y - width / 2.0f);
                    shapes[1].lineTo(x2, (float)y + width / 2.0f);
                    shapes[1].lineTo(xStart, (float)y + width / 2.0f);
                    shapes[1].closePath();
                    shapes[2] = new GeneralPath();
                    shapes[3] = new GeneralPath();
                    shapes[2].moveTo(x1, y);
                    shapes[2].lineTo(xEnd, y);
                    shapes[3].moveTo(xStart, y);
                    shapes[3].lineTo(x2, y);
                    this.start = new Point(x1, y);
                } else {
                    int x1 = (int)(project.pixPerBp * (double)(bpStart - 1) + 10.0);
                    int x2 = (int)(project.pixPerBp * (double)bpStop + 10.0);
                    int y = (int)((float)project.centerLinY - lOffset);
                    shapes[0] = new GeneralPath();
                    shapes[0].moveTo(x1, (float)y - width / 2.0f);
                    shapes[0].lineTo(x2, (float)y - width / 2.0f);
                    shapes[0].lineTo(x2, (float)y + width / 2.0f);
                    shapes[0].lineTo(x1, (float)y + width / 2.0f);
                    shapes[0].closePath();
                    shapes[2] = new GeneralPath();
                    shapes[2].moveTo(x1, y);
                    shapes[2].lineTo(x2, y);
                    this.start = new Point(x1, y);
                }
            }
        }
    }

    public static class BoxFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Box";
        }

        public BoxFeature() {
            super(2.0f, 3.0f, 16.0f, 10.0f, 1);
        }

        public BoxFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (!highlight) {
                gfx.setColor(fColor);
                gfx.fill(shapes[0]);
                if (shapes[1] != null) {
                    gfx.fill(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(2.0f, 0, 1));
                gfx.setColor(highlight ? Globals.highlightedColor : Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            } else {
                gfx.setStroke(new BasicStroke(4.0f, 0, 1));
                gfx.setColor(Globals.highlightedColor);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(1.0f));
                gfx.setColor(Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = BoxFeature.offsetToCircularOffset(offset, project);
                shapes[0] = BoxFeature.makeCircleBox(bpStart, bpStop, width, rOffset, antisense, this, project);
            } else {
                float lOffset = BoxFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    if (antisense) {
                        shapes[0] = BoxFeature.makeBox(bpStart, project.length(), width, lOffset, antisense, this, project);
                        shapes[1] = BoxFeature.makeBox(1, bpStop, width, lOffset, antisense, this, project);
                    } else {
                        shapes[0] = BoxFeature.makeBox(1, bpStop, width, lOffset, antisense, this, project);
                        shapes[1] = BoxFeature.makeBox(bpStart, project.length(), width, lOffset, antisense, this, project);
                    }
                } else {
                    shapes[0] = BoxFeature.makeBox(bpStart, bpStop, width, lOffset, antisense, this, project);
                }
            }
        }
    }

    public static class BoxArrowFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Box Arrow";
        }

        public BoxArrowFeature() {
            super(2.0f, 3.0f, 16.0f, 10.0f, 2);
        }

        public BoxArrowFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (!highlight) {
                gfx.setColor(fColor);
                gfx.fill(shapes[0]);
                if (shapes[1] != null) {
                    gfx.fill(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(2.0f, 0, 1));
                gfx.setColor(Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            } else {
                gfx.setStroke(new BasicStroke(4.0f, 0, 1));
                gfx.setColor(Globals.highlightedColor);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(1.0f, 0, 1));
                gfx.setColor(Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float fWidth, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = BoxArrowFeature.offsetToCircularOffset(offset, project);
                shapes[0] = BoxArrowFeature.makeCircleArrows(bpStart, bpStop, fWidth, rOffset, antisense, true, this, project);
            } else {
                float lOffset = BoxArrowFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    if (antisense) {
                        shapes[0] = BoxArrowFeature.makeArrows(bpStart, project.length(), fWidth, lOffset, true, true, this, project);
                        shapes[1] = BoxArrowFeature.makeBox(1, bpStop, fWidth, lOffset, true, this, project);
                    } else {
                        shapes[0] = BoxArrowFeature.makeArrows(1, bpStop, fWidth, lOffset, false, true, this, project);
                        shapes[1] = BoxArrowFeature.makeBox(bpStart, project.length(), fWidth, lOffset, false, this, project);
                    }
                } else {
                    shapes[0] = BoxArrowFeature.makeArrows(bpStart, bpStop, fWidth, lOffset, antisense, true, this, project);
                }
            }
        }
    }

    public static class TickMarkFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Tickmark";
        }

        public TickMarkFeature() {
            super(1.0f, 1.0f, 10.0f, 1.0f, 5);
        }

        public TickMarkFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            gfx.setColor(highlight ? Globals.highlightedColor : fColor);
            gfx.setStroke(new BasicStroke(width / 5.0f, 0, 1));
            gfx.draw(shapes[2]);
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            int startBp;
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            int n = startBp = antisense ? bpStop : bpStart;
            if (project.isCircular()) {
                float rOffset = TickMarkFeature.offsetToCircularOffset(offset, project);
                shapes[0] = TickMarkFeature.makeCircleTickBox(bpStart, bpStop, rOffset, antisense, this, project);
                int len = project.length();
                Point2D.Double pt1 = project.pCircle.getXY(TickMarkFeature.bpToDegree(startBp, len) + 90.0);
                Point2D.Double pt2 = project.pCircle.getXY(TickMarkFeature.bpToDegree(startBp, len) + 90.0, project.pCircle.radius * (double)offset);
                shapes[2] = new GeneralPath();
                shapes[2].moveTo(pt1.x, pt1.y);
                shapes[2].lineTo(pt2.x, pt2.y);
            } else {
                float lOffset = TickMarkFeature.offsetToLinearOffset(offset, project);
                int x = project.bpToX(startBp);
                int y = (int)((float)project.centerLinY - lOffset);
                shapes[2] = new GeneralPath();
                shapes[2].moveTo(x, project.centerLinY);
                shapes[2].lineTo(x, y);
                shapes[0] = new GeneralPath();
                shapes[0].moveTo((float)x - width, project.centerLinY);
                shapes[0].lineTo((float)x - width, y);
                shapes[0].lineTo((float)x + width, y);
                shapes[0].moveTo((float)x + width, project.centerLinY);
                shapes[0].closePath();
                this.start = new Point(x, y);
            }
        }
    }

    public static class BracketFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Bracket";
        }

        public BracketFeature() {
            super(3.0f, 5.0f, 16.0f, 1.0f, 6);
        }

        public BracketFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (highlight) {
                gfx.setColor(Globals.highlightedColor);
                gfx.setStroke(new BasicStroke(4.0f + width, 0, 1));
                gfx.draw(shapes[2]);
                if (shapes[3] != null) {
                    gfx.draw(shapes[3]);
                }
                gfx.setColor(fColor);
                gfx.setStroke(new BasicStroke(width));
                gfx.draw(shapes[2]);
                if (shapes[3] != null) {
                    gfx.draw(shapes[3]);
                }
            } else {
                gfx.setColor(fColor);
                gfx.setStroke(new BasicStroke(width, 0, 1));
                gfx.setStroke(new BasicStroke(width));
                gfx.draw(shapes[2]);
                if (shapes[3] != null) {
                    gfx.draw(shapes[3]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = BracketFeature.offsetToCircularOffset(offset, project);
                shapes[2] = BracketFeature.makeCircleBracket(bpStart, bpStop, rOffset, antisense, this, project);
                shapes[0] = BracketFeature.makeCircleBracketBox(bpStart, bpStop, rOffset, antisense, this, project);
                shapes[0].closePath();
            } else {
                float lOffset = BracketFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    int x1 = (int)(project.pixPerBp * (double)(bpStart - 1) + 10.0);
                    int x2 = (int)(project.pixPerBp * (double)bpStop + 10.0);
                    int xStart = 10;
                    int xEnd = project.mapWd - 10;
                    int y1 = (int)((float)project.centerLinY - lOffset);
                    shapes[2] = new GeneralPath();
                    shapes[2].moveTo(x1, project.centerLinY);
                    shapes[2].lineTo(x1, y1);
                    shapes[2].lineTo(xEnd, y1);
                    shapes[0] = (GeneralPath)shapes[2].clone();
                    shapes[0].lineTo(xEnd, project.centerLinY);
                    shapes[0].closePath();
                    shapes[3] = new GeneralPath();
                    shapes[3].moveTo(xStart, y1);
                    shapes[3].lineTo(x2, y1);
                    shapes[3].lineTo(x2, project.centerLinY);
                    shapes[1] = (GeneralPath)shapes[3].clone();
                    shapes[1].lineTo(xStart, project.centerLinY);
                    shapes[1].closePath();
                } else {
                    int x1 = (int)(project.pixPerBp * (double)(bpStart - 1) + 10.0);
                    int x2 = (int)(project.pixPerBp * (double)bpStop + 10.0);
                    int y1 = (int)((float)project.centerLinY - lOffset);
                    shapes[2] = new GeneralPath();
                    shapes[2].moveTo(x1, project.centerLinY);
                    shapes[2].lineTo(x1, y1);
                    shapes[2].lineTo(x2, y1);
                    shapes[2].lineTo(x2, project.centerLinY);
                    shapes[0] = (GeneralPath)shapes[2].clone();
                    shapes[0].closePath();
                }
            }
        }
    }

    public static class HeadlessArrowFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Headless Arrow";
        }

        public HeadlessArrowFeature() {
            super(2.0f, 3.0f, 16.0f, 10.0f, 3);
        }

        public HeadlessArrowFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float foffset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (!highlight) {
                gfx.setColor(fColor);
                gfx.fill(shapes[0]);
                if (shapes[1] != null) {
                    gfx.fill(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(2.0f, 0, 1));
                gfx.setColor(Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            } else {
                gfx.setStroke(new BasicStroke(4.0f, 0, 1));
                gfx.setColor(Globals.highlightedColor);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
                gfx.setStroke(new BasicStroke(1.0f));
                gfx.setColor(Color.BLACK);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = HeadlessArrowFeature.offsetToCircularOffset(offset, project);
                shapes[0] = HeadlessArrowFeature.makeCircleArrows(bpStart, bpStop, width, rOffset, antisense, false, this, project);
            } else {
                float lOffset = HeadlessArrowFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    if (antisense) {
                        shapes[0] = HeadlessArrowFeature.makeArrows(bpStart, project.length(), width, lOffset, true, false, this, project);
                        shapes[1] = HeadlessArrowFeature.makeBox(1, bpStop, width, lOffset, antisense, this, project);
                    } else {
                        shapes[0] = HeadlessArrowFeature.makeArrows(1, bpStop, width, lOffset, false, false, this, project);
                        shapes[1] = HeadlessArrowFeature.makeBox(bpStart, project.length(), width, lOffset, antisense, this, project);
                    }
                } else {
                    shapes[0] = HeadlessArrowFeature.makeArrows(bpStart, bpStop, width, lOffset, antisense, false, this, project);
                }
            }
        }
    }

    public static class LineArrowFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "Line Arrow";
        }

        public LineArrowFeature() {
            super(3.0f, 3.0f, 16.0f, 1.0f, 4);
        }

        public LineArrowFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
            if (!highlight) {
                gfx.setColor(fColor);
                gfx.fill(shapes[0]);
                if (shapes[1] != null) {
                    gfx.fill(shapes[1]);
                }
            } else {
                gfx.setStroke(new BasicStroke(4.0f, 0, 1));
                gfx.setColor(Globals.highlightedColor);
                gfx.draw(shapes[0]);
                if (shapes[1] != null) {
                    gfx.draw(shapes[1]);
                }
            }
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
            if (project.isCircular()) {
                float rOffset = LineArrowFeature.offsetToCircularOffset(offset, project);
                shapes[0] = LineArrowFeature.makeCircleArrows(bpStart, bpStop, width / 2.0f, rOffset, antisense, true, this, project);
            } else {
                float lOffset = LineArrowFeature.offsetToLinearOffset(offset, project);
                if (bpStop < bpStart) {
                    if (antisense) {
                        shapes[0] = LineArrowFeature.makeArrows(bpStart, project.length(), width / 2.0f, lOffset, true, true, this, project);
                        shapes[1] = LineArrowFeature.makeBox(1, bpStop, width / 2.0f, lOffset, antisense, this, project);
                    } else {
                        shapes[0] = LineArrowFeature.makeArrows(1, bpStop, width / 2.0f, lOffset, false, true, this, project);
                        shapes[1] = LineArrowFeature.makeBox(bpStart, project.length(), width / 2.0f, lOffset, antisense, this, project);
                    }
                } else {
                    shapes[0] = LineArrowFeature.makeArrows(bpStart, bpStop, width / 2.0f, lOffset, antisense, true, this, project);
                }
            }
        }
    }

    public static class NoGraphicFeature
    extends FeatureRenderer {
        @Override
        public String getName() {
            return "No Graphic";
        }

        public NoGraphicFeature() {
            super(2.0f, 3.0f, 16.0f, 10.0f, 7);
        }

        public NoGraphicFeature(float minWidth, float defWidth, float maxWidth, float mult, int sortIndex) {
            super(minWidth, defWidth, maxWidth, mult, sortIndex);
        }

        @Override
        public void paint(Graphics2D gfx, int bpStart, int bpStop, float width, float offset, boolean antisense, boolean highlight, Color fColor, GeneralPath[] shapes) {
        }

        @Override
        public void getShapes(GeneralPath[] shapes, int bpStart, int bpStop, float width, float offset, boolean antisense, ProjectDocument project) {
            shapes[0] = null;
            shapes[1] = null;
            shapes[2] = null;
            shapes[3] = null;
        }
    }
}

