/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class FeatureIcon
implements Icon {
    private static final int iconWidth = 24;
    private static final int iconHeight = 24;
    private static final int iconMidX = 12;
    private static final int iconMidY = 12;
    private static final Color defColor = Color.GREEN.darker();
    private int style = 1;
    private Icon icon;
    private Color color = null;
    private Color borderColor = Color.black;
    public static int tineHt = 2;
    public static int arrowHt = 2;
    public static int lineHt = 2;

    FeatureIcon() {
    }

    public void setStyle(int style) {
        this.style = style;
        this.icon = null;
    }

    public int getStyle() {
        return this.style;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
        this.icon = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBorderColor(Color color) {
        if (color != null) {
            this.borderColor = color;
        }
        this.icon = null;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    private Icon genIcon() {
        Color iconColor = this.color != null ? this.color : defColor;
        BufferedImage icon = new BufferedImage(24, 24, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        switch (this.style) {
            case 2: 
            case 6: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 6.0f);
                path2.lineTo(13.0f, 6.0f);
                if (this.style != 6) {
                    path2.lineTo(13.0f, 3.0f);
                }
                path2.lineTo(23.0f, 12.0f);
                if (this.style != 6) {
                    path2.lineTo(13.0f, 21.0f);
                }
                path2.lineTo(13.0f, 18.0f);
                path2.lineTo(0.0f, 18.0f);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 7: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 12 - lineHt);
                path2.lineTo(13.0f, 12 - lineHt);
                path2.lineTo(13.0f, 12 - lineHt - tineHt);
                path2.lineTo(23.0f, 12.0f);
                path2.lineTo(13.0f, 12 + lineHt + tineHt);
                path2.lineTo(13.0f, 12 + lineHt);
                path2.lineTo(0.0f, 12 + lineHt);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 0: {
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(0.0f, 12 - lineHt);
                path2.lineTo(23.0f, 12 - lineHt);
                path2.lineTo(23.0f, 12 + lineHt);
                path2.lineTo(0.0f, 12 + lineHt);
                path2.closePath();
                g2d.setColor(iconColor);
                g2d.fill(path2);
                g2d.setColor(this.borderColor);
                g2d.draw(path2);
                break;
            }
            case 3: {
                g2d.setColor(Color.black);
                g2d.drawLine(0, 15, 23, 15);
                g2d.setColor(this.color);
                g2d.drawLine(12, 9, 12, 15);
                break;
            }
            case 4: {
                g2d.setColor(Color.black);
                g2d.drawLine(0, 15, 23, 15);
                g2d.setColor(this.color);
                g2d.drawLine(7, 9, 7, 15);
                g2d.drawLine(7, 9, 17, 9);
                g2d.drawLine(17, 9, 17, 15);
                break;
            }
            default: {
                g2d.setColor(iconColor);
                g2d.fillRect(0, 6, 23, 12);
                g2d.setColor(this.borderColor);
                g2d.drawRect(0, 6, 23, 12);
            }
        }
        this.icon = new ImageIcon(icon);
        return this.icon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null) {
            this.genIcon();
        }
        this.icon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

