/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import BinaryTrees.BinaryTree;
import SequenceEditorPanels.ExtensibleArray;
import java.util.Comparator;
import plot.DefaultLibraries;
import plot.Enzyme;
import plot.EnzymeMix;
import plot.ProjectDocument;
import plot.ProjectEnzyme;

class EnzymeMixList {
    public final BinaryTree<EnzymeMix> enzymeMixes = new BinaryTree();
    private String name = "New Mix";
    public static final Comparator sortComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            this.name = name;
        }
    }

    public EnzymeMixList() {
    }

    public EnzymeMixList(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.getName();
    }

    public void addMix(EnzymeMix mix) {
        this.enzymeMixes.putIfAbsent(mix.getName(), mix);
    }

    public void addMix(Enzyme ... enzymes) {
    }

    public EnzymeMixList clone() {
        EnzymeMixList clone = new EnzymeMixList();
        clone.name = this.name;
        if (!this.enzymeMixes.isEmpty()) {
            for (EnzymeMix mix : this.enzymeMixes) {
                clone.enzymeMixes.put(mix);
            }
        }
        return clone;
    }

    public String toExportString() {
        String retVal = "UserMix\t" + this.name + "\t";
        int size = this.enzymeMixes.size();
        if (size > 0) {
            int count = 0;
            for (EnzymeMix mix : this.enzymeMixes) {
                retVal = count == 0 ? retVal + mix.getName() : retVal + "," + mix.getName();
                ++count;
            }
        }
        return retVal;
    }

    public static EnzymeMixList fromString(String datafileline) {
        return EnzymeMixList.fromString(datafileline, DefaultLibraries.defaultEnzymes.items);
    }

    public static EnzymeMixList fromString(String datafileline, ProjectDocument doc) {
        return EnzymeMixList.fromString2(datafileline, doc.defaultEnzymes);
    }

    public static EnzymeMixList fromString(String datafileline, BinaryChain<Enzyme> src) {
        String[] mixes;
        if (datafileline.startsWith(";")) {
            return null;
        }
        String[] entries = datafileline.split("\t");
        if (entries.length < 3 || !entries[0].equalsIgnoreCase("UserMix")) {
            return null;
        }
        EnzymeMixList outList = new EnzymeMixList();
        outList.name = entries[1];
        ExtensibleArray<String> enzymes = new ExtensibleArray<String>(String.class);
        for (String mix : mixes = entries[2].split(",")) {
            String[] eNames;
            enzymes.clear();
            for (String eName : eNames = mix.split("\\+")) {
                Enzyme e;
                if (eName == null || eName.length() <= 0 || (e = src.get(eName)) == null) continue;
                enzymes.add(e.name);
            }
            if (enzymes.isEmpty()) continue;
            EnzymeMix item = new EnzymeMix();
            enzymes.sort(sortComparator);
            item.enzymes = enzymes.toArray();
            outList.addMix(item);
        }
        return outList;
    }

    public static EnzymeMixList fromString2(String datafileline, BinaryChain<ProjectEnzyme> src) {
        String[] mixes;
        if (datafileline.startsWith(";")) {
            return null;
        }
        String[] entries = datafileline.split("\t");
        if (entries.length < 3 || !entries[0].equalsIgnoreCase("UserMix")) {
            return null;
        }
        EnzymeMixList outList = new EnzymeMixList();
        outList.name = entries[1];
        ExtensibleArray<String> enzymes = new ExtensibleArray<String>(String.class);
        for (String mix : mixes = entries[2].split(",")) {
            String[] eNames;
            enzymes.clear();
            for (String eName : eNames = mix.split("\\+")) {
                ProjectEnzyme e;
                if (eName == null || eName.length() <= 0 || (e = src.get(eName)) == null) continue;
                enzymes.add(e.enzyme.name);
            }
            if (enzymes.isEmpty()) continue;
            EnzymeMix item = new EnzymeMix();
            enzymes.sort(sortComparator);
            item.enzymes = enzymes.toArray();
            outList.addMix(item);
        }
        return outList;
    }
}

