/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import java.util.Arrays;
import java.util.Comparator;
import plot.DefaultLibraries;
import plot.Enzyme;

public class EnzymeMix {
    public static final Comparator sortEnzymeMix = new Comparator<EnzymeMix>(){

        @Override
        public int compare(EnzymeMix o1, EnzymeMix o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public String[] enzymes;
    public int cutsCount = 0;
    public Locus[] cuts;
    public Locus[] bands = null;
    private String name;

    public String getName() {
        return this.name == null ? EnzymeMix.pGetName(this) : this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void addEnzyme(String name) {
        if (!DefaultLibraries.defaultEnzymes.items.containsKey(name)) {
            return;
        }
        if (this.enzymes == null || this.enzymes.length == 0) {
            this.enzymes = new String[1];
            this.enzymes[0] = name;
            return;
        }
        for (String e : this.enzymes) {
            if (!e.equals(name)) continue;
            return;
        }
        String[] tmp = new String[this.enzymes.length + 1];
        System.arraycopy(this.enzymes, 0, tmp, 0, this.enzymes.length);
        tmp[tmp.length - 1] = name;
        this.enzymes = tmp;
        if (this.enzymes.length > 1) {
            Arrays.sort(this.enzymes, 0, this.enzymes.length);
        }
        name = null;
    }

    public String toGBString() {
        return EnzymeMix.pToGBString(this);
    }

    public EnzymeMix clone() {
        int x;
        EnzymeMix clone = new EnzymeMix();
        clone.name = this.name;
        clone.cutsCount = this.cutsCount;
        if (this.bands != null && this.bands.length > 0) {
            clone.bands = new Locus[this.bands.length];
            for (x = 0; x < this.bands.length; ++x) {
                clone.bands[x] = this.bands[x].clone();
            }
        }
        if (this.cuts != null && this.cuts.length > 0) {
            clone.cuts = new Locus[this.cuts.length];
            for (x = 0; x < this.cuts.length; ++x) {
                clone.cuts[x] = this.cuts[x].clone();
            }
        }
        if (this.enzymes != null && this.enzymes.length > 0) {
            clone.enzymes = new String[this.enzymes.length];
            System.arraycopy(this.enzymes, 0, clone.enzymes, 0, this.enzymes.length);
        }
        return clone;
    }

    private static String pGetName(EnzymeMix mix) {
        mix.name = new String();
        int lastEntry = mix.enzymes.length - 1;
        for (int x = 0; x < mix.enzymes.length; ++x) {
            mix.name = x < lastEntry ? mix.name + mix.enzymes[x] + "+" : mix.name + mix.enzymes[x];
        }
        return mix.name;
    }

    private static String pToGBString(EnzymeMix mix) {
        String nameString = "";
        String seqString = "";
        int lastEntry = mix.enzymes.length - 1;
        for (int x = 0; x < mix.enzymes.length; ++x) {
            Enzyme e = DefaultLibraries.getEnzyme(mix.enzymes[x]);
            if (e == null) continue;
            nameString = nameString + e.name;
            seqString = seqString + e.sequence;
            if (x >= lastEntry) continue;
            nameString = nameString + "+";
            seqString = seqString + ",";
        }
        return "COMMENT ENZMIX = [" + nameString + "],[" + seqString + "]";
    }
}

