/*
 * Decompiled with CFR 0.152.
 */
package plot;

import FileReaders.InternalLibrary;
import InternalDataFetcher.InternalFileReader;
import java.util.ArrayList;
import plot.Ladder;

class DefaultLadders
extends InternalLibrary {
    public Ladder[] items;

    @Override
    public void init() {
        this.setTitle("Default Ladders Library");
    }

    public DefaultLadders() {
        super("/Data/Ladders.dat");
    }

    public DefaultLadders(String filepath) {
        super(filepath);
    }

    @Override
    public boolean loadFileContents(String file) {
        ArrayList<Ladder> loadedLadders = new ArrayList<Ladder>();
        String[] lines = InternalFileReader.getFileLines(file);
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (String line : lines) {
            Ladder ladder = Ladder.fromString(line);
            if (ladder == null) continue;
            ladder.isDefault = true;
            loadedLadders.add(ladder);
        }
        Ladder[] outArray = new Ladder[loadedLadders.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = (Ladder)loadedLadders.get(x);
        }
        this.items = outArray;
        return this.items != null && this.items.length > 0;
    }
}

