/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import FileReaders.InternalLibrary;
import InternalDataFetcher.InternalFileReader;
import plot.Enzyme;

class DefaultEnzymes
extends InternalLibrary {
    public BinaryChain<Enzyme> items;

    @Override
    public void init() {
        this.setTitle("Default Restriction Enzymes Library");
        this.items = new BinaryChain();
    }

    public DefaultEnzymes() {
        super("/Data/Restrict.dat");
    }

    public DefaultEnzymes(String filepath) {
        super(filepath);
        this.items = new BinaryChain();
    }

    @Override
    public boolean loadFileContents(String file) {
        String[] lines = InternalFileReader.getFileLines(file);
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (String line : lines) {
            Enzyme enzyme = Enzyme.fromString(line);
            if (enzyme == null) continue;
            enzyme.isDefault = true;
            this.items.add(enzyme, enzyme.name);
            if (enzyme.sShared == null) continue;
            enzyme.proto = this.items.get(enzyme.sShared);
        }
        if (this.items.size() > 0) {
            this.items.sort(Enzyme.sortComparator);
            return true;
        }
        return false;
    }
}

