/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

class Circle
extends Arc2D.Double {
    public double centerX;
    public double centerY;
    public double radius;
    public double radius2;
    public double diameter;
    private static double p2d = Math.PI / 180;

    public String toString() {
        return super.toString() + ", (" + this.centerX + "," + this.centerY + "), radius=" + this.radius;
    }

    public Circle(double centerX, double centerY, double radius) {
        super(centerX - radius, centerY - radius, radius * 2.0, radius * 2.0, 0.0, 360.0, 0);
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.radius2 = radius * radius;
        this.diameter = radius * 2.0;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getDiameter() {
        return this.radius;
    }

    public double getX(double y) {
        return Math.abs(Math.sqrt(this.radius2 - y * y));
    }

    public double getX(double y, boolean left) {
        double tmpRad = y - this.centerY;
        tmpRad *= tmpRad;
        tmpRad = (tmpRad = this.radius2 - tmpRad) > 0.0 ? Math.sqrt(tmpRad) : 0.0;
        if (left) {
            return this.centerX - tmpRad;
        }
        return this.centerX + tmpRad;
    }

    public double getY(double x) {
        return Math.abs(Math.sqrt(this.radius2 + x * x));
    }

    public double getY(double x, boolean above) {
        if (above) {
            return this.centerY - Math.abs(Math.sqrt(this.radius2 + x * x));
        }
        return this.centerY + Math.abs(Math.sqrt(this.radius2 + x * x));
    }

    @Override
    public double getCenterX() {
        return this.centerX;
    }

    @Override
    public double getCenterY() {
        return this.centerY;
    }

    public Point2D.Double getXY(double angleInDegrees) {
        double p2dA = p2d * angleInDegrees;
        return new Point2D.Double(this.radius * Math.sin(p2dA) + this.centerX, this.radius * Math.cos(p2dA) + this.centerY);
    }

    public Point2D.Double getXY(double angleInDegrees, double radius) {
        double p2dA = p2d * angleInDegrees;
        return new Point2D.Double(radius * Math.sin(p2dA) + this.centerX, radius * Math.cos(p2dA) + this.centerY);
    }

    public static Point2D.Double getXY(double centerX, double centerY, double radius, double angleInDegrees) {
        double p2dA = p2d * angleInDegrees;
        return new Point2D.Double(radius * Math.sin(p2dA) + centerX, radius * Math.cos(p2dA) + centerY);
    }
}

