/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UIUtilities {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private static final boolean IS_OS2 = System.getProperty("os.name").toLowerCase().contains("os/2");
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
    private static final boolean IS_SUNOS = System.getProperty("os.name").toLowerCase().contains("sunos");
    private static final boolean IS_AIX = System.getProperty("os.name").toLowerCase().contains("aix");
    private static final boolean IS_HPUX = System.getProperty("os.name").toLowerCase().contains("hpux");
    private static final boolean IS_FREEBSD = System.getProperty("os.name").toLowerCase().contains("freebsd");
    private static final boolean IS_HIRES_SCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1280;
    static Double javaVersion = null;
    static Double osVersion = null;
    private static final String ELLIPSIS = "...";

    public static double getJavaVersion() {
        if (javaVersion == null) {
            try {
                String ver = System.getProperty("java.version");
                String version = "";
                boolean firstPoint = true;
                for (int i = 0; i < ver.length(); ++i) {
                    if (ver.charAt(i) == '.') {
                        if (firstPoint) {
                            version = version + ver.charAt(i);
                        }
                        firstPoint = false;
                        continue;
                    }
                    if (!Character.isDigit(ver.charAt(i))) continue;
                    version = version + ver.charAt(i);
                }
                javaVersion = Double.valueOf(version);
            }
            catch (NumberFormatException ex) {
                javaVersion = 1.3;
            }
        }
        return javaVersion;
    }

    public static double getOSVersion() {
        if (osVersion == null) {
            try {
                String ver = System.getProperties().getProperty("os.version");
                String version = "";
                boolean firstPoint = true;
                for (int i = 0; i < ver.length(); ++i) {
                    if (ver.charAt(i) == '.') {
                        if (firstPoint) {
                            version = version + ver.charAt(i);
                        }
                        firstPoint = false;
                        continue;
                    }
                    if (!Character.isDigit(ver.charAt(i))) continue;
                    version = version + ver.charAt(i);
                }
                osVersion = Double.valueOf(version);
            }
            catch (NumberFormatException ex) {
                osVersion = 1.0;
            }
        }
        return osVersion;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isOS2() {
        return IS_OS2;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isSunOS() {
        return IS_SUNOS;
    }

    public static boolean isAIX() {
        return IS_AIX;
    }

    public static boolean isHPUX() {
        return IS_HPUX;
    }

    public static boolean isFreeBSD() {
        return IS_FREEBSD;
    }

    public static boolean isHiresScreen() {
        return IS_HIRES_SCREEN;
    }

    public static boolean isLeftToRight(Component c) {
        if (c == null) {
            return true;
        }
        return c.getComponentOrientation().isLeftToRight();
    }

    public static boolean isActive(JComponent c) {
        if (c == null) {
            return false;
        }
        boolean active = true;
        if (c instanceof JInternalFrame) {
            active = ((JInternalFrame)c).isSelected();
        }
        if (active) {
            for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof JInternalFrame)) continue;
                active = ((JInternalFrame)parent).isSelected();
                break;
            }
        }
        if (active) {
            active = UIUtilities.isFrameActive(c);
        }
        return active;
    }

    public static boolean isFrameActive(Component c) {
        if (c == null) {
            return false;
        }
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null) {
            if (w.getClass().getName().contains("Popup")) {
                return true;
            }
            return w.isActive();
        }
        return true;
    }

    public static Container getRootContainer(Component c) {
        Container parent;
        if (c == null) {
            return null;
        }
        for (parent = c.getParent(); !(parent == null || parent instanceof JPopupMenu || parent instanceof JInternalFrame || parent instanceof Window || parent.getParent() == null); parent = parent.getParent()) {
        }
        return parent;
    }

    public static Dimension getFrameSize(Component c) {
        Container parent = UIUtilities.getRootContainer(c);
        if (parent != null) {
            return parent.getSize();
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Point getRelLocation(Component c) {
        if (c == null || !c.isShowing()) {
            return new Point(0, 0);
        }
        Container parent = UIUtilities.getRootContainer(c);
        if (parent != null && parent.isShowing() && c.isShowing()) {
            Point p1 = c.getLocationOnScreen();
            Point p2 = parent.getLocationOnScreen();
            return new Point(p1.x - p2.x, p1.y - p2.y);
        }
        return new Point(0, 0);
    }

    public static String getClippedText(String text, FontMetrics fm, int maxWidth) {
        if (text == null || text.length() == 0) {
            return "";
        }
        int width = SwingUtilities.computeStringWidth(fm, text);
        if (width > maxWidth) {
            int totalWidth = SwingUtilities.computeStringWidth(fm, ELLIPSIS);
            for (int i = 0; i < text.length(); ++i) {
                if ((totalWidth += fm.charWidth(text.charAt(i))) <= maxWidth) continue;
                return text.substring(0, i) + ELLIPSIS;
            }
        }
        return text;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font f) {
        FontMetrics fm = null;
        if (fm == null) {
            if (g == null && c != null) {
                g = c.getGraphics();
            }
            if (g != null) {
                fm = f != null ? g.getFontMetrics(f) : g.getFontMetrics();
            } else if (c != null) {
                fm = f != null ? c.getFontMetrics(f) : c.getFontMetrics(c.getFont());
            }
        }
        return fm;
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2D.drawString(text, x, y);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
    }

    public static void fillHorGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            int steps = colors.length;
            double dy = (double)h / (double)steps;
            if (dy <= 2.001) {
                int y1 = y;
                for (int i = 0; i < steps; ++i) {
                    int y2 = y + (int)Math.round((double)i * dy);
                    g.setColor(colors[i]);
                    if (i == steps - 1) {
                        g.fillRect(x, y1, w, y + h - y1);
                    } else {
                        g.fillRect(x, y1, w, y2 - y1);
                    }
                    y1 = y2;
                }
            } else {
                UIUtilities.smoothFillHorGradient(g, colors, x, y, w, h);
            }
        }
    }

    public static void smoothFillHorGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            Graphics2D g2D = (Graphics2D)g;
            Paint savedPaint = g2D.getPaint();
            int steps = colors.length;
            double dy = (double)h / (double)(steps - 1);
            int y1 = y;
            for (int i = 0; i < steps; ++i) {
                int y2 = y + (int)Math.round((double)i * dy);
                if (i == steps - 1) {
                    g2D.setPaint(null);
                    g2D.setColor(colors[i]);
                    g2D.fillRect(x, y1, w, y + h - y1);
                } else {
                    g2D.setPaint(new GradientPaint(0.0f, y1, colors[i], 0.0f, y2, colors[i + 1]));
                    g2D.fillRect(x, y1, w, y2 - y1);
                }
                y1 = y2;
            }
            g2D.setPaint(savedPaint);
        }
    }

    public static void fillInverseHorGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            int steps = colors.length;
            double dy = (double)h / (double)steps;
            if (dy <= 2.001) {
                int y1 = y;
                for (int i = 0; i < steps; ++i) {
                    int y2 = y + (int)Math.round((double)i * dy);
                    g.setColor(colors[colors.length - i - 1]);
                    if (i == steps - 1) {
                        g.fillRect(x, y1, w, y + h - y1);
                    } else {
                        g.fillRect(x, y1, w, y2 - y1);
                    }
                    y1 = y2;
                }
            } else {
                UIUtilities.smoothFillInverseHorGradient(g, colors, x, y, w, h);
            }
        }
    }

    public static void smoothFillInverseHorGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            Graphics2D g2D = (Graphics2D)g;
            Paint savedPaint = g2D.getPaint();
            int steps = colors.length;
            double dy = (double)h / (double)steps;
            int y1 = y;
            for (int i = 0; i < steps; ++i) {
                int y2 = y + (int)Math.round((double)i * dy);
                g.setColor(colors[colors.length - i - 1]);
                if (i == steps - 1) {
                    g2D.setPaint(null);
                    g2D.setColor(colors[colors.length - i - 1]);
                    g.fillRect(x, y1, w, y + h - y1);
                } else {
                    g2D.setPaint(new GradientPaint(0.0f, y1, colors[colors.length - i - 1], 0.0f, y2, colors[colors.length - i - 2]));
                    g.fillRect(x, y1, w, y2 - y1);
                }
                y1 = y2;
            }
            g2D.setPaint(savedPaint);
        }
    }

    public static void fillVerGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            int steps = colors.length;
            double dx = (double)w / (double)steps;
            int x1 = x;
            for (int i = 0; i < steps; ++i) {
                int x2 = x + (int)Math.round((double)i * dx);
                g.setColor(colors[i]);
                if (i == steps - 1) {
                    g.fillRect(x1, y, x + w - x1, h);
                } else {
                    g.fillRect(x1, y, x2 - x1, h);
                }
                x1 = x2;
            }
        }
    }

    public static void fillInverseVerGradient(Graphics g, Color[] colors, int x, int y, int w, int h) {
        if (colors != null) {
            int steps = colors.length;
            double dx = (double)w / (double)steps;
            int x1 = x;
            for (int i = 0; i < steps; ++i) {
                int x2 = x + (int)Math.round((double)i * dx);
                g.setColor(colors[colors.length - i - 1]);
                if (i == steps - 1) {
                    g.fillRect(x1, y, x + w - x1, h);
                } else {
                    g.fillRect(x1, y, x2 - x1, h);
                }
                x1 = x2;
            }
        }
    }

    public static void fillComponent(Graphics g, Component c, Icon texture) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int h = c.getHeight();
        if (texture != null) {
            int tw = texture.getIconWidth();
            int th = texture.getIconHeight();
            Point p = UIUtilities.getRelLocation(c);
            for (y = -p.y; y < h; y += th) {
                for (x = -p.x; x < w; x += tw) {
                    texture.paintIcon(c, g, x, y);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(x, y, w, h);
        }
    }

    public static void drawBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawRect(x, y, w - 1, h - 1);
    }

    public static void draw3DBorder(Graphics g, Color c1, Color c2, int x, int y, int w, int h) {
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        g.setColor(c1);
        g.drawLine(x, y, x2 - 1, y);
        g.drawLine(x, y + 1, x, y2);
        g.setColor(c2);
        g.drawLine(x, y2, x2 - 1, y2);
        g.drawLine(x2, y, x2, y2);
    }

    public static void drawRoundBorder(Graphics g, Color c, int x, int y, int w, int h, int r) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(c);
        g2D.drawRoundRect(x, y, w - 1, h - 1, r, r);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    public static void drawRound3DBorder(Graphics g, Color c1, Color c2, int x, int y, int w, int h) {
        Graphics2D g2D = (Graphics2D)g;
        int x2 = x + w;
        int y2 = y + h;
        int d = h;
        int r = h / 2;
        Color cm = UIUtilities.median(c1, c2);
        Color c1m = UIUtilities.median(c1, cm);
        Color c2m = UIUtilities.median(c2, cm);
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(c1);
        g2D.drawLine(x + r, y, x2 - r, y);
        g2D.drawLine(x, y + r, x, y2 - r);
        g2D.setColor(c2);
        g2D.drawLine(x + r, y2, x2 - r, y2);
        g2D.drawLine(x2, y + r, x2, y2 - r);
        g2D.setColor(c1);
        g2D.drawArc(x, y, d, d, 90, 45);
        g2D.setColor(c1m);
        g2D.drawArc(x, y, d, d, 135, 45);
        g2D.setColor(cm);
        g2D.drawArc(x, y, d, d, 180, 45);
        g2D.setColor(c2m);
        g2D.drawArc(x, y, d, d, 225, 45);
        g2D.setColor(c1m);
        g2D.drawArc(x2 - d, y, d, d, 45, 45);
        g2D.setColor(cm);
        g2D.drawArc(x2 - d, y, d, d, 0, 45);
        g2D.setColor(c2m);
        g2D.drawArc(x2 - d, y, d, d, -45, 45);
        g2D.setColor(c2);
        g2D.drawArc(x2 - d, y, d, d, -90, 45);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    public static Color createColor(int r, int g, int b) {
        return new Color((r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public static Color[] createColorArr(Color c1, Color c2, int steps) {
        if (c1 == null || c2 == null) {
            return null;
        }
        Color[] colors = new Color[steps];
        double r = c1.getRed();
        double g = c1.getGreen();
        double b = c1.getBlue();
        double dr = ((double)c2.getRed() - r) / (double)steps;
        double dg = ((double)c2.getGreen() - g) / (double)steps;
        double db = ((double)c2.getBlue() - b) / (double)steps;
        colors[0] = c1;
        for (int i = 1; i < steps - 1; ++i) {
            colors[i] = UIUtilities.createColor((int)(r += dr), (int)(g += dg), (int)(b += db));
        }
        colors[steps - 1] = c2;
        return colors;
    }

    public static Color brighter(Color c, double p) {
        if (c == null) {
            return null;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double rd = 255.0 - r;
        double gd = 255.0 - g;
        double bd = 255.0 - b;
        return UIUtilities.createColor((int)(r += rd * p / 100.0), (int)(g += gd * p / 100.0), (int)(b += bd * p / 100.0));
    }

    public static Color darker(Color c, double p) {
        if (c == null) {
            return null;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        r -= r * p / 100.0;
        g -= g * p / 100.0;
        b -= b * p / 100.0;
        return UIUtilities.createColor((int)r, (int)g, (int)b);
    }

    public static Color median(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        int r = (c1.getRed() + c2.getRed()) / 2;
        int g = (c1.getGreen() + c2.getGreen()) / 2;
        int b = (c1.getBlue() + c2.getBlue()) / 2;
        return UIUtilities.createColor(r, g, b);
    }

    public static int getGrayValue(Color c) {
        if (c == null) {
            return 0;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        return Math.min(255, (int)(r * 0.28 + g * 0.59 + b * 0.13));
    }

    public static int getGrayValue(Color[] ca) {
        int sum = 0;
        for (Color color : ca) {
            sum += UIUtilities.getGrayValue(color);
        }
        return sum / ca.length;
    }

    public static Color toGray(Color c) {
        if (c == null) {
            return null;
        }
        int gray = UIUtilities.getGrayValue(c);
        return new Color(gray, gray, gray, c.getAlpha());
    }

    public static String layout(JLabel label, FontMetrics fm, int width, int height, Icon icon, Rectangle iconRect, Rectangle textRect) {
        Insets insets = label.getInsets(null);
        String text = label.getText();
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        return UIUtilities.layoutCL(label, fm, text, icon, paintViewR, iconRect, textRect);
    }

    public static String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    public static void setContainerTransparent(Container fc) {
        Component[] cs;
        for (Component c : cs = fc.getComponents()) {
            if (c instanceof JPanel) {
                ((JPanel)c).setOpaque(false);
            } else if (c instanceof JLabel) {
                ((JLabel)c).setOpaque(false);
            }
            if (c instanceof Container) {
                UIUtilities.setContainerTransparent((Container)c);
                continue;
            }
            if (!(c instanceof JComponent)) continue;
            System.out.println(c);
        }
    }

    public static Rectangle calculateMaxBounds(Frame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle maxBounds = gc.getBounds();
        maxBounds.x = Math.max(maxBounds.x, screenInsets.left);
        maxBounds.y = Math.max(maxBounds.y, screenInsets.top);
        maxBounds.width -= screenInsets.left + screenInsets.right;
        maxBounds.height -= screenInsets.top + screenInsets.bottom;
        if (screenInsets.top == 0 && screenInsets.left == 0 && screenInsets.bottom == 0 && screenInsets.right == 0) {
            --maxBounds.height;
        }
        return maxBounds;
    }
}

