/*
 * Decompiled with CFR 0.152.
 */
package UndoRedo;

import UndoRedo.Undoable;

public class UndoRedoManager {
    private int count = 0;
    private int maxCount = 100;
    private Node currentIndex = this.root = new Node();
    private final Node root;

    public void setMaxUndoCount(int max) {
        this.maxCount = max;
        if (max < 1) {
            return;
        }
        while (max < this.count) {
            this.remove(this.root.right);
        }
    }

    public void clear() {
        if (this.root.right != null) {
            while (this.root.right != null) {
                this.remove(this.root.right);
            }
            this.currentIndex = this.root;
            this.count = 0;
            this.undoRedoOccurred();
        }
    }

    private void clearAfter(Node node) {
        while (node != null) {
            Node next = node.right;
            this.remove(node);
            node = next;
        }
    }

    private void clearUndoable(Undoable undoable) {
        undoable.afterRedo = null;
        undoable.afterUndo = null;
        undoable.beforeRedo = null;
        undoable.beforeUndo = null;
        if (undoable.childEdits != null && !undoable.childEdits.isEmpty()) {
            for (Undoable child : undoable.childEdits) {
                this.clearUndoable(child);
            }
            undoable.childEdits.removeAllElements();
        }
    }

    public String getRedoName() {
        return this.currentIndex == null || this.currentIndex.right == null || this.currentIndex.right.undoable == null ? "" : ((Node)((Node)this.currentIndex).right).undoable.redoName;
    }

    public String getUndoName() {
        return this.currentIndex == null || this.currentIndex.undoable == null ? "" : ((Node)this.currentIndex).undoable.undoName;
    }

    public void setRedoName(String title) {
        if (this.currentIndex != null && this.currentIndex.undoable != null && title != null) {
            ((Node)this.currentIndex).undoable.redoName = title;
        }
    }

    public void setUndoName(String title) {
        if (this.currentIndex != null && this.currentIndex.undoable != null && title != null) {
            ((Node)this.currentIndex).undoable.undoName = title;
        }
    }

    public boolean runEdit(Undoable edit) {
        if (edit.runRedo()) {
            this.addEdit(edit);
            return true;
        }
        return false;
    }

    public Undoable getLastEdit() {
        return this.currentIndex != null ? this.currentIndex.undoable : null;
    }

    public void addEdit(Undoable edit) {
        Node node = new Node(edit);
        if (this.currentIndex.right != null) {
            this.clearAfter(this.currentIndex.right);
        }
        this.currentIndex.right = node;
        node.left = this.currentIndex;
        if (this.maxCount > 0 && this.count == this.maxCount) {
            this.remove(this.root.right);
        }
        ++this.count;
        this.currentIndex = node;
        this.undoRedoOccurred();
    }

    private void remove(Node node) {
        if (node == null || node == this.root) {
            return;
        }
        if (node.left != null) {
            node.left.right = node.right;
        }
        if (node.right != null) {
            node.right.left = node.left;
        }
        if (node.undoable != null) {
            this.clearUndoable(node.undoable);
            node.undoable = null;
        }
        node.left = null;
        node.right = null;
        --this.count;
    }

    public boolean canUndo() {
        return this.currentIndex != this.root;
    }

    public boolean canRedo() {
        return this.currentIndex.right != null;
    }

    public void undo() {
        if (!this.canUndo()) {
            throw new IllegalStateException("Cannot undo. Index is out of range.");
        }
        this.currentIndex.undoable.runUndo();
        this.moveLeft();
        this.undoRedoOccurred();
    }

    private void moveLeft() {
        if (this.currentIndex.left == null) {
            throw new IllegalStateException("Internal index set to null.");
        }
        this.currentIndex = this.currentIndex.left;
    }

    private void moveRight() {
        if (this.currentIndex.right == null) {
            throw new IllegalStateException("Internal index set to null.");
        }
        this.currentIndex = this.currentIndex.right;
    }

    public void redo() {
        if (!this.canRedo()) {
            throw new IllegalStateException("Cannot redo. Index is out of range.");
        }
        this.moveRight();
        this.currentIndex.undoable.runRedo();
        this.undoRedoOccurred();
    }

    public void undoRedoOccurred() {
    }

    private class Node {
        int index = 0;
        private Node left = null;
        private Node right = null;
        private Undoable undoable;

        public Node(Undoable c) {
            this.undoable = c;
        }

        public Node() {
            this.undoable = null;
        }
    }
}

