/*
 * Decompiled with CFR 0.152.
 */
package URLLabel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;

public class URLLabel
extends JLabel {
    private String url = "";
    private Color colorDown = Color.RED;
    private Color colorOver = Color.RED;
    private Color colorOut = Color.BLUE;
    private URI uri = null;
    private static final Cursor handCursor = new Cursor(12);
    private static final Cursor defaultCursor = new Cursor(0);

    public URLLabel() {
        this.initListeners();
    }

    public URLLabel(String text) {
        super(text);
        this.initListeners();
    }

    public URLLabel(String text, String url) {
        super(text);
        this.setURL(url);
        this.initListeners();
    }

    public URLLabel(String text, String url, Color colorOver) {
        super(text);
        this.setURL(url);
        this.setColorOver(colorOver);
        this.initListeners();
    }

    public URLLabel(String text, String url, Color colorOver, Color colorDown) {
        super(text);
        this.setURL(url);
        this.setColorOver(colorOver);
        this.setColorDown(colorDown);
        this.initListeners();
    }

    public URLLabel(String text, String url, Color colorOver, Color colorDown, Color colorOut) {
        super(text);
        this.setURL(url);
        this.setColorOver(colorOver);
        this.setColorDown(colorDown);
        this.setColorOut(colorOut);
        this.initListeners();
    }

    public void setColorOver(Color color) {
        if (color != null) {
            this.colorOver = color;
        }
    }

    public void setColorDown(Color color) {
        if (color != null) {
            this.colorDown = color;
        }
    }

    public void setColorOut(Color color) {
        if (color != null) {
            this.colorOut = color;
        }
    }

    public Color getColorOver() {
        return this.colorOver;
    }

    public Color getColorDown() {
        return this.colorDown;
    }

    public Color getColorOut() {
        return this.colorOut;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (url == null || url.length() == 0) {
            this.url = "";
            this.uri = null;
        } else {
            this.url = url;
            try {
                this.uri = new URL(url).toURI();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                this.url = "";
                this.uri = null;
            }
        }
    }

    private void initListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                URLLabel.this.setForeground(URLLabel.this.colorDown);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (URLLabel.this.uri != null) {
                    URLLabel.this.openURL(URLLabel.this.url);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (URLLabel.this.url.length() == 0) {
                    return;
                }
                URLLabel.this.setForeground(URLLabel.this.colorOver);
                URLLabel.this.setCursor(handCursor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (URLLabel.this.url.length() == 0) {
                    return;
                }
                URLLabel.this.setForeground(URLLabel.this.colorOut);
                URLLabel.this.setCursor(defaultCursor);
            }
        });
    }

    private void openURL(String url) {
        try {
            Desktop.getDesktop().browse(this.uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

