/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.BasicGradientRenderer;
import Renderers.MetallicRenderer;
import Renderers.Renderer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class RenderedToolTipUI
extends BasicToolTipUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    static ComponentUI sharedInstance = new RenderedToolTipUI();
    private Renderer renderer = new MetallicRenderer();

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.getActiveRenderer().paintBackground((Graphics2D)g, c);
        Font font = c.getFont();
        FontMetrics metrics = c.getFontMetrics(font);
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top, size.width - (insets.left + insets.right) - 6, size.height - (insets.top + insets.bottom));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            g.setFont(font);
            g.drawString(tipText, paintTextR.x, paintTextR.y + metrics.getAscent());
        }
    }
}

