/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import IconRenderers.IconRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedButtonUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class RenderedSpinnerUI
extends BasicSpinnerUI {
    static Renderer defaultButtonRenderer = null;
    static IconRenderer defaultArrowRenderer = null;
    private Renderer buttonRenderer;
    private IconRenderer arrowRenderer;

    public static void setDefaultButtonRenderer(Renderer renderer) {
        defaultButtonRenderer = renderer;
    }

    public static IconRenderer getDefaultArrowRenderer() {
        return defaultArrowRenderer != null ? defaultArrowRenderer : IconRenderer.getDefaultArrowRenderer();
    }

    public static Renderer getDefaultButtonRenderer() {
        return defaultButtonRenderer == null ? RenderedButtonUI.getDefaultRenderer() : defaultButtonRenderer;
    }

    private Renderer getActiveButtonRenderer() {
        return this.buttonRenderer == null ? RenderedSpinnerUI.getDefaultButtonRenderer() : this.buttonRenderer;
    }

    private IconRenderer getActiveArrowRenderer() {
        return this.arrowRenderer == null ? RenderedSpinnerUI.getDefaultArrowRenderer() : this.arrowRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedSpinnerUI();
    }

    @Override
    protected Component createNextButton() {
        Component c = this.createButton(1);
        c.setName("Spinner.nextButton");
        this.installNextButtonListeners(c);
        return c;
    }

    @Override
    protected Component createPreviousButton() {
        Component c = this.createButton(5);
        c.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(c);
        return c;
    }

    private Component createButton(final int direction) {
        JButton b = new JButton(){

            @Override
            public void paint(Graphics g) {
                Renderer renderer = RenderedSpinnerUI.this.getActiveButtonRenderer();
                renderer.setOrientation(1);
                renderer.paintBackground((Graphics2D)g, this);
                RenderedSpinnerUI.this.getActiveArrowRenderer().paintIcon(g, this, direction);
                if (renderer.isPaintBorder()) {
                    renderer.paintBorder((Graphics2D)g, this);
                }
            }
        };
        b.setContentAreaFilled(true);
        b.setOpaque(true);
        b.setInheritsPopupMenu(true);
        return b;
    }
}

