/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.ThumbShapeRenderer;
import JMConstants.Constants;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import Renderers.Renderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class RenderedSliderUI
extends BasicSliderUI
implements Constants {
    static Renderer defaultTrackRenderer = new JavTRenderer();
    static Renderer defaultThumbRenderer = new MetalRenderer();
    static ThumbShapeRenderer defaultThumbShapeRenderer = ThumbShapeRenderer.CIRCLE_THUMB;
    private Renderer trackRenderer;
    private Renderer thumbRenderer;
    private ThumbShapeRenderer thumbShapeRenderer;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RenderedSliderUI.this.setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RenderedSliderUI.this.setRollover(false);
        }
    };
    boolean repaintOnRollover = false;
    boolean rollOver = false;

    public static void setDefaultTrackRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultTrackRenderer = renderer;
        }
    }

    public static Renderer getDefaultTrackRenderer() {
        return defaultTrackRenderer;
    }

    public static void setDefaultThumbRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultThumbRenderer = renderer;
        }
    }

    public static Renderer getDefaultThumbRenderer() {
        return defaultThumbRenderer;
    }

    public static void setDefaultThumbShapeRenderer(ThumbShapeRenderer renderer) {
        if (renderer != null) {
            defaultThumbShapeRenderer = renderer;
        }
    }

    public static ThumbShapeRenderer getDefaultThumbShapeRenderer() {
        return defaultThumbShapeRenderer;
    }

    public static ComponentUI createUI(JComponent b) {
        return new RenderedSliderUI((JSlider)b);
    }

    public void setRenderer(Renderer renderer) {
        this.trackRenderer = renderer;
    }

    public Renderer getRenderer() {
        return this.trackRenderer;
    }

    private Renderer getActiveRenderer() {
        return this.trackRenderer == null ? defaultTrackRenderer : this.trackRenderer;
    }

    private Renderer getActiveThumbRenderer() {
        return this.thumbRenderer == null ? defaultThumbRenderer : this.thumbRenderer;
    }

    private ThumbShapeRenderer getActiveThumbShapeRenderer() {
        return this.thumbShapeRenderer == null ? defaultThumbShapeRenderer : this.thumbShapeRenderer;
    }

    private void setRollover(boolean isRollOver) {
        if (this.repaintOnRollover) {
            this.rollOver = isRollOver;
            this.slider.repaint();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener);
        super.uninstallUI(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.slider.addMouseListener(this.mouseListener);
    }

    public RenderedSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void paintTrack(Graphics g) {
        Renderer renderer = this.getActiveRenderer();
        renderer.setOrientation(this.slider.getOrientation());
        renderer.paintBackground((Graphics)((Graphics2D)g), (Component)this.slider, this.rollOver ? 5 : 0);
        if (renderer.isPaintBorder()) {
            renderer.paintBorder((Graphics2D)g, this.slider);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintThumb(Graphics g) {
        Shape thumb = this.getActiveThumbShapeRenderer().genShape(this.thumbRect, this);
        g.setColor(this.getActiveThumbRenderer().getNormalColor(this.slider));
        ((Graphics2D)g).fill(thumb);
        g.setColor(this.getActiveThumbRenderer().getBorderColor());
        ((Graphics2D)g).draw(thumb);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(16, 16);
    }

    public boolean isDrawInverted() {
        return this.drawInverted();
    }

    public JSlider getSlider() {
        return this.slider;
    }
}

