/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.GlossyRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedButtonUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSeparatorUI;

public class RenderedSeparatorUI
extends MetalSeparatorUI {
    public static int HORIZONTAL_ORIENTATION = 0;
    public static int VERTICAL_ORIENTATION = 1;
    public static int DEFAULT_ORIENTATION = -1;
    public static int STATIC_DEFAULT_ORIENTATION = -2;
    private static int defaultSize = 4;
    private int size = 0;
    private static Renderer defaultRenderer = new GlossyRenderer();
    private Renderer renderer;
    private static int defaultForceOrientation = -1;
    private int forceOrientation = -1;

    public static void setDefaultSize(int size) {
        if (size > 0) {
            defaultSize = size;
        }
    }

    public static int getDefaultSize() {
        return defaultSize;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public static void setDefaultRenderer(Renderer renderer) {
        defaultRenderer = renderer;
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer != null ? defaultRenderer : RenderedButtonUI.getDefaultRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedSeparatorUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    public static void setDefaultForcedOrientation(int orientation) {
        if (orientation >= DEFAULT_ORIENTATION && orientation <= VERTICAL_ORIENTATION) {
            defaultForceOrientation = orientation;
        }
    }

    public static int getDefaultForcedOrientation() {
        return defaultForceOrientation;
    }

    public void setForcedOrientation(int orientation) {
        if (orientation >= STATIC_DEFAULT_ORIENTATION && orientation <= VERTICAL_ORIENTATION) {
            this.forceOrientation = orientation;
        }
    }

    public int getForcedOrientation() {
        return this.forceOrientation;
    }

    protected int getRenderedOrientation(JSeparator c) {
        int orient = this.forceOrientation != STATIC_DEFAULT_ORIENTATION ? this.forceOrientation : RenderedSeparatorUI.getDefaultForcedOrientation();
        return orient == DEFAULT_ORIENTATION ? c.getOrientation() : orient;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        Renderer renderer = this.getActiveRenderer();
        renderer.setOrientation(this.getRenderedOrientation((JSeparator)c));
        renderer.paintBackground(g, c, new Rectangle(0, 0, s.width, s.height), 0);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int size;
        int n = size = this.size > 0 ? this.size : defaultSize;
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(size, 0);
        }
        return new Dimension(0, size);
    }
}

