/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import IconRenderers.IconRenderer;
import JMConstants.Constants;
import Renderers.BasicRenderer;
import Renderers.MetalRenderer;
import Renderers.Renderer;
import Tools.UITools;
import UIRenderers.RenderedButtonUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class RenderedScrollBarUI
extends BasicScrollBarUI
implements Constants {
    static Renderer defaultTrackRenderer = new BasicRenderer();
    static Renderer defaultThumbRenderer = new MetalRenderer();
    static Renderer defaultButtonRenderer = null;
    static IconRenderer defaultArrowRenderer = null;
    private Renderer trackRenderer;
    private Renderer thumbRenderer;
    private Renderer buttonRenderer;
    private IconRenderer arrowRenderer;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RenderedScrollBarUI.this.setPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RenderedScrollBarUI.this.setPressed(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RenderedScrollBarUI.this.setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RenderedScrollBarUI.this.setRollover(false);
        }
    };
    boolean rollOver = false;
    boolean pressed = false;

    public static void setDefaultTrackRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultTrackRenderer = renderer;
        }
    }

    public static Renderer getDefaultTrackRenderer() {
        return defaultTrackRenderer;
    }

    public static void setDefaultThumbRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultThumbRenderer = renderer;
        }
    }

    public static Renderer getDefaultThumbRenderer() {
        return defaultThumbRenderer;
    }

    public static void setDefaultButtonRenderer(Renderer renderer) {
        defaultButtonRenderer = renderer;
    }

    public static Renderer getDefaultButtonRenderer() {
        return defaultButtonRenderer != null ? defaultButtonRenderer : RenderedButtonUI.getDefaultRenderer();
    }

    public static void setDefaultArrowRenderer(IconRenderer renderer) {
        defaultArrowRenderer = renderer;
    }

    public static IconRenderer getDefaultArrowRenderer() {
        return defaultArrowRenderer != null ? defaultArrowRenderer : IconRenderer.getDefaultArrowRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedScrollBarUI();
    }

    public void setTrackRenderer(Renderer renderer) {
        this.trackRenderer = renderer;
    }

    public Renderer getTrackRenderer() {
        return this.trackRenderer;
    }

    public void setThumbRenderer(Renderer renderer) {
        this.thumbRenderer = renderer;
    }

    public Renderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    public void setButtonRenderer(Renderer renderer) {
        this.buttonRenderer = renderer;
    }

    public Renderer getButtonRenderer() {
        return this.buttonRenderer;
    }

    public void setArrowRenderer(IconRenderer renderer) {
        this.arrowRenderer = renderer;
    }

    public IconRenderer getArrowRenderer() {
        return this.arrowRenderer;
    }

    private Renderer getActiveRenderer() {
        return this.trackRenderer == null ? defaultTrackRenderer : this.trackRenderer;
    }

    private Renderer getActiveThumbRenderer() {
        return this.thumbRenderer == null ? defaultThumbRenderer : this.thumbRenderer;
    }

    private Renderer getActiveButtonRenderer() {
        return this.buttonRenderer == null ? RenderedScrollBarUI.getDefaultButtonRenderer() : this.buttonRenderer;
    }

    private IconRenderer getActiveArrowRenderer() {
        return this.arrowRenderer == null ? RenderedScrollBarUI.getDefaultArrowRenderer() : this.arrowRenderer;
    }

    private void setRollover(boolean isRollOver) {
        this.rollOver = isRollOver;
        this.scrollbar.repaint();
    }

    private void setPressed(boolean isPressedOver) {
        this.pressed = isPressedOver;
        this.scrollbar.repaint();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener);
        super.uninstallUI(c);
        c = null;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.addMouseListener(this.mouseListener);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Renderer renderer = this.getActiveRenderer();
        int state = this.rollOver ? (!this.pressed ? 5 : 1) : 0;
        renderer.setOrientation(this.scrollbar.getOrientation());
        renderer.paintBackground((Graphics2D)g, c, trackBounds, state);
        if (renderer.isPaintBorder()) {
            renderer.paintBorder((Graphics2D)g, c, trackBounds);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Renderer renderer = this.getActiveThumbRenderer();
        int state = this.rollOver ? (!this.pressed ? 5 : 1) : 0;
        renderer.setOrientation(this.scrollbar.getOrientation());
        renderer.paintBackground((Graphics2D)g, c, thumbBounds, state);
        if (renderer.isPaintBorder()) {
            renderer.paintBorder((Graphics2D)g, c, thumbBounds);
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new BasicArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight")){

            @Override
            public void paint(Graphics g) {
                Renderer renderer = RenderedScrollBarUI.this.getActiveButtonRenderer();
                int state = UITools.getState(this);
                renderer.setOrientation(RenderedScrollBarUI.this.scrollbar.getOrientation());
                renderer.paintBackground((Graphics)((Graphics2D)g), (Component)this, state);
                RenderedScrollBarUI.this.getActiveArrowRenderer().paintIcon(g, this, this.direction, state);
                if (renderer.isPaintBorder()) {
                    renderer.paintBorder((Graphics2D)g, this);
                }
            }
        };
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new BasicArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight")){

            @Override
            public void paint(Graphics g) {
                Renderer renderer = RenderedScrollBarUI.this.getActiveButtonRenderer();
                renderer.setOrientation(RenderedScrollBarUI.this.scrollbar.getOrientation());
                renderer.paintBackground((Graphics2D)g, this);
                RenderedScrollBarUI.this.getActiveArrowRenderer().paintIcon(g, this, this.direction);
                if (renderer.isPaintBorder()) {
                    renderer.paintBorder((Graphics2D)g, this);
                }
            }
        };
    }
}

