/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.GlossyRenderer;
import Renderers.Renderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class RenderedRadioButtonUI
extends BasicRadioButtonUI {
    static Renderer defaultRenderer = new GlossyRenderer();
    private Renderer renderer;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RenderedRadioButtonUI.this.component.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RenderedRadioButtonUI.this.component.getModel().setRollover(false);
        }
    };
    JRadioButton component;
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private boolean foundOpaque = false;
    private boolean opaque = false;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedRadioButtonUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener);
        super.uninstallUI(c);
        if (c == this.component) {
            this.component = null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.icon = null;
        this.component = (JRadioButton)c;
        this.component.addMouseListener(this.mouseListener);
        Object opaque = UIManager.get(this.getPropertyPrefix() + "opaque");
        this.icon = UIManager.getIcon("RadioButton.icon");
        if (opaque instanceof Boolean) {
            this.foundOpaque = true;
            this.opaque = (Boolean)opaque;
            this.component.setOpaque(this.opaque);
            this.component.setContentAreaFilled(this.opaque);
        }
        this.icon = UIManager.getIcon("RadioButton.icon");
        this.component.setRolloverEnabled(true);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.foundOpaque && b.isOpaque() != this.opaque) {
            b.setOpaque(this.opaque);
        }
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        size = b.getSize(size);
        RenderedRadioButtonUI.viewRect.x = i.left;
        RenderedRadioButtonUI.viewRect.y = i.top;
        RenderedRadioButtonUI.viewRect.width = RenderedRadioButtonUI.size.width - (i.right + RenderedRadioButtonUI.viewRect.x);
        RenderedRadioButtonUI.viewRect.height = RenderedRadioButtonUI.size.height - (i.bottom + RenderedRadioButtonUI.viewRect.y);
        RenderedRadioButtonUI.iconRect.height = 0;
        RenderedRadioButtonUI.iconRect.width = 0;
        RenderedRadioButtonUI.iconRect.y = 0;
        RenderedRadioButtonUI.iconRect.x = 0;
        RenderedRadioButtonUI.textRect.height = 0;
        RenderedRadioButtonUI.textRect.width = 0;
        RenderedRadioButtonUI.textRect.y = 0;
        RenderedRadioButtonUI.textRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.getActiveRenderer().getColors().setActiveColors(c);
        if (b.isContentAreaFilled() || b.isOpaque()) {
            this.getActiveRenderer().paintBackground((Graphics)((Graphics2D)g), (Component)c, new Rectangle(0, 0, RenderedRadioButtonUI.size.width, RenderedRadioButtonUI.size.height));
        }
        if (this.icon != null) {
            this.icon.paintIcon(c, g, RenderedRadioButtonUI.iconRect.x, RenderedRadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(c.isEnabled() ? this.getActiveRenderer().getTextColor() : this.getActiveRenderer().getDisabledTextColor());
                g.drawString(text, RenderedRadioButtonUI.textRect.x, RenderedRadioButtonUI.textRect.y + fm.getAscent());
            }
        }
    }
}

