/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.Renderer;
import Tools.UITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import plaf.UIUtilities;

public class RenderedOptionPaneUI
extends BasicOptionPaneUI {
    private static final int YES_BUTTON = 0;
    private static final int NO_BUTTON = 1;
    private static final int OK_BUTTON = 2;
    private static final int CANCEL_BUTTON = 3;
    private static final Renderer[] renderers = new Renderer[4];

    public static void setButtonRenderer(int buttonType, Renderer renderer) {
        if (buttonType >= 0 && buttonType < renderers.length) {
            RenderedOptionPaneUI.renderers[buttonType] = renderer;
        }
    }

    public static Renderer getButtonRenderer(int buttonType) {
        if (buttonType >= 0 && buttonType < renderers.length) {
            return renderers[buttonType];
        }
        return null;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        UIUtilities.setContainerTransparent(c);
    }

    public static ComponentUI createUI(JComponent x) {
        return new RenderedOptionPaneUI();
    }

    public RenderedOptionPaneUI() {
        Renderer defRenderer = null;
        Object obj = UIManager.get("OptionPane.buttons.renderer");
        if (obj == null || obj instanceof Renderer) {
            defRenderer = (Renderer)obj;
        }
        RenderedOptionPaneUI.renderers[0] = (obj = UIManager.get("OptionPane.yesbutton.renderer")) == null || obj instanceof Renderer ? (Renderer)obj : defRenderer;
        obj = UIManager.get("OptionPane.nobutton.renderer");
        RenderedOptionPaneUI.renderers[1] = obj == null || obj instanceof Renderer ? (Renderer)obj : defRenderer;
        obj = UIManager.get("OptionPane.okbutton.renderer");
        RenderedOptionPaneUI.renderers[2] = obj == null || obj instanceof Renderer ? (Renderer)obj : defRenderer;
        obj = UIManager.get("OptionPane.cancelbutton.renderer");
        RenderedOptionPaneUI.renderers[3] = obj == null || obj instanceof Renderer ? (Renderer)obj : defRenderer;
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Object[] defaultOptions = null;
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                int minimumWidth = UITools.getInt("OptionPane.buttonMinimumWidth", -1);
                switch (type) {
                    case 0: {
                        defaultOptions = new RenderedButton[]{this.createRenderedButton(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), UITools.getIcon("OptionPane.yesIcon"), minimumWidth, 0), this.createRenderedButton(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), UITools.getIcon("OptionPane.noIcon"), minimumWidth, 1)};
                        break;
                    }
                    case 1: {
                        defaultOptions = new RenderedButton[]{this.createRenderedButton(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), UITools.getIcon("OptionPane.yesIcon"), minimumWidth, 0), this.createRenderedButton(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), UITools.getIcon("OptionPane.noIcon"), minimumWidth, 1), this.createRenderedButton(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), UITools.getIcon("OptionPane.cancelIcon"), minimumWidth, 3)};
                        break;
                    }
                    case 2: {
                        defaultOptions = new RenderedButton[]{this.createRenderedButton(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), UITools.getIcon("OptionPane.okIcon"), minimumWidth, 2), this.createRenderedButton(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), UITools.getIcon("OptionPane.cancelIcon"), minimumWidth, 3)};
                        break;
                    }
                    default: {
                        defaultOptions = new RenderedButton[]{this.createRenderedButton(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), UITools.getIcon("OptionPane.okIcon"), minimumWidth, 2)};
                    }
                }
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private RenderedButton createRenderedButton(String text, int mnemonic, Icon icon, int minimumWidth, int buttonType) {
        String actionName;
        int actionKey;
        RenderedButton button = minimumWidth > 0 ? new ConstrainedButton(text, minimumWidth) : new RenderedButton(text);
        if (icon != null) {
            button.setIcon(icon);
        }
        if (mnemonic != 0) {
            button.setMnemonic(mnemonic);
        }
        button.buttonType = buttonType;
        button.setRolloverEnabled(true);
        button.setName("OptionPane.button");
        Object opaque = UIManager.get("OptionPane.buttons.opaque");
        if (opaque instanceof Boolean) {
            button.setOpaque((Boolean)opaque);
        } else {
            opaque = UIManager.get("Button.opaque");
            if (opaque instanceof Boolean) {
                button.setOpaque((Boolean)opaque);
            }
        }
        button.setMultiClickThreshhold(UITools.getInt("OptionPane.buttonClickThreshhold", 0));
        Font buttonFont = UITools.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
        final RenderedButtonActionListener buttonListener = new RenderedButtonActionListener(buttonType);
        button.addActionListener(buttonListener);
        switch (button.buttonType) {
            case 2: {
                actionKey = 10;
                actionName = "ok";
                break;
            }
            case 0: {
                actionKey = 89;
                actionName = "yes";
                break;
            }
            case 1: {
                actionKey = 78;
                actionName = "no";
                break;
            }
            default: {
                actionKey = 27;
                actionName = "escape";
            }
        }
        InputMap inputMap = this.optionPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(actionKey, 0), actionName);
        ActionMap actionMap = this.optionPane.getActionMap();
        actionMap.put(actionName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RenderedOptionPaneUI.this.inputComponent == null || !RenderedOptionPaneUI.this.inputComponent.hasFocus() || actionKey == 27) {
                    buttonListener.actionPerformed(null);
                } else if (RenderedOptionPaneUI.this.inputComponent instanceof JTextField && RenderedOptionPaneUI.this.inputComponent.hasFocus() && (actionKey == 27 || actionKey == 10)) {
                    buttonListener.actionPerformed(null);
                }
            }
        });
        return button;
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setOpaque(false);
        Border topBorder = (Border)UIManager.get("OptionPane.messageAreaBorder");
        if (topBorder != null) {
            top.setBorder(topBorder);
        }
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel(new GridBagLayout());
        JPanel realBody = new JPanel(new BorderLayout());
        body.setName("OptionPane.body");
        realBody.setName("OptionPane.realBody");
        body.setOpaque(false);
        realBody.setOpaque(false);
        if (this.getIcon() != null) {
            JPanel sep = new JPanel();
            sep.setOpaque(false);
            sep.setName("OptionPane.separator");
            sep.setPreferredSize(new Dimension(15, 1));
            realBody.add((Component)sep, "Before");
        }
        realBody.add((Component)body, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        int anchor = 10;
        Object oAnchor = UIManager.get("OptionPane.messageAnchor");
        if (oAnchor instanceof Integer) {
            anchor = (Integer)oAnchor;
        }
        cons.anchor = anchor;
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        this.addIcon(top);
        top.setOpaque(false);
        return top;
    }

    @Override
    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        bottom.setOpaque(false);
        Border border = (Border)UIManager.get("OptionPane.buttonAreaBorder");
        bottom.setName("OptionPane.buttonArea");
        if (border != null) {
            bottom.setBorder(border);
        }
        bottom.setLayout(new BasicOptionPaneUI.ButtonAreaLayout(UITools.getBoolean("OptionPane.sameSizeButtons", true), UITools.getInt("OptionPane.buttonPadding", 6)));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    private static class RenderedButton
    extends JButton {
        int buttonType = 2;

        public void setButtonType(int buttonType) {
            this.buttonType = buttonType;
        }

        public RenderedButton() {
        }

        RenderedButton(String text) {
            super(text);
        }

        @Override
        public void paint(Graphics g) {
            Renderer renderer = RenderedOptionPaneUI.getButtonRenderer(this.buttonType);
            if (renderer == null) {
                super.paint(g);
            } else {
                renderer.paint(g, this);
            }
        }
    }

    private static class ConstrainedButton
    extends RenderedButton {
        int minimumWidth;

        ConstrainedButton(String text, int minimumWidth) {
            super(text);
            this.minimumWidth = minimumWidth;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            min.width = Math.max(min.width, this.minimumWidth);
            return min;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.width = Math.max(pref.width, this.minimumWidth);
            return pref;
        }
    }

    public class RenderedButtonActionListener
    implements ActionListener {
        protected int buttonType;

        public RenderedButtonActionListener(int buttonType) {
            this.buttonType = buttonType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RenderedOptionPaneUI.this.optionPane != null) {
                int optionType = RenderedOptionPaneUI.this.optionPane.getOptionType();
                Object[] options = RenderedOptionPaneUI.this.optionPane.getOptions();
                if (!(RenderedOptionPaneUI.this.inputComponent == null || options == null && optionType != -1 && (optionType != 0 && optionType != 1 && optionType != 2 || this.buttonType != 2 && this.buttonType != 0))) {
                    RenderedOptionPaneUI.this.resetInputValue();
                }
                if (options == null) {
                    switch (this.buttonType) {
                        case 0: 
                        case 2: {
                            RenderedOptionPaneUI.this.optionPane.setValue(0);
                            break;
                        }
                        case 1: {
                            RenderedOptionPaneUI.this.optionPane.setValue(1);
                            break;
                        }
                        case 3: {
                            RenderedOptionPaneUI.this.optionPane.setValue(2);
                            break;
                        }
                    }
                }
            }
        }
    }
}

