/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.RendererColors;
import Tools.UITools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class RenderedMenuSeparatorUI
extends BasicSeparatorUI {
    public static final int TYPE_FILLCOLOR = 3;
    private static int typesCount = 4;
    private static int statesCount = 7;
    protected RendererColors colors = new RendererColors(typesCount, statesCount);
    private static RendererColors defaultColors = new RendererColors(typesCount, statesCount);
    protected boolean showText = true;
    private int direction = 1;
    private static int pad = 4;
    private static int smallBarHt = 2;

    public static RendererColors getDefaultColor() {
        return defaultColors;
    }

    public static void setDefaultColor(RendererColors colors) {
        defaultColors = colors;
    }

    public static void setDefaultColor(int type, int state, Color color) {
        defaultColors.setColor(type, state, color);
    }

    public static void setDefaultColors(int type, Color color) {
        defaultColors.setColors(type, color);
    }

    public RendererColors getColor() {
        return this.colors;
    }

    public void setColor(RendererColors colors) {
        this.colors = colors;
    }

    public void setColor(int type, int state, Color color) {
        this.colors.setColor(type, state, color);
    }

    public void setColors(int type, Color color) {
        this.colors.setColors(type, color);
    }

    public static void setDefaultTextColor(Color color) {
        defaultColors.setColors(0, color);
    }

    public static void setDefaultBackColor(Color color) {
        defaultColors.setColors(1, color);
    }

    public static void setDefaultFillColor(Color color) {
        defaultColors.setColors(3, color);
    }

    public static void setDefaultBorderColor(Color color) {
        defaultColors.setColors(2, color);
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object val = UIManager.get("MenuSeparator.opaque");
        if (val instanceof Boolean) {
            c.setOpaque((Boolean)val);
        }
    }

    public RenderedMenuSeparatorUI() {
        this(0);
    }

    public RenderedMenuSeparatorUI(int direction, boolean showText) {
        this(direction);
        this.showText = showText;
    }

    public RenderedMenuSeparatorUI(int direction) {
        Color color = UIManager.getColor("RenderedUI.MenuSeparator.background");
        if (color != null) {
            this.colors.setColors(1, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuSeparator.bordercolor")) != null) {
            this.colors.setColors(2, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuSeparator.fillcolor")) != null) {
            this.colors.setColors(3, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuSeparator.foreground")) != null) {
            this.colors.setColors(0, color);
        }
        switch (direction) {
            case 3: {
                this.showText = false;
                this.direction = direction;
                break;
            }
            case 0: 
            case 1: {
                this.direction = direction;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color textColor;
        Color backColor;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cWd = c.getWidth();
        int cHt = c.getHeight();
        String caption = c.getToolTipText();
        boolean haveCaption = caption != null && caption.length() > 0;
        int state = UITools.getState(c);
        Color color = backColor = this.colors.getColor(1, state) != null ? this.colors.getColor(1, state) : defaultColors.getColor(1, state);
        if (backColor == null && c.isOpaque()) {
            backColor = c.getBackground();
        }
        Color fillColor = this.colors.getColor(3, state) != null ? this.colors.getColor(3, state) : defaultColors.getColor(3, state);
        Color borderColor = this.colors.getColor(2, state) != null ? this.colors.getColor(2, state) : defaultColors.getColor(2, state);
        Color color2 = textColor = this.colors.getColor(0, state) != null ? this.colors.getColor(0, state) : defaultColors.getColor(0, state);
        if (haveCaption) {
            Shape backgroundShape;
            g2d.setFont(c.getFont());
            FontMetrics fm = g2d.getFontMetrics();
            int wd = fm.stringWidth(caption);
            int ht = fm.getMaxAscent() - fm.getMaxDescent();
            int captionX = (c.getWidth() - wd) / 2;
            int captionY = (c.getHeight() + ht) / 2;
            switch (this.direction) {
                case 3: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeBottom(g2d, c, caption);
                    break;
                }
                case 1: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeTop(g2d, c, caption);
                    break;
                }
                default: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeCenter(g2d, c, caption);
                }
            }
            if (backColor != null) {
                g2d.setColor(backColor);
                g2d.fillRect(0, 0, cWd, cHt);
            }
            if (fillColor != null) {
                g2d.setColor(fillColor);
                g2d.fill(backgroundShape);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.draw(backgroundShape);
            }
            if (this.showText && textColor != null) {
                g2d.setColor(textColor);
                g2d.drawString(caption, captionX, captionY);
            }
            g2d.setClip(null);
        } else {
            if (backColor != null) {
                g2d.setColor(backColor);
                g2d.fillRect(0, 0, cWd, cHt);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.drawRect(-1, 0, cWd + 1, cHt - 1);
            }
        }
    }

    public void setVerticalPad(int newPad) {
        if (newPad >= 0) {
            pad = newPad;
        }
    }

    public int getVerticalPad() {
        return pad;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int ht;
        boolean haveText;
        String text = ((JSeparator)c).getToolTipText();
        boolean vertical = ((JSeparator)c).getOrientation() == 1;
        boolean bl = haveText = text != null && text.length() > 0;
        if (vertical) {
            return new Dimension(2, 0);
        }
        if (!haveText) {
            return new Dimension(0, smallBarHt * 2);
        }
        Graphics g = c.getGraphics();
        if (g == null) {
            Font font = c.getFont();
            FontMetrics f = null;
            if (font != null) {
                f = c.getFontMetrics(font);
            }
            ht = f != null ? f.getHeight() + pad : 2 + pad;
        } else {
            ht = g.getFontMetrics().getHeight() + pad;
        }
        return new Dimension(0, ht);
    }

    public static Shape getShapeBottom(Graphics2D g2d, JComponent menuItem, String caption) {
        FontMetrics fm = g2d.getFontMetrics();
        int cWd = menuItem.getWidth();
        int cHt = menuItem.getHeight();
        int midY = cHt / 2;
        int y1 = midY - smallBarHt;
        g2d.setFont(menuItem.getFont());
        int wd = fm.stringWidth(caption);
        int captionX = (menuItem.getWidth() - wd) / 2;
        GeneralPath backgroundShape = new GeneralPath();
        int x1 = captionX - pad;
        int x2 = captionX + wd + pad;
        backgroundShape.moveTo(-1.0f, y1);
        backgroundShape.lineTo(x1, y1);
        backgroundShape.lineTo(x1 + pad, 0.0f);
        backgroundShape.lineTo(x2 - pad, 0.0f);
        backgroundShape.lineTo(x2, y1);
        backgroundShape.lineTo(cWd, y1);
        backgroundShape.lineTo(cWd, cHt - 1);
        backgroundShape.lineTo(-1.0f, cHt - 1);
        backgroundShape.closePath();
        return backgroundShape;
    }

    public static Shape getShapeTop(Graphics2D g2d, JComponent menuItem, String caption) {
        FontMetrics fm = g2d.getFontMetrics();
        int cWd = menuItem.getWidth();
        int cHt = menuItem.getHeight();
        int midY = cHt / 2;
        boolean y1 = false;
        int y2 = midY + smallBarHt - 1;
        g2d.setFont(menuItem.getFont());
        int wd = fm.stringWidth(caption);
        int captionX = (menuItem.getWidth() - wd) / 2;
        GeneralPath backgroundShape = new GeneralPath();
        int x1 = captionX - pad;
        int x2 = captionX + wd + pad;
        backgroundShape.moveTo(-1.0f, (float)y1);
        backgroundShape.lineTo(cWd, (float)y1);
        backgroundShape.lineTo(cWd, y2);
        backgroundShape.lineTo(x2, y2);
        backgroundShape.lineTo(x2 - pad, cHt - 1);
        backgroundShape.lineTo(x1 + pad, cHt - 1);
        backgroundShape.lineTo(x1, y2);
        backgroundShape.lineTo(-1.0f, y2);
        backgroundShape.closePath();
        return backgroundShape;
    }

    public static Shape getShapeCenter(Graphics g, JComponent c, String caption) {
        int cWd = c.getWidth();
        int cHt = c.getHeight();
        int midY = cHt / 2;
        int y1 = midY - smallBarHt;
        int y2 = midY + smallBarHt - 1;
        FontMetrics fm = g.getFontMetrics();
        int wd = fm.stringWidth(caption);
        int captionX = (c.getWidth() - wd) / 2;
        GeneralPath backgroundShape = new GeneralPath();
        int x1 = captionX - pad;
        int x2 = captionX + wd + pad;
        backgroundShape.moveTo(-1.0f, y1);
        backgroundShape.lineTo(x1, y1);
        backgroundShape.lineTo(x1 + pad, 0.0f);
        backgroundShape.lineTo(x2 - pad, 0.0f);
        backgroundShape.lineTo(x2, y1);
        backgroundShape.lineTo(cWd, y1);
        backgroundShape.lineTo(cWd, y2);
        backgroundShape.lineTo(x2, y2);
        backgroundShape.lineTo(x2 - pad, cHt - 1);
        backgroundShape.lineTo(x1 + pad, cHt - 1);
        backgroundShape.lineTo(x1, y2);
        backgroundShape.lineTo(-1.0f, y2);
        backgroundShape.closePath();
        return backgroundShape;
    }
}

