/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.AbstractStatedIcon;
import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;

public class RenderedMenuRadioItemUI
extends BasicRadioButtonMenuItemUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    private Renderer renderer;
    private static AbstractStatedIcon defaultIcon = null;
    private Icon icon;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuRadioItemUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    public static void setDefaultIconRenderer(AbstractStatedIcon icon) {
        defaultIcon = icon;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object val = UIManager.get("RenderedUI.MenuRadioItem.opaque");
        this.checkIcon = UIManager.getIcon("RadioButtonMenuItem.checkIcon");
        if (val instanceof Boolean) {
            this.menuItem.setOpaque((Boolean)val);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Renderer renderer = this.getActiveRenderer();
        renderer.setActiveColors(c);
        this.selectionBackground = renderer.getColors().getActiveColor(1);
        this.selectionForeground = renderer.getColors().getActiveColor(0);
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        Graphics2D g2d = (Graphics2D)g;
        Renderer renderer = this.getActiveRenderer();
        renderer.paintBackground(g2d, menuItem);
        if (renderer.isPaintBorder()) {
            renderer.paintBorder(g2d, menuItem);
        }
    }
}

