/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;

public class RenderedMenuCheckItemUI
extends BasicCheckBoxMenuItemUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuCheckItemUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object val = UIManager.get("RenderedUI.MenuCheckBoxItem.opaque");
        this.checkIcon = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
        if (val instanceof Boolean) {
            this.menuItem.setOpaque((Boolean)val);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Renderer renderer = this.getActiveRenderer();
        renderer.setActiveColors(c);
        this.selectionBackground = renderer.getColors().getActiveColor(1);
        this.selectionForeground = renderer.getColors().getActiveColor(0);
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        Graphics2D g2d = (Graphics2D)g;
        Renderer renderer = this.getActiveRenderer();
        renderer.paintBackground(g2d, menuItem);
        if (renderer.isPaintBorder()) {
            this.getActiveRenderer().paintBorder(g2d, menuItem);
        }
    }
}

