/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.JavTRenderer;
import Renderers.Renderer;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.metal.MetalMenuBarUI;

public class RenderedMenuBarUI
extends MetalMenuBarUI {
    static Renderer defaultRenderer = new JavTRenderer();
    private Renderer renderer;

    public static ComponentUI createUI(JComponent x) {
        return new RenderedMenuBarUI();
    }

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        LookAndFeel.installProperty(this.menuBar, "opaque", Boolean.TRUE);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.getActiveRenderer().setOrientation(0);
        this.getActiveRenderer().paint(g, c);
    }
}

