/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import JMConstants.Constants;
import Renderers.GlossyRenderer;
import Renderers.Renderer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import plaf.UIUtilities;

public class RenderedLabelUI
extends BasicLabelUI
implements Constants {
    static Renderer defaultRenderer = new GlossyRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedLabelUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        Renderer renderer = this.getActiveRenderer();
        JLabel label = (JLabel)c;
        String text = label.getText();
        boolean haveText = text != null && text.length() > 0;
        boolean enabled = label.isEnabled();
        if (enabled) {
            icon = label.getIcon();
            label.setForeground(renderer.getNormalTextColor(c));
        } else {
            icon = label.getDisabledIcon();
            label.setForeground(renderer.getDisabledTextColor(c));
        }
        boolean opaque = label.isOpaque();
        if (opaque) {
            renderer.paintBackground((Graphics2D)g, c, null, enabled ? 0 : 2);
        }
        if (icon == null && !haveText) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        String clippedText = UIUtilities.layout(label, fm, c.getWidth(), c.getHeight(), icon, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(c, g, paintIconR.x, paintIconR.y);
        }
        if (haveText) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                g.setColor(c.isEnabled() ? this.getActiveRenderer().getTextColor() : this.getActiveRenderer().getDisabledTextColor());
                g.drawString(clippedText, paintTextR.x, paintTextR.y + fm.getAscent());
            }
        }
        if (opaque && renderer.isPaintBorder()) {
            renderer.paintBorder((Graphics2D)g, c);
        }
    }
}

