/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.MetallicRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedInternalFrameUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class RenderedInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Renderer titleBarRenderer;
    Renderer renderer = new MetallicRenderer();
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    boolean leftToRight = true;

    private Renderer getActiveRenderer() {
        return this.titleBarRenderer == null ? RenderedInternalFrameUI.getDefaultTitleBarRenderer() : this.titleBarRenderer;
    }

    @Override
    protected void installDefaults() {
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
    }

    @Override
    protected void uninstallDefaults() {
    }

    public RenderedInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        Object background = null;
        Color foreground = null;
        Object shadow = null;
        if (isSelected) {
            this.getActiveRenderer().paintBackground((Graphics)((Graphics2D)g), (Component)this, 5);
        } else {
            this.getActiveRenderer().paintBackground((Graphics)((Graphics2D)g), (Component)this, 0);
        }
        int xOffset = this.leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!this.leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += this.leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int fHeight = fm.getHeight();
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (this.leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= fm.stringWidth(frameTitle);
            }
            int titleLength = fm.stringWidth(frameTitle);
            g.drawString(frameTitle, xOffset, yOffset);
        }
    }
}

