/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import IconRenderers.IconRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedButtonUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class RenderedComboBoxUI
extends BasicComboBoxUI {
    static Renderer defaultButtonRenderer = null;
    static IconRenderer defaultArrowRenderer;
    private Renderer buttonRenderer;
    private IconRenderer arrowRenderer;

    public static void setDefaultButtonRenderer(Renderer renderer) {
        defaultButtonRenderer = renderer;
    }

    public static Renderer getDefaultButtonRenderer() {
        return defaultButtonRenderer == null ? RenderedButtonUI.getDefaultRenderer() : defaultButtonRenderer;
    }

    public static void setDefaultArrowRenderer(IconRenderer renderer) {
        if (renderer != null) {
            defaultArrowRenderer = renderer;
        }
    }

    public static IconRenderer getDefaultArrowRenderer() {
        return defaultArrowRenderer != null ? defaultArrowRenderer : IconRenderer.getDefaultArrowRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedComboBoxUI();
    }

    private Renderer getActiveButtonRenderer() {
        return this.buttonRenderer != null ? this.buttonRenderer : RenderedComboBoxUI.getDefaultButtonRenderer();
    }

    private IconRenderer getActiveArrowRenderer() {
        return this.arrowRenderer != null ? this.arrowRenderer : RenderedComboBoxUI.getDefaultArrowRenderer();
    }

    @Override
    public JButton createArrowButton() {
        super.createArrowButton();
        JButton button = new JButton(){

            @Override
            public void paint(Graphics g) {
                Renderer renderer = RenderedComboBoxUI.this.getActiveButtonRenderer();
                renderer.setOrientation(0);
                renderer.paintBackground((Graphics2D)g, this);
                RenderedComboBoxUI.this.getActiveArrowRenderer().paintIcon(g, this, 5);
                if (renderer.isPaintBorder()) {
                    renderer.paintBorder((Graphics2D)g, this);
                }
            }
        };
        button.setName("ComboBox.arrowButton");
        button.setOpaque(false);
        return button;
    }
}

